/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.compiler.ast;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import org.xvm.asm.Argument;
import org.xvm.asm.ErrorListener;
import org.xvm.asm.MethodStructure;
import org.xvm.asm.ast.BinaryAST;
import org.xvm.asm.ast.ExprAST;
import org.xvm.asm.ast.MultiExprAST;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.asm.op.Label;
import org.xvm.compiler.Compiler;
import org.xvm.compiler.ast.AstNode;
import org.xvm.compiler.ast.Context;
import org.xvm.compiler.ast.Expression;
import org.xvm.compiler.ast.Statement;
import org.xvm.compiler.ast.VariableDeclarationStatement;

public class MultipleLValueStatement
extends Statement {
    protected List<AstNode> LVals;
    protected transient Label[] aGroundLabels;
    protected transient MultipleLValueExpression expr;
    private static final Field[] STMT_FIELDS = MultipleLValueStatement.fieldsForNames(MultipleLValueStatement.class, "LVals");
    private static final Field[] EXPR_FIELDS = MultipleLValueStatement.fieldsForNames(MultipleLValueExpression.class, "exprs");

    public MultipleLValueStatement(List<AstNode> LVals) {
        assert (LVals.stream().allMatch(AstNode::isLValueSyntax));
        this.LVals = LVals;
    }

    @Override
    public long getStartPosition() {
        return this.LVals.getFirst().getStartPosition();
    }

    @Override
    public long getEndPosition() {
        return this.LVals.get(this.LVals.size() - 1).getEndPosition();
    }

    @Override
    protected Field[] getChildFields() {
        return STMT_FIELDS;
    }

    public TypeConstant[] getTypes() {
        List<AstNode> listLVals = this.LVals;
        int cTypes = listLVals.size();
        TypeConstant[] aTypes = new TypeConstant[cTypes];
        for (int i = 0; i < cTypes; ++i) {
            TypeConstant typeConstant;
            AstNode nodeLVal = listLVals.get(i);
            if (nodeLVal instanceof VariableDeclarationStatement) {
                VariableDeclarationStatement stmtDecl = (VariableDeclarationStatement)nodeLVal;
                typeConstant = stmtDecl.getType();
            } else {
                typeConstant = nodeLVal.getLValueExpression().getType();
            }
            aTypes[i] = typeConstant;
        }
        return aTypes;
    }

    @Override
    public boolean isLValueSyntax() {
        return true;
    }

    @Override
    public Expression getLValueExpression() {
        if (this.expr == null) {
            this.expr = new MultipleLValueExpression();
        }
        return this.expr;
    }

    @Override
    public void updateLValueFromRValueTypes(Context ctx, Context.Branch branch, boolean fCond, TypeConstant[] aTypes) {
        assert (aTypes != null && aTypes.length >= 1);
        List<AstNode> listLVals = this.LVals;
        int c = Math.min(aTypes.length, listLVals.size());
        for (int i = 0; i < c; ++i) {
            listLVals.get(i).updateLValueFromRValueTypes(ctx, branch, fCond, new TypeConstant[]{aTypes[i]});
        }
    }

    @Override
    public void resetLValueTypes(Context ctx) {
        for (AstNode listLVal : this.LVals) {
            listLVal.resetLValueTypes(ctx);
        }
    }

    @Override
    protected boolean isRValue(Expression exprChild) {
        return false;
    }

    @Override
    protected boolean allowsShortCircuit(AstNode nodeChild) {
        assert (this.indexOfChild(nodeChild) >= 0);
        return true;
    }

    @Override
    protected Label ensureShortCircuitLabel(AstNode nodeOrigin, Context ctxOrigin) {
        AstNode nodeChild = this.findChild(nodeOrigin);
        int iPos = this.indexOfChild(nodeChild);
        if (iPos < 0) {
            throw new IllegalStateException("unknown child: " + String.valueOf(nodeChild));
        }
        return this.ensureShortCircuitLabel(iPos);
    }

    int indexOfChild(AstNode node) {
        assert (node != null);
        List<AstNode> list = this.LVals;
        int cNodes = list.size();
        for (int i = 0; i < cNodes; ++i) {
            if (node != list.get(i)) continue;
            return i;
        }
        return -1;
    }

    Label peekShortCircuitLabel(int i) {
        return this.aGroundLabels == null ? null : this.aGroundLabels[i];
    }

    Label ensureShortCircuitLabel(int i) {
        Label label;
        Label[] aLabels = this.aGroundLabels;
        if (aLabels == null) {
            this.aGroundLabels = aLabels = new Label[this.LVals.size()];
        }
        if ((label = aLabels[i]) == null) {
            aLabels[i] = label = new Label("ground_" + i);
        }
        return label;
    }

    @Override
    protected Statement validateImpl(Context ctx, ErrorListener errs) {
        int c = this.LVals.size();
        for (int i = 0; i < c; ++i) {
            AstNode nodeNew;
            AstNode nodeOld = this.LVals.get(i);
            if (nodeOld instanceof Statement) {
                Statement stmt = (Statement)nodeOld;
                v0 = stmt.validate(ctx, errs);
            } else {
                v0 = nodeNew = ((Expression)nodeOld).validate(ctx, null, errs);
            }
            if (nodeNew == null || nodeNew == nodeOld) continue;
            this.LVals.set(i, nodeNew);
        }
        return this;
    }

    @Override
    protected boolean emit(Context ctx, boolean fReachable, MethodStructure.Code code, ErrorListener errs) {
        boolean fCompletes = fReachable;
        List<AstNode> LVals = this.LVals;
        int cVals = LVals.size();
        ExprAST[] aAst = new ExprAST[cVals];
        int c = LVals.size();
        for (int i = 0; i < c; ++i) {
            AstNode node = LVals.get(i);
            if (node instanceof Statement) {
                Statement stmt = (Statement)node;
                fCompletes = stmt.completes(ctx, fCompletes, code, errs);
                aAst[i] = (ExprAST)ctx.getHolder().getAst(stmt);
            } else {
                aAst[i] = BinaryAST.POISON;
            }
            Label labelGround = this.peekShortCircuitLabel(i);
            if (labelGround == null) continue;
            code.add(labelGround);
        }
        ctx.getHolder().setAst(this, new MultiExprAST(aAst));
        return fCompletes;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('(');
        boolean first = true;
        for (AstNode node : this.LVals) {
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            sb.append(node);
        }
        sb.append(')');
        return sb.toString();
    }

    @Override
    public String getDumpDesc() {
        return this.toString();
    }

    protected class MultipleLValueExpression
    extends Expression {
        protected List<Expression> exprs;

        protected MultipleLValueExpression() {
        }

        @Override
        public MultipleLValueStatement getParent() {
            return MultipleLValueStatement.this;
        }

        @Override
        public long getStartPosition() {
            return this.getParent().getStartPosition();
        }

        @Override
        public long getEndPosition() {
            return this.getParent().getEndPosition();
        }

        @Override
        protected Field[] getChildFields() {
            return EXPR_FIELDS;
        }

        @Override
        public Compiler.Stage getStage() {
            return this.getParent().getStage();
        }

        @Override
        protected void setStage(Compiler.Stage stage) {
            this.getParent().setStage(stage);
        }

        @Override
        public boolean isLValueSyntax() {
            return true;
        }

        @Override
        public Expression getLValueExpression() {
            return this;
        }

        @Override
        public void updateLValueFromRValueTypes(Context ctx, Context.Branch branch, boolean fCond, TypeConstant[] aTypes) {
            this.getParent().updateLValueFromRValueTypes(ctx, branch, fCond, aTypes);
        }

        @Override
        public void resetLValueTypes(Context ctx) {
            this.getParent().resetLValueTypes(ctx);
        }

        @Override
        protected boolean usesSuper() {
            return this.getParent().usesSuper();
        }

        @Override
        protected boolean hasSingleValueImpl() {
            return false;
        }

        @Override
        protected boolean hasMultiValueImpl() {
            return true;
        }

        @Override
        public TypeConstant[] getImplicitTypes(Context ctx) {
            List<Expression> listExprs = this.ensureExpressions();
            int cTypes = listExprs.size();
            TypeConstant[] aTypes = new TypeConstant[cTypes];
            for (int i = 0; i < cTypes; ++i) {
                TypeConstant type = listExprs.get(i).getImplicitType(ctx);
                if (type == null) {
                    type = this.pool().typeObject();
                }
                aTypes[i] = type;
            }
            return aTypes;
        }

        @Override
        public Expression.TypeFit testFitMulti(Context ctx, TypeConstant[] atypeRequired, boolean fExhaustive, ErrorListener errs) {
            List<Expression> listExprs;
            int cExprs;
            int cReq = atypeRequired == null ? 0 : atypeRequired.length;
            if (cReq > (cExprs = (listExprs = this.ensureExpressions()).size())) {
                return Expression.TypeFit.NoFit;
            }
            Expression.TypeFit fit = Expression.TypeFit.Fit;
            for (int i = 0; i < cReq; ++i) {
                Expression.TypeFit fitSingle = listExprs.get(i).testFit(ctx, atypeRequired[i], fExhaustive, errs);
                if (!fitSingle.isFit()) {
                    return Expression.TypeFit.NoFit;
                }
                fit = fit.combineWith(fitSingle);
            }
            return fit;
        }

        @Override
        protected Expression validateMulti(Context ctx, TypeConstant[] atypeRequired, ErrorListener errs) {
            Expression.TypeFit fit = Expression.TypeFit.Fit;
            List<Expression> listExprs = this.ensureExpressions();
            int cExprs = listExprs.size();
            TypeConstant[] atypeActual = new TypeConstant[cExprs];
            int cRequired = atypeRequired == null ? 0 : atypeRequired.length;
            for (int i = 0; i < cExprs; ++i) {
                Expression exprOld = listExprs.get(i);
                Expression exprNew = exprOld.validate(ctx, i < cRequired ? atypeRequired[i] : null, errs);
                if (exprNew == null) {
                    atypeActual = null;
                    fit = Expression.TypeFit.NoFit;
                    continue;
                }
                if (exprNew != exprOld) {
                    listExprs.set(i, exprNew);
                }
                if (atypeActual != null) {
                    atypeActual[i] = exprNew.getType();
                }
                fit = fit.combineWith(exprNew.getTypeFit());
            }
            return this.finishValidations(ctx, atypeRequired, atypeActual, fit, null, errs);
        }

        @Override
        public Argument[] generateArguments(Context ctx, MethodStructure.Code code, boolean fLocalPropOk, boolean fUsedOnce, ErrorListener errs) {
            throw new IllegalStateException();
        }

        @Override
        public void generateAssignments(Context ctx, MethodStructure.Code code, Expression.Assignable[] aLVal, ErrorListener errs) {
            throw new IllegalStateException();
        }

        @Override
        public Expression.Assignable[] generateAssignables(Context ctx, MethodStructure.Code code, ErrorListener errs) {
            List<Expression> listExprs = this.ensureExpressions();
            int cExprs = listExprs.size();
            Expression.Assignable[] aLVals = new Expression.Assignable[cExprs];
            for (int i = 0; i < cExprs; ++i) {
                aLVals[i] = listExprs.get(i).generateAssignable(ctx, code, errs);
            }
            return aLVals;
        }

        @Override
        public ExprAST getExprAST(Context ctx) {
            List<Expression> listExprs = this.ensureExpressions();
            int cExprs = listExprs.size();
            ExprAST[] aAstExpr = new ExprAST[cExprs];
            for (int i = 0; i < cExprs; ++i) {
                aAstExpr[i] = listExprs.get(i).getExprAST(ctx);
            }
            return new MultiExprAST(aAstExpr);
        }

        @Override
        public boolean isAssignable(Context ctx) {
            return super.isAssignable(ctx);
        }

        @Override
        public void requireAssignable(Context ctx, ErrorListener errs) {
            for (Expression expr : this.ensureExpressions()) {
                expr.requireAssignable(ctx, errs);
            }
        }

        @Override
        public void markAssignment(Context ctx, boolean fCond, ErrorListener errs) {
            for (Expression expr : this.ensureExpressions()) {
                expr.markAssignment(ctx, fCond, errs);
            }
        }

        @Override
        public boolean isCompletable() {
            for (Expression expr : this.ensureExpressions()) {
                if (expr.isCompletable()) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean isShortCircuiting() {
            for (Expression expr : this.ensureExpressions()) {
                if (!expr.isShortCircuiting()) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean isConstant() {
            for (Expression expr : this.ensureExpressions()) {
                if (expr.isConstant()) continue;
                return false;
            }
            return true;
        }

        @Override
        protected boolean allowsShortCircuit(AstNode nodeChild) {
            Expression exprChild;
            return nodeChild instanceof Expression && this.indexOfChild(exprChild = (Expression)nodeChild) >= 0;
        }

        @Override
        protected Label ensureShortCircuitLabel(AstNode nodeOrigin, Context ctxOrigin) {
            int iPos;
            AstNode nodeChild = this.findChild(nodeOrigin);
            if (nodeChild instanceof Expression) {
                Expression exprChild = (Expression)nodeChild;
                v0 = this.indexOfChild(exprChild);
            } else {
                v0 = iPos = -1;
            }
            if (iPos < 0) {
                throw new IllegalStateException("unknown child: " + String.valueOf(nodeChild));
            }
            return MultipleLValueStatement.this.ensureShortCircuitLabel(iPos);
        }

        @Override
        protected Expression replaceThisWith(Expression that) {
            throw new IllegalStateException();
        }

        List<Expression> ensureExpressions() {
            List<Expression> listExprs = this.exprs;
            if (listExprs == null) {
                List<AstNode> LVals = MultipleLValueStatement.this.LVals;
                int cExprs = LVals.size();
                listExprs = new ArrayList<Expression>(cExprs);
                for (AstNode lVal : LVals) {
                    listExprs.add(lVal.getLValueExpression());
                }
                this.exprs = listExprs;
            }
            return listExprs;
        }

        int indexOfChild(Expression expr) {
            assert (expr != null);
            List<Expression> listExprs = this.ensureExpressions();
            int c = listExprs.size();
            for (int i = 0; i < c; ++i) {
                if (expr != listExprs.get(i)) continue;
                return i;
            }
            return -1;
        }

        @Override
        public String toString() {
            return this.getParent().toString();
        }
    }
}

