/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.compiler.ast;

import java.lang.reflect.Field;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.xvm.asm.Annotation;
import org.xvm.asm.Argument;
import org.xvm.asm.ClassStructure;
import org.xvm.asm.Component;
import org.xvm.asm.Constant;
import org.xvm.asm.ConstantPool;
import org.xvm.asm.Constants;
import org.xvm.asm.ErrorListener;
import org.xvm.asm.GenericTypeResolver;
import org.xvm.asm.MethodStructure;
import org.xvm.asm.MultiMethodStructure;
import org.xvm.asm.PackageStructure;
import org.xvm.asm.Parameter;
import org.xvm.asm.PropertyStructure;
import org.xvm.asm.Register;
import org.xvm.asm.TypedefStructure;
import org.xvm.asm.XvmStructure;
import org.xvm.asm.ast.BindMethodAST;
import org.xvm.asm.ast.ConstantExprAST;
import org.xvm.asm.ast.ExprAST;
import org.xvm.asm.ast.OuterExprAST;
import org.xvm.asm.ast.PropertyExprAST;
import org.xvm.asm.ast.UnaryOpExprAST;
import org.xvm.asm.constants.AnnotatedTypeConstant;
import org.xvm.asm.constants.ChildInfo;
import org.xvm.asm.constants.ClassConstant;
import org.xvm.asm.constants.ConditionalConstant;
import org.xvm.asm.constants.DeferredValueConstant;
import org.xvm.asm.constants.DynamicFormalConstant;
import org.xvm.asm.constants.FormalConstant;
import org.xvm.asm.constants.FormalTypeChildConstant;
import org.xvm.asm.constants.IdentityConstant;
import org.xvm.asm.constants.MethodConstant;
import org.xvm.asm.constants.MethodInfo;
import org.xvm.asm.constants.ModuleConstant;
import org.xvm.asm.constants.MultiMethodConstant;
import org.xvm.asm.constants.NamedConstant;
import org.xvm.asm.constants.PackageConstant;
import org.xvm.asm.constants.ParentClassConstant;
import org.xvm.asm.constants.PropertyClassTypeConstant;
import org.xvm.asm.constants.PropertyConstant;
import org.xvm.asm.constants.PropertyInfo;
import org.xvm.asm.constants.PseudoConstant;
import org.xvm.asm.constants.SingletonConstant;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.asm.constants.TypeInfo;
import org.xvm.asm.constants.TypeParameterConstant;
import org.xvm.asm.constants.TypedefConstant;
import org.xvm.asm.constants.UnresolvedNameConstant;
import org.xvm.asm.op.FBind;
import org.xvm.asm.op.Invoke_00;
import org.xvm.asm.op.Invoke_01;
import org.xvm.asm.op.Invoke_0N;
import org.xvm.asm.op.Invoke_10;
import org.xvm.asm.op.Invoke_11;
import org.xvm.asm.op.Invoke_1N;
import org.xvm.asm.op.Invoke_N0;
import org.xvm.asm.op.Invoke_N1;
import org.xvm.asm.op.Invoke_NN;
import org.xvm.asm.op.L_Get;
import org.xvm.asm.op.MBind;
import org.xvm.asm.op.Move;
import org.xvm.asm.op.MoveRef;
import org.xvm.asm.op.MoveThis;
import org.xvm.asm.op.MoveVar;
import org.xvm.asm.op.P_Get;
import org.xvm.asm.op.P_Ref;
import org.xvm.asm.op.P_Var;
import org.xvm.asm.op.Return_0;
import org.xvm.asm.op.Return_1;
import org.xvm.asm.op.Return_N;
import org.xvm.asm.op.Var_D;
import org.xvm.asm.op.Var_I;
import org.xvm.compiler.Token;
import org.xvm.compiler.ast.AstNode;
import org.xvm.compiler.ast.Context;
import org.xvm.compiler.ast.Expression;
import org.xvm.compiler.ast.LabeledStatement;
import org.xvm.compiler.ast.NameResolver;
import org.xvm.compiler.ast.NamedTypeExpression;
import org.xvm.compiler.ast.RelOpExpression;
import org.xvm.compiler.ast.StatementBlock;
import org.xvm.compiler.ast.TypeExpression;
import org.xvm.runtime.Utils;
import org.xvm.util.ListMap;
import org.xvm.util.Severity;

public class NameExpression
extends Expression {
    protected Expression left;
    protected Token amp;
    protected Token name;
    protected List<TypeExpression> params;
    protected long lEndPos;
    private ListMap<FormalConstant, TypeConstant> m_mapTypeParams;
    private transient StatementBlock.TargetInfo m_targetInfo;
    private transient Argument m_arg;
    private transient Plan m_plan = Plan.None;
    private transient MethodConstant m_idBjarnLambda;
    private transient PropertyAccess m_propAccessPlan;
    private transient IdentityConstant m_idSingletonParent;
    private transient boolean m_fClassAttribute;
    private transient boolean m_fAssignable;
    private transient ExprAST m_astRefTarget;
    private transient ExprAST m_astResult;
    private static final Field[] CHILD_FIELDS = NameExpression.fieldsForNames(NameExpression.class, "left", "params");

    public NameExpression(Token name) {
        this(null, name, null, name.getEndPosition());
    }

    NameExpression(AstNode parent, Token name, Register reg) {
        this(name);
        if (reg != null) {
            this.m_plan = Plan.None;
            this.m_arg = reg;
            this.m_fAssignable = reg.isWritable();
        }
        parent.adopt(this);
        this.setStage(parent.getStage());
    }

    public NameExpression(Token amp, Token name, List<TypeExpression> params, long lEndPos) {
        this(null, amp, name, params, lEndPos);
    }

    public NameExpression(Expression left, Token amp, Token name, List<TypeExpression> params, long lEndPos) {
        this.left = left;
        this.amp = amp;
        this.name = name;
        this.params = params;
        this.lEndPos = lEndPos;
    }

    @Override
    protected boolean usesSuper() {
        return "super".equals(this.name.getValueText()) || this.left != null && this.left.usesSuper();
    }

    @Override
    public boolean validateCondition(ErrorListener errs) {
        Expression expression = this.left;
        if (expression instanceof NameExpression) {
            NameExpression exprName = (NameExpression)expression;
            if (this.amp == null && this.params == null && "present".equals(this.getName())) {
                while (exprName.left != null) {
                    if (!"present".equals(exprName.getName()) && exprName.left instanceof NameExpression) {
                        exprName = (NameExpression)exprName.left;
                        continue;
                    }
                    return super.validateCondition(errs);
                }
                return true;
            }
        }
        return super.validateCondition(errs);
    }

    @Override
    public ConditionalConstant toConditionalConstant() {
        if (this.validateCondition(null)) {
            ConstantPool pool = this.pool();
            return pool.ensurePresentCondition(new UnresolvedNameConstant(pool, ((NameExpression)this.left).collectNames(1), false));
        }
        return super.toConditionalConstant();
    }

    public boolean isSimpleName() {
        return this.left == null && !this.isSuppressDeref() && !this.isSpecial() && !this.hasTrailingTypeParams();
    }

    public boolean isOnlyNames() {
        NameExpression exprName;
        Expression expression;
        return this.left == null || (expression = this.left) instanceof NameExpression && (exprName = (NameExpression)expression).isOnlyNames();
    }

    public List<Token> getNameTokens() {
        return this.collectNameTokens(1);
    }

    protected String[] collectNames(int cNames) {
        String[] asName;
        Expression expression = this.left;
        if (expression instanceof NameExpression) {
            NameExpression exprName = (NameExpression)expression;
            asName = exprName.collectNames(cNames + 1);
        } else {
            asName = new String[cNames];
        }
        asName[asName.length - cNames] = this.getName();
        return asName;
    }

    protected List<Token> collectNameTokens(int cNames) {
        ArrayList<Token> list;
        Expression expression = this.left;
        if (expression instanceof NameExpression) {
            NameExpression exprName = (NameExpression)expression;
            list = exprName.collectNameTokens(cNames + 1);
        } else {
            list = new ArrayList<Token>(cNames);
        }
        list.add(this.getNameToken());
        return list;
    }

    public Expression getLeftExpression() {
        return this.left;
    }

    public boolean isSuppressDeref() {
        return this.amp != null;
    }

    public boolean hasAnySuppressDeref() {
        NameExpression exprName;
        Expression expression;
        return this.isSuppressDeref() || (expression = this.left) instanceof NameExpression && (exprName = (NameExpression)expression).hasAnySuppressDeref();
    }

    public Token getNameToken() {
        return this.name;
    }

    public String getName() {
        return this.name.getValueText();
    }

    public boolean hasTrailingTypeParams() {
        return this.params != null && !this.params.isEmpty();
    }

    public List<TypeExpression> getTrailingTypeParams() {
        return this.params;
    }

    @Override
    public long getStartPosition() {
        if (this.left != null && this.name.getId() != Token.Id.CONSTRUCT) {
            return this.left.getStartPosition();
        }
        if (this.amp != null) {
            return this.amp.getStartPosition();
        }
        return this.name.getStartPosition();
    }

    @Override
    public long getEndPosition() {
        return this.lEndPos;
    }

    public boolean isSpecial() {
        NameExpression exprName;
        Expression expression;
        return this.name.isSpecial() || (expression = this.left) instanceof NameExpression && (exprName = (NameExpression)expression).isSpecial();
    }

    @Override
    public TypeExpression toTypeExpression() {
        AstNode exprType;
        block4: {
            exprType = null;
            Expression expression = this.left;
            if (expression instanceof NameExpression) {
                NameExpression exprLeft = (NameExpression)expression;
                ArrayList<Token> tokens = new ArrayList<Token>();
                tokens.add(this.name);
                while (true) {
                    if (exprLeft.params != null) break;
                    tokens.add(0, exprLeft.name);
                    Expression expr = exprLeft.left;
                    if (expr instanceof NameExpression) {
                        exprLeft = (NameExpression)expr;
                        continue;
                    }
                    break block4;
                    break;
                }
                NameExpression exprPrev = exprLeft;
                NamedTypeExpression exprLeftType = (NamedTypeExpression)exprPrev.toTypeExpression();
                exprType = new NamedTypeExpression(exprLeftType, tokens, this.params, this.lEndPos);
            }
        }
        if (exprType == null) {
            exprType = new NamedTypeExpression(null, this.getNameTokens(), null, null, this.params, this.lEndPos);
        }
        exprType.setParent(this.getParent());
        return exprType;
    }

    @Override
    protected Field[] getChildFields() {
        return CHILD_FIELDS;
    }

    @Override
    public boolean isLValueSyntax() {
        return true;
    }

    @Override
    public Expression getLValueExpression() {
        return this;
    }

    @Override
    public void updateLValueFromRValueTypes(Context ctx, Context.Branch branch, boolean fCond, TypeConstant[] aTypes) {
        assert (aTypes != null && aTypes.length >= 1);
        Argument argument = this.m_arg;
        if (argument instanceof Register) {
            Register reg = (Register)argument;
            TypeConstant typeOld = reg.getType();
            TypeConstant typeOrig = reg.getOriginalType();
            TypeConstant typeNew = aTypes[0];
            TypeConstant typeWide = typeNew.widenEnumValueTypes();
            if (typeWide != typeNew && typeWide.isA(reg.getOriginalType())) {
                typeNew = typeWide;
            }
            if (fCond) {
                typeNew = typeNew.union(this.pool(), typeOld);
            }
            if (typeNew.isA(typeOld) || typeNew.isA(typeOrig)) {
                ctx.narrowLocalRegister(this.getName(), reg, branch, typeNew);
            }
        }
    }

    @Override
    public void resetLValueTypes(Context ctx) {
        ctx.restoreOriginalType(this.getName());
    }

    @Override
    public TypeConstant getImplicitType(Context ctx) {
        return this.isValidated() ? this.getType() : this.getImplicitType(ctx, null, ErrorListener.BLACKHOLE);
    }

    public TypeConstant getImplicitType(Context ctx, TypeConstant typeDesired, ErrorListener errs) {
        Argument arg = this.resolveRawArgument(ctx, true, errs);
        return arg == null ? null : this.planCodeGen(ctx, arg, this.getImplicitTrailingTypeParameters(ctx), typeDesired, true, errs);
    }

    @Override
    public Expression.TypeFit testFit(Context ctx, TypeConstant typeRequired, boolean fExhaustive, ErrorListener errs) {
        if (typeRequired == null) {
            return Expression.TypeFit.Fit;
        }
        if (errs == null) {
            errs = ErrorListener.BLACKHOLE;
        }
        return this.calcFit(ctx, this.getImplicitType(ctx, typeRequired, errs), typeRequired);
    }

    @Override
    protected Expression validate(Context ctx, TypeConstant typeRequired, ErrorListener errs) {
        TypeConstant typeResolved;
        NameExpression exprName;
        Cloneable prop;
        Constant constVal;
        TypeConstant type;
        ConstantPool pool;
        Argument argRaw;
        block56: {
            boolean fValid;
            boolean fInferring;
            if (this.left != null) {
                Expression leftNew = this.left.validate(ctx, null, errs);
                if (leftNew == null) {
                    return this.finishValidation(ctx, typeRequired, typeRequired, Expression.TypeFit.NoFit, null, errs);
                }
                this.left = leftNew;
            }
            boolean bl = fInferring = typeRequired != null && !typeRequired.equals(this.pool().typeObject());
            if (fInferring) {
                ctx = ctx.enterInferring(typeRequired);
            }
            boolean bl2 = fValid = (argRaw = this.resolveRawArgument(ctx, true, errs)) != null;
            if (fInferring) {
                ctx = ctx.exit();
            }
            TypeConstant[] atypeParams = null;
            pool = this.pool();
            if (this.hasTrailingTypeParams()) {
                int cParams = this.params.size();
                atypeParams = new TypeConstant[cParams];
                for (int i = 0; i < cParams; ++i) {
                    TypeExpression exprOld = this.params.get(i);
                    TypeExpression exprNew = (TypeExpression)exprOld.validate(ctx, pool.typeType(), errs);
                    if (!(fValid &= exprNew != null)) continue;
                    if (exprNew != exprOld) {
                        this.params.set(i, exprNew);
                    }
                    atypeParams[i] = exprNew.ensureTypeConstant();
                }
            }
            if (!fValid) {
                return this.finishValidation(ctx, typeRequired, typeRequired, Expression.TypeFit.NoFit, null, errs);
            }
            type = this.planCodeGen(ctx, argRaw, atypeParams, typeRequired, false, errs);
            if (type == null) {
                return null;
            }
            argRaw = this.m_arg;
            constVal = null;
            block0 : switch (this.getMeaning().ordinal()) {
                case 6: {
                    switch (this.m_plan.ordinal()) {
                        case 0: {
                            constVal = (Constant)argRaw;
                            break block0;
                        }
                        case 1: 
                        case 2: {
                            break block0;
                        }
                        case 10: {
                            IdentityConstant identityConstant;
                            assert (argRaw instanceof IdentityConstant || argRaw instanceof PseudoConstant);
                            if (argRaw instanceof PseudoConstant) {
                                PseudoConstant constPseudo = (PseudoConstant)argRaw;
                                identityConstant = constPseudo.getDeclarationLevelClass();
                            } else {
                                identityConstant = (IdentityConstant)argRaw;
                            }
                            IdentityConstant idClass = identityConstant;
                            constVal = pool.ensureSingletonConstConstant(idClass);
                            break block0;
                        }
                        case 8: {
                            constVal = type;
                            break block0;
                        }
                    }
                    throw new IllegalStateException("plan=" + String.valueOf((Object)this.m_plan));
                }
                case 7: {
                    assert (argRaw instanceof IdentityConstant || argRaw instanceof PseudoConstant || argRaw instanceof TypedefConstant);
                    constVal = type;
                    break;
                }
                case 3: {
                    PropertyConstant id = (PropertyConstant)argRaw;
                    switch (this.m_plan.ordinal()) {
                        case 4: 
                        case 10: {
                            prop = (PropertyStructure)id.getComponent();
                            if (!((PropertyStructure)prop).isRuntimeConstant()) break;
                            constVal = ((PropertyStructure)prop).getInitialValue();
                            if (constVal instanceof DeferredValueConstant && !errs.hasSeriousErrors()) {
                                this.log(errs, Severity.ERROR, "COMPILER-47", new Object[0]);
                                return null;
                            }
                            if (constVal != null) break;
                            constVal = pool.ensureSingletonConstConstant(id);
                            break;
                        }
                        case 6: {
                            assert (type.isA(pool.typeProperty()));
                            TypeConstant typeParent = this.left == null ? ctx.getThisType() : (this.m_fClassAttribute || !this.isIdentityMode(ctx, false) ? this.left.getType() : this.left.getType().getParamType(0));
                            constVal = pool.ensurePropertyClassTypeConstant(typeParent, id);
                            break;
                        }
                        case 0: {
                            assert (type.isA(pool.typeProperty()));
                            assert (this.left == null || this.left.getType().isA(pool.typeClass()));
                            TypeConstant typeParent = this.left == null ? ctx.getThisType() : (this.m_fClassAttribute ? this.left.getType() : this.left.getType().getParamType(0));
                            constVal = pool.ensurePropertyClassTypeConstant(typeParent, id);
                            break;
                        }
                    }
                    break;
                }
                case 5: {
                    MethodConstant idMethod = (MethodConstant)argRaw;
                    switch (this.m_plan.ordinal()) {
                        case 0: {
                            if (this.m_mapTypeParams == null) {
                                constVal = idMethod;
                                break block0;
                            }
                            break block56;
                        }
                        case 12: {
                            IdentityConstant idClz;
                            ClassStructure clz;
                            NameExpression exprName2;
                            if (this.left == null) {
                                ctx.requireThis(this.getStartPosition(), errs);
                                break block0;
                            }
                            Expression expression = this.left;
                            if (expression instanceof NameExpression && (exprName2 = (NameExpression)expression).getMeaning() == Meaning.Class && !(clz = (ClassStructure)(idClz = exprName2.getIdentity(ctx)).getComponent()).isSingleton()) {
                                this.log(errs, Severity.ERROR, "COMPILER-108", idMethod.getValueString(), exprName2.getName());
                                break block0;
                            }
                            break block56;
                        }
                        case 13: {
                            constVal = this.m_idBjarnLambda;
                        }
                    }
                }
            }
        }
        if (this.left == null && this.isRValue()) {
            switch (this.getMeaning().ordinal()) {
                case 2: {
                    if (type.containsFormalType(true)) {
                        ctx.useFormalType(type, errs);
                    }
                    ctx.markVarRead(this.getNameToken(), !this.isSuppressDeref(), errs);
                    break;
                }
                case 1: {
                    ctx.markVarRead(this.getNameToken(), true, errs);
                    break;
                }
                case 3: {
                    ClassStructure clzParent;
                    PropertyConstant idProp = (PropertyConstant)argRaw;
                    if (idProp.isFormalType()) {
                        ctx.useFormalType(idProp.getFormalType(), errs);
                        break;
                    }
                    if (idProp.getComponent().isStatic() || this.m_plan == Plan.PropertySelf) break;
                    prop = (PropertyStructure)idProp.getComponent();
                    MethodStructure method = ctx.getMethod();
                    Component component = ((Component)prop).getParent();
                    if (component instanceof ClassStructure && (clzParent = (ClassStructure)component).isSingleton() && (method == null || !method.isPotentialInitializer())) {
                        this.m_propAccessPlan = PropertyAccess.SingletonParent;
                        this.m_idSingletonParent = clzParent.getIdentityConstant();
                        break;
                    }
                    if (this.getParent() instanceof NameExpression) {
                        if (ctx.requireThis(this.getStartPosition(), null)) break;
                        this.m_plan = Plan.PropertyIdentity;
                        break;
                    }
                    ctx.requireThis(this.getStartPosition(), errs);
                    break;
                }
            }
        }
        if ((prop = this.left) instanceof NameExpression && (exprName = (NameExpression)prop).getMeaning() == Meaning.Label) {
            String sVar;
            LabeledStatement.LabelVar labelVar = (LabeledStatement.LabelVar)ctx.getVar(exprName.getNameToken(), errs);
            if (labelVar.isPropReadable(sVar = this.getName())) {
                labelVar.markPropRead(ctx, sVar);
            } else {
                String sLabel = exprName.getName();
                this.log(errs, Severity.ERROR, "COMPILER-94", sVar, sLabel);
                return this.finishValidation(ctx, typeRequired, null, Expression.TypeFit.NoFit, null, errs);
            }
        }
        if (type != null && type.isGenericType() && !(typeResolved = type.resolveGenerics(pool, ctx.getThisType())).isGenericType()) {
            type = typeResolved;
        }
        return this.finishValidation(ctx, typeRequired, type, Expression.TypeFit.Fit, constVal, errs);
    }

    @Override
    public boolean isCompletable() {
        return this.left == null || this.left.isCompletable();
    }

    @Override
    public boolean isConditionalResult() {
        return this.getValueCount() == 1 && this.isConstantFalse();
    }

    @Override
    public boolean isShortCircuiting() {
        return this.left != null && this.left.isShortCircuiting();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected Expression.SideEffect mightAffect(Expression exprLeft, Argument arg) {
        switch (super.mightAffect(exprLeft, arg)) {
            case DefNo: {
                return Expression.SideEffect.DefNo;
            }
            case AnyCompute: {
                Expression.SideEffect sideEffect;
                if (this.getMeaning() == Meaning.Property && !this.isSuppressDeref()) {
                    sideEffect = Expression.SideEffect.DefYes;
                    return sideEffect;
                }
                sideEffect = Expression.SideEffect.DefNo;
                return sideEffect;
            }
            case Unknown: {
                Expression.SideEffect sideEffect;
                if (exprLeft instanceof NameExpression) {
                    NameExpression that = (NameExpression)exprLeft;
                    if (this.getMeaning() == Meaning.Variable && that.getMeaning() == Meaning.Variable && this.getName().equals(that.getName())) {
                        sideEffect = Expression.SideEffect.AnySeqOp;
                        return sideEffect;
                    }
                }
                sideEffect = Expression.SideEffect.DefNo;
                return sideEffect;
            }
        }
        throw new IllegalStateException();
    }

    @Override
    public boolean isTraceworthy() {
        if (!this.isCompletable()) {
            return false;
        }
        return switch (this.getMeaning().ordinal()) {
            default -> throw new MatchException(null, null);
            case 2, 3, 4 -> true;
            case 0, 1, 5, 6, 7, 8 -> false;
        };
    }

    @Override
    protected void selectTraceableExpressions(Map<String, Expression> mapExprs) {
        switch (this.getMeaning().ordinal()) {
            case 2: 
            case 3: 
            case 4: {
                return;
            }
        }
        super.selectTraceableExpressions(mapExprs);
    }

    @Override
    public boolean isAssignable(Context ctx) {
        if (this.m_fAssignable) {
            switch (this.getMeaning().ordinal()) {
                case 2: {
                    return this.m_plan == Plan.None;
                }
                case 3: {
                    return this.m_plan == Plan.PropertyDeref;
                }
            }
        }
        return false;
    }

    @Override
    public void requireAssignable(Context ctx, ErrorListener errs) {
        if (this.isAssignable(ctx)) {
            if (this.left == null) {
                switch (this.getMeaning().ordinal()) {
                    case 1: 
                    case 2: {
                        return;
                    }
                    case 3: {
                        if (((PropertyConstant)this.m_arg).getComponent().isStatic()) break;
                        ctx.requireThis(this.getStartPosition(), errs);
                    }
                }
            }
        } else {
            super.requireAssignable(ctx, errs);
        }
    }

    @Override
    public void markAssignment(Context ctx, boolean fCond, ErrorListener errs) {
        if (this.isAssignable(ctx) && this.left == null) {
            switch (this.getMeaning().ordinal()) {
                case 1: 
                case 2: {
                    ctx.markVarWrite(this.getNameToken(), fCond, errs);
                    break;
                }
            }
        }
    }

    @Override
    public void generateAssignment(Context ctx, MethodStructure.Code code, Expression.Assignable LVal, ErrorListener errs) {
        if (LVal.isLocalArgument() && !this.isConstant()) {
            Argument argLVal = LVal.getLocalArgument();
            Argument argRaw = this.m_arg;
            switch (this.m_plan.ordinal()) {
                case 1: {
                    int n;
                    assert (this.getMeaning() == Meaning.Class || this.getMeaning() == Meaning.Reserved);
                    Constants.Access access = this.getType().getAccess();
                    if (argRaw instanceof ParentClassConstant) {
                        ParentClassConstant constParent = (ParentClassConstant)argRaw;
                        n = constParent.getDepth();
                    } else {
                        n = ((StatementBlock.TargetInfo)argRaw).getStepsOut();
                    }
                    int cSteps = n;
                    code.add(new MoveThis(cSteps, argLVal, access));
                    this.m_astResult = new OuterExprAST(ctx.getThisRegisterAST(), cSteps, this.getType());
                    return;
                }
                case 2: {
                    int n;
                    assert (this.getMeaning() == Meaning.Class);
                    if (argRaw instanceof ParentClassConstant) {
                        ParentClassConstant constParent = (ParentClassConstant)argRaw;
                        n = constParent.getDepth();
                    } else {
                        n = 0;
                    }
                    int cSteps = n;
                    TypeConstant typeRef = this.getType();
                    TypeConstant typeReferent = typeRef.getParamType(0);
                    Register regTemp = code.createRegister(typeReferent);
                    code.add(new MoveThis(cSteps, regTemp, typeRef.getAccess()));
                    code.add(new MoveRef(regTemp, argLVal));
                    ExprAST astTemp = ctx.getThisRegisterAST();
                    if (cSteps > 0) {
                        astTemp = new OuterExprAST(astTemp, cSteps, typeReferent);
                    }
                    if (typeRef.getAccess() != typeReferent.getAccess()) {
                        UnaryOpExprAST.Operator op = switch (typeRef.getAccess()) {
                            case Constants.Access.PUBLIC -> UnaryOpExprAST.Operator.Public;
                            case Constants.Access.PROTECTED -> UnaryOpExprAST.Operator.Protected;
                            case Constants.Access.PRIVATE -> UnaryOpExprAST.Operator.Private;
                            default -> throw new IllegalStateException();
                        };
                        astTemp = new UnaryOpExprAST(astTemp, op, this.getType());
                    }
                    this.m_astResult = new UnaryOpExprAST(astTemp, UnaryOpExprAST.Operator.Ref, this.getType());
                    return;
                }
                case 4: {
                    NameExpression exprName;
                    Expression typeRef = this.left;
                    if (typeRef instanceof NameExpression && (exprName = (NameExpression)typeRef).getMeaning() == Meaning.Label || !LVal.supportsLocalPropMode()) break;
                    PropertyConstant idProp = (PropertyConstant)argRaw;
                    switch (this.calculatePropertyAccess(false).ordinal()) {
                        case 0: {
                            SingletonConstant idSingleton = this.pool().ensureSingletonConstConstant(this.m_idSingletonParent);
                            code.add(new P_Get(idProp, idSingleton, argLVal));
                            ConstantExprAST astSingleton = new ConstantExprAST(idSingleton);
                            this.m_astResult = new PropertyExprAST(astSingleton, idProp);
                            break;
                        }
                        case 1: {
                            int cSteps = this.m_targetInfo.getStepsOut();
                            TypeConstant type = this.m_targetInfo.getType();
                            Register regOuter = new Register(type, null, -1);
                            code.add(new MoveThis(cSteps, regOuter, type.getAccess()));
                            code.add(new P_Get(idProp, regOuter, argLVal));
                            OuterExprAST astOuter = new OuterExprAST(ctx.getThisRegisterAST(), cSteps, type);
                            this.m_astResult = new PropertyExprAST(astOuter, idProp);
                            break;
                        }
                        case 2: {
                            if (idProp.equals(argLVal)) {
                                this.log(errs, Severity.ERROR, "COMPILER-201", idProp.getName());
                            }
                            code.add(new L_Get(idProp, argLVal));
                            this.m_astResult = new PropertyExprAST(ctx.getThisRegisterAST(), idProp);
                            break;
                        }
                        case 3: {
                            assert (!idProp.getComponent().isStatic());
                            Argument argLeft = this.left.generateArgument(ctx, code, false, true, errs);
                            code.add(new P_Get(idProp, argLeft, argLVal));
                            this.m_astResult = new PropertyExprAST(this.left.getExprAST(ctx), idProp);
                            break;
                        }
                    }
                    return;
                }
                case 5: {
                    PropertyConstant idProp = (PropertyConstant)argRaw;
                    Argument argTarget = this.generateRefTarget(ctx, code, idProp, errs);
                    if ("outer".equals(idProp.getName())) {
                        TypeConstant typeTarget = argTarget.getType().resolveConstraints();
                        TypeConstant typeOuter = typeTarget.isVirtualChild() ? typeTarget.getParentType() : this.pool().typeObject();
                        Register regOuter = new Register(typeOuter, null, -1);
                        code.add(new P_Get(idProp, argTarget, regOuter));
                        code.add(new MoveRef(regOuter, argLVal));
                    } else {
                        code.add(this.m_fAssignable ? new P_Var(idProp, argTarget, argLVal) : new P_Ref(idProp, argTarget, argLVal));
                    }
                    PropertyExprAST astTarget = new PropertyExprAST(this.m_astRefTarget, idProp);
                    this.m_astResult = new UnaryOpExprAST(astTarget, this.m_fAssignable ? UnaryOpExprAST.Operator.Var : UnaryOpExprAST.Operator.Ref, this.getType());
                    return;
                }
                case 3: {
                    Register regRVal = (Register)argRaw;
                    code.add(this.m_fAssignable ? new MoveVar(regRVal, argLVal) : new MoveRef(regRVal, argLVal));
                    this.m_astResult = new UnaryOpExprAST(regRVal.getRegisterAST(), this.m_fAssignable ? UnaryOpExprAST.Operator.Var : UnaryOpExprAST.Operator.Ref, this.getType());
                    return;
                }
                case 12: {
                    ExprAST astTarget;
                    Argument argTarget;
                    MethodConstant idMethod = (MethodConstant)argRaw;
                    if (this.left == null) {
                        int cSteps;
                        int n = cSteps = this.m_targetInfo == null ? 0 : this.m_targetInfo.getStepsOut();
                        if (cSteps > 0) {
                            TypeConstant typeTarget = this.m_targetInfo.getTargetType();
                            argTarget = new Register(typeTarget, null, -1);
                            code.add(new MoveThis(cSteps, argTarget, typeTarget.getAccess()));
                            astTarget = new OuterExprAST(ctx.getThisRegisterAST(), cSteps, typeTarget);
                        } else {
                            argTarget = ctx.getThisRegister();
                            astTarget = ctx.getThisRegisterAST();
                        }
                    } else {
                        argTarget = this.left.generateArgument(ctx, code, true, true, errs);
                        astTarget = this.left.getExprAST(ctx);
                    }
                    if (this.m_mapTypeParams == null) {
                        code.add(new MBind(argTarget, idMethod, argLVal));
                    } else {
                        Register regFn = new Register(this.pool().typeFunction(), null, -1);
                        code.add(new MBind(argTarget, idMethod, regFn));
                        this.bindTypeParameters(ctx, code, regFn, argLVal);
                    }
                    this.m_astResult = new BindMethodAST(astTarget, idMethod, this.getType());
                    return;
                }
                case 13: {
                    MethodConstant idHandler = this.m_idBjarnLambda;
                    code.add(new Move(idHandler, argLVal));
                    this.m_astResult = new ConstantExprAST(idHandler);
                    return;
                }
            }
        }
        super.generateAssignment(ctx, code, LVal, errs);
    }

    @Override
    public Argument generateArgument(Context ctx, MethodStructure.Code code, boolean fLocalPropOk, boolean fUsedOnce, ErrorListener errs) {
        if (this.isConstant()) {
            return this.toConstant();
        }
        Argument argRaw = this.m_arg;
        switch (this.m_plan.ordinal()) {
            case 0: {
                switch (this.getMeaning().ordinal()) {
                    case 1: {
                        Expression expression = this.left;
                        if (!(expression instanceof NameExpression)) break;
                        NameExpression nameLeft = (NameExpression)expression;
                        if (nameLeft.m_plan != Plan.OuterThis) break;
                        TypeConstant typeOuter = argRaw.getType();
                        Register regOuter = code.createRegister(typeOuter, fUsedOnce);
                        code.add(new MoveThis(1, regOuter, typeOuter.getAccess()));
                        this.m_astResult = new OuterExprAST(ctx.getThisRegisterAST(), 1, typeOuter);
                        assert (this.m_mapTypeParams == null);
                        return regOuter;
                    }
                    case 8: {
                        throw new IllegalStateException();
                    }
                }
                if (this.m_mapTypeParams != null) {
                    Register regFn = code.createRegister(argRaw.getType(), fUsedOnce);
                    this.bindTypeParameters(ctx, code, argRaw, regFn);
                    System.err.println("TODO: AST for " + String.valueOf(this));
                    return regFn;
                }
                this.m_astResult = NameExpression.toExprAst(argRaw);
                return argRaw;
            }
            case 1: {
                Object targetInfo;
                int cSteps;
                TypeConstant typeOuter;
                if (argRaw instanceof ParentClassConstant) {
                    ParentClassConstant constParent = (ParentClassConstant)argRaw;
                    typeOuter = this.getType();
                    cSteps = constParent.getDepth();
                } else {
                    targetInfo = (StatementBlock.TargetInfo)argRaw;
                    typeOuter = ((StatementBlock.TargetInfo)targetInfo).getType();
                    cSteps = ((StatementBlock.TargetInfo)targetInfo).getStepsOut();
                }
                targetInfo = this.left;
                if (targetInfo instanceof NameExpression) {
                    NameExpression nameLeft = (NameExpression)targetInfo;
                    if (nameLeft.m_plan == Plan.OuterThis) {
                        ++cSteps;
                    }
                }
                Register regOuter = code.createRegister(typeOuter, fUsedOnce);
                code.add(new MoveThis(cSteps, regOuter, typeOuter.getAccess()));
                this.m_astResult = new OuterExprAST(ctx.getThisRegisterAST(), cSteps, typeOuter);
                return regOuter;
            }
            case 2: {
                int cSteps;
                TypeConstant typeRef;
                TypeConstant typeOuter;
                if (argRaw instanceof StatementBlock.TargetInfo) {
                    StatementBlock.TargetInfo targetInfo = (StatementBlock.TargetInfo)argRaw;
                    typeOuter = targetInfo.getType();
                    typeRef = this.pool().ensureParameterizedTypeConstant(this.pool().typeRef(), typeOuter);
                    cSteps = targetInfo.getStepsOut();
                } else {
                    int n;
                    typeRef = this.getType();
                    typeOuter = typeRef.getParamType(0);
                    if (argRaw instanceof ParentClassConstant) {
                        ParentClassConstant constParent = (ParentClassConstant)argRaw;
                        n = constParent.getDepth();
                    } else {
                        n = 0;
                    }
                    cSteps = n;
                }
                Register regOuter = code.createRegister(typeOuter, fUsedOnce);
                code.add(new MoveThis(cSteps, regOuter, typeOuter.getAccess()));
                Register regRef = code.createRegister(typeRef, fUsedOnce);
                code.add(new MoveRef(regOuter, (Argument)regRef));
                this.m_astResult = new UnaryOpExprAST(new OuterExprAST(ctx.getThisRegisterAST(), cSteps, typeOuter), UnaryOpExprAST.Operator.Ref, typeRef);
                return regRef;
            }
            case 4: {
                NameExpression nameLeft;
                Expression typeOuter = this.left;
                if (typeOuter instanceof NameExpression && (nameLeft = (NameExpression)typeOuter).getMeaning() == Meaning.Label) {
                    LabeledStatement.LabelVar labelVar = (LabeledStatement.LabelVar)nameLeft.m_arg;
                    Register regLabel = labelVar.getPropRegister(ctx, this.getName());
                    this.m_astResult = regLabel.getRegisterAST();
                    return regLabel;
                }
                PropertyConstant idProp = (PropertyConstant)argRaw;
                Register regTemp = code.createRegister(this.getType(), fUsedOnce);
                switch (this.calculatePropertyAccess(false).ordinal()) {
                    case 0: {
                        SingletonConstant idSingleton = this.pool().ensureSingletonConstConstant(this.m_idSingletonParent);
                        code.add(new P_Get(idProp, idSingleton, regTemp));
                        ConstantExprAST astSingleton = new ConstantExprAST(idSingleton);
                        this.m_astResult = new PropertyExprAST(astSingleton, idProp);
                        break;
                    }
                    case 1: {
                        int cSteps = this.m_targetInfo.getStepsOut();
                        TypeConstant typeOuter2 = this.m_targetInfo.getType();
                        Register regOuter = new Register(typeOuter2, null, -1);
                        code.add(new MoveThis(cSteps, regOuter, typeOuter2.getAccess()));
                        if (idProp.isFuture()) {
                            regTemp = code.createRegister(typeOuter2);
                            code.add(new Var_D(regTemp));
                        }
                        code.add(new P_Get(idProp, regOuter, regTemp));
                        OuterExprAST astOuter = new OuterExprAST(ctx.getThisRegisterAST(), cSteps, typeOuter2);
                        this.m_astResult = new PropertyExprAST(astOuter, idProp);
                        break;
                    }
                    case 2: {
                        if ("outer".equals(idProp.getName())) {
                            code.add(new MoveThis(1, regTemp));
                            this.m_astResult = new OuterExprAST(ctx.getThisRegisterAST(), 1, this.getType());
                            break;
                        }
                        if (idProp.isFuture()) {
                            regTemp = code.createRegister(idProp.getRefType(ctx.getThisType()));
                            code.add(new Var_D(regTemp));
                        } else if (fLocalPropOk || idProp.getComponent().isStatic()) {
                            return idProp;
                        }
                        code.add(new L_Get(idProp, regTemp));
                        this.m_astResult = new PropertyExprAST(ctx.getThisRegisterAST(), idProp);
                        break;
                    }
                    case 3: {
                        if (idProp.getComponent().isStatic()) {
                            return idProp;
                        }
                        Argument argLeft = this.left.generateArgument(ctx, code, false, true, errs);
                        if (idProp.isFuture()) {
                            regTemp = code.createRegister(idProp.getRefType(argLeft.getType()));
                            code.add(new Var_D(regTemp));
                        }
                        code.add(new P_Get(idProp, argLeft, regTemp));
                        this.m_astResult = new PropertyExprAST(this.left.getExprAST(ctx), idProp);
                        break;
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
                return regTemp;
            }
            case 5: {
                Register regRef;
                PropertyConstant idProp = (PropertyConstant)argRaw;
                Argument argTarget = this.generateRefTarget(ctx, code, idProp, errs);
                if ("outer".equals(idProp.getName())) {
                    ConstantPool pool = this.pool();
                    TypeConstant typeTarget = argTarget.getType().resolveConstraints();
                    TypeConstant typeOuter = typeTarget.isVirtualChild() ? typeTarget.getParentType() : pool.typeObject();
                    Register regOuter = new Register(typeOuter, null, -1);
                    code.add(new P_Get(idProp, argTarget, regOuter));
                    TypeConstant typeRef = pool.ensureParameterizedTypeConstant(pool.typeRef(), typeOuter);
                    regRef = code.createRegister(typeRef, fUsedOnce);
                    code.add(new MoveRef(regOuter, (Argument)regRef));
                } else {
                    regRef = code.createRegister(this.getType(), fUsedOnce);
                    code.add(this.m_fAssignable ? new P_Var(idProp, argTarget, regRef) : new P_Ref(idProp, argTarget, regRef));
                }
                PropertyExprAST astTarget = new PropertyExprAST(this.m_astRefTarget, idProp);
                this.m_astResult = new UnaryOpExprAST(astTarget, this.m_fAssignable ? UnaryOpExprAST.Operator.Var : UnaryOpExprAST.Operator.Ref, this.getType());
                return regRef;
            }
            case 3: {
                Register regVal = (Register)argRaw;
                Register regRef = code.createRegister(this.getType(), fUsedOnce);
                code.add(this.m_fAssignable ? new MoveVar(regVal, (Argument)regRef) : new MoveRef(regVal, (Argument)regRef));
                this.m_astResult = new UnaryOpExprAST(regVal.getRegisterAST(), this.m_fAssignable ? UnaryOpExprAST.Operator.Var : UnaryOpExprAST.Operator.Ref, this.getType());
                return regRef;
            }
            case 10: {
                assert (!this.isConstant());
                assert (((IdentityConstant)argRaw).getComponent().isStatic());
                return argRaw;
            }
            case 8: 
            case 9: {
                assert (this.isConstant());
                return this.toConstant();
            }
            case 11: {
                FormalTypeChildConstant idChild = (FormalTypeChildConstant)argRaw;
                Argument argTarget = this.left.generateArgument(ctx, code, true, true, errs);
                Register regType = code.createRegister(idChild.getType(), fUsedOnce);
                code.add(new P_Get(idChild, argTarget, regType));
                this.m_astResult = new PropertyExprAST(this.left.getExprAST(ctx), idChild);
                return regType;
            }
            case 12: {
                ExprAST astTarget;
                Argument argTarget;
                MethodConstant idMethod = (MethodConstant)argRaw;
                if (this.left == null) {
                    int cSteps;
                    int n = cSteps = this.m_targetInfo == null ? 0 : this.m_targetInfo.getStepsOut();
                    if (cSteps > 0) {
                        TypeConstant typeTarget = this.m_targetInfo.getTargetType();
                        argTarget = new Register(typeTarget, null, -1);
                        code.add(new MoveThis(cSteps, argTarget, typeTarget.getAccess()));
                        astTarget = new OuterExprAST(ctx.getThisRegisterAST(), cSteps, typeTarget);
                    } else {
                        argTarget = ctx.getThisRegister();
                        astTarget = ctx.getThisRegisterAST();
                    }
                } else {
                    argTarget = this.left.generateArgument(ctx, code, true, true, errs);
                    astTarget = this.left.getExprAST(ctx);
                }
                Register regFn = code.createRegister(idMethod.getType(), fUsedOnce);
                if (this.m_mapTypeParams == null) {
                    code.add(new MBind(argTarget, idMethod, regFn));
                } else {
                    Register regFn0 = code.createRegister(this.pool().typeFunction());
                    code.add(new MBind(argTarget, idMethod, regFn0));
                    this.bindTypeParameters(ctx, code, regFn0, regFn);
                }
                this.m_astResult = new BindMethodAST(astTarget, idMethod, this.getType());
                return regFn;
            }
            case 13: {
                MethodConstant idHandler = this.m_idBjarnLambda;
                this.m_astResult = new ConstantExprAST(idHandler);
                return idHandler;
            }
        }
        throw new IllegalStateException("arg=" + String.valueOf(argRaw));
    }

    private MethodConstant createBjarneLambda(ClassStructure clz, MethodConstant idMethod, int cReturns) {
        ConstantPool pool = this.pool();
        MultiMethodStructure mms = clz.ensureMultiMethodStructure("->");
        TypeConstant typeLambda = idMethod.getBjarneLambdaType();
        TypeConstant[] atypeParam = pool.extractFunctionParams(typeLambda);
        TypeConstant[] atypeReturn = pool.extractFunctionReturns(typeLambda);
        int cParams = atypeParam.length;
        int cOrigReturns = atypeReturn.length;
        assert (cParams > 0 && cReturns <= cOrigReturns);
        Parameter[] aparamParam = new Parameter[cParams];
        for (int i = 0; i < cParams; ++i) {
            aparamParam[i] = new Parameter(pool, atypeParam[i], "p" + i, null, false, i, false);
        }
        Parameter[] aparamReturn = new Parameter[cReturns];
        for (int i = 0; i < cReturns; ++i) {
            aparamReturn[i] = new Parameter(pool, atypeReturn[i], null, null, true, i, false);
        }
        if (cReturns < cOrigReturns) {
            atypeReturn = Arrays.copyOfRange(atypeReturn, 0, cReturns);
        }
        MethodStructure lambda = mms.createLambda(TypeConstant.NO_TYPES, Utils.NO_NAMES);
        lambda.configureLambda(aparamParam, 0, aparamReturn);
        lambda.setStatic(true);
        lambda.getIdentityConstant().setSignature(pool.ensureSignatureConstant("->", atypeParam, atypeReturn));
        MethodStructure.Code code = lambda.createCode();
        Register regTarget = new Register(atypeParam[0], null, 0);
        block0 : switch (cParams - 1) {
            case 0: {
                switch (cReturns) {
                    case 0: {
                        code.add(new Invoke_00(regTarget, idMethod));
                        code.add(Return_0.INSTANCE);
                        break block0;
                    }
                    case 1: {
                        Register regRet = new Register(atypeReturn[0], null, -1);
                        code.add(new Invoke_01(regTarget, idMethod, regRet));
                        code.add(new Return_1(regRet));
                        break block0;
                    }
                }
                Argument[] aregRet = new Register[cReturns];
                for (int i = 0; i < cReturns; ++i) {
                    aregRet[i] = new Register(atypeReturn[i], null, -1);
                }
                code.add(new Invoke_0N(regTarget, idMethod, aregRet));
                code.add(new Return_N(aregRet));
                break;
            }
            case 1: {
                Register regParam = new Register(atypeParam[1], null, 1);
                switch (cReturns) {
                    case 0: {
                        code.add(new Invoke_10(regTarget, idMethod, regParam));
                        code.add(Return_0.INSTANCE);
                        break block0;
                    }
                    case 1: {
                        Register regRet = new Register(atypeReturn[0], null, -1);
                        code.add(new Invoke_11(regTarget, idMethod, regParam, regRet));
                        code.add(new Return_1(regRet));
                        break block0;
                    }
                }
                Argument[] aregRet = new Register[cReturns];
                for (int i = 0; i < cReturns; ++i) {
                    aregRet[i] = new Register(atypeReturn[i], null, -1);
                }
                code.add(new Invoke_1N(regTarget, idMethod, regParam, aregRet));
                code.add(new Return_N(aregRet));
                break;
            }
            default: {
                Argument[] aregParam = new Register[cParams];
                for (int i = 1; i < cParams; ++i) {
                    aregParam[i] = new Register(atypeParam[i], null, i);
                }
                switch (cReturns) {
                    case 0: {
                        code.add(new Invoke_N0(regTarget, idMethod, aregParam));
                        code.add(Return_0.INSTANCE);
                        break block0;
                    }
                    case 1: {
                        Register regRet = new Register(atypeReturn[0], null, -1);
                        code.add(new Invoke_N1(regTarget, idMethod, aregParam, regRet));
                        code.add(new Return_1(regRet));
                        break block0;
                    }
                }
                Argument[] aregRet = new Register[cReturns];
                for (int i = 0; i < cReturns; ++i) {
                    aregRet[i] = new Register(atypeReturn[i], null, -1);
                }
                code.add(new Invoke_NN(regTarget, idMethod, aregParam, aregRet));
                code.add(new Return_N(aregRet));
                break;
            }
        }
        lambda.forceAssembly(pool);
        return lambda.getIdentityConstant();
    }

    private MethodConstant createBjarneLambda(ClassStructure clz, PropertyConstant idProp) {
        ConstantPool pool = this.pool();
        MultiMethodStructure mms = clz.ensureMultiMethodStructure("->");
        TypeConstant typeParam = idProp.getNamespace().getType();
        TypeConstant typeReturn = idProp.getType();
        Parameter[] aparamParam = new Parameter[]{new Parameter(pool, typeParam, "p", null, false, 0, false)};
        Parameter[] aparamReturn = new Parameter[]{new Parameter(pool, typeReturn, null, null, true, 0, false)};
        MethodStructure lambda = mms.createLambda(TypeConstant.NO_TYPES, Utils.NO_NAMES);
        lambda.configureLambda(aparamParam, 0, aparamReturn);
        lambda.setStatic(true);
        lambda.getIdentityConstant().setSignature(pool.ensureSignatureConstant("->", new TypeConstant[]{typeParam}, new TypeConstant[]{typeReturn}));
        MethodStructure.Code code = lambda.createCode();
        Register regTarget = new Register(typeParam, null, 0);
        Register regRet = new Register(typeReturn, null, -1);
        code.add(new P_Get(idProp, regTarget, regRet));
        code.add(new Return_1(regRet));
        lambda.forceAssembly(pool);
        return lambda.getIdentityConstant();
    }

    private Argument generateRefTarget(Context ctx, MethodStructure.Code code, PropertyConstant idProp, ErrorListener errs) {
        switch (this.calculatePropertyAccess(true).ordinal()) {
            case 0: {
                this.m_astRefTarget = new ConstantExprAST(this.m_idSingletonParent);
                return this.pool().ensureSingletonConstConstant(this.m_idSingletonParent);
            }
            case 1: {
                int cSteps = this.m_targetInfo.getStepsOut();
                TypeConstant typeOuter = this.m_targetInfo.getTargetType().ensureAccess(Constants.Access.PRIVATE);
                Register regOuter = new Register(typeOuter, null, -1);
                code.add(new MoveThis(cSteps, regOuter, Constants.Access.PRIVATE));
                this.m_astRefTarget = new OuterExprAST(ctx.getThisRegisterAST(), cSteps, typeOuter);
                return regOuter;
            }
            case 2: {
                this.m_astRefTarget = ctx.getThisRegisterAST();
                return ctx.getThisRegister();
            }
            case 3: {
                assert (!idProp.getComponent().isStatic());
                Argument arg = this.left.generateArgument(ctx, code, true, true, errs);
                this.m_astRefTarget = this.left.getExprAST(ctx);
                return arg;
            }
        }
        throw new IllegalStateException();
    }

    private void bindTypeParameters(Context ctx, MethodStructure.Code code, Argument argFnOrig, Argument argFnResult) {
        List<Map.Entry<FormalConstant, TypeConstant>> list = this.m_mapTypeParams.asList();
        int cParams = list.size();
        int[] anBindIx = new int[cParams];
        Argument[] aArgBind = new Argument[cParams];
        for (int i = 0; i < cParams; ++i) {
            Map.Entry<FormalConstant, TypeConstant> entry = list.get(i);
            FormalConstant constFormal = entry.getKey();
            TypeConstant type = entry.getValue();
            anBindIx[i] = i;
            if (type.isGenericType()) {
                TypeInfo infoThis = ctx.getThisType().ensureTypeInfo();
                Register regType = code.createRegister(this.pool().typeType(), i == 0);
                code.add(new L_Get(infoThis.findProperty(constFormal.getName()).getIdentity(), regType));
                aArgBind[i] = regType;
                continue;
            }
            if (type.isTypeParameter()) {
                int iReg = ((TypeParameterConstant)constFormal).getRegister();
                aArgBind[i] = ctx.getParameter(iReg);
                continue;
            }
            aArgBind[i] = type;
        }
        code.add(new FBind(argFnOrig, anBindIx, aArgBind, argFnResult));
    }

    @Override
    public Expression.Assignable generateAssignable(Context ctx, MethodStructure.Code code, ErrorListener errs) {
        if (this.isAssignable(ctx)) {
            StatementBlock.TargetInfo target = this.m_targetInfo;
            Argument arg = this.m_arg;
            if (arg instanceof Register) {
                Register reg = (Register)arg;
                assert (target == null);
                this.m_astResult = reg.getRegisterAST();
                return new Expression.Assignable(reg);
            }
            if (arg instanceof PropertyConstant) {
                Argument argTarget;
                ExprAST astTarget;
                PropertyConstant idProp = (PropertyConstant)arg;
                if (this.left == null) {
                    Register regTarget;
                    switch (this.m_propAccessPlan.ordinal()) {
                        case 0: {
                            IdentityConstant idParent = this.m_idSingletonParent;
                            SingletonConstant idSingleton = this.pool().ensureSingletonConstConstant(idParent);
                            regTarget = code.createRegister(idParent.getType());
                            code.add(new Var_I(regTarget, idSingleton));
                            astTarget = regTarget.getRegAllocAST();
                            break;
                        }
                        case 2: {
                            regTarget = ctx.getThisRegister();
                            astTarget = regTarget.getRegisterAST();
                            break;
                        }
                        case 1: {
                            int cSteps;
                            ClassStructure clz = ctx.getThisClass();
                            int i = cSteps = target.getStepsOut();
                            while (--i >= 0) {
                                clz = clz.getContainingClass();
                            }
                            regTarget = new Register(clz.getFormalType(), null, -1);
                            code.add(new MoveThis(cSteps, regTarget));
                            astTarget = new OuterExprAST(ctx.getThisRegisterAST(), cSteps, this.getType());
                            break;
                        }
                        default: {
                            throw new IllegalStateException();
                        }
                    }
                    argTarget = regTarget;
                } else {
                    argTarget = this.left.generateArgument(ctx, code, true, true, errs);
                    astTarget = this.left.getExprAST(ctx);
                }
                this.m_astResult = new PropertyExprAST(astTarget, idProp);
                return (Expression)this.new Expression.Assignable(argTarget, idProp);
            }
            return super.generateAssignable(ctx, code, errs);
        }
        return null;
    }

    @Override
    public ExprAST getExprAST(Context ctx) {
        Register reg;
        if (this.m_astResult != null) {
            return this.m_astResult;
        }
        Argument argRaw = this.m_arg;
        if ((argRaw instanceof PropertyConstant && this.m_plan == Plan.PropertyDeref || argRaw instanceof Register && !(reg = (Register)argRaw).isStack()) && !this.getTypeFit().isConverting()) {
            return NameExpression.toExprAst(argRaw);
        }
        return this.isConstant() && this.isRValue() ? new ConstantExprAST(this.toConstant()) : super.getExprAST(ctx);
    }

    protected TypeConstant[] getImplicitTrailingTypeParameters(Context ctx) {
        if (this.hasTrailingTypeParams()) {
            TypeExpression param;
            TypeConstant typeParam;
            int cParams = this.params.size();
            ArrayList<TypeConstant> listTypes = new ArrayList<TypeConstant>(cParams);
            Iterator<TypeExpression> iterator = this.params.iterator();
            while (iterator.hasNext() && (typeParam = (param = iterator.next()).getImplicitType(ctx)) != null) {
                assert (typeParam.isTypeOfType() && typeParam.isParamsSpecified());
                listTypes.add(typeParam.getParamType(0));
            }
            return listTypes.toArray(new TypeConstant[cParams]);
        }
        return null;
    }

    protected Argument resolveRawArgument(Context ctx, boolean fForce, ErrorListener errs) {
        block67: {
            XvmStructure xvmStructure;
            Cloneable idChild;
            PropertyConstant idProp;
            NameExpression exprName;
            boolean fIdMode;
            String sName;
            ConstantPool pool;
            block65: {
                Argument arg;
                block68: {
                    block66: {
                        if (!fForce && this.m_arg != null) {
                            return this.m_arg;
                        }
                        this.m_targetInfo = null;
                        this.m_arg = null;
                        this.m_fAssignable = false;
                        pool = this.pool();
                        sName = this.name.getValueText();
                        if (this.left != null) break block65;
                        ErrorListener errsTemp = errs.branch(this);
                        arg = ctx.resolveName(this.name, errsTemp);
                        errsTemp.merge();
                        if (arg == null && !errsTemp.hasSeriousErrors()) {
                            MethodStructure method = ctx.getMethod();
                            IdentityConstant idCtx = method == null ? ctx.getThisClassId() : method.getIdentityConstant();
                            this.log(errs, Severity.ERROR, "COMPILER-36", sName, idCtx.getValueString());
                            return null;
                        }
                        if (!(arg instanceof Register)) break block66;
                        Register reg = (Register)arg;
                        this.m_arg = arg;
                        this.m_fAssignable = reg.isWritable();
                        break block67;
                    }
                    if (!(arg instanceof Constant)) break block68;
                    Constant constant = (Constant)arg;
                    switch (constant.getFormat()) {
                        case Package: 
                        case Module: 
                        case Class: 
                        case Typedef: {
                            if (this.isSuppressDeref()) {
                                this.log(errs, Severity.ERROR, "COMPILER-146", new Object[0]);
                                return null;
                            }
                        }
                        case Property: {
                            this.m_arg = arg;
                            break block67;
                        }
                        case MultiMethod: {
                            MultiMethodConstant idMM = (MultiMethodConstant)constant;
                            MultiMethodStructure mms = (MultiMethodStructure)idMM.getComponent();
                            Collection<MethodStructure> methods = mms.methods();
                            this.m_arg = methods.size() == 1 ? methods.iterator().next().getIdentityConstant() : idMM;
                            break block67;
                        }
                        default: {
                            throw new IllegalStateException("format=" + String.valueOf((Object)constant.getFormat()) + ", constant=" + String.valueOf(constant));
                        }
                    }
                }
                if (arg instanceof StatementBlock.TargetInfo) {
                    StatementBlock.TargetInfo target;
                    this.m_targetInfo = target = (StatementBlock.TargetInfo)arg;
                    IdentityConstant id = target.getId();
                    switch (id.getFormat()) {
                        case MultiMethod: {
                            MultiMethodConstant idMM = (MultiMethodConstant)id;
                            MultiMethodStructure mms = (MultiMethodStructure)idMM.getComponent();
                            Collection<MethodStructure> methods = mms.methods();
                            if (methods.size() == 1) {
                                this.m_arg = methods.iterator().next().getIdentityConstant();
                                break;
                            }
                            this.m_arg = idMM;
                            break;
                        }
                        case Property: {
                            TypeConstant typeTarget = target.getTargetType();
                            TypeInfo infoTarget = this.getTypeInfo(ctx, typeTarget, errs);
                            PropertyInfo prop = infoTarget.findProperty((PropertyConstant)id);
                            if (prop == null) {
                                throw new IllegalStateException("missing property: " + String.valueOf(id) + " on " + String.valueOf(typeTarget));
                            }
                            if (infoTarget.isTopLevel() && infoTarget.isStatic() && !infoTarget.getClassStructure().equals(ctx.getThisClass()) || prop.isConstant() && prop.getInitializer() != null) {
                                this.m_propAccessPlan = PropertyAccess.SingletonParent;
                                this.m_idSingletonParent = infoTarget.getIdentity();
                            } else if (target.getStepsOut() == 0) {
                                if (!prop.isConstant() && prop.getHead().getStructure().isSynthetic() && ctx.getMethod().isPropertyInitializer()) {
                                    this.log(errs, Severity.ERROR, "COMPILER-162", prop.getName(), typeTarget.removeAccess().getValueString());
                                    return null;
                                }
                                this.m_propAccessPlan = PropertyAccess.This;
                            } else {
                                if (!prop.isConstant() && target.getStepsOut() > 0 && !target.hasThis()) {
                                    this.log(errs, Severity.ERROR, "COMPILER-159", typeTarget.removeAccess().getValueString(), prop.getName());
                                    return null;
                                }
                                this.m_propAccessPlan = PropertyAccess.Outer;
                            }
                            PropertyConstant idProp2 = (PropertyConstant)id;
                            if (idProp2.isTypeSequenceTypeParameter()) {
                                this.m_arg = idProp2;
                                this.m_fAssignable = false;
                                break;
                            }
                            this.m_arg = prop.getIdentity();
                            this.m_fAssignable = prop.isVar();
                            break;
                        }
                        case Package: 
                        case Module: 
                        case Class: {
                            this.m_arg = target;
                            break;
                        }
                        default: {
                            throw new IllegalStateException("unsupported constant format: " + String.valueOf(id));
                        }
                    }
                }
                break block67;
            }
            if ("this".equals(sName)) {
                this.log(errs, Severity.ERROR, "COMPILER-59", new Object[0]);
                return null;
            }
            Expression reg = this.left;
            boolean bl = fIdMode = reg instanceof NameExpression && (exprName = (NameExpression)reg).resolveRawArgument(ctx, false, errs) != null && exprName.isIdentityMode(ctx, true);
            if (fIdMode) {
                PackageStructure pkg;
                NameExpression exprLeft = (NameExpression)this.left;
                IdentityConstant idLeft = exprLeft.getIdentity(ctx);
                if (idLeft.getFormat() == Constant.Format.Package && (pkg = (PackageStructure)idLeft.getComponent()).isModuleImport()) {
                    idLeft = pkg.getImportedModule().getIdentityConstant();
                }
                if (idLeft instanceof PropertyConstant) {
                    idProp = (PropertyConstant)idLeft;
                    TypeInfo infoProp = pool.ensurePropertyClassTypeConstant(idProp.getParentConstant().getFormalType().ensureAccess(Constants.Access.PRIVATE), idProp).ensureTypeInfo(errs);
                    idChild = infoProp.findName(pool, sName);
                } else {
                    ClassStructure clzLeft;
                    xvmStructure = idLeft.getComponent();
                    if (xvmStructure instanceof ClassStructure && (xvmStructure = (clzLeft = (ClassStructure)xvmStructure).findChildDeep(sName)) instanceof TypedefStructure) {
                        TypedefStructure typedef = (TypedefStructure)xvmStructure;
                        idChild = typedef.getIdentityConstant();
                    } else {
                        idChild = this.getTypeInfo(ctx, idLeft.getType(), errs).findName(pool, sName);
                    }
                }
                if (idChild == null) {
                    TypeInfo infoClz = idLeft.getValueType(pool, null).ensureTypeInfo(errs);
                    idChild = infoClz.findName(pool, sName);
                    boolean bl2 = this.m_fClassAttribute = idChild != null;
                }
                if (idChild != null) {
                    switch (((Constant)idChild).getFormat()) {
                        case Package: 
                        case Class: 
                        case Typedef: 
                        case Property: 
                        case Method: {
                            this.m_arg = idChild;
                            break;
                        }
                        case MultiMethod: {
                            this.log(errs, Severity.ERROR, "COMPILER-37", sName);
                            return null;
                        }
                        default: {
                            throw new IllegalStateException("format=" + String.valueOf((Object)((Constant)idChild).getFormat()) + ", constant=" + String.valueOf(idChild));
                        }
                    }
                }
            }
            if (this.m_arg == null) {
                AnnotatedTypeConstant typeAnno;
                TypeConstant typeLeft = this.left.getImplicitType(ctx);
                if (!(typeLeft != null && !typeLeft.containsUnresolved() || typeLeft instanceof AnnotatedTypeConstant && !(typeAnno = (AnnotatedTypeConstant)typeLeft).getUnderlyingType().containsUnresolved())) {
                    this.log(errs, Severity.ERROR, "COMPILER-38", this.getName());
                    return null;
                }
                if (typeLeft.isTypeOfType() && (idChild = this.left) instanceof NameExpression) {
                    NameExpression exprLeft = (NameExpression)idChild;
                    FormalConstant constFormal = null;
                    switch (exprLeft.getMeaning().ordinal()) {
                        case 2: {
                            TypeConstant typeData = typeLeft.getParamType(0);
                            if (typeData.containsGenericParam(sName)) {
                                Register argLeft = (Register)exprLeft.m_arg;
                                TypeConstant typeFormal = argLeft.getOriginalType().getParamType(0);
                                if (typeFormal.isFormalType()) {
                                    constFormal = (FormalConstant)typeFormal.getDefiningConstant();
                                }
                                typeLeft = typeData;
                                break;
                            }
                            if (!"OuterType".equals(sName) || !typeData.isFormalType()) break;
                            constFormal = (FormalConstant)typeData.getDefiningConstant();
                            break;
                        }
                        case 4: {
                            TypeConstant typeData = typeLeft.getParamType(0);
                            if (!typeData.isFormalType() || !typeData.resolveConstraints().containsGenericParam(sName)) break;
                            constFormal = (FormalConstant)typeData.getDefiningConstant();
                            break;
                        }
                        case 3: {
                            idProp = (PropertyConstant)exprLeft.m_arg;
                            if (!idProp.isFormalType() || !idProp.getConstraintType().containsGenericParam(sName)) break;
                            constFormal = idProp;
                            break;
                        }
                    }
                    if (constFormal != null) {
                        this.m_fAssignable = false;
                        this.m_arg = pool.ensureFormalTypeChildConstant(constFormal, sName);
                        return this.m_arg;
                    }
                }
                TypeInfo infoLeft = this.getTypeInfo(ctx, typeLeft, errs);
                boolean fCheckAccess = !typeLeft.isAccessSpecified() && infoLeft.getType().getAccess() != Constants.Access.PRIVATE;
                IdentityConstant idChild2 = infoLeft.findName(pool, sName);
                if (idChild2 == null) {
                    Constant constTarget;
                    if (!typeLeft.isTypeOfType() && !fIdMode && (constTarget = new NameResolver((AstNode)this, sName).forceResolve(ErrorListener.BLACKHOLE)) instanceof IdentityConstant && constTarget.isClass()) {
                        if (constTarget.equals(pool.clzOuter())) {
                            if (!typeLeft.isVirtualChild()) {
                                this.log(errs, Severity.ERROR, "COMPILER-59", new Object[0]);
                                return null;
                            }
                            this.m_arg = new StatementBlock.TargetInfo(sName, typeLeft.getParentType(), 1);
                            return this.m_arg;
                        }
                        if (typeLeft instanceof PropertyClassTypeConstant && constTarget.getType().equals(typeLeft.getParentType())) {
                            this.m_arg = new StatementBlock.TargetInfo(sName, typeLeft.getParentType(), 1);
                            return this.m_arg;
                        }
                        if (ctx.getThisType().isA(constTarget.getType())) {
                            TypeConstant typeTarget = constTarget.getType().adoptParameters(pool, ctx.getThisType());
                            this.m_arg = ctx.getThisRegister().narrowType(typeTarget);
                            return this.m_arg;
                        }
                        PseudoConstant idRelative = this.getRelativeIdentity(typeLeft, (IdentityConstant)constTarget);
                        if (idRelative != null) {
                            this.m_arg = idRelative;
                            return this.m_arg;
                        }
                    }
                    this.log(errs, Severity.ERROR, "COMPILER-36", sName, typeLeft.getValueString());
                    return null;
                }
                switch (idChild2.getFormat()) {
                    case Class: {
                        ChildInfo infoChild = infoLeft.getChildInfosByName().get(sName);
                        assert (infoChild != null);
                        xvmStructure = infoChild.getIdentity();
                        if (xvmStructure instanceof TypedefConstant) {
                            TypedefConstant idTypedef = (TypedefConstant)xvmStructure;
                            this.m_arg = idTypedef;
                            break;
                        }
                        this.log(errs, Severity.ERROR, "COMPILER-04", sName);
                        break;
                    }
                    case Typedef: {
                        this.log(errs, Severity.ERROR, "COMPILER-34", sName, typeLeft.getValueString());
                        break;
                    }
                    case Property: {
                        PropertyInfo infoProp = infoLeft.findProperty((PropertyConstant)idChild2);
                        if (infoProp == null || fCheckAccess && !infoProp.isVisible(ctx.getThisClassId())) {
                            this.log(errs, Severity.ERROR, "COMPILER-162", idChild2.getName(), typeLeft.getValueString());
                            return null;
                        }
                        this.m_arg = idChild2;
                        this.m_fAssignable = infoProp.isVar();
                        break;
                    }
                    case Method: {
                        MethodInfo infoMethod = infoLeft.getMethodById((MethodConstant)idChild2);
                        if (infoMethod == null || fCheckAccess && !infoMethod.isVisible(ctx.getThisClassId())) {
                            this.log(errs, Severity.ERROR, "COMPILER-177", idChild2.getValueString(), typeLeft.getValueString());
                            return null;
                        }
                    }
                    case MultiMethod: {
                        this.m_arg = idChild2;
                        break;
                    }
                    default: {
                        throw new IllegalStateException("format=" + String.valueOf((Object)idChild2.getFormat()) + ", constant=" + String.valueOf(idChild2));
                    }
                }
            }
        }
        return this.m_arg;
    }

    protected TypeConstant planCodeGen(Context ctx, Argument argRaw, TypeConstant[] aTypeParams, TypeConstant typeDesired, boolean fDraft, ErrorListener errs) {
        assert (ctx != null && argRaw != null);
        ConstantPool pool = this.pool();
        boolean fSuppressDeref = this.isSuppressDeref();
        if (argRaw instanceof Register) {
            Register reg = (Register)argRaw;
            if (aTypeParams != null) {
                this.log(errs, Severity.ERROR, "COMPILER-12", new Object[0]);
            }
            if (reg.isLabel() && (fSuppressDeref || !(this.getParent() instanceof NameExpression))) {
                this.log(errs, Severity.ERROR, "COMPILER-38", this.getName());
            }
            if (fSuppressDeref) {
                this.m_plan = Plan.RegisterRef;
                return reg.ensureRegType(!this.m_fAssignable);
            }
            this.m_plan = Plan.None;
            return this.isRValue() ? reg.getType() : reg.getOriginalType();
        }
        if (argRaw instanceof StatementBlock.TargetInfo) {
            StatementBlock.TargetInfo targetInfo = (StatementBlock.TargetInfo)argRaw;
            if (fSuppressDeref) {
                this.m_plan = Plan.OuterRef;
                return pool.ensureParameterizedTypeConstant(pool.typeRef(), targetInfo.getType());
            }
            this.m_plan = Plan.OuterThis;
            return targetInfo.getType();
        }
        Constant constant = (Constant)argRaw;
        switch (constant.getFormat()) {
            case ThisClass: {
                TypeConstant typeThis = pool.ensureAccessTypeConstant(constant.getType().adoptParameters(pool, ctx.getThisType()), Constants.Access.PRIVATE);
                if (fSuppressDeref) {
                    this.m_plan = Plan.OuterRef;
                    return pool.ensureParameterizedTypeConstant(pool.typeRef(), typeThis);
                }
                this.m_plan = Plan.None;
                return typeThis;
            }
            case ParentClass: {
                TypeConstant typeParent = pool.ensureAccessTypeConstant(((ParentClassConstant)constant).getDeclarationLevelClass().getFormalType(), Constants.Access.PRIVATE);
                NameExpression exprLeft = (NameExpression)this.left;
                if (exprLeft.isSuppressDeref()) {
                    this.m_plan = Plan.OuterRef;
                    return pool.ensureParameterizedTypeConstant(pool.typeRef(), typeParent);
                }
                this.m_plan = Plan.OuterThis;
                return typeParent;
            }
            case Package: 
            case Module: 
            case Class: {
                boolean fHasTypeParams;
                boolean fCouldBeSingleton = !this.isIdentityMode(ctx, false);
                boolean fSingletonDesired = typeDesired != null && constant.getType().isA(typeDesired);
                boolean fClassDesired = typeDesired != null && typeDesired.isA(pool.typeClass());
                boolean fTypeDesired = typeDesired != null && typeDesired.isTypeOfType();
                boolean bl = fHasTypeParams = aTypeParams != null;
                if (fCouldBeSingleton && (fSingletonDesired || !fClassDesired && !fTypeDesired && !fHasTypeParams)) {
                    if (fHasTypeParams) {
                        this.log(errs, Severity.ERROR, "COMPILER-12", new Object[0]);
                    }
                    this.m_plan = Plan.Singleton;
                    return pool.ensureTerminalTypeConstant(constant);
                }
                if (aTypeParams != null || fTypeDesired) {
                    TypeConstant type = null;
                    IdentityConstant idTarget = (IdentityConstant)constant;
                    Component component = this.getComponent();
                    ClassStructure clzThis = component.getContainingClass();
                    ClassStructure clzTarget = (ClassStructure)idTarget.getComponent();
                    if (clzThis != null) {
                        IdentityConstant idThis = clzThis.getIdentityConstant();
                        if (idThis.equals(idTarget)) {
                            type = clzThis.getFormalType();
                        } else if (clzTarget.isVirtualChild()) {
                            MethodStructure method;
                            boolean fMate = idTarget.isNestMateOf(idThis);
                            ClassConstant idBase = fMate ? ((ClassConstant)idThis).getOutermost() : ((ClassConstant)idTarget).getAutoNarrowingBase();
                            ClassStructure clzBase = (ClassStructure)idBase.getComponent();
                            boolean fFormal = !(component instanceof MethodStructure && (method = (MethodStructure)component).isFunction());
                            type = pool.ensureVirtualTypeConstant(clzBase, clzTarget, fFormal && fMate, false, idTarget);
                        }
                    }
                    if (type == null) {
                        type = pool.ensureTerminalTypeConstant(idTarget);
                    }
                    if (aTypeParams != null) {
                        if (clzTarget.isTuple() || clzTarget.isParameterized() && aTypeParams.length <= clzTarget.getTypeParamCount()) {
                            type = type.adoptParameters(pool, aTypeParams);
                        } else {
                            this.log(errs, Severity.ERROR, "COMPILER-12", new Object[0]);
                        }
                    }
                    if (fTypeDesired) {
                        this.m_plan = Plan.TypeOfClass;
                        return type.getType();
                    }
                    IdentityConstant clz = pool.ensureClassConstant(type);
                    this.m_plan = Plan.None;
                    this.m_arg = clz;
                    return clz.getValueType(pool, type);
                }
                this.m_plan = Plan.None;
                if (!(constant instanceof ClassConstant)) {
                    this.m_arg = pool.ensureClassConstant(constant.getType());
                }
                TypeConstant typeThisClass = ctx.getThisClass().getFormalType();
                return ((IdentityConstant)constant).getValueType(pool, typeThisClass);
            }
            case Property: {
                PropertyInfo infoProp;
                TypeConstant typeLeft;
                if (aTypeParams != null) {
                    this.log(errs, Severity.ERROR, "COMPILER-12", new Object[0]);
                }
                PropertyConstant idProp = (PropertyConstant)argRaw;
                TypeConstant typeProp = idProp.getType();
                StatementBlock.TargetInfo target = this.m_targetInfo;
                boolean fClass = this.m_fClassAttribute;
                if (typeDesired != null && typeDesired.removeNullable().isA(pool.typeProperty()) && !typeProp.removeNullable().isA(pool.typeProperty())) {
                    TypeConstant typeLeft2;
                    if (fSuppressDeref) {
                        this.log(errs, Severity.ERROR, "COMPILER-146", new Object[0]);
                        return null;
                    }
                    if (this.left == null) {
                        typeLeft2 = target == null ? ctx.getThisType() : target.getTargetType();
                    } else {
                        typeLeft2 = this.left.getImplicitType(ctx);
                        if (!fClass && this.isIdentityMode(ctx, false)) {
                            if (typeLeft2.isA(pool.typeClass())) {
                                typeLeft2 = typeLeft2.getParamType(0);
                            } else {
                                NameExpression nameLeft;
                                Expression component;
                                assert ((component = this.left) instanceof NameExpression && (nameLeft = (NameExpression)component).getMeaning() == Meaning.Property && (nameLeft.m_plan == Plan.None || nameLeft.m_plan == Plan.PropertyIdentity));
                                if (!idProp.getComponent().isStatic() && !ctx.requireThis(this.getStartPosition(), errs)) {
                                    return null;
                                }
                            }
                        }
                    }
                    PropertyInfo infoProp2 = this.findProperty(ctx, typeLeft2, idProp, errs);
                    if (infoProp2 == null) {
                        return null;
                    }
                    this.m_plan = Plan.PropertySelf;
                    return idProp.getValueType(pool, typeLeft2);
                }
                if (idProp.isTypeSequenceTypeParameter()) {
                    assert (!this.m_fAssignable);
                    this.m_plan = Plan.PropertyDeref;
                    return idProp.getConstraintType();
                }
                PropertyStructure prop = (PropertyStructure)idProp.getComponent();
                if (prop.isConstant() && !fSuppressDeref) {
                    assert (!this.m_fAssignable);
                    this.m_plan = prop.hasInitialValue() ? Plan.PropertyDeref : Plan.Singleton;
                    return typeProp;
                }
                if (this.left == null) {
                    if (target == null) {
                        typeLeft = pool.ensureAccessTypeConstant(ctx.getThisType(), Constants.Access.PRIVATE);
                    } else {
                        idProp = (PropertyConstant)target.getId();
                        typeLeft = target.getTargetType();
                    }
                    infoProp = this.findProperty(ctx, typeLeft, idProp, errs);
                    if (infoProp != null) {
                        Argument argNarrowed = ctx.getVar(prop.getName());
                        typeProp = argNarrowed instanceof StatementBlock.TargetInfo ? argNarrowed.getType() : infoProp.inferImmutable(typeLeft).resolveAutoNarrowing(pool, false, typeLeft, null);
                    }
                } else {
                    typeLeft = this.left.getImplicitType(ctx);
                    if (fClass && typeDesired != null && typeDesired.isA(pool.typeProperty()) || !fClass && this.isIdentityMode(ctx, false)) {
                        if (fSuppressDeref) {
                            this.log(errs, Severity.ERROR, "COMPILER-146", new Object[0]);
                            return null;
                        }
                        if (typeLeft.isA(pool.typeClass())) {
                            if (!fClass) {
                                typeLeft = typeLeft.getParamType(0);
                            }
                        } else {
                            NameExpression nameLeft;
                            Expression clzThis;
                            assert ((clzThis = this.left) instanceof NameExpression && (nameLeft = (NameExpression)clzThis).getMeaning() == Meaning.Property && (nameLeft.m_plan == Plan.None || nameLeft.m_plan == Plan.PropertyIdentity));
                            if (!prop.isStatic() && !ctx.requireThis(this.getStartPosition(), errs)) {
                                return null;
                            }
                        }
                        if ((infoProp = this.findProperty(ctx, typeLeft, idProp, errs)) != null) {
                            if (typeDesired != null && typeDesired.isA(pool.typeFunction()) && !typeProp.isA(pool.typeFunction())) {
                                this.m_plan = Plan.BjarneLambda;
                                if (!fDraft) {
                                    this.m_idBjarnLambda = this.createBjarneLambda(ctx.getThisClass(), idProp);
                                }
                                return idProp.getBjarneLambdaType();
                            }
                            this.m_plan = Plan.None;
                            return idProp.getValueType(pool, typeLeft);
                        }
                    } else {
                        infoProp = this.findProperty(ctx, typeLeft, idProp, errs);
                        if (infoProp != null) {
                            FormalConstant idFormal;
                            IdentityConstant idConstraint;
                            Cloneable clzConstraint;
                            TypeConstant typeConstraint;
                            if (typeProp.isFormalType() && typeLeft.isTypeParameter() && (typeConstraint = typeLeft.resolveConstraints()).isVirtualChild() && ((ClassStructure)(clzConstraint = (ClassStructure)(idConstraint = typeConstraint.getSingleUnderlyingClass(true)).getComponent())).isVirtualDescendant((idFormal = (FormalConstant)typeProp.getDefiningConstant()).getParentConstant())) {
                                TypeParameterConstant idParam = (TypeParameterConstant)typeLeft.getDefiningConstant();
                                idProp = pool.ensureFormalTypeChildConstant(idParam, idFormal.getName());
                                typeProp = idProp.getType();
                            } else if (infoProp.isFormalType()) {
                                if (this.m_fClassAttribute) {
                                    if (this.isSuppressDeref()) {
                                        this.log(errs, Severity.ERROR, "COMPILER-146", new Object[0]);
                                        return null;
                                    }
                                    assert (typeLeft.isA(pool.typeClass()));
                                    typeProp = infoProp.getType().resolveAutoNarrowing(pool, false, typeLeft, null);
                                } else {
                                    NameExpression exprLeft;
                                    boolean fDynamic = false;
                                    clzConstraint = this.left;
                                    if (clzConstraint instanceof NameExpression && !(exprLeft = (NameExpression)clzConstraint).isSuppressDeref()) {
                                        switch (exprLeft.getMeaning().ordinal()) {
                                            case 2: {
                                                Register argLeft = (Register)exprLeft.m_arg;
                                                DynamicFormalConstant constDynamic = pool.ensureDynamicFormal(ctx.getMethod().getIdentityConstant(), argLeft, idProp, exprLeft.getName());
                                                typeProp = constDynamic.getType().getType();
                                                fDynamic = true;
                                                break;
                                            }
                                            case 3: {
                                                break;
                                            }
                                        }
                                    }
                                    if (!fDynamic) {
                                        typeProp = idProp.getType();
                                    }
                                }
                            } else {
                                TypeConstant typeResolved = infoProp.inferImmutable(typeLeft);
                                if (typeDesired != null && typeDesired.containsDynamicType()) {
                                    typeResolved = this.resolveDynamicType(ctx, typeLeft, typeProp, typeResolved);
                                }
                                typeProp = typeResolved.resolveAutoNarrowing(pool, false, typeLeft, null);
                            }
                        }
                    }
                }
                if (infoProp == null) {
                    if (!errs.hasSeriousErrors()) {
                        this.log(errs, Severity.ERROR, "COMPILER-36", idProp.getName(), typeLeft.getValueString());
                    }
                    return null;
                }
                if (fSuppressDeref) {
                    this.m_plan = Plan.PropertyRef;
                    return infoProp.isCustomLogic() ? pool.ensurePropertyClassTypeConstant(typeLeft, idProp) : infoProp.getBaseRefType();
                }
                this.m_plan = Plan.PropertyDeref;
                return typeProp;
            }
            case FormalTypeChild: {
                FormalTypeChildConstant idFormal = (FormalTypeChildConstant)constant;
                this.m_plan = Plan.TypeOfFormalChild;
                return idFormal.getType().getType();
            }
            case Typedef: {
                if (aTypeParams != null) {
                    throw this.notImplemented();
                }
                this.m_plan = Plan.TypeOfTypedef;
                TypeConstant typeRef = ((TypedefConstant)constant).getReferredToType();
                TypeConstant typeLeft = this.left == null ? ctx.getThisType() : this.left.getImplicitType(ctx);
                return typeRef.getType().resolveGenerics(pool, typeLeft);
            }
            case Method: {
                TypeConstant typeFn;
                MethodConstant idMethod = (MethodConstant)argRaw;
                MethodStructure method = (MethodStructure)idMethod.getComponent();
                if (idMethod.isFunction()) {
                    this.m_plan = Plan.None;
                    typeFn = idMethod.getType();
                } else {
                    NameExpression exprName;
                    if (typeDesired != null && typeDesired.isA(pool.typeMethod())) {
                        Annotation[] aAnno;
                        this.m_plan = Plan.None;
                        TypeConstant typeMethod = idMethod.getType();
                        if (method != null && (aAnno = method.getAnnotations()) != null && aAnno.length > 0) {
                            typeMethod = pool.ensureAnnotatedTypeConstant(typeMethod, aAnno);
                        }
                        return typeMethod;
                    }
                    Expression aAnno = this.left;
                    if (aAnno instanceof NameExpression && (exprName = (NameExpression)aAnno).getMeaning() == Meaning.Class) {
                        IdentityConstant idClz = exprName.getIdentity(ctx);
                        ClassStructure clz = (ClassStructure)idClz.getComponent();
                        if (clz.isSingleton()) {
                            this.m_plan = Plan.BindTarget;
                            typeFn = idMethod.getSignature().asFunctionType();
                        } else {
                            this.m_plan = Plan.BjarneLambda;
                            typeFn = idMethod.getBjarneLambdaType();
                            if (!fDraft) {
                                int cReturns = typeDesired == null ? idMethod.getRawReturns().length : pool.extractFunctionReturns(typeDesired).length;
                                this.m_idBjarnLambda = this.createBjarneLambda(ctx.getThisClass(), idMethod, cReturns);
                            }
                        }
                    } else {
                        this.m_plan = Plan.BindTarget;
                        typeFn = idMethod.getSignature().asFunctionType();
                    }
                }
                if (typeDesired != null) {
                    int cTypeParams;
                    if (method == null) {
                        TypeConstant typeLeft = this.left == null ? ctx.getThisType() : this.left.getImplicitType(ctx);
                        TypeInfo infoLeft = this.getTypeInfo(ctx, typeLeft, errs);
                        MethodInfo infoMethod = infoLeft.getMethodBySignature(idMethod.getSignature());
                        if (infoMethod == null) {
                            this.log(errs, Severity.ERROR, "COMPILER-177", idMethod.getValueString(), infoLeft.getType().getValueString());
                            return null;
                        }
                        method = infoMethod.getTopmostMethodStructure(infoLeft);
                        assert (method != null);
                        this.m_arg = method.getIdentityConstant();
                    }
                    if ((cTypeParams = method.getTypeParamCount()) > 0) {
                        TypeConstant[] atypeArgs = pool.extractFunctionParams(typeDesired);
                        if (atypeArgs == null) {
                            this.log(errs, Severity.ERROR, "COMPILER-43", typeDesired.getValueString(), typeFn.getValueString());
                            return null;
                        }
                        ListMap<FormalConstant, TypeConstant> mapTypeParams = method.resolveTypeParameters(pool, null, atypeArgs, TypeConstant.NO_TYPES, false);
                        if (mapTypeParams.size() < cTypeParams) {
                            this.log(errs, Severity.ERROR, "COMPILER-145", method.collectUnresolvedTypeParameters(mapTypeParams.keySet().stream().map(NamedConstant::getName).collect(Collectors.toSet())));
                            return null;
                        }
                        typeFn = typeFn.resolveGenerics(pool, GenericTypeResolver.of(mapTypeParams));
                        this.m_mapTypeParams = mapTypeParams;
                    }
                    if (this.m_plan == Plan.BindTarget && typeDesired.isA(pool.typeFunction())) {
                        int cArgDesired = pool.extractFunctionParams(typeDesired).length;
                        int cArgVisible = method.getVisibleParamCount();
                        int cArgRequired = method.getRequiredParamCount();
                        if (cArgDesired < cArgRequired || cArgDesired > cArgVisible) {
                            this.log(errs, Severity.ERROR, "COMPILER-84", cArgDesired, cArgRequired);
                            return null;
                        }
                        if (cArgVisible > cArgDesired) {
                            for (int i = cArgVisible - 1; i > cArgDesired - 1; --i) {
                                typeFn = pool.bindFunctionParam(typeFn, i);
                            }
                        }
                    }
                }
                return typeFn;
            }
            case MultiMethod: {
                this.m_plan = Plan.None;
                if (typeDesired != null) {
                    // empty if block
                }
                this.log(errs, Severity.ERROR, "COMPILER-37", ((MultiMethodConstant)constant).getName());
                return null;
            }
        }
        throw new IllegalStateException("constant=" + String.valueOf(constant));
    }

    private PropertyInfo findProperty(Context ctx, TypeConstant typeTarget, PropertyConstant idProp, ErrorListener errs) {
        TypeInfo infoTarget = this.getTypeInfo(ctx, typeTarget, errs);
        boolean fCheckAccess = !typeTarget.isAccessSpecified();
        PropertyInfo infoProp = infoTarget.findProperty(idProp);
        if (infoProp == null || fCheckAccess && !infoProp.isVisible(ctx.getThisClassId())) {
            this.log(errs, Severity.ERROR, "COMPILER-162", idProp.getName(), typeTarget.getValueString());
            return null;
        }
        return infoProp;
    }

    private TypeConstant resolveDynamicType(Context ctx, TypeConstant typeLeft, TypeConstant typeProp, final TypeConstant typeResolved) {
        final ConstantPool pool = this.pool();
        Expression expression = this.left;
        if (expression instanceof NameExpression) {
            Register regLeft;
            Argument argLeft;
            NameExpression exprLeft = (NameExpression)expression;
            if (typeLeft.isSingleDefiningConstant() && !typeLeft.isFormalType() && !exprLeft.isSuppressDeref() && (argLeft = exprLeft.resolveRawArgument(ctx, false, ErrorListener.BLACKHOLE)) instanceof Register && !(regLeft = (Register)argLeft).isPredefined()) {
                final MethodConstant idMethod = ctx.getMethod().getIdentityConstant();
                final String sName = exprLeft.getName();
                final IdentityConstant idParent = (IdentityConstant)typeLeft.removeAutoNarrowing().getDefiningConstant();
                if (typeProp.isGenericType()) {
                    FormalConstant idFormal = (FormalConstant)typeProp.getDefiningConstant();
                    if (!typeResolved.isGenericType() && idFormal.getParentConstant().equals(idParent)) {
                        return pool.ensureDynamicFormal(idMethod, regLeft, idFormal, sName).getType();
                    }
                } else if (typeProp.containsGenericType(true)) {
                    GenericTypeResolver resolver = new GenericTypeResolver(){

                        @Override
                        public TypeConstant resolveGenericType(String sFormalName) {
                            return typeResolved.resolveGenericType(sFormalName);
                        }

                        @Override
                        public TypeConstant resolveFormalType(FormalConstant idFormal) {
                            return idFormal.getParentConstant().equals(idParent) ? pool.ensureDynamicFormal(idMethod, regLeft, idFormal, sName).getType() : this.resolveGenericType(idFormal.getName());
                        }
                    };
                    return typeProp.resolveGenerics(pool, resolver);
                }
            }
        }
        return typeResolved;
    }

    protected Meaning getMeaning() {
        Argument arg;
        Argument argument = arg = this.m_arg;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Register.class, StatementBlock.TargetInfo.class, Constant.class}, (Argument)argument, n)) {
            case -1: {
                return Meaning.Unknown;
            }
            case 0: {
                Register reg = (Register)argument;
                return reg.isPredefined() ? (reg.isLabel() ? Meaning.Label : Meaning.Reserved) : Meaning.Variable;
            }
            case 1: {
                StatementBlock.TargetInfo ignored = (StatementBlock.TargetInfo)argument;
                return Meaning.Reserved;
            }
            case 2: {
                Constant constant = (Constant)argument;
                switch (constant.getFormat()) {
                    case Package: 
                    case Module: 
                    case ThisClass: 
                    case ParentClass: {
                        return Meaning.Class;
                    }
                    case Class: 
                    case DecoratedClass: {
                        return this.m_plan == Plan.TypeOfClass ? Meaning.Type : Meaning.Class;
                    }
                    case Property: {
                        return Meaning.Property;
                    }
                    case FormalTypeChild: {
                        return Meaning.FormalChildType;
                    }
                    case MultiMethod: 
                    case Method: {
                        return Meaning.Method;
                    }
                    case Typedef: {
                        return Meaning.Type;
                    }
                }
            }
        }
        throw new IllegalStateException("arg=" + String.valueOf(arg));
    }

    public boolean isDynamicVar() {
        Register reg;
        Argument argument = this.m_arg;
        return argument instanceof Register && (reg = (Register)argument).isVar();
    }

    protected boolean isIdentityMode(Context ctx, boolean fSoft) {
        if (this.left != null && !(this.left instanceof NameExpression)) {
            return false;
        }
        switch (this.getMeaning().ordinal()) {
            case 6: 
            case 7: {
                if (this.left != null && (!((NameExpression)this.left).isIdentityMode(ctx, true) || "this".equals(this.name.getValueText()))) {
                    return false;
                }
                IdentityConstant id = this.getIdentity(ctx);
                if (id instanceof TypedefConstant) {
                    TypedefConstant idTypedef = (TypedefConstant)id;
                    TypeConstant typeRef = idTypedef.getReferredToType();
                    if (typeRef.isSingleUnderlyingClass(false)) {
                        id = typeRef.getSingleUnderlyingClass(false);
                    } else {
                        return false;
                    }
                }
                if (fSoft && (id instanceof ModuleConstant || id instanceof PackageConstant)) {
                    return true;
                }
                return this.isSuppressDeref() || !((ClassStructure)id.getComponent()).isSingleton();
            }
            case 3: {
                PropertyStructure prop = (PropertyStructure)this.getIdentity(ctx).getComponent();
                return !prop.isConstant() && !this.m_fClassAttribute && (this.left == null ? this.m_plan == Plan.PropertyIdentity : ((NameExpression)this.left).isIdentityMode(ctx, false));
            }
        }
        return false;
    }

    protected boolean isTypeParameter(Context ctx, Register reg) {
        return !reg.isUnknown() && ctx.getMethod().isTypeParameter(reg.getIndex());
    }

    protected IdentityConstant getIdentity(Context ctx) {
        IdentityConstant id;
        Argument argument = this.m_arg;
        return argument instanceof IdentityConstant ? (id = (IdentityConstant)argument) : ((TypeConstant)this.m_arg).getSingleUnderlyingClass(true);
    }

    protected PseudoConstant getRelativeIdentity(TypeConstant typeFrom, IdentityConstant idTarget) {
        if (!typeFrom.isExplicitClassIdentity(true)) {
            return null;
        }
        Component component = typeFrom.getSingleUnderlyingClass(true).getComponent();
        if (!(component instanceof ClassStructure)) {
            return null;
        }
        ClassStructure clzFrom = (ClassStructure)component;
        ConstantPool pool = this.pool();
        PseudoConstant idVirtPath = null;
        int cDepth = 0;
        while (clzFrom != null) {
            IdentityConstant idFrom = clzFrom.getIdentityConstant();
            PseudoConstant pseudoConstant = idVirtPath = idVirtPath == null ? pool.ensureThisClassConstant(idFrom) : pool.ensureParentClassConstant(idVirtPath);
            if (idFrom.equals(idTarget) || cDepth > 0 && clzFrom.hasContribution(idTarget)) {
                return idVirtPath;
            }
            if (clzFrom.isTopLevel() || clzFrom.isStatic()) {
                return null;
            }
            clzFrom = clzFrom.getContainingClass();
            ++cDepth;
        }
        return null;
    }

    protected PropertyAccess calculatePropertyAccess(boolean fRef) {
        NameExpression exprLeft;
        if (this.m_propAccessPlan != null) {
            return this.m_propAccessPlan;
        }
        if (this.left == null) {
            return PropertyAccess.This;
        }
        Expression expression = this.left;
        if (expression instanceof NameExpression && "this".equals((exprLeft = (NameExpression)expression).getName()) && (fRef || exprLeft.m_plan == Plan.None)) {
            return PropertyAccess.This;
        }
        return PropertyAccess.Left;
    }

    protected MethodConstant findAtomicInPlaceAssignMethod(Context ctx, String sMethod, String sOp, TypeConstant typeArg) {
        TypeConstant typeTarget = switch (this.calculatePropertyAccess(true).ordinal()) {
            case 2 -> ctx.getThisType().ensureAccess(Constants.Access.PRIVATE);
            case 3 -> this.getLeftExpression().getType();
            default -> throw new IllegalStateException();
        };
        int cArgs = typeArg == null ? 0 : 1;
        PropertyConstant idProp = (PropertyConstant)this.m_arg;
        TypeConstant typeVar = idProp.getRefType(typeTarget);
        Set<MethodConstant> setMethods = typeVar.ensureTypeInfo().findOpMethods(sMethod, sOp, cArgs);
        return switch (setMethods.size()) {
            case 0 -> null;
            case 1 -> setMethods.iterator().next();
            default -> RelOpExpression.chooseBestMethod(setMethods, typeArg);
        };
    }

    public void narrowType(Context ctx, Context.Branch branch, TypeConstant typeNarrow) {
        if (typeNarrow != null) {
            assert (this.isValidated());
            Argument arg = this.resolveRawArgument(ctx, false, ErrorListener.BLACKHOLE);
            if (this.left != null) {
                if (arg instanceof FormalTypeChildConstant) {
                    FormalTypeChildConstant constFormal = (FormalTypeChildConstant)arg;
                    ctx.replaceGenericType(constFormal, branch, typeNarrow);
                }
                return;
            }
            String sName = this.getName();
            if (arg instanceof Register) {
                Register reg = (Register)arg;
                ctx.narrowLocalRegister(sName, reg, branch, typeNarrow);
            } else if (arg instanceof StatementBlock.TargetInfo) {
                StatementBlock.TargetInfo info = (StatementBlock.TargetInfo)arg;
                IdentityConstant id = info.getId();
                if (id instanceof PropertyConstant) {
                    PropertyConstant idProp = (PropertyConstant)id;
                    assert (sName.equals(id.getName()));
                    if (ctx.getVar(sName) instanceof Register) {
                        return;
                    }
                    if (idProp.isFormalType()) {
                        ctx.replaceGenericArgument(idProp, branch, new StatementBlock.TargetInfo(info, typeNarrow));
                    } else {
                        TypeConstant typeTarget = info.getTargetType();
                        IdentityConstant idTarget = typeTarget.getSingleUnderlyingClass(false);
                        MethodStructure method = ctx.getMethod();
                        if ((!idTarget.equals(ctx.getThisClassId()) || !method.isConstructor() && !method.isValidator()) && typeTarget.isImmutable()) {
                            ctx.narrowProperty(sName, idProp, branch, new StatementBlock.TargetInfo(info, typeNarrow));
                        }
                    }
                } else if (id instanceof IdentityConstant) {
                    ctx.replaceArgument("this", branch, new StatementBlock.TargetInfo(info, typeNarrow));
                }
            } else if (arg instanceof PropertyConstant) {
                PropertyConstant idProp = (PropertyConstant)arg;
                assert (sName.equals(idProp.getName()));
                if (ctx.getVar(sName) instanceof Register) {
                    return;
                }
                if (idProp.isFormalType()) {
                    assert (typeNarrow.isTypeOfType());
                    StatementBlock.TargetInfo info = new StatementBlock.TargetInfo(sName, idProp, true, idProp.getNamespace().getType(), 0);
                    ctx.replaceGenericArgument(idProp, branch, new StatementBlock.TargetInfo(info, typeNarrow));
                } else {
                    MethodStructure method = ctx.getMethod();
                    if (!method.isConstructor() && !method.isValidator() && ctx.getThisClass().isConst()) {
                        StatementBlock.TargetInfo info = new StatementBlock.TargetInfo(sName, idProp, true, ctx.getThisType(), 0);
                        ctx.narrowProperty(sName, idProp, branch, new StatementBlock.TargetInfo(info, typeNarrow));
                    }
                }
            } else if (arg instanceof TypeParameterConstant) {
                TypeParameterConstant constTypeParam = (TypeParameterConstant)arg;
                ctx.replaceGenericType(constTypeParam, branch, typeNarrow);
            }
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.left != null) {
            if (this.left instanceof NameExpression) {
                sb.append(this.left);
            } else {
                sb.append('(').append(this.left).append(')');
            }
            sb.append('.');
        }
        if (this.amp != null) {
            sb.append('&');
        }
        sb.append(this.name.getValueText());
        if (this.params != null) {
            sb.append('<');
            boolean first = true;
            for (Expression expression : this.params) {
                if (first) {
                    first = false;
                } else {
                    sb.append(", ");
                }
                sb.append(expression);
            }
            sb.append('>');
        }
        return sb.toString();
    }

    @Override
    public String getDumpDesc() {
        return this.toString();
    }

    protected static enum Plan {
        None,
        OuterThis,
        OuterRef,
        RegisterRef,
        PropertyDeref,
        PropertyRef,
        PropertySelf,
        PropertyIdentity,
        TypeOfClass,
        TypeOfTypedef,
        Singleton,
        TypeOfFormalChild,
        BindTarget,
        BjarneLambda;

    }

    protected static enum Meaning {
        Unknown,
        Reserved,
        Variable,
        Property,
        FormalChildType,
        Method,
        Class,
        Type,
        Label;

    }

    protected static enum PropertyAccess {
        SingletonParent,
        Outer,
        This,
        Left;

    }
}

