/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.compiler.ast;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.xvm.asm.ClassStructure;
import org.xvm.asm.Component;
import org.xvm.asm.ComponentResolver;
import org.xvm.asm.CompositeComponent;
import org.xvm.asm.Constant;
import org.xvm.asm.ConstantPool;
import org.xvm.asm.Constants;
import org.xvm.asm.ErrorListener;
import org.xvm.asm.MethodStructure;
import org.xvm.asm.ModuleStructure;
import org.xvm.asm.PackageStructure;
import org.xvm.asm.PropertyStructure;
import org.xvm.asm.TypedefStructure;
import org.xvm.asm.XvmStructure;
import org.xvm.asm.constants.ClassConstant;
import org.xvm.asm.constants.FormalConstant;
import org.xvm.asm.constants.FormalTypeChildConstant;
import org.xvm.asm.constants.IdentityConstant;
import org.xvm.asm.constants.MethodConstant;
import org.xvm.asm.constants.PseudoConstant;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.asm.constants.TypeParameterConstant;
import org.xvm.compiler.ast.AstNode;
import org.xvm.compiler.ast.ImportStatement;
import org.xvm.compiler.ast.StatementBlock;
import org.xvm.compiler.ast.TypeCompositionStatement;
import org.xvm.util.Severity;

public class NameResolver
implements ComponentResolver.ResolutionCollector {
    private final AstNode m_node;
    private final Iterator<String> m_iter;
    private String m_sName;
    private Stage m_stage = Stage.CHECK_IMPORTS;
    private ImportStatement m_stmtImport;
    private StatementBlock m_blockImport;
    private Constant m_constantFirst;
    private Constant m_constant;
    private Component m_component;
    private final boolean m_fTypeGoal;
    private TypeMode m_typeMode;
    private ErrorListener m_errs;

    public NameResolver(AstNode node, String sName) {
        this.m_node = node;
        this.m_iter = Collections.emptyIterator();
        this.m_sName = sName;
        this.m_fTypeGoal = false;
    }

    public NameResolver(AstNode node, Iterator<String> iterNames) {
        assert (node instanceof NameResolving);
        assert (iterNames != null && iterNames.hasNext());
        this.m_node = node;
        this.m_iter = iterNames;
        this.m_sName = this.m_iter.next();
        this.m_fTypeGoal = true;
    }

    public Constant forceResolve(ErrorListener errs) {
        switch (this.resolve(errs).ordinal()) {
            case 1: {
                return this.m_constant;
            }
            case 0: {
                this.m_node.log(errs, Severity.ERROR, "COMPILER-38", this.m_sName);
                this.m_stage = Stage.ERROR;
            }
        }
        return null;
    }

    public boolean isFirstTime() {
        return this.m_stage == Stage.CHECK_IMPORTS;
    }

    public Result resolve(ErrorListener errs) {
        this.m_errs = errs;
        switch (this.m_stage.ordinal()) {
            case 0: {
                this.m_stmtImport = this.m_node.resolveImportBySingleName(this.m_sName, errs);
                if (this.m_stmtImport != null) {
                    if (this.m_stmtImport == this.m_node) {
                        StringBuilder sb = new StringBuilder(this.m_sName);
                        while (this.m_iter.hasNext()) {
                            sb.append('.').append(this.m_iter.next());
                        }
                        this.m_stmtImport.log(errs, Severity.ERROR, "COMPILER-31", sb.toString());
                        this.m_stage = Stage.ERROR;
                        return Result.ERROR;
                    }
                    this.m_blockImport = this.m_stmtImport.getParentBlock();
                }
                this.m_stage = Stage.RESOLVE_FIRST_NAME;
            }
            case 1: {
                boolean fPossibleFormal = false;
                Constants.Access access = Constants.Access.PRIVATE;
                IdentityConstant idOuter = null;
                String sName = this.m_sName;
                block19: for (AstNode node = this.m_node; node != null; node = node.getParent()) {
                    if (node == this.m_blockImport) {
                        Result result = this.resolveImport(this.m_stmtImport, errs);
                        if (result == Result.RESOLVED) break;
                        return result;
                    }
                    if (!node.isComponentNode()) continue;
                    if (!node.canResolveNames()) {
                        return Result.DEFERRED;
                    }
                    ComponentResolver componentResolver = node.getComponentResolver();
                    if (componentResolver == null) {
                        return Result.DEFERRED;
                    }
                    switch (componentResolver.resolveName(sName, access, this)) {
                        case POSSIBLE: {
                            fPossibleFormal = true;
                        }
                        case UNKNOWN: {
                            StatementBlock body;
                            ImportStatement stmt;
                            if (node.getParent() != null || (stmt = (body = ((TypeCompositionStatement)node).ensureBody()).resolveImportBySingleName(sName, errs)) == null) break;
                            this.resolveImport(stmt, errs);
                            break;
                        }
                        case RESOLVED: {
                            break block19;
                        }
                        case ERROR: {
                            this.m_stage = Stage.ERROR;
                            return Result.ERROR;
                        }
                        default: {
                            throw new IllegalStateException();
                        }
                    }
                    if (!(componentResolver instanceof Component)) continue;
                    Component component = (Component)componentResolver;
                    IdentityConstant id = component.getIdentityConstant();
                    IdentityConstant idClz = id.getClassIdentity();
                    if (idOuter == null) {
                        if (idClz instanceof ClassConstant) {
                            ClassConstant clz = (ClassConstant)idClz;
                            v0 = clz.getOutermost();
                        } else {
                            v0 = idOuter = idClz;
                        }
                    }
                    if (id != idOuter) continue;
                    access = Constants.Access.PUBLIC;
                }
                if (this.m_constant == null) {
                    Component component = this.getPool().getImplicitlyImportedComponent(sName);
                    if (component == null) {
                        if (fPossibleFormal) {
                            return Result.DEFERRED;
                        }
                        this.m_node.log(errs, Severity.ERROR, "COMPILER-38", sName);
                        this.m_stage = Stage.ERROR;
                        return Result.ERROR;
                    }
                    if (this.resolvedComponent(component) != ComponentResolver.ResolutionResult.RESOLVED) {
                        return Result.ERROR;
                    }
                    assert (this.m_constant != null);
                }
                this.m_constantFirst = this.m_constant;
                this.m_stage = Stage.RESOLVE_DOT_NAME;
                this.m_sName = this.m_iter.hasNext() ? this.m_iter.next() : null;
            }
            case 2: {
                block20: while (this.m_sName != null) {
                    XvmStructure structure = this.ensurePartiallyResolvedComponent();
                    if (structure == null) {
                        return this.getResult();
                    }
                    if (structure instanceof PropertyStructure) {
                        PropertyStructure prop = (PropertyStructure)structure;
                        if (!prop.isGenericTypeParameter()) {
                            this.m_node.log(errs, Severity.ERROR, "COMPILER-32", this.m_sName);
                            return Result.ERROR;
                        }
                        Result result = this.resolveFormalDotName(prop.getType(), errs);
                        if (result == Result.RESOLVED) continue;
                        return result;
                    }
                    if (structure instanceof TypeParameterConstant) {
                        TypeConstant typeParam;
                        TypeParameterConstant constTypeParam = (TypeParameterConstant)structure;
                        MethodConstant idMethod = constTypeParam.getMethod();
                        int nRegister = constTypeParam.getRegister();
                        MethodStructure method = (MethodStructure)idMethod.getComponent();
                        TypeConstant typeConstant = typeParam = method == null ? idMethod.getRawParams()[nRegister] : method.getParam(nRegister).getType();
                        assert (typeParam.isTypeOfType());
                        Result result = this.resolveFormalDotName(typeParam.getParamType(0), errs);
                        if (result == Result.RESOLVED) continue;
                        return result;
                    }
                    Component component = (Component)structure;
                    switch (component.resolveName(this.m_sName, Constants.Access.PRIVATE, this)) {
                        case POSSIBLE: 
                        case UNKNOWN: {
                            this.m_node.log(errs, Severity.ERROR, "COMPILER-36", this.m_sName, this.m_constant);
                            this.m_stage = Stage.ERROR;
                            return Result.ERROR;
                        }
                        case RESOLVED: {
                            this.m_sName = this.m_iter.hasNext() ? this.m_iter.next() : null;
                            continue block20;
                        }
                        case ERROR: {
                            assert (errs.hasSeriousErrors());
                            this.m_stage = Stage.ERROR;
                            return Result.ERROR;
                        }
                    }
                    throw new IllegalStateException();
                }
                this.m_stage = Stage.RESOLVE_TURTLES;
            }
            case 3: {
                if (this.m_constant.canResolve()) {
                    this.m_stage = Stage.RESOLVED;
                } else {
                    return Result.DEFERRED;
                }
            }
            case 4: {
                return Result.RESOLVED;
            }
        }
        return Result.ERROR;
    }

    private XvmStructure ensurePartiallyResolvedComponent() {
        TypeConstant typeParam;
        Component component = this.m_component;
        if (this.m_typeMode == null) {
            if (component.getFormat().isDeadEnd()) {
                this.m_node.log(this.m_errs, Severity.ERROR, "COMPILER-38", this.m_sName);
                this.m_stage = Stage.ERROR;
                return null;
            }
            return component;
        }
        Constant id = this.m_constant;
        while (true) {
            Component component2;
            TypeConstant type;
            switch (id.getFormat()) {
                case Module: 
                case Package: 
                case Class: {
                    return component;
                }
                case Property: {
                    if (component instanceof PropertyStructure) {
                        return component;
                    }
                    if (component instanceof CompositeComponent) {
                        CompositeComponent composite = (CompositeComponent)component;
                        List<Component> listProps = composite.components();
                        PropertyStructure prop0 = (PropertyStructure)listProps.get(0);
                        TypeConstant type0 = prop0.getType();
                        int c = listProps.size();
                        for (int i = 1; i < c; ++i) {
                            TypeConstant typeN = ((PropertyStructure)listProps.get(i)).getType();
                            if (type0.equals(typeN)) continue;
                            throw new UnsupportedOperationException("non-uniform composite property type: " + String.valueOf(id) + "; 0=" + String.valueOf(type0) + ", " + i + "=" + String.valueOf(typeN));
                        }
                        return prop0;
                    }
                    throw new IllegalStateException("id=" + String.valueOf(id) + ", prop=" + String.valueOf(component));
                }
                case Typedef: {
                    if (component instanceof TypedefStructure) {
                        TypedefStructure typedef = (TypedefStructure)component;
                        type = typedef.getType();
                        break;
                    }
                    if (component instanceof CompositeComponent) {
                        CompositeComponent composite = (CompositeComponent)component;
                        List<Component> listTypedefs = composite.components();
                        type = ((TypedefStructure)listTypedefs.get(0)).getType();
                        int c = listTypedefs.size();
                        for (int i = 1; i < c; ++i) {
                            TypeConstant constTypeN = ((TypedefStructure)listTypedefs.get(i)).getType();
                            if (type.equals(constTypeN)) continue;
                            throw new UnsupportedOperationException("non-uniform composite typedef type: " + String.valueOf(id) + "; 0=" + String.valueOf(type) + ", " + i + "=" + String.valueOf(constTypeN));
                        }
                        break;
                    }
                    throw new IllegalStateException("id=" + String.valueOf(id) + ", typedef=" + String.valueOf(component));
                }
                case TypeParameter: {
                    return id;
                }
                case ThisClass: 
                case ChildClass: 
                case ParentClass: {
                    PseudoConstant constClass = (PseudoConstant)id;
                    return constClass.getDeclarationLevelClass().getComponent();
                }
                case FormalTypeChild: {
                    FormalTypeChildConstant constFormal = (FormalTypeChildConstant)id;
                    type = constFormal.getConstraintType().getType();
                    break;
                }
                default: {
                    throw new IllegalStateException("illegal type param constant id: " + String.valueOf(id));
                }
            }
            if (!type.isTypeOfType()) {
                this.m_errs.log(Severity.ERROR, "COMPILER-32", new Object[]{id.getValueString()}, component);
                this.m_stage = Stage.ERROR;
                return null;
            }
            typeParam = type.getParamType(0);
            if (!typeParam.isSingleDefiningConstant()) break;
            id = typeParam.getDefiningConstant();
            if (id instanceof IdentityConstant) {
                IdentityConstant constId = (IdentityConstant)id;
                component2 = constId.getComponent();
            } else {
                component2 = null;
            }
            component = component2;
        }
        throw new IllegalStateException("not a single defining constant: " + String.valueOf(typeParam));
    }

    protected Result resolveImport(ImportStatement stmtImport, ErrorListener errs) {
        NameResolver resolver = stmtImport.getNameResolver();
        switch (resolver.resolve(errs).ordinal()) {
            case 1: {
                if (stmtImport.isWildcard()) {
                    ModuleStructure module;
                    PackageStructure pkg;
                    Component component = ((IdentityConstant)resolver.getConstant()).getComponent().getChild(this.m_sName);
                    assert (component instanceof ClassStructure || component instanceof TypedefStructure);
                    if (component instanceof PackageStructure && (pkg = (PackageStructure)component).isModuleImport() && (module = pkg.getImportedModule()).isFingerprint()) {
                        component = module.getFingerprintOrigin();
                    }
                    this.m_constant = component.getIdentityConstant();
                    this.m_component = component;
                } else {
                    this.m_constant = resolver.m_constant;
                    this.m_component = resolver.m_component;
                }
                return Result.RESOLVED;
            }
            case 0: {
                return Result.DEFERRED;
            }
        }
        this.m_stage = Stage.ERROR;
        return Result.ERROR;
    }

    private Result resolveFormalDotName(TypeConstant typeConstraint, ErrorListener errs) {
        ComponentResolver.ResolutionResult result = ComponentResolver.ResolutionResult.UNKNOWN;
        if (typeConstraint.isSingleDefiningConstant()) {
            Component component;
            Constant id = typeConstraint.getDefiningConstant();
            if (id instanceof IdentityConstant) {
                IdentityConstant constId = (IdentityConstant)id;
                v0 = constId.getComponent();
            } else if (id instanceof PseudoConstant) {
                PseudoConstant constPseudo = (PseudoConstant)id;
                v0 = constPseudo.getDeclarationLevelClass().getComponent();
            } else {
                v0 = component = null;
            }
            if (component != null) {
                result = component.resolveName(this.m_sName, Constants.Access.PRIVATE, this);
            }
        }
        if (result == ComponentResolver.ResolutionResult.UNKNOWN) {
            result = this.getPool().clzType().getComponent().resolveName(this.m_sName, Constants.Access.PUBLIC, this);
        }
        switch (result) {
            case UNKNOWN: {
                this.m_node.log(errs, Severity.ERROR, "COMPILER-36", this.m_sName, this.m_constant);
            }
            case POSSIBLE: 
            case ERROR: {
                this.m_stage = Stage.ERROR;
                return Result.ERROR;
            }
            case RESOLVED: {
                this.m_sName = this.m_iter.hasNext() ? this.m_iter.next() : null;
                return Result.RESOLVED;
            }
        }
        throw new IllegalStateException();
    }

    public Result getResult() {
        return switch (this.m_stage.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0, 1, 2 -> Result.DEFERRED;
            case 4 -> Result.RESOLVED;
            case 3, 5 -> Result.ERROR;
        };
    }

    public Constant getBaseConstant() {
        return this.m_constantFirst;
    }

    public Constant getConstant() {
        return this.m_constant;
    }

    private ConstantPool getPool() {
        return this.m_node.pool();
    }

    @Override
    public ComponentResolver.ResolutionResult resolvedComponent(Component component) {
        CompositeComponent composite;
        IdentityConstant id = component.getIdentityConstant();
        if (component instanceof CompositeComponent && (composite = (CompositeComponent)component).isAmbiguous()) {
            this.m_node.log(this.m_errs, Severity.ERROR, "COMPILER-37", this.m_sName);
            this.m_stage = Stage.ERROR;
            return ComponentResolver.ResolutionResult.ERROR;
        }
        if (this.m_typeMode != null) {
            boolean fNameMissing = false;
            switch (component.getFormat()) {
                case TYPEDEF: {
                    if (this.m_typeMode != TypeMode.FORMAL_TYPE || component.getParent().getIdentityConstant().equals(this.getPool().clzType())) break;
                    this.m_node.log(this.m_errs, Severity.ERROR, "COMPILER-34", this.m_sName, id.getParentConstant().getValueString());
                    this.m_stage = Stage.ERROR;
                    return ComponentResolver.ResolutionResult.ERROR;
                }
                case CLASS: 
                case INTERFACE: 
                case MIXIN: {
                    if (((ClassStructure)component).isVirtualChild()) {
                        this.m_typeMode = TypeMode.TYPE;
                        break;
                    }
                    fNameMissing = true;
                    break;
                }
                case PROPERTY: {
                    if (((PropertyStructure)component).isGenericTypeParameter()) {
                        if (this.m_typeMode == TypeMode.FORMAL_TYPE) {
                            this.m_component = null;
                            this.m_constant = this.getPool().ensureFormalTypeChildConstant((FormalConstant)this.m_constant, this.m_sName);
                            return ComponentResolver.ResolutionResult.RESOLVED;
                        }
                        this.m_typeMode = TypeMode.FORMAL_TYPE;
                        break;
                    }
                    fNameMissing = true;
                    break;
                }
                default: {
                    fNameMissing = true;
                }
            }
            if (fNameMissing) {
                this.m_node.log(this.m_errs, Severity.ERROR, "COMPILER-36", component.getName(), this.m_constant);
                this.m_stage = Stage.ERROR;
                return ComponentResolver.ResolutionResult.ERROR;
            }
        } else if (this.m_fTypeGoal) {
            switch (component.getFormat()) {
                case PACKAGE: {
                    PackageStructure pkg = (PackageStructure)component;
                    if (!pkg.isModuleImport()) break;
                    ModuleStructure module = pkg.getImportedModule();
                    Component component2 = component = module.isFingerprint() ? module.getFingerprintOrigin() : module;
                    if (component == null) {
                        this.m_node.log(this.m_errs, Severity.ERROR, "COMPILER-24", module.getName());
                        this.m_stage = Stage.ERROR;
                        return ComponentResolver.ResolutionResult.ERROR;
                    }
                    id = module.getIdentityConstant();
                    break;
                }
                case PROPERTY: {
                    if (!((PropertyStructure)component).isGenericTypeParameter()) break;
                    this.m_typeMode = TypeMode.FORMAL_TYPE;
                    break;
                }
                case TYPEDEF: {
                    this.m_typeMode = TypeMode.TYPE;
                }
            }
        }
        this.m_component = component;
        this.m_constant = id;
        return ComponentResolver.ResolutionResult.RESOLVED;
    }

    @Override
    public ComponentResolver.ResolutionResult resolvedConstant(Constant constant) {
        IdentityConstant id;
        Component component;
        if (constant == null) {
            return ComponentResolver.ResolutionResult.UNKNOWN;
        }
        if (constant instanceof IdentityConstant && (component = (id = (IdentityConstant)constant).getComponent()) != null) {
            return this.resolvedComponent(component);
        }
        this.m_constant = constant;
        this.m_component = null;
        this.m_typeMode = constant instanceof TypeParameterConstant ? TypeMode.FORMAL_TYPE : (this.m_fTypeGoal ? TypeMode.TYPE : null);
        return ComponentResolver.ResolutionResult.RESOLVED;
    }

    @Override
    public AstNode getNode() {
        return this.m_node;
    }

    @Override
    public ErrorListener getErrorListener() {
        return this.m_errs;
    }

    private static enum Stage {
        CHECK_IMPORTS,
        RESOLVE_FIRST_NAME,
        RESOLVE_DOT_NAME,
        RESOLVE_TURTLES,
        RESOLVED,
        ERROR;

    }

    @FunctionalInterface
    public static interface NameResolving {
        public NameResolver getNameResolver();
    }

    public static enum Result {
        DEFERRED,
        RESOLVED,
        ERROR;

    }

    private static enum TypeMode {
        TYPE,
        FORMAL_TYPE;

    }
}

