/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.compiler.ast;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.xvm.asm.Argument;
import org.xvm.asm.ClassStructure;
import org.xvm.asm.Component;
import org.xvm.asm.Constant;
import org.xvm.asm.ConstantPool;
import org.xvm.asm.Constants;
import org.xvm.asm.ErrorListener;
import org.xvm.asm.MethodStructure;
import org.xvm.asm.ast.ConstantExprAST;
import org.xvm.asm.ast.ExprAST;
import org.xvm.asm.constants.ChildClassConstant;
import org.xvm.asm.constants.ClassConstant;
import org.xvm.asm.constants.IdentityConstant;
import org.xvm.asm.constants.PropertyConstant;
import org.xvm.asm.constants.PseudoConstant;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.asm.constants.TypeInfo;
import org.xvm.asm.constants.TypeParameterConstant;
import org.xvm.asm.constants.TypedefConstant;
import org.xvm.asm.constants.UnresolvedNameConstant;
import org.xvm.asm.constants.UnresolvedTypeConstant;
import org.xvm.compiler.Compiler;
import org.xvm.compiler.Lexer;
import org.xvm.compiler.Token;
import org.xvm.compiler.ast.AnnotatedTypeExpression;
import org.xvm.compiler.ast.AnonInnerClass;
import org.xvm.compiler.ast.AstNode;
import org.xvm.compiler.ast.Context;
import org.xvm.compiler.ast.Expression;
import org.xvm.compiler.ast.NameExpression;
import org.xvm.compiler.ast.NameResolver;
import org.xvm.compiler.ast.NewExpression;
import org.xvm.compiler.ast.StageMgr;
import org.xvm.compiler.ast.TypeCompositionStatement;
import org.xvm.compiler.ast.TypeExpression;
import org.xvm.util.Severity;

public class NamedTypeExpression
extends TypeExpression
implements NameResolver.NameResolving {
    protected List<Token> module;
    protected TypeExpression left;
    protected Token immutable;
    protected List<Token> names;
    protected Token access;
    protected Token nonnarrow;
    protected List<TypeExpression> paramTypes;
    protected long lStartPos;
    protected long lEndPos;
    protected transient NameResolver m_resolver;
    protected transient Constant m_constId;
    protected transient boolean m_fVirtualChild;
    protected transient boolean m_fExternalTypedef;
    private transient NameExpression m_exprDynamic;
    protected transient UnresolvedNameConstant m_constUnresolved;
    protected transient UnresolvedTypeConstant m_typeUnresolved;
    private static final Field[] CHILD_FIELDS = NamedTypeExpression.fieldsForNames(NamedTypeExpression.class, "left", "paramTypes");

    public NamedTypeExpression(Token immutable, List<Token> names, Token access, Token nonnarrow, List<TypeExpression> params, long lEndPos) {
        this.left = null;
        this.immutable = immutable;
        this.names = names;
        this.access = access;
        this.nonnarrow = nonnarrow;
        this.paramTypes = params;
        this.lStartPos = immutable == null ? names.get(0).getStartPosition() : immutable.getStartPosition();
        this.lEndPos = lEndPos;
    }

    public NamedTypeExpression(TypeExpression left, List<Token> names, List<TypeExpression> params, long lEndPos) {
        this.left = left;
        this.immutable = null;
        this.names = names;
        this.access = null;
        this.nonnarrow = null;
        this.paramTypes = params;
        this.lStartPos = names.get(0).getStartPosition();
        this.lEndPos = lEndPos;
    }

    public NamedTypeExpression(Expression exprSource, TypeConstant type) {
        this.left = null;
        this.immutable = null;
        this.access = null;
        this.nonnarrow = null;
        this.paramTypes = null;
        this.lStartPos = exprSource.getStartPosition();
        this.lEndPos = exprSource.getEndPosition();
        this.names = Collections.singletonList(new Token(this.lStartPos, this.lEndPos, Token.Id.IDENTIFIER, type.getValueString()));
        this.setTypeConstant(type);
        this.setStage(Compiler.Stage.Validated);
        this.setParent(exprSource);
    }

    public NamedTypeExpression(List<Token> module, List<Token> names, List<TypeExpression> params, long lEndPos) {
        this.module = module;
        this.left = null;
        this.immutable = null;
        this.names = names;
        this.access = null;
        this.nonnarrow = null;
        this.paramTypes = params;
        this.lStartPos = (module == null ? names : module).get(0).getStartPosition();
        this.lEndPos = lEndPos;
    }

    public String getModule() {
        if (this.module == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (Token name : this.module) {
            if (first) {
                first = false;
            } else {
                sb.append('.');
            }
            sb.append(name.getValueText());
        }
        return sb.toString();
    }

    public String getName() {
        if (this.names == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (Token name : this.names) {
            if (first) {
                first = false;
            } else {
                sb.append('.');
            }
            sb.append(name.getValueText());
        }
        return sb.toString();
    }

    public String[] getNames() {
        List<Token> list = this.names;
        int c = list == null ? 0 : list.size();
        String[] as = new String[c];
        for (int i = 0; i < c; ++i) {
            as[i] = list.get(i).getValueText();
        }
        return as;
    }

    public Constant getIdentityConstant() {
        Constant constId = this.m_constId;
        if (constId == null) {
            this.m_constUnresolved = new UnresolvedNameConstant(this.pool(), this.getNames(), this.isExplicitlyNonAutoNarrowing());
            this.m_constId = constId = this.m_constUnresolved;
        } else {
            this.m_constId = constId = constId.resolve();
        }
        return constId;
    }

    public List<TypeExpression> getParamTypes() {
        return this.paramTypes;
    }

    public Constants.Access getExplicitAccess() {
        if (this.access == null) {
            return null;
        }
        return switch (this.access.getId()) {
            case Token.Id.PUBLIC -> Constants.Access.PUBLIC;
            case Token.Id.PROTECTED -> Constants.Access.PROTECTED;
            case Token.Id.PRIVATE -> Constants.Access.PRIVATE;
            case Token.Id.STRUCT -> Constants.Access.STRUCT;
            default -> throw new IllegalStateException("access=" + String.valueOf(this.access));
        };
    }

    public boolean isExplicitlyNonAutoNarrowing() {
        return this.nonnarrow != null;
    }

    public boolean isVirtualChild() {
        return this.m_fVirtualChild;
    }

    public boolean isAutoNarrowingAllowed() {
        TypeExpression type = this;
        AstNode parent = this.getParent();
        while (parent.isAutoNarrowingAllowed(type)) {
            if (parent.isComponentNode()) {
                return true;
            }
            if (parent instanceof AnnotatedTypeExpression) {
                AnnotatedTypeExpression exprAnno = (AnnotatedTypeExpression)parent;
                if (type == exprAnno.type) {
                    type = exprAnno;
                }
            }
            parent = parent.getParent();
        }
        return false;
    }

    protected Constant inferAutoNarrowing(Constant constId, ErrorListener errs) {
        if (!constId.containsUnresolved() && this.isAutoNarrowingAllowed() != this.isExplicitlyNonAutoNarrowing()) {
            if (this.isExplicitlyNonAutoNarrowing()) {
                this.log(errs, Severity.ERROR, "COMPILER-87", new Object[0]);
            } else if (constId instanceof ClassConstant) {
                ClassStructure clz;
                ClassStructure clzThis;
                ClassConstant idClz = (ClassConstant)constId;
                Component component = this.getComponent();
                ClassStructure classStructure = clzThis = component instanceof ClassStructure ? (clz = (ClassStructure)component) : component.getContainingClass();
                if (clzThis != null && clzThis.getIdentityConstant().getFormat() == Constant.Format.Class) {
                    return ((ClassConstant)clzThis.getIdentityConstant()).calculateAutoNarrowingConstant(idClz);
                }
            }
        }
        return constId;
    }

    protected List<String> collectNames(int cNames) {
        ArrayList<String> listNames;
        List<Token> listThis = this.names;
        int cNamesThis = listThis == null ? 0 : listThis.size();
        TypeExpression typeExpression = this.left;
        if (typeExpression instanceof NamedTypeExpression) {
            NamedTypeExpression exprName = (NamedTypeExpression)typeExpression;
            listNames = exprName.collectNames(cNames + cNamesThis);
        } else {
            listNames = new ArrayList(cNames + cNamesThis);
        }
        for (int i = 0; i < cNamesThis; ++i) {
            listNames.add(listThis.get(i).getValueText());
        }
        return listNames;
    }

    protected boolean isFullyQualifiedChild() {
        assert (this.m_resolver != null && this.m_resolver.getResult() == NameResolver.Result.RESOLVED);
        IdentityConstant idFirst = (IdentityConstant)this.m_resolver.getBaseConstant();
        return !(idFirst instanceof ClassConstant) || !((ClassStructure)idFirst.getComponent()).isVirtualChild();
    }

    public boolean isValidModuleName() {
        return this.immutable == null && this.access == null && (this.paramTypes == null || this.paramTypes.isEmpty()) && Lexer.isValidQualifiedModule(this.getName());
    }

    @Override
    public long getStartPosition() {
        return this.lStartPos;
    }

    @Override
    public long getEndPosition() {
        return this.lEndPos;
    }

    @Override
    protected Field[] getChildFields() {
        return CHILD_FIELDS;
    }

    @Override
    public NameResolver getNameResolver() {
        NameResolver resolver = this.m_resolver;
        if (resolver == null || resolver.getNode() != this) {
            this.m_resolver = resolver = new NameResolver((AstNode)this, this.collectNames(0).iterator());
        }
        return resolver;
    }

    @Override
    protected TypeConstant instantiateTypeConstant(Context ctx, ErrorListener errs) {
        Constant constId = this.getIdentityConstant();
        Constants.Access access = this.getExplicitAccess();
        List<TypeExpression> listParams = this.paramTypes;
        if (constId instanceof TypeConstant) {
            TypeConstant type = (TypeConstant)constId;
            if (access != null) {
                throw new IllegalStateException("log error: access override unexpected");
            }
            if (listParams != null && !listParams.isEmpty()) {
                throw new IllegalStateException("log error: type params unexpected");
            }
            return type;
        }
        ConstantPool pool = this.pool();
        TypeConstant type = this.calculateDefaultType(ctx, constId, ErrorListener.BLACKHOLE);
        if (listParams != null) {
            int cParams = listParams.size();
            TypeConstant[] atypeParams = new TypeConstant[cParams];
            for (int i = 0; i < cParams; ++i) {
                atypeParams[i] = listParams.get(i).ensureTypeConstant(ctx, errs);
            }
            type = pool.ensureParameterizedTypeConstant(type, atypeParams);
        }
        if (access != null && access != Constants.Access.PUBLIC) {
            type = pool.ensureAccessTypeConstant(type, access);
        }
        if (this.immutable != null) {
            type = type.freeze();
        }
        return type;
    }

    @Override
    protected void setTypeConstant(TypeConstant constType) {
        if (!constType.containsUnresolved()) {
            this.m_constId = constType;
        }
        super.setTypeConstant(constType);
    }

    @Override
    protected void collectAnonInnerClassInfo(AnonInnerClass info) {
        info.addContribution(this);
    }

    @Override
    public boolean isDynamic() {
        return this.m_exprDynamic != null;
    }

    @Override
    public void resolveNames(StageMgr mgr, ErrorListener errs) {
        if (this.left == null) {
            AstNode parent = this.getParent();
            while (parent instanceof AnnotatedTypeExpression) {
                parent = parent.getParent();
            }
            if (parent instanceof NewExpression) {
                NewExpression exprNew = (NewExpression)parent;
                if (exprNew.left != null) {
                    this.m_fVirtualChild = true;
                    return;
                }
            }
            while (parent != null) {
                if (parent instanceof TypeCompositionStatement) {
                    TypeCompositionStatement stmt = (TypeCompositionStatement)parent;
                    ClassStructure clz = (ClassStructure)stmt.getComponent();
                    if (stmt.getName().equals(this.getName())) {
                        if (!stmt.alreadyReached(Compiler.Stage.Resolved) && clz != null && clz.getFormat() == Component.Format.MIXIN && !clz.isParameterized()) {
                            mgr.requestRevisit();
                            return;
                        }
                        break;
                    }
                    if (clz != null && clz.isTopLevel()) break;
                }
                parent = parent.getParent();
            }
        } else {
            boolean fDone = mgr.processChildrenExcept(node -> node != this.left);
            if (!fDone) {
                mgr.requestRevisit();
                return;
            }
        }
        ErrorListener errsTemp = errs.branch(this);
        NameResolver resolver = this.getNameResolver();
        switch (resolver.resolve(errsTemp)) {
            case DEFERRED: {
                mgr.requestRevisit();
                return;
            }
            case RESOLVED: {
                if (!mgr.processChildren()) {
                    mgr.requestRevisit();
                    return;
                }
                Constant constId = resolver.getConstant();
                boolean fProceed = this.checkValidType(constId, errsTemp);
                if (!fProceed) {
                    errsTemp.merge();
                    mgr.deferChildren();
                    return;
                }
                Constant constIdNew = this.m_constId = this.inferAutoNarrowing(constId, errsTemp);
                if (!errsTemp.hasSeriousErrors()) {
                    UnresolvedTypeConstant typeUnresolved;
                    if (this.m_constUnresolved != null) {
                        this.m_constUnresolved.resolve(constIdNew);
                        this.m_constUnresolved = null;
                    }
                    if ((typeUnresolved = this.m_typeUnresolved) != null) {
                        if (typeUnresolved.containsUnresolved()) {
                            TypeConstant typeNew = this.calculateDefaultType(null, constIdNew, errsTemp);
                            if (typeNew.containsUnresolved()) {
                                mgr.requestRevisit();
                                return;
                            }
                            typeUnresolved.resolve(typeNew);
                        }
                        this.m_typeUnresolved = null;
                    }
                }
                if (errsTemp.hasSeriousErrors()) {
                    errsTemp.merge();
                    mgr.deferChildren();
                    return;
                }
                this.resetTypeConstant();
                break;
            }
            case ERROR: {
                if (this.left == null && this.names != null && this.access == null && this.immutable == null && this.paramTypes == null && this.getCodeContainer() != null) {
                    NameExpression exprDyn = new NameExpression(this.names.get(0));
                    this.getParent().adopt(exprDyn);
                    int cNames = this.names.size();
                    for (int i = 1; i < cNames; ++i) {
                        NameExpression exprNext = new NameExpression(exprDyn, null, this.names.get(i), null, this.lEndPos);
                        exprDyn.adopt(exprNext);
                        exprDyn = exprNext;
                    }
                    this.m_exprDynamic = exprDyn;
                    return;
                }
                errsTemp.merge();
            }
        }
    }

    @Override
    protected Expression validate(Context ctx, TypeConstant typeRequired, ErrorListener errs) {
        Constants.Access access;
        List<TypeExpression> listParams;
        TypeConstant type;
        Constant constId;
        ConstantPool pool = this.pool();
        if (this.m_exprDynamic != null) {
            NameExpression exprOld = this.m_exprDynamic;
            NameExpression exprNew = (NameExpression)exprOld.validate(ctx, pool.typeType(), errs);
            if (exprNew == null) {
                return null;
            }
            this.m_exprDynamic = exprNew;
            TypeConstant typeType = exprNew.getType();
            if (exprNew.isSimpleName() && typeType.getParamType(0).equals(pool.typeObject())) {
                typeType = this.transformType(ctx, exprNew);
            }
            this.m_constId = typeType.getParamType(0);
            return this.finishValidation(ctx, typeRequired, typeType, Expression.TypeFit.Fit, null, errs);
        }
        if (this.m_constId == null || this.m_constId.containsUnresolved()) {
            ErrorListener errsTemp = errs.branch(this);
            NameResolver resolver = this.getNameResolver();
            switch (resolver.resolve(errsTemp)) {
                case DEFERRED: 
                case ERROR: {
                    errsTemp.merge();
                    return null;
                }
                case RESOLVED: {
                    constId = resolver.getConstant();
                    if (!this.checkValidType(constId, errsTemp)) {
                        errsTemp.merge();
                        return null;
                    }
                    this.m_constId = this.inferAutoNarrowing(constId, errsTemp);
                }
            }
        }
        if (this.left == null) {
            constId = this.m_constId;
            if (constId instanceof TypeConstant) {
                TypeConstant constType;
                type = constType = (TypeConstant)constId;
            } else {
                type = this.calculateDefaultType(ctx, this.m_constId, errs);
                if (type.containsUnresolved()) {
                    this.log(errs, Severity.ERROR, "COMPILER-38", this.getName());
                    return null;
                }
            }
            if (type.containsFormalType(false)) {
                ctx.useFormalType(type, errs);
            }
            if (this.m_fExternalTypedef && type.containsGenericType(true)) {
                TypeConstant typeParent = ((TypedefConstant)this.m_constId).getParentConstant().getType();
                type = type.resolveGenerics(pool, typeParent.normalizeParameters());
            }
        } else {
            TypeExpression exprOld = this.left;
            Expression exprNew = exprOld.validate(ctx, null, errs);
            if (exprNew == null) {
                return null;
            }
            type = this.left.getType().getParamType(0);
            for (Token name : this.names) {
                String sName;
                TypeInfo infoLeft = type.ensureTypeInfo(errs);
                if ((type = infoLeft.calculateChildType(pool, sName = name.getValueText())) != null) continue;
                this.log(errs, Severity.ERROR, "COMPILER-38", sName);
                return null;
            }
        }
        if ((listParams = this.paramTypes) != null) {
            Object[] atypeParams = this.validateParameters(ctx, listParams, errs);
            if (atypeParams == null) {
                return null;
            }
            if (type.isParamsSpecified()) {
                Object[] atypeActual = type.getParamTypesArray();
                if (!Arrays.equals(atypeActual, atypeParams)) {
                    this.log(errs, Severity.ERROR, "COMPILER-12", new Object[0]);
                    return null;
                }
            } else if (type.isExplicitClassIdentity(true) && (type.isTuple() || atypeParams.length <= type.getMaxParamsCount())) {
                type = pool.ensureParameterizedTypeConstant(type, (TypeConstant[])atypeParams);
            } else {
                this.log(errs, Severity.ERROR, "COMPILER-12", new Object[0]);
                return null;
            }
        }
        if ((access = this.getExplicitAccess()) != null && access != Constants.Access.PUBLIC) {
            type = pool.ensureAccessTypeConstant(type, access);
        }
        if (this.immutable != null) {
            type = type.freeze();
        }
        TypeConstant typeType = type.getType();
        return this.finishValidation(ctx, typeRequired, typeType, Expression.TypeFit.Fit, type.isFormalType() ? null : typeType, errs);
    }

    private TypeConstant[] validateParameters(Context ctx, List<TypeExpression> listParams, ErrorListener errs) {
        ConstantPool pool = this.pool();
        boolean fValid = true;
        TypeConstant[] atypeParams = new TypeConstant[listParams.size()];
        int c = listParams.size();
        for (int i = 0; i < c; ++i) {
            TypeExpression exprOld = listParams.get(i);
            TypeExpression exprNew = (TypeExpression)exprOld.validate(ctx, pool.typeType(), errs);
            if (exprNew == null) {
                fValid = false;
                continue;
            }
            if (exprNew != exprOld) {
                listParams.set(i, exprNew);
            }
            atypeParams[i] = exprNew.ensureTypeConstant(ctx, errs);
        }
        return fValid ? atypeParams : null;
    }

    protected TypeConstant calculateDefaultType(Context ctx, Constant constTarget, ErrorListener errs) {
        ConstantPool pool = this.pool();
        if (this.left == null) {
            ClassConstant idTarget;
            boolean fAllowFormal = false;
            boolean fParent = false;
            boolean fRetainConst = true;
            switch (constTarget.getFormat()) {
                case ParentClass: {
                    fParent = true;
                }
                case ThisClass: {
                    fAllowFormal = true;
                    idTarget = (ClassConstant)((PseudoConstant)constTarget).getDeclarationLevelClass();
                    break;
                }
                case ChildClass: {
                    fRetainConst = false;
                    idTarget = (ClassConstant)((ChildClassConstant)constTarget).getDeclarationLevelClass();
                    break;
                }
                case Class: {
                    idTarget = (ClassConstant)constTarget;
                    break;
                }
                case Property: {
                    PropertyConstant idProp = (PropertyConstant)constTarget;
                    if (idProp.isFormalType()) {
                        Argument arg;
                        if (ctx != null && (arg = ctx.getVar(idProp.getName())) != null) {
                            TypeConstant typeType = arg.getType();
                            assert (typeType.isTypeOfType());
                            return typeType.getParamType(0);
                        }
                        return idProp.getFormalType();
                    }
                    return new UnresolvedTypeConstant(pool, new UnresolvedNameConstant(pool, idProp.getName()));
                }
                case Typedef: {
                    TypedefConstant idTypedef = (TypedefConstant)constTarget;
                    TypeConstant typeRef = idTypedef.getReferredToType();
                    IdentityConstant idFrom = idTypedef.getParentConstant();
                    IdentityConstant idClass = this.getComponent().getContainingClass().getIdentityConstant();
                    if (!idFrom.isNestMateOf(idClass)) {
                        if (idFrom.equals(pool.clzType())) {
                            Constant idLeft = this.m_resolver.getBaseConstant();
                            if (idLeft instanceof PropertyConstant) {
                                PropertyConstant idProp = (PropertyConstant)idLeft;
                                typeRef = typeRef.resolveGenerics(pool, idProp.getFormalType().getType());
                            } else if (idLeft instanceof TypeParameterConstant) {
                                typeRef = typeRef.resolveGenerics(pool, idLeft.getType().getType());
                            }
                        }
                        this.m_fExternalTypedef = true;
                    }
                    return typeRef;
                }
                case UnresolvedName: {
                    TypeConstant type;
                    if (this.m_exprDynamic != null && ctx != null && (type = this.m_exprDynamic.getImplicitType(ctx)) != null && type.isTypeOfType()) {
                        return type.getParamType(0);
                    }
                    this.m_typeUnresolved = new UnresolvedTypeConstant(pool, (UnresolvedNameConstant)constTarget);
                    return this.m_typeUnresolved;
                }
                default: {
                    idTarget = null;
                }
            }
            TypeConstant typeTarget = null;
            Component component = this.getComponent();
            ClassStructure clzClass = component.getContainingClass();
            if (idTarget != null && clzClass != null) {
                boolean fValid;
                IdentityConstant idClass = clzClass.getIdentityConstant();
                ClassStructure clzTarget = (ClassStructure)idTarget.getComponent();
                if (idTarget.isNestMateOf(idClass)) {
                    MethodStructure method;
                    if (clzTarget.isVirtualChild()) {
                        idBase = idTarget.getAutoNarrowingBase();
                        clzBase = (ClassStructure)idBase.getComponent();
                        if (clzBase.containsUnresolvedContribution()) {
                            return new UnresolvedTypeConstant(pool, new UnresolvedNameConstant(pool, clzTarget.getName()));
                        }
                        boolean fFormalParent = true;
                        if (component instanceof MethodStructure) {
                            MethodStructure method2 = (MethodStructure)component;
                            fFormalParent = !method2.isFunction() || method2.isLambda();
                        }
                        boolean fFormalChild = fFormalParent && fAllowFormal && this.paramTypes == null;
                        TypeConstant typeConstant = typeTarget = fParent ? clzTarget.getAutoNarrowingFormalType() : pool.ensureVirtualTypeConstant(clzBase, clzTarget, fFormalParent, fFormalChild, constTarget);
                        assert (typeTarget != null);
                    } else if (clzClass.isVirtualDescendant(idTarget) && this.paramTypes == null && clzTarget.isParameterized() && (!component.isStatic() || component instanceof MethodStructure && (method = (MethodStructure)component).isConstructor() && !method.isPropertyInitializer())) {
                        typeTarget = pool.ensureClassTypeConstant(constTarget, null, clzTarget.getFormalType().getParamTypesArray());
                    }
                    if (ctx != null && typeTarget != null) {
                        typeTarget = ctx.resolveFormalType(typeTarget);
                    }
                } else if (clzTarget.isVirtualChild()) {
                    idBase = idTarget.getAutoNarrowingBase();
                    clzBase = (ClassStructure)idBase.getComponent();
                    if (clzBase.containsUnresolvedContribution()) {
                        return new UnresolvedTypeConstant(pool, new UnresolvedNameConstant(pool, clzTarget.getName()));
                    }
                    typeTarget = pool.ensureVirtualTypeConstant(clzBase, clzTarget, false, false, idTarget);
                } else if (clzTarget.isInnerChild()) {
                    ClassStructure clzParent = clzTarget.getContainingClass();
                    typeTarget = pool.ensureInnerChildTypeConstant(clzParent.getFormalType(), idTarget);
                }
                if (clzTarget.isParameterized()) {
                    int cParams = this.paramTypes == null ? 0 : this.paramTypes.size();
                    fValid = clzTarget.isTuple() || cParams <= clzTarget.getTypeParamCount();
                } else {
                    boolean bl = fValid = this.paramTypes == null;
                }
                if (!fValid) {
                    this.log(errs, Severity.ERROR, "COMPILER-12", new Object[0]);
                }
            }
            return typeTarget == null ? pool.ensureTerminalTypeConstant(fRetainConst ? constTarget : idTarget) : typeTarget;
        }
        TypeConstant type = this.left.ensureTypeConstant(ctx, errs);
        switch (this.m_constId.getFormat()) {
            case ChildClass: 
            case Class: {
                if (this.names != null) {
                    for (Token name : this.names) {
                        String sChild;
                        if (!type.isExplicitClassIdentity(true)) {
                            this.log(errs, Severity.ERROR, "COMPILER-32", type.getValueString());
                            break;
                        }
                        ClassConstant idLeft = (ClassConstant)type.getSingleUnderlyingClass(true);
                        ClassStructure clzLeft = (ClassStructure)idLeft.getComponent();
                        Component child = clzLeft.findChildDeep(sChild = name.getValueText());
                        if (child instanceof ClassStructure) {
                            ClassStructure clzChild = (ClassStructure)child;
                            if (clzChild.isVirtualChild()) {
                                type = this.isExplicitlyNonAutoNarrowing() ? pool.ensureVirtualChildTypeConstant(type, sChild) : pool.ensureThisVirtualChildTypeConstant(type, sChild);
                                continue;
                            }
                            type = clzChild.getIdentityConstant().getType();
                            continue;
                        }
                        this.log(errs, Severity.ERROR, "COMPILER-32", child.getIdentityConstant());
                        break;
                    }
                }
                return type;
            }
            case Typedef: {
                TypeConstant typeTypedef = ((TypedefConstant)this.m_constId).getReferredToType();
                return typeTypedef.resolveGenerics(pool, type);
            }
            case UnresolvedName: {
                this.m_typeUnresolved = new UnresolvedTypeConstant(pool, (UnresolvedNameConstant)this.m_constId);
                return this.m_typeUnresolved;
            }
        }
        return new UnresolvedTypeConstant(pool, new UnresolvedNameConstant(pool, this.getNames(), false));
    }

    @Override
    public Argument generateArgument(Context ctx, MethodStructure.Code code, boolean fLocalPropOk, boolean fUsedOnce, ErrorListener errs) {
        return this.isDynamic() ? this.m_exprDynamic.generateArgument(ctx, code, fLocalPropOk, fUsedOnce, errs) : this.getType().resolveAutoNarrowingBase();
    }

    @Override
    public ExprAST getExprAST(Context ctx) {
        return this.isDynamic() ? this.m_exprDynamic.getExprAST(ctx) : new ConstantExprAST(this.getType().resolveAutoNarrowingBase());
    }

    @Override
    public AstNode clone() {
        NamedTypeExpression that = (NamedTypeExpression)super.clone();
        if (this.m_exprDynamic != null) {
            that.m_exprDynamic = (NameExpression)this.m_exprDynamic.clone();
        }
        return that;
    }

    @Override
    protected void discard(boolean fRecurse) {
        super.discard(fRecurse);
        if (fRecurse && this.m_exprDynamic != null) {
            this.m_exprDynamic.discard(fRecurse);
        }
    }

    private boolean checkValidType(Constant constId, ErrorListener errs) {
        Constant.Format format = constId.getFormat();
        if (!format.isTypeable()) {
            this.log(errs, Severity.ERROR, "COMPILER-32", constId.getValueString());
            return false;
        }
        if (format == Constant.Format.Property || format == Constant.Format.Typedef) {
            if (this.paramTypes != null) {
                this.log(errs, Severity.ERROR, "COMPILER-12", new Object[0]);
                return false;
            }
            if (format == Constant.Format.Property && (!((PropertyConstant)constId).isFormalType() || this.names != null && this.names.size() > 1)) {
                this.log(errs, Severity.ERROR, "COMPILER-135", new Object[0]);
                return false;
            }
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.module != null) {
            sb.append(this.getModule()).append(':');
        }
        if (this.left != null) {
            sb.append(this.left).append('.');
        }
        if (this.immutable != null) {
            sb.append("immutable ");
        }
        sb.append(this.getName());
        if (this.access != null) {
            sb.append(':').append(this.access.getId().TEXT);
        }
        if (this.nonnarrow != null) {
            sb.append('!');
        }
        if (this.paramTypes != null) {
            sb.append('<');
            boolean first = true;
            for (TypeExpression type : this.paramTypes) {
                if (first) {
                    first = false;
                } else {
                    sb.append(", ");
                }
                sb.append(type);
            }
            sb.append('>');
        }
        return sb.toString();
    }

    @Override
    public String getDumpDesc() {
        return this.toString();
    }
}

