/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.compiler.ast;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.xvm.asm.Annotation;
import org.xvm.asm.Argument;
import org.xvm.asm.ClassStructure;
import org.xvm.asm.Component;
import org.xvm.asm.Constant;
import org.xvm.asm.ConstantPool;
import org.xvm.asm.Constants;
import org.xvm.asm.ErrorListener;
import org.xvm.asm.MethodStructure;
import org.xvm.asm.Parameter;
import org.xvm.asm.PropertyStructure;
import org.xvm.asm.Register;
import org.xvm.asm.ast.AssignAST;
import org.xvm.asm.ast.BinaryAST;
import org.xvm.asm.ast.CallExprAST;
import org.xvm.asm.ast.ConstantExprAST;
import org.xvm.asm.ast.ExprAST;
import org.xvm.asm.ast.InitAST;
import org.xvm.asm.ast.NewExprAST;
import org.xvm.asm.ast.OuterExprAST;
import org.xvm.asm.ast.PropertyExprAST;
import org.xvm.asm.ast.RegisterAST;
import org.xvm.asm.ast.StmtBlockAST;
import org.xvm.asm.constants.AnnotatedTypeConstant;
import org.xvm.asm.constants.DynamicFormalConstant;
import org.xvm.asm.constants.ExpressionConstant;
import org.xvm.asm.constants.MethodConstant;
import org.xvm.asm.constants.MethodInfo;
import org.xvm.asm.constants.PropertyConstant;
import org.xvm.asm.constants.RegisterConstant;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.asm.constants.TypeInfo;
import org.xvm.asm.op.Construct_0;
import org.xvm.asm.op.Construct_1;
import org.xvm.asm.op.Construct_N;
import org.xvm.asm.op.L_Get;
import org.xvm.asm.op.L_Set;
import org.xvm.asm.op.Move;
import org.xvm.asm.op.MoveRef;
import org.xvm.asm.op.MoveThis;
import org.xvm.asm.op.MoveType;
import org.xvm.asm.op.MoveVar;
import org.xvm.asm.op.NewCG_0;
import org.xvm.asm.op.NewCG_1;
import org.xvm.asm.op.NewCG_N;
import org.xvm.asm.op.NewC_0;
import org.xvm.asm.op.NewC_1;
import org.xvm.asm.op.NewC_N;
import org.xvm.asm.op.NewG_0;
import org.xvm.asm.op.NewG_1;
import org.xvm.asm.op.NewG_N;
import org.xvm.asm.op.NewV_0;
import org.xvm.asm.op.NewV_1;
import org.xvm.asm.op.NewV_N;
import org.xvm.asm.op.New_0;
import org.xvm.asm.op.New_1;
import org.xvm.asm.op.New_N;
import org.xvm.asm.op.Return_0;
import org.xvm.asm.op.SynInit;
import org.xvm.asm.op.Var;
import org.xvm.compiler.Compiler;
import org.xvm.compiler.Token;
import org.xvm.compiler.ast.AnnotatedTypeExpression;
import org.xvm.compiler.ast.AnonInnerClass;
import org.xvm.compiler.ast.ArrayTypeExpression;
import org.xvm.compiler.ast.AstNode;
import org.xvm.compiler.ast.Context;
import org.xvm.compiler.ast.Expression;
import org.xvm.compiler.ast.NamedTypeExpression;
import org.xvm.compiler.ast.StageMgr;
import org.xvm.compiler.ast.StatementBlock;
import org.xvm.compiler.ast.TypeCompositionStatement;
import org.xvm.compiler.ast.TypeExpression;
import org.xvm.util.Handy;
import org.xvm.util.Severity;

public class NewExpression
extends Expression {
    protected Expression left;
    protected Token operator;
    protected TypeExpression type;
    protected List<Expression> args;
    protected int dims;
    protected StatementBlock body;
    protected TypeCompositionStatement anon;
    protected long lEndPos;
    private transient MethodStructure m_constructor;
    private transient boolean m_fTupleArg;
    private transient AnonPurpose m_purposeCurrent = AnonPurpose.None;
    private transient TypeCompositionStatement m_anonActualBackup;
    private transient ClassStructure m_clzActualBackup;
    private transient AnonInnerClassContext m_ctxCapture;
    private transient Map<String, Boolean> m_mapCapture;
    private transient Map<String, Register> m_mapRegisters;
    private transient Plan m_plan;
    private transient int m_nParentSteps;
    private transient PropertyConstant m_idFormal;
    private transient Register m_regFormal;
    private transient boolean m_fFixedSizeArray;
    private transient boolean m_fInstanceChild;
    private transient boolean m_fDynamicAnno;
    private transient ExprAST m_astNew;
    private static final Field[] CHILD_FIELDS = NewExpression.fieldsForNames(NewExpression.class, "left", "type", "args", "anon");

    public NewExpression(Expression left, Token operator, TypeExpression type, List<Expression> args, int dims, StatementBlock body, long lEndPos) {
        assert (operator != null);
        assert (args != null);
        this.left = left;
        this.operator = operator;
        this.type = type;
        this.args = args;
        this.dims = dims;
        this.body = body;
        this.lEndPos = lEndPos;
    }

    @Override
    public boolean isComponentNode() {
        return this.body != null;
    }

    public boolean isVirtualNew() {
        return this.type == null;
    }

    public boolean hasSquareBrackets() {
        return this.dims >= 0;
    }

    public int getDimensionCount() {
        return Math.max(this.dims, 0);
    }

    @Override
    public boolean isAutoNarrowingAllowed(TypeExpression type) {
        return type != this.type;
    }

    @Override
    public long getStartPosition() {
        return this.left == null ? this.operator.getStartPosition() : this.left.getStartPosition();
    }

    @Override
    public long getEndPosition() {
        return this.lEndPos;
    }

    @Override
    protected Field[] getChildFields() {
        return CHILD_FIELDS;
    }

    @Override
    public AstNode clone() {
        NewExpression that = (NewExpression)super.clone();
        if (this.body != null) {
            that.body = this.anon == null ? (StatementBlock)this.body.clone() : that.anon.body;
        }
        return that;
    }

    @Override
    protected void discard(boolean fRecurse) {
        super.discard(fRecurse);
        if (fRecurse && this.body != null) {
            this.body.discard(fRecurse);
        }
    }

    @Override
    protected RuntimeException notCodeContainer() {
        throw new IllegalStateException("invalid return from an anonymous inner class: " + String.valueOf(this));
    }

    public AnonInnerClassContext getCaptureContext() {
        return this.m_ctxCapture;
    }

    @Override
    public TypeConstant getImplicitType(Context ctx) {
        return this.calculateTargetType(ctx, null);
    }

    private TypeConstant calculateTargetType(Context ctx, ErrorListener errs) {
        if (this.isValidated()) {
            return this.getType();
        }
        if (errs == null) {
            errs = ErrorListener.BLACKHOLE;
        }
        TypeConstant typeTarget = null;
        if (this.body == null) {
            if (this.isVirtualNew()) {
                typeTarget = (this.left == null ? ctx.getThisType() : this.left.getImplicitType(ctx)).removeImmutable();
            } else if (this.left == null) {
                typeTarget = this.type.ensureTypeConstant(ctx, errs);
            } else {
                TypeExpression typeExpression;
                TypeConstant typeLeft = this.left.getImplicitType(ctx).removeImmutable();
                if (typeLeft != null && (typeExpression = this.type) instanceof NamedTypeExpression) {
                    NamedTypeExpression exprNameType = (NamedTypeExpression)typeExpression;
                    typeTarget = typeLeft.ensureTypeInfo(errs).calculateChildType(this.pool(), exprNameType.getName());
                }
            }
        } else if (this.anon == null) {
            this.ensureInnerClass(ctx, AnonPurpose.RoughDraft, errs);
            typeTarget = this.type.ensureTypeConstant(ctx, errs);
        } else {
            assert (this.anon != null && this.anon.getComponent() != null);
            return ((ClassStructure)this.anon.getComponent()).getFormalType();
        }
        if (typeTarget != null && typeTarget.containsUnresolved()) {
            this.log(errs, Severity.ERROR, "COMPILER-38", this.type.toString());
            return null;
        }
        return typeTarget;
    }

    @Override
    public Expression.TypeFit testFit(Context ctx, TypeConstant typeRequired, boolean fExhaustive, ErrorListener errs) {
        return this.calcFit(ctx, this.calculateTargetType(ctx, errs), typeRequired);
    }

    @Override
    protected Expression.TypeFit calcFit(Context ctx, TypeConstant typeIn, TypeConstant typeOut) {
        TypeConstant typeInferred;
        if (typeIn != null && typeOut != null && (typeInferred = this.inferTypeFromRequired(typeIn, typeOut)) != null) {
            typeIn = typeInferred;
        }
        return super.calcFit(ctx, typeIn, typeOut);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected Expression validate(Context ctx, TypeConstant typeRequired, ErrorListener errs) {
        TypeConstant typeInferred;
        ClassStructure clz;
        TypeInfo infoTarget;
        Plan plan;
        ErrorListener errsTemp;
        boolean fVirtual;
        boolean fAnonymous;
        TypeConstant typeResult;
        TypeConstant typeTarget;
        TypeConstant typeSuper;
        ConstantPool pool;
        block79: {
            block81: {
                block82: {
                    pool = this.pool();
                    typeSuper = null;
                    typeTarget = null;
                    typeResult = null;
                    fAnonymous = this.body != null;
                    fVirtual = this.isVirtualNew();
                    if (fAnonymous) {
                        errsTemp = errs.branch(this);
                        this.ensureInnerClass(ctx, AnonPurpose.RoughDraft, errsTemp);
                        if (errsTemp.hasSeriousErrors()) {
                            errsTemp.merge();
                            return null;
                        }
                    }
                    if (this.left != null) break block81;
                    typeTarget = ctx.getThisType();
                    if (!fVirtual) break block82;
                    typeResult = typeTarget.removeImmutable();
                    plan = Plan.Virtual;
                    break block79;
                }
                typeResult = this.type.ensureTypeConstant(ctx, errs);
                if (typeResult.containsUnresolved()) {
                    if ((typeResult = this.checkDynamicAnnotation(typeResult)) == null) {
                        this.log(errs, Severity.ERROR, "COMPILER-38", this.type.toString());
                        return null;
                    }
                    plan = Plan.Regular;
                    break block79;
                } else if (typeResult.isFormalType()) {
                    if (typeResult.isGenericType()) {
                        this.m_idFormal = (PropertyConstant)typeResult.getDefiningConstant();
                    } else if (typeResult.isTypeParameter()) {
                        TypeExpression typeExpression = this.type;
                        if (!(typeExpression instanceof NamedTypeExpression)) {
                            this.log(errs, Severity.ERROR, "COMPILER-169", typeResult.getValueString());
                            return null;
                        }
                        NamedTypeExpression exprNamed = (NamedTypeExpression)typeExpression;
                        this.m_regFormal = (Register)ctx.getVar(exprNamed.getName());
                        assert (this.m_regFormal != null);
                    } else {
                        if (!typeResult.isDynamicType()) {
                            this.log(errs, Severity.ERROR, "COMPILER-169", typeResult.getValueString());
                            return null;
                        }
                        this.m_regFormal = ((DynamicFormalConstant)typeResult.getDefiningConstant()).getRegister();
                    }
                    plan = Plan.Formal;
                    break block79;
                } else {
                    plan = Plan.Regular;
                }
                break block79;
            }
            assert (this.body == null);
            Expression exprLeftOld = this.left;
            Expression exprLeftNew = exprLeftOld.validate(ctx, null, errs);
            if (exprLeftNew == null) {
                return null;
            }
            this.left = exprLeftNew;
            TypeConstant typeLeft = exprLeftNew.getType();
            if (fVirtual) {
                if (typeLeft.isFormalTypeType()) {
                    this.log(errs, Severity.ERROR, "COMPILER-183", this.left.toString());
                    return null;
                }
                typeResult = typeTarget = typeLeft.removeImmutable();
                plan = Plan.Virtual;
            } else {
                TypeExpression exprType = this.type;
                while (exprType instanceof AnnotatedTypeExpression) {
                    exprType = exprType.unwrapIntroductoryType();
                }
                NamedTypeExpression exprNameType = (NamedTypeExpression)exprType;
                if (exprNameType.isVirtualChild()) {
                    String sChild = exprNameType.getName();
                    TypeInfo infoLeft = typeLeft.ensureTypeInfo(errs);
                    typeResult = infoLeft.calculateChildType(pool, sChild);
                    if (typeResult != null) {
                        exprNameType.setTypeConstant(typeResult);
                    }
                    plan = Plan.Child;
                } else {
                    plan = Plan.Regular;
                }
                if (typeResult == null) {
                    TypeExpression exprTest = (TypeExpression)this.type.clone();
                    Annotation[] ctxTest = ctx.enter();
                    int fValid = 1;
                    if (exprTest.validate((Context)ctxTest, pool.typeType(), errs) == null) {
                        fValid = 0;
                    } else {
                        typeResult = exprTest.ensureTypeConstant(ctx, errs);
                        if (typeResult.containsUnresolved() && (typeResult = this.checkDynamicAnnotation(typeResult)) == null) {
                            this.log(errs, Severity.ERROR, "COMPILER-38", exprTest.toString());
                            fValid = 0;
                        }
                    }
                    ctx.exit();
                    exprTest.discard(true);
                    if (fValid == 0) {
                        return null;
                    }
                }
                if (!(typeResult == null || typeResult.isVirtualChild() && typeLeft.isA(typeResult.getParentType()))) {
                    this.log(errs, Severity.ERROR, "COMPILER-175", typeResult.getValueString(), typeLeft.getValueString());
                    return null;
                }
            }
        }
        if (!fVirtual) {
            Annotation[] annos;
            TypeExpression exprTypeOld;
            TypeExpression exprTypeNew;
            TypeConstant typeInferred2;
            if (typeRequired != null && (typeInferred2 = this.inferTypeFromRequired(typeResult, typeRequired)) != null) {
                if (typeInferred2.containsFormalType(true)) {
                    typeInferred2 = ctx.resolveFormalType(typeInferred2);
                }
                typeResult = typeInferred2;
                this.type.setTypeConstant(typeResult);
                if (typeInferred2.containsFormalType(true)) {
                    ctx.useFormalType(typeInferred2, errs);
                }
            }
            if ((exprTypeNew = (TypeExpression)(exprTypeOld = this.type).validate(ctx, typeResult == null ? null : typeResult.getType(), errs)) == null) {
                return null;
            }
            this.type = exprTypeNew;
            typeResult = exprTypeNew.ensureTypeConstant(ctx, errs);
            if (this.m_fDynamicAnno) {
                typeResult = ((AnnotatedTypeConstant)typeResult).stripParameters();
            }
            if (!(typeResult instanceof AnnotatedTypeConstant)) {
                assert (!typeResult.isAnnotated());
                typeTarget = typeResult;
                annos = null;
            } else {
                AnnotatedTypeConstant typeAnno = (AnnotatedTypeConstant)typeResult;
                ArrayList<Annotation> listClass = new ArrayList<Annotation>();
                ArrayList<Annotation> listMixin = new ArrayList<Annotation>();
                typeTarget = typeAnno.extractAnnotation(listClass, listMixin, errs);
                if (typeTarget == null) {
                    return null;
                }
                assert (listClass.isEmpty() && !listMixin.isEmpty());
                for (Annotation anno : annos = listMixin.toArray(Annotation.NO_ANNOTATIONS)) {
                    TypeConstant typeA = anno.getAnnotationType();
                    if (!typeA.isVirtualChild()) continue;
                    if (!typeTarget.isVirtualChild()) {
                        this.log(errs, Severity.ERROR, "COMPILER-203", typeA.getValueString());
                        return null;
                    }
                    if (typeTarget.getParentType().isA(typeA.getParentType())) continue;
                    this.log(errs, Severity.ERROR, "COMPILER-175", typeA.getValueString(), typeTarget.getParentType().getValueString());
                    return null;
                }
            }
            if (this.left == null) {
                boolean fNestMate = typeTarget.isNestMateOf(ctx.getThisClassId());
                if (fAnonymous) {
                    errsTemp = errs.branch(this);
                    this.ensureInnerClass(ctx, AnonPurpose.Actual, (ErrorListener)errsTemp);
                    errsTemp.merge();
                    if (errsTemp.hasSeriousErrors()) {
                        return null;
                    }
                    typeSuper = pool.ensureAccessTypeConstant(typeTarget, fNestMate ? Constants.Access.PRIVATE : Constants.Access.PROTECTED);
                    ClassStructure clzAnon = (ClassStructure)this.anon.getComponent();
                    typeResult = clzAnon.getIdentityConstant().getType();
                    if (!ctx.isFunction()) {
                        typeResult = typeResult.adoptParameters(pool, clzAnon.getFormalType());
                        typeResult = typeResult.resolveGenerics(pool, typeTarget);
                        if (!clzAnon.isStatic()) {
                            plan = Plan.Child;
                        }
                    }
                    typeTarget = pool.ensureAccessTypeConstant(typeResult, Constants.Access.PRIVATE);
                    if (annos != null) {
                        typeResult = pool.ensureAnnotatedTypeConstant(typeResult, annos);
                    }
                } else {
                    errsTemp = this.type;
                    if (errsTemp instanceof ArrayTypeExpression) {
                        ArrayTypeExpression exprArray = (ArrayTypeExpression)errsTemp;
                        int cDims = exprArray.getDimensions();
                        switch (cDims) {
                            case 0: {
                                break;
                            }
                            case 1: {
                                TypeConstant typeElement;
                                int cArgs = this.args.size();
                                if (cArgs == 1 && (typeElement = typeTarget.getParamType(0)).getDefaultValue() == null) {
                                    this.log(errs, Severity.ERROR, "COMPILER-123", typeElement.getValueString());
                                    return null;
                                }
                                this.m_fFixedSizeArray = true;
                                break;
                            }
                            default: {
                                this.log(errs, Severity.ERROR, "COMPILER-NI", "Multi-dimensional array");
                                return null;
                            }
                        }
                    } else if (typeTarget.isVirtualChild() || typeTarget.isInnerChildClass()) {
                        ClassStructure clzTarget = (ClassStructure)typeTarget.getSingleUnderlyingClass(false).getComponent();
                        plan = Plan.Child;
                        int nSteps = ctx.getStepsToOuterClass(clzTarget.getOuter());
                        if (nSteps < 0) {
                            this.log(errs, Severity.ERROR, "COMPILER-203", typeTarget.getValueString());
                            return null;
                        }
                        if (nSteps == 0 && ctx.isConstructor()) {
                            this.log(errs, Severity.ERROR, "COMPILER-149", clzTarget.getSimpleName());
                            return null;
                        }
                        ctx.requireThis(this.getStartPosition(), errs);
                        this.m_nParentSteps = nSteps;
                    }
                }
            }
        }
        errsTemp = errs.branch(this);
        TypeInfo typeInfo = infoTarget = fAnonymous ? typeTarget.ensureTypeInfo(errsTemp) : this.getTypeInfo(ctx, typeTarget, errsTemp);
        if (errsTemp.hasSeriousErrors()) {
            errsTemp.merge();
            return null;
        }
        if (!(plan != Plan.Regular && plan != Plan.Child || infoTarget.isNewable(false, errsTemp))) {
            String sTarget = infoTarget.getType().removeAccess().getValueString();
            infoTarget.reportNotNewable(sTarget, null, false, errsTemp);
            errsTemp.merge();
            return null;
        }
        List<Expression> listArgs = this.args;
        MethodConstant idConstruct = this.findMethod(ctx, typeTarget, infoTarget, "construct", listArgs, TypeInfo.MethodKind.Constructor, true, false, null, errsTemp);
        MethodStructure constructor = null;
        if (fAnonymous) {
            if (idConstruct == null && !listArgs.isEmpty()) {
                TypeInfo infoSuper = typeSuper.ensureTypeInfo(errs);
                MethodConstant idSuper = this.findMethod(ctx, typeSuper, infoSuper, "construct", listArgs, TypeInfo.MethodKind.Constructor, true, false, null, errs);
                if (idSuper == null) {
                    return null;
                }
                this.destroyDefaultConstructor();
                MethodInfo methodInfo = infoSuper.getMethodById(idSuper);
                MethodStructure methodSuper = methodInfo.getHead().getMethodStructure();
                constructor = this.createPassThroughConstructor(methodSuper);
                idConstruct = infoSuper.resolveMethodConstant(methodInfo);
                infoTarget = infoSuper;
                typeTarget.invalidateTypeInfo();
            } else {
                errsTemp.merge();
            }
        } else if (idConstruct == null) {
            TypeConstant[] atypeArgs = this.validateExpressions(ctx, listArgs, null, errs);
            if (atypeArgs == null) {
                errsTemp.merge();
            } else {
                idConstruct = this.findMethod(ctx, typeTarget, infoTarget, "construct", listArgs, TypeInfo.MethodKind.Constructor, true, false, null, errs);
            }
        }
        if (idConstruct == null) {
            return null;
        }
        if (constructor == null && (constructor = (MethodStructure)idConstruct.getComponent()) == null) {
            constructor = infoTarget.getMethodById(idConstruct).getTopmostMethodStructure(infoTarget);
            assert (constructor != null);
        }
        this.m_constructor = constructor;
        if (this.containsNamedArgs(listArgs)) {
            if ((listArgs = this.rearrangeNamedArgs(constructor, listArgs, errs)) == null) {
                return null;
            }
            this.args = listArgs;
        }
        if (this.validateExpressions(ctx, listArgs, idConstruct.getRawParams(), errs) == null) {
            return null;
        }
        if (!typeResult.isParamsSpecified() && (clz = (ClassStructure)constructor.getParent().getParent()).isParameterized() && (typeInferred = this.inferTypeFromConstructor(ctx, clz, constructor, listArgs)) != null) {
            typeResult = typeInferred;
        }
        if (fAnonymous) {
            this.ensureInnerClass(ctx, AnonPurpose.CaptureAnalysis, ErrorListener.BLACKHOLE);
            AnonInnerClassContext ctxAnon = this.m_ctxCapture;
            boolean fValid = new StageMgr(this.anon, Compiler.Stage.Emitted, errs).fastForward(20);
            ctxAnon.exit();
            this.destroyTempInnerClass();
            if (!fValid) {
                return null;
            }
            this.m_mapCapture = ctxAnon.getCaptureMap();
            this.m_mapRegisters = ctxAnon.ensureRegisterMap();
            this.m_fInstanceChild = ctxAnon.isInstanceChild();
            this.m_ctxCapture = null;
            ClassStructure clzAnon = ctxAnon.getThisClass();
            for (String sName : this.m_mapCapture.keySet()) {
                if (clzAnon.getChild(sName) == null) continue;
                this.log(errs, Severity.ERROR, "COMPILER-31", sName);
                return null;
            }
        }
        this.m_plan = plan;
        Expression exprResult = this.finishValidation(ctx, typeRequired, typeResult, Expression.TypeFit.Fit, null, errs);
        this.clearAnonTypeInfos();
        return exprResult;
    }

    @Override
    public boolean isStandalone() {
        return true;
    }

    @Override
    public boolean isCompletable() {
        for (Expression expr : this.args) {
            if (expr.isCompletable()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isShortCircuiting() {
        for (Expression expr : this.args) {
            if (!expr.isShortCircuiting()) continue;
            return true;
        }
        return false;
    }

    @Override
    protected Expression.SideEffect mightAffect(Expression exprLeft, Argument arg) {
        switch (super.mightAffect(exprLeft, arg)) {
            case DefNo: {
                return Expression.SideEffect.DefNo;
            }
            case AnyCompute: {
                return Expression.SideEffect.DefYes;
            }
            case Unknown: {
                Expression.SideEffect effect = Expression.SideEffect.DefNo;
                for (Expression expr : this.args) {
                    switch (expr.mightAffect(exprLeft, arg)) {
                        case DefNo: 
                        case Unknown: {
                            break;
                        }
                        case AnyCompute: {
                            throw new IllegalStateException();
                        }
                        case DefYes: {
                            return Expression.SideEffect.DefYes;
                        }
                    }
                }
                return effect;
            }
        }
        throw new IllegalStateException();
    }

    @Override
    public void generateAssignment(Context ctx, MethodStructure.Code code, Expression.Assignable LVal, ErrorListener errs) {
        if (LVal.isLocalArgument()) {
            List<Expression> listArgs = this.args;
            int cArgs = listArgs.size();
            Argument[] aArgs = new Argument[cArgs];
            ExprAST[] aAstArgs = new ExprAST[cArgs];
            for (int i = 0; i < cArgs; ++i) {
                Expression expr = listArgs.get(i);
                Argument arg = expr.generateArgument(ctx, code, false, true, errs);
                aArgs[i] = expr.ensurePointInTime(code, arg, listArgs, i);
                aAstArgs[i] = expr.getExprAST(ctx);
            }
            if (this.anon != null) {
                aArgs = this.addCaptures(code, aArgs);
            }
            this.generateNew(ctx, code, aArgs, LVal.getLocalArgument(), aAstArgs, errs);
        } else {
            super.generateAssignment(ctx, code, LVal, errs);
        }
    }

    @Override
    public ExprAST getExprAST(Context ctx) {
        return this.m_astNew == null ? super.getExprAST(ctx) : this.m_astNew;
    }

    private TypeConstant checkDynamicAnnotation(TypeConstant typeUnresolved) {
        AnnotatedTypeConstant typeAnno;
        AnnotatedTypeConstant typeResolved;
        if (typeUnresolved instanceof AnnotatedTypeConstant && !((Constant)(typeResolved = (typeAnno = (AnnotatedTypeConstant)typeUnresolved).stripParameters())).containsUnresolved()) {
            this.m_fDynamicAnno = true;
            return typeResolved;
        }
        return null;
    }

    private void generateNew(Context ctx, MethodStructure.Code code, Argument[] aArgs, Argument argResult, ExprAST[] aAstArgs, ErrorListener errs) {
        TypeConstant typeTarget;
        assert (this.m_constructor.getTypeParamCount() == 0);
        if (this.m_fDynamicAnno) {
            AnnotatedTypeConstant typeAnno = (AnnotatedTypeConstant)this.type.ensureTypeConstant(ctx, errs);
            typeTarget = this.generateDynamicParameters(ctx, code, typeAnno, errs);
        } else {
            typeTarget = this.getType();
        }
        MethodConstant idConstruct = this.m_constructor.getIdentityConstant();
        int cParams = this.m_constructor.getParamCount();
        int cArgs = aArgs.length;
        int cDefaults = cParams - cArgs;
        if (this.m_fTupleArg) {
            throw this.notImplemented();
        }
        if (cDefaults > 0) {
            Argument[] aArgAll = new Argument[cParams];
            System.arraycopy(aArgs, 0, aArgAll, 0, cArgs);
            aArgs = aArgAll;
            for (int i = 0; i < cDefaults; ++i) {
                aArgs[cArgs + i] = Register.DEFAULT;
            }
        }
        Argument argOuter = null;
        ExprAST astOuter = null;
        if (this.m_plan == Plan.Child) {
            if (this.left == null) {
                if (this.m_nParentSteps == 0) {
                    argOuter = ctx.getThisRegister();
                    astOuter = ctx.getThisRegisterAST();
                } else {
                    TypeConstant typeParent = typeTarget.getParentType();
                    int cSteps = this.m_nParentSteps;
                    argOuter = new Register(typeParent, null, -1);
                    code.add(new MoveThis(cSteps, argOuter));
                    astOuter = new OuterExprAST(ctx.getThisRegisterAST(), cSteps, typeParent);
                }
            } else {
                argOuter = this.left.generateArgument(ctx, code, true, true, errs);
                astOuter = this.left.getExprAST(ctx);
            }
        }
        if (this.m_plan == Plan.Virtual || this.m_plan == Plan.Formal) {
            Register regType;
            if (this.m_plan == Plan.Virtual) {
                ExprAST astTarget;
                Argument argTarget;
                if (this.left == null) {
                    argTarget = new Register(ctx.getThisType(), null, -6);
                    astTarget = new ConstantExprAST(argTarget.getType());
                } else {
                    argTarget = this.left.generateArgument(ctx, code, true, true, errs);
                    astTarget = this.left.getExprAST(ctx);
                }
                regType = new Register(this.pool().typeType(), null, -1);
                code.add(new MoveType(argTarget, regType));
                this.m_astNew = new NewExprAST(astTarget, (Constant)idConstruct, aAstArgs);
            } else {
                if (typeTarget.isGenericType()) {
                    regType = new Register(this.pool().typeType(), null, -1);
                    code.add(new L_Get(this.m_idFormal, regType));
                } else {
                    regType = this.m_regFormal;
                }
                this.m_astNew = new NewExprAST(typeTarget, (Constant)idConstruct, aAstArgs);
            }
            switch (cParams) {
                case 0: {
                    code.add(new NewV_0(idConstruct, regType, argResult));
                    break;
                }
                case 1: {
                    code.add(new NewV_1(idConstruct, regType, aArgs[0], argResult));
                    break;
                }
                default: {
                    code.add(new NewV_N(idConstruct, regType, aArgs, argResult));
                    break;
                }
            }
        } else if (NewExpression.isTypeRequired(typeTarget)) {
            if (argOuter == null) {
                switch (cParams) {
                    case 0: {
                        code.add(new NewG_0(idConstruct, typeTarget, argResult));
                        break;
                    }
                    case 1: {
                        if (this.m_fFixedSizeArray) {
                            Argument[] aArg2 = new Argument[]{aArgs[0], Register.DEFAULT};
                            idConstruct = ((ArrayTypeExpression)this.type).getSupplyConstructor();
                            code.add(new NewG_N(idConstruct, typeTarget, aArg2, argResult));
                            aAstArgs = new ExprAST[]{aAstArgs[0], Register.DEFAULT.getRegisterAST()};
                            break;
                        }
                        code.add(new NewG_1(idConstruct, typeTarget, aArgs[0], argResult));
                        break;
                    }
                    default: {
                        code.add(new NewG_N(idConstruct, typeTarget, aArgs, argResult));
                    }
                }
                this.m_astNew = new NewExprAST(typeTarget, (Constant)idConstruct, aAstArgs);
            } else {
                switch (cParams) {
                    case 0: {
                        code.add(new NewCG_0(idConstruct, argOuter, typeTarget, argResult));
                        break;
                    }
                    case 1: {
                        code.add(new NewCG_1(idConstruct, argOuter, typeTarget, aArgs[0], argResult));
                        break;
                    }
                    default: {
                        code.add(new NewCG_N(idConstruct, argOuter, typeTarget, aArgs, argResult));
                    }
                }
                this.m_astNew = new NewExprAST(astOuter, typeTarget, idConstruct, aAstArgs);
            }
        } else if (argOuter == null) {
            switch (cParams) {
                case 0: {
                    code.add(new New_0(idConstruct, argResult));
                    break;
                }
                case 1: {
                    code.add(new New_1(idConstruct, aArgs[0], argResult));
                    break;
                }
                default: {
                    code.add(new New_N(idConstruct, aArgs, argResult));
                }
            }
            this.m_astNew = new NewExprAST(typeTarget, (Constant)idConstruct, aAstArgs);
        } else {
            switch (cParams) {
                case 0: {
                    code.add(new NewC_0(idConstruct, argOuter, argResult));
                    break;
                }
                case 1: {
                    code.add(new NewC_1(idConstruct, argOuter, aArgs[0], argResult));
                    break;
                }
                default: {
                    code.add(new NewC_N(idConstruct, argOuter, aArgs, argResult));
                }
            }
            this.m_astNew = new NewExprAST(astOuter, typeTarget, idConstruct, aAstArgs);
        }
    }

    private TypeConstant generateDynamicParameters(Context ctx, MethodStructure.Code code, AnnotatedTypeConstant typeAnno, ErrorListener errs) {
        ConstantPool pool = this.pool();
        TypeConstant typeUnderlying = typeAnno.getUnderlyingType();
        if (typeUnderlying instanceof AnnotatedTypeConstant) {
            AnnotatedTypeConstant typeUnder = (AnnotatedTypeConstant)typeUnderlying;
            typeUnderlying = this.generateDynamicParameters(ctx, code, typeUnder, errs);
        }
        Constant[] aConst = typeAnno.getAnnotationParams();
        boolean fDiff = false;
        int c = aConst.length;
        for (int j = 0; j < c; ++j) {
            Register regArg;
            Constant constArg = aConst[j];
            if (!(constArg instanceof ExpressionConstant)) continue;
            ExpressionConstant constExpr = (ExpressionConstant)constArg;
            Expression exprArg = constExpr.getExpression();
            Argument argArg = exprArg.generateArgument(ctx, code, true, false, errs);
            if (argArg instanceof Register) {
                Register regA;
                regArg = regA = (Register)argArg;
            } else {
                regArg = code.createRegister(exprArg.getType());
                code.add(new Var(regArg));
                code.add(new Move(argArg, regArg));
            }
            aConst[j] = new RegisterConstant(pool, regArg);
            fDiff = true;
        }
        return fDiff ? pool.ensureAnnotatedTypeConstant(typeAnno.getAnnotationClass(), aConst, typeUnderlying) : typeAnno;
    }

    private void ensureInnerClass(Context ctx, AnonPurpose purpose, ErrorListener errs) {
        String sName;
        assert (this.body != null);
        if (this.m_purposeCurrent == purpose) {
            return;
        }
        this.destroyTempInnerClass();
        if (this.m_purposeCurrent == purpose) {
            return;
        }
        if (this.m_purposeCurrent == AnonPurpose.Actual) {
            assert (this.anon != null);
            assert (this.anon.getComponent() != null);
            this.m_anonActualBackup = this.anon;
            this.m_clzActualBackup = (ClassStructure)this.anon.getComponent();
        }
        AnonInnerClass inner = this.type.inferAnonInnerClass(errs);
        Component parent = this.getComponent();
        String sDefault = inner.getDefaultName();
        int nSuffix = 1;
        while (parent.getChild(sName = sDefault + ":" + nSuffix) != null) {
            ++nSuffix;
        }
        Token tokName = new Token(this.type.getStartPosition(), this.type.getEndPosition(), Token.Id.IDENTIFIER, sName);
        switch (purpose.ordinal()) {
            case 1: {
                assert (this.m_purposeCurrent == AnonPurpose.None);
                this.anon = this.adopt(new TypeCompositionStatement(this, this.clone(inner.getAnnotations()), inner.getCategory(), tokName, null, this.clone(inner.getCompositions()), this.clone(this.args), (StatementBlock)this.body.clone(), this.type.getStartPosition(), this.body.getEndPosition()));
                break;
            }
            case 3: {
                this.anon = this.adopt(new TypeCompositionStatement(this, inner.getAnnotations(), inner.getCategory(), tokName, null, inner.getCompositions(), this.args, this.body, this.type.getStartPosition(), this.body.getEndPosition()));
                break;
            }
            case 2: {
                assert (this.m_purposeCurrent == AnonPurpose.Actual);
                this.anon = (TypeCompositionStatement)this.adopt(this.anon.clone());
                this.anon.setComponent(this.m_clzActualBackup.replaceWithTemporary());
            }
        }
        this.m_ctxCapture = new AnonInnerClassContext(ctx);
        this.catchUpChildren(errs);
        if (purpose != AnonPurpose.CaptureAnalysis) {
            this.m_ctxCapture = null;
        }
        this.m_purposeCurrent = purpose;
    }

    private void destroyTempInnerClass() {
        if (this.anon != null && this.m_purposeCurrent != AnonPurpose.Actual) {
            ClassStructure clzTemp = (ClassStructure)this.anon.getComponent();
            if (clzTemp != null) {
                Component componentParent = clzTemp.getParent();
                assert (componentParent == this.getComponent());
                ClassStructure clzActual = this.m_clzActualBackup;
                if (clzActual == null) {
                    componentParent.removeChild(clzTemp);
                } else {
                    clzTemp.replaceTemporaryWith(clzActual);
                }
            }
            this.anon.discard(true);
            this.anon = null;
            this.m_purposeCurrent = AnonPurpose.None;
            if (this.m_anonActualBackup != null) {
                this.anon = this.m_anonActualBackup;
                this.m_anonActualBackup = null;
                this.m_clzActualBackup = null;
                this.m_purposeCurrent = AnonPurpose.Actual;
            }
        }
    }

    private void destroyDefaultConstructor() {
        ClassStructure clz = (ClassStructure)this.anon.getComponent();
        MethodConstant id = this.pool().ensureMethodConstant(clz.getIdentityConstant(), "construct", TypeConstant.NO_TYPES, TypeConstant.NO_TYPES);
        MethodStructure constrDefault = (MethodStructure)id.getComponent();
        if (constrDefault != null) {
            clz.getChild("construct").removeChild(constrDefault);
        }
    }

    private <T extends AstNode> List<T> clone(List<? extends AstNode> list) {
        if (list == null || list.isEmpty()) {
            return list;
        }
        ArrayList<AstNode> listCopy = new ArrayList<AstNode>(list.size());
        for (AstNode astNode : list) {
            listCopy.add(astNode.clone());
        }
        return listCopy;
    }

    private MethodStructure createPassThroughConstructor(MethodStructure methodSuper) {
        Parameter[] aParams = methodSuper.getParamArray();
        int cParams = aParams.length;
        MethodConstant idSuper = methodSuper.getIdentityConstant();
        ClassStructure clzAnon = (ClassStructure)this.anon.getComponent();
        MethodStructure constrThis = clzAnon.createMethod(true, Constants.Access.PUBLIC, null, Parameter.NO_PARAMS, "construct", aParams, true, false);
        constrThis.setSynthetic(true);
        MethodStructure.Code code = constrThis.createCode();
        ArrayList<BinaryAST> listAsts = new ArrayList<BinaryAST>();
        assert (constrThis.isAnonymousClassWrapperConstructor());
        if (!methodSuper.isAnonymousClassWrapperConstructor()) {
            code.add(new SynInit());
            listAsts.add(InitAST.INSTANCE);
        }
        ExprAST[] aAstArgs = new RegisterAST[cParams];
        if (cParams == 1) {
            Register regParam = new Register(aParams[0].getType(), null, 0);
            code.add(new Construct_1(idSuper, regParam));
            aAstArgs[0] = (RegisterAST)regParam.getRegisterAST();
        } else {
            assert (cParams > 1);
            Argument[] aArgs = new Register[cParams];
            for (int i = 0; i < cParams; ++i) {
                Register regParam = new Register(aParams[i].getType(), null, i);
                aArgs[i] = regParam;
                aAstArgs[i] = (RegisterAST)regParam.getRegisterAST();
            }
            code.add(new Construct_N(idSuper, aArgs));
        }
        code.add(new Return_0());
        listAsts.add(new CallExprAST(new ConstantExprAST(idSuper), TypeConstant.NO_TYPES, aAstArgs, false));
        constrThis.setAst(new StmtBlockAST(listAsts.toArray(BinaryAST.NO_ASTS), false), (RegisterAST[])aAstArgs);
        return constrThis;
    }

    private Argument[] addCaptures(MethodStructure.Code code, Argument[] aOldArgs) {
        this.clearAnonTypeInfos();
        this.anon.getComponent().setStatic(!this.m_fInstanceChild);
        Map<String, Boolean> mapCapture = this.m_mapCapture;
        Map<String, Register> mapRegisters = this.m_mapRegisters;
        if (mapCapture == null || mapCapture.isEmpty()) {
            return aOldArgs;
        }
        ConstantPool pool = this.pool();
        Parameter[] aOldParams = this.m_constructor.getParamArray();
        int cOldParams = aOldParams.length;
        int cCaptures = mapCapture.size();
        int cNewParams = cOldParams + cCaptures;
        Parameter[] aNewParams = new Parameter[cNewParams];
        int iNewParam = cOldParams;
        Argument[] aNewArgs = new Argument[cNewParams];
        assert (cOldParams == aOldArgs.length);
        System.arraycopy(aOldParams, 0, aNewParams, 0, cOldParams);
        System.arraycopy(aOldArgs, 0, aNewArgs, 0, cOldParams);
        for (Map.Entry<String, Boolean> entry : mapCapture.entrySet()) {
            String sName = entry.getKey();
            Register reg = mapRegisters.get(sName);
            Boolean FVar = entry.getValue();
            TypeConstant type = reg.getType();
            Register arg = reg;
            if (FVar.booleanValue()) {
                type = pool.ensureParameterizedTypeConstant(pool.typeVar(), type);
                arg = new Register(type, null, -1);
                code.add(new MoveVar(reg, (Argument)arg));
            } else if (!reg.isEffectivelyFinal()) {
                type = pool.ensureParameterizedTypeConstant(pool.typeRef(), type);
                arg = new Register(type, null, -1);
                code.add(new MoveRef(reg, (Argument)arg));
            }
            aNewParams[iNewParam] = new Parameter(pool, type, sName, null, false, iNewParam, false);
            aNewArgs[iNewParam] = arg;
            ++iNewParam;
        }
        ClassStructure clzAnon = (ClassStructure)this.anon.getComponent();
        MethodStructure constrOld = this.m_constructor;
        MethodStructure constrNew = clzAnon.createMethod(true, Constants.Access.PUBLIC, null, Parameter.NO_PARAMS, "construct", aNewParams, true, false);
        constrNew.setSynthetic(true);
        MethodStructure.Code codeConstr = constrNew.createCode();
        ArrayList<BinaryAST> listAsts = new ArrayList<BinaryAST>();
        Argument[] aRegs = new Register[cNewParams];
        for (int i = 0; i < cOldParams; ++i) {
            Parameter param = aOldParams[i];
            aRegs[i] = new Register(param.getType(), param.getName(), i);
        }
        if (cCaptures > 0) {
            RegisterAST astThis = new RegisterAST(-10, pool.ensureAccessTypeConstant(clzAnon.getFormalType(), Constants.Access.STRUCT), null);
            for (int iCapture = 0; iCapture < cCaptures; ++iCapture) {
                iNewParam = cOldParams + iCapture;
                Parameter param = aNewParams[iNewParam];
                String sName = param.getName();
                TypeConstant type = param.getType();
                aRegs[iNewParam] = new Register(type, sName, iNewParam);
                Register reg = aRegs[iNewParam];
                PropertyStructure prop = clzAnon.createProperty(false, Constants.Access.PRIVATE, Constants.Access.PRIVATE, type, sName);
                prop.addAnnotation(pool.clzUnassigned(), new Constant[0]);
                prop.setSynthetic(true);
                PropertyConstant idProp = prop.getIdentityConstant();
                codeConstr.add(new L_Set(idProp, reg));
                listAsts.add(new AssignAST(new PropertyExprAST(astThis, idProp), AssignAST.Operator.Asn, reg.getRegisterAST()));
            }
        }
        if (!constrOld.isAnonymousClassWrapperConstructor()) {
            codeConstr.add(new SynInit());
            listAsts.add(InitAST.INSTANCE);
        }
        ExprAST[] aAstRegNew = new RegisterAST[cNewParams];
        for (int i = 0; i < cNewParams; ++i) {
            aAstRegNew[i] = (RegisterAST)aRegs[i].getRegisterAST();
        }
        MethodConstant idOld = constrOld.getIdentityConstant();
        switch (cOldParams) {
            case 0: {
                codeConstr.add(new Construct_0(idOld));
                break;
            }
            case 1: {
                codeConstr.add(new Construct_1(idOld, aRegs[0]));
                break;
            }
            default: {
                Argument[] aArgs = aRegs;
                if (cCaptures > 0) {
                    aArgs = new Register[cOldParams];
                    System.arraycopy(aRegs, 0, aArgs, 0, cOldParams);
                }
                codeConstr.add(new Construct_N(idOld, aArgs));
            }
        }
        codeConstr.add(new Return_0());
        ExprAST[] aAstRegOld = aAstRegNew;
        if (cCaptures > 0) {
            aAstRegOld = new RegisterAST[cOldParams];
            System.arraycopy(aAstRegNew, 0, aAstRegOld, 0, cOldParams);
        }
        listAsts.add(new CallExprAST(new ConstantExprAST(idOld), TypeConstant.NO_TYPES, aAstRegOld, false));
        constrNew.setAst(new StmtBlockAST(listAsts.toArray(BinaryAST.NO_ASTS), false), (RegisterAST[])aAstRegNew);
        this.m_constructor = constrNew;
        return aNewArgs;
    }

    private void clearAnonTypeInfos() {
        if (this.anon != null) {
            this.getType().invalidateTypeInfo();
        }
    }

    protected boolean isCapture(String sCaptureName) {
        return this.m_mapCapture != null && this.m_mapCapture.containsKey(sCaptureName);
    }

    protected TypeConstant getCaptureType(String sCaptureName) {
        assert (this.m_mapRegisters.containsKey(sCaptureName));
        return this.m_mapRegisters.get(sCaptureName).getType();
    }

    protected boolean isCaptureFinal(String sCaptureName) {
        assert (this.m_mapRegisters.containsKey(sCaptureName));
        return this.m_mapRegisters.get(sCaptureName).isEffectivelyFinal();
    }

    protected boolean isImplicitDeref(String sCaptureName) {
        assert (this.m_mapCapture.containsKey(sCaptureName));
        Register reg = this.m_mapRegisters.get(sCaptureName);
        Boolean FVar = this.m_mapCapture.get(sCaptureName);
        return FVar != false || !reg.isEffectivelyFinal();
    }

    private static boolean isTypeRequired(TypeConstant type) {
        if (type.isParamsSpecified() || type.isAnnotated()) {
            return true;
        }
        if (type.isAnonymousClass()) {
            return NewExpression.isTypeRequired(type.getParentType());
        }
        return false;
    }

    public String toSignatureString() {
        StringBuilder sb = new StringBuilder();
        if (this.left != null) {
            sb.append(this.left).append('.');
        }
        sb.append(this.operator.getId().TEXT);
        if (this.type != null) {
            sb.append(' ').append(this.type);
        }
        if (this.args != null) {
            int i;
            boolean first;
            int iFirst = 0;
            if (this.hasSquareBrackets()) {
                iFirst = this.getDimensionCount();
                sb.append('[');
                first = true;
                for (i = 0; i < iFirst; ++i) {
                    Expression arg = this.args.get(i);
                    if (first) {
                        first = false;
                    } else {
                        sb.append(", ");
                    }
                    sb.append(arg);
                }
                sb.append(']');
            }
            sb.append('(');
            first = true;
            int c = this.args.size();
            for (i = iFirst; i < c; ++i) {
                Expression arg = this.args.get(i);
                if (first) {
                    first = false;
                } else {
                    sb.append(", ");
                }
                sb.append(arg);
            }
            sb.append(')');
        }
        return sb.toString();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.toSignatureString());
        if (this.body != null) {
            sb.append('\n').append(Handy.indentLines(this.body.toString(), "        "));
        }
        return sb.toString();
    }

    @Override
    public String getDumpDesc() {
        String s = this.toSignatureString();
        return this.body == null ? s : s + "{..}";
    }

    private static enum AnonPurpose {
        None,
        RoughDraft,
        CaptureAnalysis,
        Actual;

    }

    public class AnonInnerClassContext
    extends Context.CaptureContext {
        public AnonInnerClassContext(Context ctxOuter) {
            super(ctxOuter);
        }

        @Override
        public TypeConstant getThisType() {
            TypeConstant typeBase = NewExpression.this.type.ensureTypeConstant();
            TypeConstant typeThis = this.getThisClass().getFormalType();
            return typeThis.resolveGenerics(this.pool(), typeBase);
        }

        @Override
        public ClassStructure getThisClass() {
            return (ClassStructure)NewExpression.this.anon.getComponent();
        }

        @Override
        public boolean requireThis(long lPos, ErrorListener errs) {
            if (this.getMethod().isStatic()) {
                if (errs != null) {
                    errs.log(Severity.ERROR, "COMPILER-52", null, this.getSource(), lPos, lPos);
                }
                return false;
            }
            return super.requireThis(lPos, errs);
        }

        public boolean isInstanceChild() {
            return this.isThisCaptured() || !this.getMethod().isStatic() && !this.getMethod().getContainingClass().isSingleton();
        }
    }

    static enum Plan {
        Regular,
        Child,
        Virtual,
        Formal;

    }
}

