/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.compiler.ast;

import java.lang.reflect.Field;
import org.xvm.asm.Argument;
import org.xvm.asm.ErrorListener;
import org.xvm.asm.MethodStructure;
import org.xvm.asm.Register;
import org.xvm.asm.ast.ExprAST;
import org.xvm.asm.ast.RegisterAST;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.compiler.ast.Context;
import org.xvm.compiler.ast.Expression;
import org.xvm.compiler.ast.TypeExpression;

public class NonBindingExpression
extends Expression {
    protected long lStartPos;
    protected long lEndPos;
    protected TypeExpression type;
    private static final Field[] CHILD_FIELDS = NonBindingExpression.fieldsForNames(NonBindingExpression.class, "type");

    public NonBindingExpression(long lStartPos, long lEndPos, TypeExpression type) {
        this.lStartPos = lStartPos;
        this.lEndPos = lEndPos;
        this.type = type;
    }

    public TypeExpression getArgType() {
        return this.type;
    }

    @Override
    public long getStartPosition() {
        return this.lStartPos;
    }

    @Override
    public long getEndPosition() {
        return this.lEndPos;
    }

    @Override
    protected Field[] getChildFields() {
        return CHILD_FIELDS;
    }

    @Override
    public TypeConstant getImplicitType(Context ctx) {
        return this.type == null ? null : this.type.ensureTypeConstant(ctx, null);
    }

    @Override
    public Expression.TypeFit testFit(Context ctx, TypeConstant typeRequired, boolean fExhaustive, ErrorListener errs) {
        return this.type == null || typeRequired == null ? Expression.TypeFit.Fit : this.type.testFit(ctx, typeRequired.getType(), fExhaustive, errs);
    }

    @Override
    protected Expression validate(Context ctx, TypeConstant typeRequired, ErrorListener errs) {
        TypeConstant typeArg;
        TypeExpression exprOldType;
        Expression.TypeFit fit = Expression.TypeFit.Fit;
        if (typeRequired == null) {
            typeRequired = this.pool().typeObject();
        }
        if ((exprOldType = this.type) == null) {
            typeArg = typeRequired;
        } else {
            TypeConstant typeReqType = typeRequired.getType();
            TypeExpression exprNewType = (TypeExpression)exprOldType.validate(ctx, typeReqType, errs);
            if (exprNewType == null) {
                fit = Expression.TypeFit.NoFit;
                typeArg = typeRequired;
            } else {
                this.type = exprNewType;
                typeArg = exprNewType.ensureTypeConstant(ctx, errs).resolveAutoNarrowingBase();
            }
        }
        return this.finishValidation(ctx, typeRequired, typeArg, fit, null, errs);
    }

    @Override
    public boolean isNonBinding() {
        return true;
    }

    @Override
    public Argument generateArgument(Context ctx, MethodStructure.Code code, boolean fLocalPropOk, boolean fUsedOnce, ErrorListener errs) {
        return Register.DEFAULT;
    }

    @Override
    public ExprAST getExprAST(Context ctx) {
        return RegisterAST.defaultReg(this.getType());
    }

    @Override
    protected Expression.SideEffect mightAffect(Expression exprLeft, Argument arg) {
        return Expression.SideEffect.DefNo;
    }

    @Override
    public String toString() {
        return this.type == null ? "?" : "<" + String.valueOf(this.type) + ">?";
    }

    @Override
    public String getDumpDesc() {
        return this.toString();
    }
}

