/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.compiler.ast;

import java.lang.reflect.Field;
import org.xvm.asm.Argument;
import org.xvm.asm.ConstantPool;
import org.xvm.asm.ErrorListener;
import org.xvm.asm.MethodStructure;
import org.xvm.asm.Register;
import org.xvm.asm.ast.ExprAST;
import org.xvm.asm.ast.NotNullExprAST;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.asm.op.JumpFalse;
import org.xvm.asm.op.JumpNull;
import org.xvm.asm.op.Label;
import org.xvm.compiler.Token;
import org.xvm.compiler.ast.AstNode;
import org.xvm.compiler.ast.Context;
import org.xvm.compiler.ast.Expression;
import org.xvm.compiler.ast.NameExpression;
import org.xvm.compiler.ast.NullableTypeExpression;
import org.xvm.compiler.ast.TypeExpression;
import org.xvm.util.Severity;

public class NotNullExpression
extends Expression {
    protected Expression expr;
    protected Token operator;
    private transient boolean m_fCond;
    private transient Label m_labelShort;
    private static final Field[] CHILD_FIELDS = NotNullExpression.fieldsForNames(NotNullExpression.class, "expr");

    public NotNullExpression(Expression expr, Token operator) {
        this.expr = expr;
        this.operator = operator;
    }

    @Override
    public TypeExpression toTypeExpression() {
        if (this.operator.getId() == Token.Id.COND) {
            NullableTypeExpression exprType = new NullableTypeExpression(this.expr.toTypeExpression(), this.getEndPosition());
            exprType.setParent(this.getParent());
            return exprType;
        }
        return super.toTypeExpression();
    }

    @Override
    public long getStartPosition() {
        return this.expr.getStartPosition();
    }

    @Override
    public long getEndPosition() {
        return this.operator.getEndPosition();
    }

    @Override
    protected Field[] getChildFields() {
        return CHILD_FIELDS;
    }

    @Override
    public TypeConstant getImplicitType(Context ctx) {
        TypeConstant[] atype = this.expr.getImplicitTypes(ctx);
        switch (atype.length) {
            case 0: {
                return null;
            }
            case 1: {
                TypeConstant type = atype[0];
                return type.isNullable() ? type.removeNullable() : null;
            }
        }
        TypeConstant type0 = atype[0];
        return type0.isA(this.pool().typeBoolean()) ? atype[1] : (type0.isNullable() ? type0.removeNullable() : null);
    }

    @Override
    public Expression.TypeFit testFit(Context ctx, TypeConstant typeRequired, boolean fExhaustive, ErrorListener errs) {
        if (typeRequired != null) {
            Expression.TypeFit fit;
            if (typeRequired.isTypeOfType() && (fit = this.toTypeExpression().testFit(ctx, typeRequired, fExhaustive, ErrorListener.BLACKHOLE)).isFit()) {
                return fit;
            }
            fit = this.expr.testFitMulti(ctx, new TypeConstant[]{this.pool().typeBoolean(), typeRequired}, fExhaustive, ErrorListener.BLACKHOLE);
            if (fit.isFit()) {
                return fit;
            }
        }
        return super.testFit(ctx, typeRequired, fExhaustive, errs);
    }

    @Override
    protected Expression validate(Context ctx, TypeConstant typeRequired, ErrorListener errs) {
        TypeConstant typeResult;
        Expression exprNew;
        ConstantPool pool = this.pool();
        boolean fCond = false;
        TypeConstant[] atypeCond = new TypeConstant[]{pool.typeBoolean(), pool.typeObject()};
        if (this.expr.testFitMulti(ctx, atypeCond, true, ErrorListener.BLACKHOLE).isFit()) {
            fCond = true;
            this.m_fCond = true;
            if (typeRequired != null) {
                atypeCond[1] = typeRequired;
            }
            exprNew = this.expr.validateMulti(ctx, atypeCond, errs);
        } else {
            Expression exprType;
            if (typeRequired != null && typeRequired.isTypeOfType() && (exprType = this.validateAsType(ctx, typeRequired, errs)) != null) {
                return exprType;
            }
            TypeConstant typeRequest = typeRequired == null ? null : typeRequired.ensureNullable();
            exprNew = this.expr.validate(ctx, typeRequest, errs);
        }
        if (exprNew == null) {
            return null;
        }
        this.expr = exprNew;
        TypeConstant typeConstant = typeResult = fCond ? exprNew.getTypes()[1] : exprNew.getType();
        if (!(fCond || typeResult.isNullable() || this.pool().typeNull().isA(typeResult.resolveConstraints()))) {
            exprNew.log(errs, Severity.ERROR, "COMPILER-71", new Object[0]);
            return null;
        }
        AstNode parent = this.getParent();
        if (!parent.allowsShortCircuit(this)) {
            exprNew.log(errs, Severity.ERROR, "COMPILER-73", new Object[0]);
            return null;
        }
        if (!fCond && exprNew.isConstantNull()) {
            exprNew.log(errs, Severity.ERROR, "COMPILER-130", new Object[0]);
            return null;
        }
        this.m_labelShort = parent.ensureShortCircuitLabel(this, ctx);
        if (!fCond) {
            typeResult = typeResult.removeNullable();
            if (exprNew instanceof NameExpression) {
                Register regCurr;
                TypeConstant typeCurr;
                String sName;
                Argument arg;
                NameExpression exprName = (NameExpression)exprNew;
                if (exprName.left == null && (arg = ctx.getVar(sName = exprName.getName())) instanceof Register && !(typeCurr = (regCurr = (Register)arg).getType()).isA(typeResult)) {
                    assert (typeResult.isA(typeCurr));
                    ctx.narrowLocalRegister(sName, regCurr, Context.Branch.Always, typeResult);
                    this.m_labelShort.addRestore(sName, regCurr);
                }
            }
        }
        return this.finishValidation(ctx, typeRequired, typeResult, Expression.TypeFit.Fit, null, errs);
    }

    @Override
    public boolean isShortCircuiting() {
        return true;
    }

    @Override
    protected Expression.SideEffect mightAffect(Expression exprLeft, Argument arg) {
        return this.expr.mightAffect(exprLeft, arg);
    }

    @Override
    protected boolean allowsConditional(Expression exprChild) {
        return this.m_fCond;
    }

    @Override
    public void resetLValueTypes(Context ctx) {
        this.expr.resetLValueTypes(ctx);
    }

    @Override
    public Argument generateArgument(Context ctx, MethodStructure.Code code, boolean fLocalPropOk, boolean fUsedOnce, ErrorListener errs) {
        TypeConstant typeExpr = this.getType();
        if (this.isConstant() || !this.m_fCond && this.pool().typeNull().isA(typeExpr.resolveConstraints())) {
            return super.generateArgument(ctx, code, fLocalPropOk, fUsedOnce, errs);
        }
        if (this.m_fCond) {
            Expression.Assignable varCond = this.createTempVar(code, this.pool().typeBoolean(), true);
            Expression.Assignable varVal = this.createTempVar(code, this.getType(), false);
            Expression.Assignable[] LVals = new Expression.Assignable[]{varCond, varVal};
            this.expr.generateAssignments(ctx, code, LVals, errs);
            code.add(new JumpFalse(varCond.getRegister(), this.m_labelShort));
            return varVal.getRegister();
        }
        TypeConstant typeTemp = typeExpr.ensureNullable();
        Expression.Assignable var = this.createTempVar(code, typeTemp, false);
        this.generateAssignment(ctx, code, var, errs);
        return var.getRegister().narrowType(typeExpr);
    }

    @Override
    public void generateAssignment(Context ctx, MethodStructure.Code code, Expression.Assignable LVal, ErrorListener errs) {
        if (this.isConstant() || this.m_fCond || !LVal.isLocalArgument() || !this.pool().typeNull().isA(LVal.getType().resolveConstraints())) {
            super.generateAssignment(ctx, code, LVal, errs);
            return;
        }
        Argument arg = this.expr.generateArgument(ctx, code, true, false, errs);
        code.add(new JumpNull(arg, this.m_labelShort));
        LVal.assign(arg, code, errs);
    }

    @Override
    public ExprAST getExprAST(Context ctx) {
        return new NotNullExprAST(this.expr.getExprAST(ctx), this.getType());
    }

    @Override
    public String toString() {
        return String.valueOf(this.expr) + this.operator.getId().TEXT;
    }

    @Override
    public String getDumpDesc() {
        return this.toString();
    }
}

