/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.compiler.ast;

import java.lang.reflect.Field;
import org.xvm.asm.ConstantPool;
import org.xvm.asm.ErrorListener;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.compiler.ast.AnonInnerClass;
import org.xvm.compiler.ast.Context;
import org.xvm.compiler.ast.Expression;
import org.xvm.compiler.ast.TypeExpression;
import org.xvm.util.Severity;

public class NullableTypeExpression
extends TypeExpression {
    protected TypeExpression type;
    protected long lEndPos;
    private static final Field[] CHILD_FIELDS = NullableTypeExpression.fieldsForNames(NullableTypeExpression.class, "type");

    public NullableTypeExpression(TypeExpression type, long lEndPos) {
        this.type = type;
        this.lEndPos = lEndPos;
    }

    @Override
    protected boolean canResolveNames() {
        return super.canResolveNames() || this.type.canResolveNames();
    }

    @Override
    public long getStartPosition() {
        return this.type.getStartPosition();
    }

    @Override
    public long getEndPosition() {
        return this.lEndPos;
    }

    @Override
    protected Field[] getChildFields() {
        return CHILD_FIELDS;
    }

    @Override
    protected TypeConstant instantiateTypeConstant(Context ctx, ErrorListener errs) {
        ConstantPool pool = this.pool();
        return pool.ensureUnionTypeConstant(pool.typeNullable(), this.type.ensureTypeConstant(ctx, errs));
    }

    @Override
    protected void collectAnonInnerClassInfo(AnonInnerClass info) {
        this.log(info.getErrorListener(true), Severity.ERROR, "COMPILER-100", new Object[0]);
    }

    @Override
    protected Expression validate(Context ctx, TypeConstant typeRequired, ErrorListener errs) {
        TypeExpression exprOld = this.type;
        TypeExpression exprNew = (TypeExpression)exprOld.validate(ctx, typeRequired, errs);
        if (exprNew == null) {
            return null;
        }
        this.type = exprNew;
        TypeConstant typeActual = this.pool().ensureNullableTypeConstant(exprNew.ensureTypeConstant(ctx, errs));
        TypeConstant typeType = typeActual.getType();
        return this.finishValidation(ctx, typeRequired, typeType, Expression.TypeFit.Fit, typeType, errs);
    }

    @Override
    public String toString() {
        return String.valueOf(this.type) + "?";
    }

    @Override
    public String getDumpDesc() {
        return this.toString();
    }
}

