/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.compiler.ast;

import org.xvm.asm.Argument;
import org.xvm.asm.ConstantPool;
import org.xvm.asm.ErrorListener;
import org.xvm.asm.MethodStructure;
import org.xvm.asm.Register;
import org.xvm.asm.constants.ArrayConstant;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.asm.op.Var_T;
import org.xvm.compiler.ast.Context;
import org.xvm.compiler.ast.Expression;
import org.xvm.compiler.ast.SyntheticExpression;

public class PackExpression
extends SyntheticExpression {
    public PackExpression(Expression expr, ErrorListener errs) {
        super(expr);
        ConstantPool pool = this.pool();
        TypeConstant type = pool.ensureTupleType(expr.getTypes());
        ArrayConstant val = null;
        if (expr.isConstant()) {
            type = pool.ensureImmutableTypeConstant(type);
            val = pool.ensureTupleConstant(type, expr.toConstants());
        }
        this.finishValidation(null, null, type, expr.getTypeFit().addPack(), val, errs);
    }

    @Override
    public TypeConstant getImplicitType(Context ctx) {
        return this.getType();
    }

    @Override
    protected Expression validate(Context ctx, TypeConstant typeRequired, ErrorListener errs) {
        return this;
    }

    @Override
    public void generateVoid(Context ctx, MethodStructure.Code code, ErrorListener errs) {
        this.expr.generateVoid(ctx, code, errs);
    }

    @Override
    public Argument generateArgument(Context ctx, MethodStructure.Code code, boolean fLocalPropOk, boolean fUsedOnce, ErrorListener errs) {
        if (this.isConstant()) {
            return this.toConstant();
        }
        Argument[] args = this.expr.generateArguments(ctx, code, fLocalPropOk, fUsedOnce, errs);
        assert (args != null && args.length == 1);
        Register reg = code.createRegister(this.getType());
        code.add(new Var_T(reg, args));
        return reg;
    }

    @Override
    public String toString() {
        return "Packed:" + this.getUnderlyingExpression().toString();
    }
}

