/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.compiler.ast;

import java.lang.reflect.Field;
import org.xvm.compiler.Token;
import org.xvm.compiler.ast.AstNode;
import org.xvm.compiler.ast.Expression;
import org.xvm.compiler.ast.TypeExpression;

public class Parameter
extends AstNode {
    protected TypeExpression type;
    protected Token name;
    protected Expression value;
    private static final Field[] CHILD_FIELDS = Parameter.fieldsForNames(Parameter.class, "type", "value");

    public Parameter(TypeExpression type) {
        this(type, null);
    }

    public Parameter(TypeExpression type, Token name) {
        this(type, name, null);
    }

    public Parameter(TypeExpression type, Token name, Expression value) {
        this.type = type;
        this.name = name;
        this.value = value;
    }

    public TypeExpression getType() {
        return this.type;
    }

    public String getName() {
        return this.name == null ? null : this.name.getValueText();
    }

    public Token getNameToken() {
        return this.name;
    }

    public Expression getValue() {
        return this.value;
    }

    @Override
    public long getStartPosition() {
        return this.type == null ? this.name.getStartPosition() : (this.name == null ? this.type.getStartPosition() : Math.min(this.type.getStartPosition(), this.name.getStartPosition()));
    }

    @Override
    public long getEndPosition() {
        return this.value == null ? (this.name == null ? this.type.getEndPosition() : Math.max(this.type.getEndPosition(), this.name.getEndPosition())) : this.value.getEndPosition();
    }

    @Override
    protected Field[] getChildFields() {
        return CHILD_FIELDS;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.type);
        if (this.name != null) {
            sb.append(' ').append(this.name.getValueText());
        }
        if (this.value != null) {
            sb.append(" = ").append(this.value);
        }
        return sb.toString();
    }

    public String toTypeParamString() {
        assert (this.name != null);
        String s = String.valueOf(this.name.getValue());
        return this.type == null ? s : s + " extends " + String.valueOf(this.type);
    }

    @Override
    public String getDumpDesc() {
        return this.toString();
    }
}

