/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.compiler.ast;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import org.xvm.asm.ErrorListener;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.asm.constants.UnionTypeConstant;
import org.xvm.compiler.ast.Context;
import org.xvm.compiler.ast.DelegatingExpression;
import org.xvm.compiler.ast.Expression;
import org.xvm.compiler.ast.TupleExpression;
import org.xvm.compiler.ast.TypeExpression;

public class ParenthesizedExpression
extends DelegatingExpression {
    private final long m_lStartPos;
    private final long m_lEndPos;
    private static final Field[] CHILD_FIELDS = ParenthesizedExpression.fieldsForNames(ParenthesizedExpression.class, "expr");

    public ParenthesizedExpression(Expression expr, long lStartPos, long lEndPos) {
        super(expr);
        this.m_lStartPos = lStartPos;
        this.m_lEndPos = lEndPos;
    }

    @Override
    public Expression.TypeFit testFit(Context ctx, TypeConstant typeRequired, boolean fExhaustive, ErrorListener errs) {
        Expression.TypeFit fitTuple = this.testTupleFit(ctx, typeRequired, fExhaustive, null);
        Expression.TypeFit fitValue = super.testFit(ctx, typeRequired, fExhaustive, null);
        return fitValue.betterOf(fitTuple);
    }

    private Expression.TypeFit testTupleFit(Context ctx, TypeConstant typeRequired, boolean fExhaustive, ErrorListener errs) {
        TypeConstant typeTuple = ParenthesizedExpression.mightBeTuple(typeRequired);
        if (typeTuple != null) {
            List<TypeConstant> listElements = typeTuple.getTupleParamTypes();
            if (listElements == null || listElements.isEmpty()) {
                return Expression.TypeFit.Fit;
            }
            if (listElements.size() == 1) {
                TypeConstant typeElement = listElements.getFirst();
                return this.expr.testFit(ctx, typeElement, fExhaustive, errs);
            }
        }
        return Expression.TypeFit.NoFit;
    }

    private static TypeConstant mightBeTuple(TypeConstant typeRequired) {
        List<TypeConstant> elementTypes;
        if (typeRequired == null) {
            return null;
        }
        TypeConstant typeTuple = null;
        if (typeRequired.isTuple()) {
            typeTuple = typeRequired;
        } else if (typeRequired instanceof UnionTypeConstant) {
            UnionTypeConstant typeUnion = (UnionTypeConstant)typeRequired;
            typeTuple = typeUnion.extractTuple();
        }
        if (typeTuple != null && ((elementTypes = typeTuple.getTupleParamTypes()) == null || elementTypes.size() <= 1)) {
            return typeTuple;
        }
        return null;
    }

    @Override
    public Expression.TypeFit testFitMulti(Context ctx, TypeConstant[] atypeRequired, boolean fExhaustive, ErrorListener errs) {
        return atypeRequired.length == 1 ? this.testFit(ctx, atypeRequired[0], fExhaustive, errs) : super.testFitMulti(ctx, atypeRequired, fExhaustive, errs);
    }

    @Override
    protected Expression validate(Context ctx, TypeConstant typeRequired, ErrorListener errs) {
        Expression.TypeFit fitValue;
        Expression.TypeFit fitTuple;
        if (typeRequired != null && (fitTuple = this.testTupleFit(ctx, typeRequired, true, null)).betterThan(fitValue = super.testFit(ctx, typeRequired, true, null))) {
            TupleExpression exprTuple = new TupleExpression(null, new ArrayList<Expression>(List.of(this.expr)), this.getStartPosition(), this.getEndPosition());
            exprTuple.adopt(this.expr);
            this.replaceThisWith(exprTuple);
            return exprTuple.validate(ctx, typeRequired, errs);
        }
        return super.validate(ctx, typeRequired, errs);
    }

    @Override
    protected Expression validateMulti(Context ctx, TypeConstant[] atypeRequired, ErrorListener errs) {
        if (atypeRequired != null && atypeRequired.length == 1) {
            return this.validate(ctx, atypeRequired[0], errs);
        }
        return super.validateMulti(ctx, atypeRequired, errs);
    }

    @Override
    public long getStartPosition() {
        return this.m_lStartPos;
    }

    @Override
    public long getEndPosition() {
        return this.m_lEndPos;
    }

    @Override
    protected Field[] getChildFields() {
        return CHILD_FIELDS;
    }

    @Override
    public TypeExpression toTypeExpression() {
        return this.expr.toTypeExpression();
    }

    @Override
    public boolean isStandalone() {
        return this.expr.isStandalone();
    }

    @Override
    public String toString() {
        return "(" + String.valueOf(this.expr) + ")";
    }
}

