/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.compiler.ast;

import java.lang.reflect.Field;
import java.util.Set;
import org.xvm.asm.Argument;
import org.xvm.asm.ErrorListener;
import org.xvm.asm.ast.ExprAST;
import org.xvm.asm.ast.UnaryOpExprAST;
import org.xvm.asm.constants.ConditionalConstant;
import org.xvm.asm.constants.MethodConstant;
import org.xvm.asm.constants.MethodInfo;
import org.xvm.asm.constants.SignatureConstant;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.asm.constants.TypeInfo;
import org.xvm.compiler.Token;
import org.xvm.compiler.ast.Context;
import org.xvm.compiler.ast.Expression;
import org.xvm.compiler.ast.NameExpression;
import org.xvm.compiler.ast.SequentialAssignExpression;
import org.xvm.util.Severity;

public abstract class PrefixExpression
extends Expression {
    protected Token operator;
    protected Expression expr;
    private static final Field[] CHILD_FIELDS = PrefixExpression.fieldsForNames(PrefixExpression.class, "expr");

    protected PrefixExpression(Token operator, Expression expr) {
        this.operator = operator;
        this.expr = expr;
    }

    @Override
    public boolean validateCondition(ErrorListener errs) {
        return this.operator.getId() == Token.Id.NOT ? this.expr.validateCondition(errs) : super.validateCondition(errs);
    }

    @Override
    public ConditionalConstant toConditionalConstant() {
        return this.operator.getId() == Token.Id.NOT ? this.expr.toConditionalConstant().negate() : super.toConditionalConstant();
    }

    @Override
    public long getStartPosition() {
        return this.operator.getStartPosition();
    }

    @Override
    public long getEndPosition() {
        return this.expr.getEndPosition();
    }

    @Override
    protected Field[] getChildFields() {
        return CHILD_FIELDS;
    }

    protected TypeConstant findBestOp(Context ctx, TypeConstant typeRequired, TypeConstant typeRight, String sMethod, String sOp, ErrorListener errs) {
        Expression exprRight = this.expr.validate(ctx, typeRight, errs);
        if (exprRight != null) {
            MethodConstant idBest = null;
            this.expr = exprRight;
            typeRight = exprRight.getType();
            TypeInfo infoRight = typeRight.ensureTypeInfo(errs);
            Set<MethodConstant> setOps = infoRight.findOpMethods(sMethod, sOp, 0);
            boolean fAmbiguous = false;
            for (MethodConstant idMethod : setOps) {
                if (typeRequired != null && !this.isAssignable(ctx, idMethod.getSignature().getRawReturns()[0], typeRequired)) continue;
                if (idBest == null) {
                    idBest = idMethod;
                    continue;
                }
                MethodInfo infoMethod = infoRight.getMethodById(idMethod);
                MethodInfo infoBest = infoRight.getMethodById(idBest);
                if (infoMethod.getIdentity().equals(infoBest.getIdentity())) continue;
                SignatureConstant sigNew = infoMethod.getSignature();
                SignatureConstant sigBest = infoBest.getSignature();
                boolean fNewBetter = sigNew.isSubstitutableFor(sigBest, typeRight);
                boolean fOldBetter = sigBest.isSubstitutableFor(sigNew, typeRight);
                if (fOldBetter ^ fNewBetter) {
                    if (!fNewBetter) continue;
                    idBest = idMethod;
                    continue;
                }
                fAmbiguous = true;
                break;
            }
            if (idBest == null) {
                if (fAmbiguous) {
                    this.log(errs, Severity.ERROR, "COMPILER-69", this.operator.getValueText(), typeRight.getValueString());
                } else {
                    this.log(errs, Severity.ERROR, "COMPILER-67", this.operator.getValueText(), typeRight.getValueString());
                }
            } else {
                return idBest.getSignature().getRawReturns()[0].removeAutoNarrowing();
            }
        }
        return null;
    }

    @Override
    public boolean isTraceworthy() {
        return false;
    }

    @Override
    public boolean isCompletable() {
        return this.expr.isCompletable();
    }

    @Override
    public boolean isShortCircuiting() {
        return this.expr.isShortCircuiting();
    }

    @Override
    public ExprAST getExprAST(Context ctx) {
        UnaryOpExprAST.Operator op;
        switch (this.operator.getId()) {
            case NOT: {
                op = UnaryOpExprAST.Operator.Not;
                break;
            }
            case ADD: {
                return this.expr.getExprAST(ctx);
            }
            case SUB: {
                op = UnaryOpExprAST.Operator.Minus;
                break;
            }
            case BIT_NOT: {
                op = UnaryOpExprAST.Operator.Compl;
                break;
            }
            case INC: {
                op = UnaryOpExprAST.Operator.PreInc;
                break;
            }
            case DEC: {
                op = UnaryOpExprAST.Operator.PreDec;
                break;
            }
            default: {
                throw new UnsupportedOperationException(this.operator.getValueText());
            }
        }
        return new UnaryOpExprAST(this.expr.getExprAST(ctx), op, this.getType());
    }

    @Override
    protected Expression.SideEffect mightAffect(Expression exprLeft, Argument arg) {
        return this.expr.mightAffect(exprLeft, arg);
    }

    @Override
    public String toString() {
        SequentialAssignExpression exprSeq;
        boolean fPre;
        StringBuilder sb = new StringBuilder();
        PrefixExpression prefixExpression = this;
        boolean bl = fPre = !(prefixExpression instanceof SequentialAssignExpression) || (exprSeq = (SequentialAssignExpression)prefixExpression).isPre();
        if (fPre) {
            sb.append(this.operator.getId().TEXT);
        }
        if (this.expr instanceof NameExpression) {
            sb.append(this.expr);
        } else {
            sb.append('(').append(this.expr).append(')');
        }
        if (!fPre) {
            sb.append(this.operator.getId().TEXT);
        }
        return sb.toString();
    }

    @Override
    public String getDumpDesc() {
        return this.toString();
    }
}

