/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.compiler.ast;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.xvm.asm.Annotation;
import org.xvm.asm.ClassStructure;
import org.xvm.asm.Component;
import org.xvm.asm.Constant;
import org.xvm.asm.ConstantPool;
import org.xvm.asm.Constants;
import org.xvm.asm.ErrorListener;
import org.xvm.asm.MethodStructure;
import org.xvm.asm.Parameter;
import org.xvm.asm.PropertyStructure;
import org.xvm.asm.Register;
import org.xvm.asm.constants.ClassConstant;
import org.xvm.asm.constants.MethodConstant;
import org.xvm.asm.constants.PropertyConstant;
import org.xvm.asm.constants.StringConstant;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.asm.constants.TypeInfo;
import org.xvm.asm.op.JumpTrue;
import org.xvm.asm.op.Label;
import org.xvm.asm.op.P_Get;
import org.xvm.asm.op.P_Var;
import org.xvm.compiler.Compiler;
import org.xvm.compiler.Token;
import org.xvm.compiler.ast.AnnotatedTypeExpression;
import org.xvm.compiler.ast.AnnotationExpression;
import org.xvm.compiler.ast.AssignmentStatement;
import org.xvm.compiler.ast.AstNode;
import org.xvm.compiler.ast.ComponentStatement;
import org.xvm.compiler.ast.Context;
import org.xvm.compiler.ast.Expression;
import org.xvm.compiler.ast.MethodDeclarationStatement;
import org.xvm.compiler.ast.NameExpression;
import org.xvm.compiler.ast.StageMgr;
import org.xvm.compiler.ast.Statement;
import org.xvm.compiler.ast.StatementBlock;
import org.xvm.compiler.ast.TypeExpression;
import org.xvm.util.Handy;
import org.xvm.util.ListMap;
import org.xvm.util.Severity;

public class PropertyDeclarationStatement
extends ComponentStatement {
    protected Expression condition;
    protected List<Token> modifiers;
    protected List<AnnotationExpression> annotations;
    protected TypeExpression type;
    protected Token name;
    protected Token tokAsn;
    protected Expression value;
    protected StatementBlock body;
    protected Token doc;
    protected transient MethodDeclarationStatement initializer;
    protected transient AssignmentStatement assignment;
    protected transient boolean m_fSynthetic;
    protected transient int m_counter;
    private static final Field[] CHILD_FIELDS = PropertyDeclarationStatement.fieldsForNames(PropertyDeclarationStatement.class, "condition", "annotations", "type", "value", "body", "initializer", "assignment");

    public PropertyDeclarationStatement(long lStartPos, long lEndPos, Expression condition, List<Token> modifiers, List<AnnotationExpression> annotations, TypeExpression type, Token name, Token tokAsn, Expression value, StatementBlock body, Token doc) {
        super(lStartPos, lEndPos);
        TypeExpression typePrev = null;
        TypeExpression typeNext = type;
        while (typeNext.isIntroductoryType()) {
            if (typeNext instanceof AnnotatedTypeExpression) {
                AnnotatedTypeExpression typeAnno = (AnnotatedTypeExpression)typeNext;
                AnnotationExpression anno = typeAnno.getAnnotation();
                anno.setParent(this);
                if (annotations == null || annotations.isEmpty()) {
                    annotations = new ArrayList<AnnotationExpression>();
                }
                annotations.add(anno);
                typeNext = typeAnno.unwrapIntroductoryType();
                if (typePrev == null) {
                    typeNext.setParent(typeAnno);
                    continue;
                }
                typePrev.replaceIntroducedType(typeNext);
                typeNext.setParent(typePrev);
                continue;
            }
            typePrev = typeNext;
            typeNext = typeNext.unwrapIntroductoryType();
        }
        this.condition = condition;
        this.modifiers = modifiers;
        this.annotations = annotations;
        this.type = type;
        this.name = name;
        this.tokAsn = tokAsn;
        this.value = value;
        this.body = body;
        this.doc = doc;
    }

    public String getName() {
        return this.name.getValueText();
    }

    public TypeExpression getType() {
        return this.type;
    }

    @Override
    public boolean isAutoNarrowingAllowed(TypeExpression type) {
        return this.getComponent().isAutoNarrowingAllowed();
    }

    public boolean isStatic() {
        List<Token> list = this.modifiers;
        if (list != null && !list.isEmpty()) {
            for (Token token : list) {
                if (token.getId() != Token.Id.STATIC) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public Constants.Access getDefaultAccess() {
        Constants.Access access = PropertyDeclarationStatement.getAccess(this.modifiers);
        return access == null ? Constants.Access.PUBLIC : access;
    }

    public Constants.Access getAccess2() {
        if (this.modifiers != null && !this.modifiers.isEmpty()) {
            Constants.Access access = null;
            for (Token modifier : this.modifiers) {
                switch (modifier.getId()) {
                    case PUBLIC: {
                        if (access == null) {
                            access = Constants.Access.PUBLIC;
                            break;
                        }
                        return Constants.Access.PUBLIC;
                    }
                    case PROTECTED: {
                        if (access == null) {
                            access = Constants.Access.PROTECTED;
                            break;
                        }
                        return Constants.Access.PROTECTED;
                    }
                    case PRIVATE: {
                        if (access == null) {
                            access = Constants.Access.PRIVATE;
                            break;
                        }
                        return Constants.Access.PRIVATE;
                    }
                }
            }
        }
        return null;
    }

    public boolean isInMethod() {
        Component componentParent = this.getParent().getComponent();
        assert (componentParent != null);
        return componentParent.getFormat() == Component.Format.METHOD;
    }

    @Override
    protected AstNode getCodeContainer() {
        return this.isInMethod() ? super.getCodeContainer() : null;
    }

    @Override
    protected int getCodeContainerCounter() {
        int n;
        if (this.isInMethod()) {
            n = super.getCodeContainerCounter();
        } else {
            int n2 = this.m_counter;
            n = n2;
            this.m_counter = n2 + 1;
        }
        return n;
    }

    @Override
    protected Field[] getChildFields() {
        return CHILD_FIELDS;
    }

    public void markSynthetic() {
        this.m_fSynthetic = true;
    }

    @Override
    protected void registerStructures(StageMgr mgr, ErrorListener errs) {
        if (this.getComponent() != null) {
            return;
        }
        String sName = this.name.getValueText();
        Component container = this.getParent().getComponent();
        if (container == null) {
            return;
        }
        if (!container.isClassContainer()) {
            this.log(errs, Severity.ERROR, "COMPILER-06", sName, container);
            return;
        }
        if (this.name.getId() == Token.Id.ANY) {
            this.log(errs, Severity.ERROR, "COMPILER-124", sName);
            return;
        }
        if (!(!this.name.isSpecial() || "outer".equals(sName) && container.getIdentityConstant().getModuleConstant().isEcstasyModule() && "reflect.Outer.Inner".equals(container.getIdentityConstant().getPathString()))) {
            this.log(errs, Severity.ERROR, "COMPILER-124", sName);
            return;
        }
        if (container.getChild(sName) != null) {
            this.log(errs, Severity.ERROR, "COMPILER-05", sName);
            return;
        }
        Constants.Access accessDft = this.getDefaultAccess();
        Constants.Access accessGet = PropertyDeclarationStatement.getAccess(this.modifiers);
        Constants.Access accessSet = this.getAccess2();
        boolean fStatic = this.isStatic();
        boolean fInMethod = this.isInMethod();
        if (fInMethod) {
            if (fStatic) {
                if (accessGet != null) {
                    this.log(errs, Severity.ERROR, "COMPILER-119", sName, container.getIdentityConstant().getValueString());
                }
            } else if (accessGet != Constants.Access.PRIVATE) {
                this.log(errs, Severity.ERROR, "COMPILER-120", sName, container.getIdentityConstant().getValueString());
            }
            accessDft = Constants.Access.PRIVATE;
        }
        if (accessSet != null) {
            if (accessSet == accessGet) {
                accessSet = null;
            } else if (fStatic) {
                this.log(errs, Severity.ERROR, "COMPILER-121", sName, container.getIdentityConstant().getValueString());
                accessSet = null;
            } else if (accessSet.isMoreAccessibleThan(accessGet)) {
                this.log(errs, Severity.ERROR, "COMPILER-122", sName, container.getIdentityConstant().getValueString());
                accessSet = null;
            }
        }
        TypeConstant constType = this.type.ensureTypeConstant();
        PropertyStructure prop = container.createProperty(fStatic, accessDft, accessSet, constType, sName);
        if (this.value != null) {
            prop.indicateInitialValue();
        }
        prop.setSynthetic(this.m_fSynthetic);
        this.setComponent(prop);
        if (this.annotations != null) {
            ConstantPool pool = this.pool();
            for (AnnotationExpression annotation : this.annotations) {
                prop.addAnnotation(annotation.ensureAnnotation(pool));
            }
        }
    }

    @Override
    public void resolveNames(StageMgr mgr, ErrorListener errs) {
        PropertyStructure prop = (PropertyStructure)this.getComponent();
        if (!prop.resolveAnnotations()) {
            mgr.requestRevisit();
        }
    }

    @Override
    public void validateContent(StageMgr mgr, ErrorListener errs) {
        if (!this.alreadyReached(Compiler.Stage.Validated)) {
            MethodStructure methodGetter;
            this.setStage(Compiler.Stage.Validating);
            PropertyStructure prop = (PropertyStructure)this.getComponent();
            TypeConstant type = prop.getType();
            if (type.containsUnresolved()) {
                mgr.requestRevisit();
                return;
            }
            if (prop.isStatic() && type.containsGenericType(true)) {
                this.log(errs, Severity.ERROR, "COMPILER-166", prop.getName(), type.getValueString());
                return;
            }
            if (prop.isSimpleUnassigned() && (methodGetter = prop.getGetter()) != null && !methodGetter.usesSuper()) {
                AnnotationExpression exprAnno = this.annotations.get(0);
                exprAnno.log(errs, Severity.ERROR, "COMPILER-140", this.pool().clzUnassigned().getName(), prop.getIdentityConstant().getValueString());
                return;
            }
            ClassStructure clz = prop.getContainingClass(false);
            String sInvalid = clz.checkGenericTypeVisibility(type);
            if (sInvalid != null) {
                this.log(errs, Severity.ERROR, "COMPILER-145", sInvalid);
                return;
            }
            if (!this.validateRefAnnotations(prop.getRefAnnotations(), clz, prop, errs)) {
                return;
            }
            TypeConstant typeRef = prop.getIdentityConstant().getValueType(this.pool(), null);
            if (!this.validateAnnotations(prop.getPropertyAnnotations(), typeRef, errs)) {
                mgr.requestRevisit();
                return;
            }
            if (prop.hasInitialValue()) {
                if (prop.isExplicitReadOnly() || prop.getContainingClass().getFormat() == Component.Format.INTERFACE && !prop.isStatic()) {
                    this.log(errs, Severity.ERROR, "COMPILER-202", prop.getName());
                    return;
                }
                if (this.isInMethod() && !this.isStatic()) {
                    AssignmentStatement stmtInit = this.adopt(new AssignmentStatement(new NameExpression(this.name), this.tokAsn, this.value));
                    stmtInit.introduceParentage();
                    ErrorListener errsTmp = errs.branch(this);
                    if (!new StageMgr(stmtInit, Compiler.Stage.Resolved, errsTmp).fastForward(3) || errsTmp.hasSeriousErrors()) {
                        if (mgr.isLastAttempt()) {
                            errsTmp.merge();
                        } else {
                            mgr.requestRevisit();
                        }
                        return;
                    }
                    errsTmp.merge();
                    this.assignment = stmtInit;
                    prop.addAnnotation(this.pool().clzUnassigned(), new Constant[0]);
                    prop.setInitialValue(null);
                } else {
                    boolean fMethodRequired;
                    ErrorListener errsTmp;
                    MethodStructure methodInit;
                    PropertyDeclarationStatement stmtClone = (PropertyDeclarationStatement)this.clone();
                    MethodDeclarationStatement stmtInit = stmtClone.createAstNodeFor(methodInit = stmtClone.createInitializer());
                    if (!new StageMgr(stmtInit, Compiler.Stage.Emitted, errsTmp = errs.branch(this)).fastForward(10) || errsTmp.hasSeriousErrors()) {
                        stmtClone.discardInitializer(methodInit);
                        stmtInit.discard(true);
                        if (mgr.isLastAttempt()) {
                            errsTmp.merge();
                        } else {
                            mgr.requestRevisit();
                        }
                        return;
                    }
                    errsTmp.merge();
                    Expression exprTest = stmtInit.getInitializerExpression();
                    boolean fConstant = exprTest != null && exprTest.isConstant();
                    boolean bl = fMethodRequired = !fConstant;
                    if (fConstant) {
                        Constant constValue = exprTest.toConstant();
                        if (constValue.containsUnresolved()) {
                            stmtClone.discardInitializer(methodInit);
                            stmtInit.discard(true);
                            if (mgr.isLastAttempt()) {
                                this.log(errs, Severity.ERROR, "COMPILER-185", prop.getName());
                            } else {
                                mgr.requestRevisit();
                            }
                            return;
                        }
                        prop.setInitialValue(exprTest.validateAndConvertConstant(constValue, type, errs));
                        HashSet<MethodConstant> setMethods = new HashSet<MethodConstant>();
                        if (constValue instanceof MethodConstant) {
                            MethodConstant idMethod = (MethodConstant)constValue;
                            setMethods.add(idMethod);
                        } else {
                            constValue.forEachUnderlying(c -> {
                                if (c instanceof MethodConstant) {
                                    MethodConstant idMethod = (MethodConstant)c;
                                    setMethods.add(idMethod);
                                }
                            });
                        }
                        if (!setMethods.isEmpty()) {
                            for (MethodConstant idMethod : setMethods) {
                                if (!idMethod.getNamespace().equals(methodInit.getIdentityConstant())) continue;
                                fMethodRequired = true;
                                break;
                            }
                        }
                    } else {
                        prop.setInitialValue(null);
                    }
                    stmtClone.discardInitializer(methodInit);
                    stmtInit.discard(true);
                    if (fMethodRequired) {
                        methodInit = this.createInitializer();
                        this.initializer = this.createAstNodeFor(methodInit);
                        assert (this.value.getParent() != this);
                        this.value = null;
                        if (!new StageMgr(this.initializer, Compiler.Stage.Validated, errs).fastForward(10)) {
                            this.log(errs, Severity.FATAL, "COMPILER-01", this.initializer);
                        }
                    }
                }
            }
        }
    }

    private boolean validateRefAnnotations(Annotation[] aAnno, ClassStructure clz, PropertyStructure prop, ErrorListener errs) {
        if (aAnno.length > 0) {
            if (clz.getFormat() == Component.Format.INTERFACE) {
                this.log(errs, Severity.ERROR, "VERIFY-45", clz.getIdentityConstant().getValueString(), prop.getName());
                return false;
            }
            ConstantPool pool = this.pool();
            for (Annotation anno : aAnno) {
                ClassConstant idAnno = (ClassConstant)anno.getAnnotationClass();
                ClassStructure clzAnno = (ClassStructure)idAnno.getComponent();
                if (clzAnno.getFormat() != Component.Format.ANNOTATION) {
                    this.findAnnotationExpression(anno, this.annotations).log(errs, Severity.ERROR, "VERIFY-27", anno.getValueString());
                    return false;
                }
                if (!idAnno.equals(pool.clzVolatile())) continue;
                this.findAnnotationExpression(anno, this.annotations).log(errs, Severity.ERROR, "COMPILER-140", idAnno.getName(), prop.getIdentityConstant().getValueString());
                return false;
            }
        }
        return true;
    }

    private boolean validateAnnotations(Annotation[] aAnno, TypeConstant typeProp, ErrorListener errs) {
        ConstantPool pool = this.pool();
        assert (typeProp.isA(pool.typeProperty()));
        int c = aAnno.length;
        block0: for (int iA = 0; iA < c; ++iA) {
            TypeConstant typeAnno;
            Annotation anno = aAnno[iA];
            ClassConstant idAnno = (ClassConstant)anno.getAnnotationClass();
            ClassStructure clzAnno = (ClassStructure)idAnno.getComponent();
            if (clzAnno.getFormat() != Component.Format.ANNOTATION) {
                this.findAnnotationExpression(anno, this.annotations).log(errs, Severity.ERROR, "VERIFY-27", anno.getValueString());
                break;
            }
            Constant[] aParams = anno.getParams();
            int cParams = aParams.length;
            MethodStructure ctor = clzAnno.findMethod("construct", cParams, new TypeConstant[0]);
            if (ctor == null) continue;
            if (clzAnno.isParameterized() && cParams > 0) {
                ListMap<String, TypeConstant> mapResolved = new ListMap<String, TypeConstant>();
                for (Map.Entry<StringConstant, TypeConstant> entry : clzAnno.getTypeParamsAsList()) {
                    String sFormal = entry.getKey().getValue();
                    mapResolved.put(sFormal, entry.getValue());
                    for (int iP = 0; iP < cParams; ++iP) {
                        TypeConstant typeActual;
                        Constant constParam = aParams[iP];
                        if (constParam.containsUnresolved()) {
                            return false;
                        }
                        TypeConstant typeFormal = ctor.getParam(iP).getType();
                        TypeConstant typeResolved = typeFormal.resolveTypeParameter(typeActual = constParam.getType(), sFormal);
                        if (typeResolved == null) continue;
                        mapResolved.put(sFormal, typeResolved);
                    }
                }
                typeAnno = clzAnno.getFormalType().resolveGenerics(pool, mapResolved::get);
            } else {
                typeAnno = clzAnno.getCanonicalType();
            }
            TypeConstant typeInto = typeAnno.getExplicitClassInto(true);
            if (!typeProp.isA(typeInto)) {
                this.findAnnotationExpression(anno, this.annotations).log(errs, Severity.ERROR, "VERIFY-32", typeProp.getValueString(), typeAnno.getValueString(), typeInto.getValueString());
                break;
            }
            for (int iA2 = iA + 1; iA2 < c; ++iA2) {
                Annotation anno2 = aAnno[iA2];
                TypeConstant typeAnno2 = anno2.getAnnotationType();
                if (!typeAnno2.equals(typeAnno)) continue;
                this.findAnnotationExpression(anno, this.annotations).log(errs, Severity.ERROR, "VERIFY-28", anno.getValueString());
                continue block0;
            }
        }
        return true;
    }

    @Override
    protected Statement validateImpl(Context ctx, ErrorListener errs) {
        if (this.assignment != null) {
            ctx.getThisType().invalidateTypeInfo();
            AssignmentStatement stmtNew = (AssignmentStatement)this.assignment.validate(ctx, errs);
            if (stmtNew == null) {
                return null;
            }
            this.assignment = stmtNew;
        }
        return this;
    }

    @Override
    public void generateCode(StageMgr mgr, ErrorListener errs) {
        if (!errs.isSilent()) {
            PropertyStructure prop = (PropertyStructure)this.getComponent();
            ClassStructure clz = prop.getContainingClass();
            TypeConstant type = this.pool().ensureAccessTypeConstant(clz.getFormalType(), Constants.Access.PRIVATE);
            TypeInfo info = type.ensureTypeInfo(errs);
            Set<MethodConstant> set = info.findMethods(prop.getName(), -1, TypeInfo.MethodKind.Any);
            if (!set.isEmpty()) {
                MethodConstant idMethod = set.iterator().next();
                this.log(errs, Severity.ERROR, "COMPILER-143", prop.getName(), idMethod.getNamespace().getPathString());
            }
        }
    }

    @Override
    protected boolean emit(Context ctx, boolean fReachable, MethodStructure.Code code, ErrorListener errs) {
        boolean fCompletes = fReachable;
        if (this.assignment != null) {
            NameExpression exprProp = (NameExpression)this.assignment.getLValueExpression();
            ConstantPool pool = this.pool();
            PropertyConstant idProp = (PropertyConstant)exprProp.getIdentity(ctx);
            TypeConstant typeVar = idProp.getRefType(ctx.getThisType().ensureAccess(Constants.Access.PRIVATE));
            Register regPropRef = new Register(typeVar, null, -1);
            Register regAssigned = new Register(pool.typeBoolean(), null, -1);
            Label labelSkipAssign = new Label("skip_assign_" + idProp.getName());
            PropertyConstant idAssigned = typeVar.ensureTypeInfo(errs).findProperty("assigned").getIdentity();
            Register regThis = ctx.getThisRegister();
            code.add(new P_Var(idProp, regThis, regPropRef));
            code.add(new P_Get(idAssigned, regPropRef, regAssigned));
            code.add(new JumpTrue(regAssigned, labelSkipAssign));
            fCompletes = this.assignment.completes(ctx, fCompletes, code, errs);
            code.add(labelSkipAssign);
        }
        return fCompletes;
    }

    @Override
    protected boolean canResolveNames() {
        return super.canResolveNames() || this.type.canResolveNames();
    }

    private MethodStructure createInitializer() {
        PropertyStructure prop = (PropertyStructure)this.getComponent();
        MethodStructure method = prop.createMethod(this.isStatic(), Constants.Access.PRIVATE, Annotation.NO_ANNOTATIONS, new Parameter[]{new Parameter(this.pool(), prop.getType(), null, null, true, 0, false)}, "=", Parameter.NO_PARAMS, true, false);
        this.donateSource(method);
        return method;
    }

    private MethodDeclarationStatement createAstNodeFor(MethodStructure methodInit) {
        return this.adopt(new MethodDeclarationStatement(methodInit, this.value));
    }

    private void discardInitializer(MethodStructure methodInit) {
        PropertyStructure prop = (PropertyStructure)this.getComponent();
        prop.removeChild(methodInit.getParent());
    }

    public String toSignatureString() {
        StringBuilder sb = new StringBuilder();
        if (this.modifiers != null) {
            for (Token token : this.modifiers) {
                sb.append(token.getId().TEXT).append(' ');
            }
        }
        if (this.annotations != null) {
            for (AnnotationExpression annotation : this.annotations) {
                sb.append(annotation).append(' ');
            }
        }
        sb.append(this.type).append(' ').append(this.name.getValueText());
        return sb.toString();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.doc != null) {
            Object sDoc = String.valueOf(this.doc.getValue());
            if (((String)sDoc).length() > 100) {
                sDoc = ((String)sDoc).substring(0, 97) + "...";
            }
            Handy.appendString(sb.append("/*"), (String)sDoc).append("*/\n");
        }
        sb.append(this.toSignatureString());
        if (this.value != null) {
            sb.append(" = ").append(this.value).append(";");
        } else if (this.body != null) {
            String sBody = this.body.toString();
            if (sBody.indexOf(10) >= 0) {
                sb.append('\n').append(Handy.indentLines(sBody, "    "));
            } else {
                sb.append(' ').append(sBody);
            }
        } else {
            sb.append(';');
        }
        return sb.toString();
    }

    @Override
    public String getDumpDesc() {
        return this.toSignatureString();
    }
}

