/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.compiler.ast;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.xvm.asm.Argument;
import org.xvm.asm.Constant;
import org.xvm.asm.ConstantPool;
import org.xvm.asm.ErrorListener;
import org.xvm.asm.MethodStructure;
import org.xvm.asm.ast.ExprAST;
import org.xvm.asm.ast.InvokeExprAST;
import org.xvm.asm.constants.ArrayConstant;
import org.xvm.asm.constants.ConditionalConstant;
import org.xvm.asm.constants.MethodConstant;
import org.xvm.asm.constants.MethodInfo;
import org.xvm.asm.constants.SignatureConstant;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.asm.constants.TypeInfo;
import org.xvm.asm.op.GP_Add;
import org.xvm.asm.op.GP_And;
import org.xvm.asm.op.GP_Div;
import org.xvm.asm.op.GP_DivRem;
import org.xvm.asm.op.GP_ERangeE;
import org.xvm.asm.op.GP_ERangeI;
import org.xvm.asm.op.GP_IRangeE;
import org.xvm.asm.op.GP_IRangeI;
import org.xvm.asm.op.GP_Mod;
import org.xvm.asm.op.GP_Mul;
import org.xvm.asm.op.GP_Or;
import org.xvm.asm.op.GP_Shl;
import org.xvm.asm.op.GP_Shr;
import org.xvm.asm.op.GP_ShrAll;
import org.xvm.asm.op.GP_Sub;
import org.xvm.asm.op.GP_Xor;
import org.xvm.compiler.Compiler;
import org.xvm.compiler.Token;
import org.xvm.compiler.ast.BiExpression;
import org.xvm.compiler.ast.BiTypeExpression;
import org.xvm.compiler.ast.Context;
import org.xvm.compiler.ast.Expression;
import org.xvm.compiler.ast.StageMgr;
import org.xvm.compiler.ast.TypeExpression;
import org.xvm.util.Severity;

public class RelOpExpression
extends BiExpression {
    private final Token f_tokBefore;
    private final Token f_tokAfter;
    protected transient MethodConstant m_idOp;

    public RelOpExpression(Expression expr1, Token operator, Expression expr2) {
        this(null, expr1, operator, expr2, null);
    }

    public RelOpExpression(Token tokBefore, Expression expr1, Token operator, Expression expr2, Token tokAfter) {
        super(expr1, operator, expr2);
        switch (operator.getId()) {
            case COND_XOR: 
            case BIT_OR: 
            case BIT_XOR: 
            case BIT_AND: 
            case I_RANGE_I: 
            case E_RANGE_I: 
            case I_RANGE_E: 
            case E_RANGE_E: 
            case SHL: 
            case SHR: 
            case USHR: 
            case ADD: 
            case SUB: 
            case MUL: 
            case DIV: 
            case MOD: 
            case DIVREM: {
                break;
            }
            default: {
                throw new IllegalArgumentException("operator: " + String.valueOf(operator));
            }
        }
        this.f_tokBefore = tokBefore;
        this.f_tokAfter = tokAfter;
    }

    @Override
    public long getStartPosition() {
        return this.f_tokBefore == null ? super.getStartPosition() : this.f_tokBefore.getStartPosition();
    }

    @Override
    public long getEndPosition() {
        return this.f_tokAfter == null ? super.getEndPosition() : this.f_tokAfter.getEndPosition();
    }

    @Override
    public TypeExpression toTypeExpression() {
        switch (this.operator.getId()) {
            case BIT_OR: 
            case ADD: 
            case SUB: {
                BiTypeExpression exprType = new BiTypeExpression(this.expr1.toTypeExpression(), this.operator, this.expr2.toTypeExpression());
                exprType.setParent(this.getParent());
                return exprType;
            }
        }
        return super.toTypeExpression();
    }

    @Override
    public boolean validateCondition(ErrorListener errs) {
        return switch (this.operator.getId()) {
            case Token.Id.BIT_OR, Token.Id.BIT_AND -> {
                if (this.expr1.validateCondition(errs) && this.expr2.validateCondition(errs)) {
                    yield true;
                }
                yield false;
            }
            default -> super.validateCondition(errs);
        };
    }

    @Override
    public ConditionalConstant toConditionalConstant() {
        return switch (this.operator.getId()) {
            case Token.Id.BIT_AND -> this.expr1.toConditionalConstant().addAnd(this.expr2.toConditionalConstant());
            case Token.Id.BIT_OR -> this.expr1.toConditionalConstant().addOr(this.expr2.toConditionalConstant());
            default -> super.toConditionalConstant();
        };
    }

    @Override
    protected boolean hasMultiValueImpl() {
        return true;
    }

    @Override
    public TypeConstant getImplicitType(Context ctx) {
        MethodConstant method = this.getImplicitMethod(ctx);
        return method == null ? null : method.getRawReturns()[0];
    }

    @Override
    public TypeConstant[] getImplicitTypes(Context ctx) {
        if (this.operator.getId() == Token.Id.DIVREM) {
            MethodConstant method = this.getImplicitMethod(ctx);
            return method == null ? null : method.getRawReturns();
        }
        return super.getImplicitTypes(ctx);
    }

    protected MethodConstant getImplicitMethod(Context ctx) {
        Set<MethodConstant> setOpsRight;
        TypeConstant typeLeft = this.expr1.getImplicitType(ctx);
        if (typeLeft == null) {
            return null;
        }
        Set<MethodConstant> setOpsLeft = typeLeft.ensureTypeInfo().findOpMethods(this.getDefaultMethodName(), this.operator.getId().TEXT, 1);
        MethodConstant idBestLeft = setOpsLeft.size() == 1 ? setOpsLeft.iterator().next() : null;
        TypeConstant typeRight = this.expr2.getImplicitType(ctx);
        if (typeRight == null) {
            return idBestLeft;
        }
        HashMap<SignatureConstant, MethodConstant> mapBest = new HashMap<SignatureConstant, MethodConstant>();
        MethodConstant idBest = this.chooseBest(setOpsLeft, typeRight, mapBest);
        if (idBest == null && mapBest.isEmpty() && !typeLeft.equals(typeRight) && typeLeft.getConverterTo(typeRight) != null && !(setOpsRight = typeRight.ensureTypeInfo().findOpMethods(this.getDefaultMethodName(), this.operator.getId().TEXT, 1)).isEmpty()) {
            idBest = this.chooseBest(setOpsRight, typeRight, mapBest);
        }
        if (idBest == null && !mapBest.isEmpty()) {
            SignatureConstant sigBest = typeLeft.selectBest(mapBest.keySet(), null);
            if (sigBest == null) {
                return null;
            }
            idBest = (MethodConstant)mapBest.get(sigBest);
            assert (idBest != null);
        }
        return idBest == null ? idBestLeft : idBest;
    }

    private MethodConstant chooseBest(Set<MethodConstant> setOps, TypeConstant typeParam, Map<SignatureConstant, MethodConstant> mapBest) {
        MethodConstant idBest = null;
        for (MethodConstant idMethod : setOps) {
            TypeConstant type = idMethod.getRawParams()[0];
            if (!typeParam.isAssignableTo(type)) continue;
            if (!mapBest.isEmpty()) {
                mapBest.put(idMethod.getSignature(), idMethod);
                continue;
            }
            if (idBest == null || type.isAssignableTo(idBest.getRawParams()[0])) {
                idBest = idMethod;
                continue;
            }
            if (idBest.getRawParams()[0].isAssignableTo(type)) continue;
            mapBest.put(idBest.getSignature(), idBest);
            mapBest.put(idMethod.getSignature(), idMethod);
            idBest = null;
        }
        return idBest;
    }

    @Override
    public Expression.TypeFit testFit(Context ctx, TypeConstant typeRequired, boolean fExhaustive, ErrorListener errs) {
        Expression.TypeFit fit;
        if (typeRequired != null && typeRequired.isTypeOfType() && (fit = this.testFitAsType(ctx, typeRequired, fExhaustive, errs)).isFit()) {
            return fit;
        }
        TypeConstant typeLeft = this.expr1.getImplicitType(ctx);
        if (typeLeft == null) {
            return Expression.TypeFit.NoFit;
        }
        Expression.TypeFit fitVia = Expression.TypeFit.NoFit;
        TypeInfo infoLeft = typeLeft.ensureTypeInfo();
        String sMethod = this.getDefaultMethodName();
        String sOp = this.operator.getId().TEXT;
        Set<MethodConstant> setOps = infoLeft.findOpMethods(sMethod, sOp, 1);
        for (MethodConstant idMethod : setOps) {
            TypeConstant[] aRets = idMethod.getRawReturns();
            if (aRets.length < 1) continue;
            TypeConstant typeResult = aRets[0];
            if (this.isA(ctx, typeResult, typeRequired)) {
                return Expression.TypeFit.Fit;
            }
            if (fitVia.isFit() || !this.isAssignable(ctx, typeResult, typeRequired)) continue;
            fitVia = Expression.TypeFit.Conv;
        }
        if (fitVia.isFit()) {
            return fitVia;
        }
        ConstantPool pool = this.pool();
        for (MethodInfo infoAuto : infoLeft.getAutoMethodInfos()) {
            TypeConstant typeConv = infoAuto.getSignature().getRawReturns()[0];
            if (typeConv.containsAutoNarrowing(false)) {
                typeConv = typeConv.resolveAutoNarrowing(pool, false, typeLeft, null);
            }
            for (MethodConstant idMethod : typeConv.ensureTypeInfo().findOpMethods(sMethod, sOp, 1)) {
                TypeConstant[] aRets = idMethod.getRawReturns();
                if (aRets.length < 1 || !this.isAssignable(ctx, aRets[0], typeRequired)) continue;
                return Expression.TypeFit.Conv;
            }
        }
        return Expression.TypeFit.NoFit;
    }

    @Override
    public Expression.TypeFit testFitMulti(Context ctx, TypeConstant[] atypeRequired, boolean fExhaustive, ErrorListener errs) {
        if (this.operator.getId() != Token.Id.DIVREM || atypeRequired.length < 2) {
            return super.testFitMulti(ctx, atypeRequired, fExhaustive, errs);
        }
        TypeConstant typeLeft = this.expr1.getImplicitType(ctx);
        if (typeLeft == null) {
            return Expression.TypeFit.NoFit;
        }
        Expression.TypeFit fitVia = Expression.TypeFit.NoFit;
        TypeInfo infoLeft = typeLeft.ensureTypeInfo();
        String sMethod = this.getDefaultMethodName();
        String sOp = this.operator.getId().TEXT;
        Set<MethodConstant> setOps = infoLeft.findOpMethods(sMethod, sOp, 1);
        for (MethodConstant idMethod : setOps) {
            TypeConstant[] aRets = idMethod.getRawReturns();
            if (aRets.length < 2) continue;
            if (this.isA(ctx, aRets[0], atypeRequired[0]) && this.isA(ctx, aRets[1], atypeRequired[1])) {
                return Expression.TypeFit.Fit;
            }
            if (fitVia.isFit() || !this.isAssignable(ctx, aRets[0], atypeRequired[0]) || !this.isAssignable(ctx, aRets[1], atypeRequired[1])) continue;
            fitVia = Expression.TypeFit.Conv;
        }
        if (fitVia.isFit()) {
            return fitVia;
        }
        for (MethodInfo infoAuto : infoLeft.getAutoMethodInfos()) {
            TypeConstant typeConv = infoAuto.getSignature().getRawReturns()[0];
            TypeInfo infoConv = typeConv.ensureTypeInfo();
            for (MethodConstant idMethod : infoConv.findOpMethods(sMethod, sOp, 1)) {
                TypeConstant[] aRets = idMethod.getRawReturns();
                if (aRets.length < 2 || !this.isAssignable(ctx, aRets[0], atypeRequired[0]) || !this.isAssignable(ctx, aRets[1], atypeRequired[1])) continue;
                return Expression.TypeFit.Conv;
            }
        }
        return Expression.TypeFit.NoFit;
    }

    @Override
    protected Expression validateMulti(Context ctx, TypeConstant[] atypeRequired, ErrorListener errs) {
        int cExpected;
        Expression exprType;
        TypeConstant typeRequired = atypeRequired != null && atypeRequired.length >= 1 ? atypeRequired[0] : null;
        ctx = ctx.enter();
        if (typeRequired != null && typeRequired.isTypeOfType() && (exprType = this.validateAsType(ctx, typeRequired, errs)) != null) {
            ctx.exit();
            return exprType;
        }
        TypeConstant type1Req = this.guessLeftType(ctx, typeRequired);
        Expression expr1Copy = null;
        if (type1Req == null) {
            expr1Copy = (Expression)this.expr1.clone();
        }
        boolean fValid = true;
        Expression expr1New = this.expr1.validate(ctx, type1Req, errs);
        TypeConstant type1Act = null;
        if (expr1New == null) {
            fValid = false;
        } else {
            this.expr1 = expr1New;
            type1Act = expr1New.getType();
        }
        TypeConstant type2Req = this.selectRightType(ctx, typeRequired, type1Act);
        if (type2Req == null && type1Req != null) {
            type1Act = type1Req;
            type2Req = this.selectRightType(ctx, typeRequired, type1Act);
        }
        Expression expr2New = this.expr2.validate(ctx, type2Req, errs);
        TypeConstant type2Act = null;
        if (expr2New == null) {
            fValid = false;
        } else {
            this.expr2 = expr2New;
            type2Act = expr2New.getType();
        }
        ctx = ctx.exit();
        if (!fValid) {
            return null;
        }
        if (type1Act == null || type2Act == null) {
            (type1Act == null ? expr1New : expr2New).log(errs, Severity.ERROR, "COMPILER-41", new Object[0]);
            return null;
        }
        boolean fMulti = this.operator.getId() == Token.Id.DIVREM;
        int cResults = cExpected = fMulti ? 2 : 1;
        TypeConstant[] atypeResults = null;
        ErrorListener errsAct = errs.branch(this);
        MethodConstant idOp = this.findOpMethod(type1Act, type2Act, typeRequired, errsAct);
        if (idOp == null) {
            ErrorListener errsAlt;
            if ((type1Act.containsFormalType(true) || type2Act.containsFormalType(true)) && (idOp = this.findOpMethod(type1Act = type1Act.resolveConstraints(), type2Act = type2Act.resolveConstraints(), typeRequired, errsAlt = errs.branch(this))) != null) {
                errsAct = errsAlt;
            } else if (type1Req == null && !Objects.equals(type1Act, type2Act) && new StageMgr(expr1Copy, Compiler.Stage.Validated, errsAlt = errs.branch(this)).fastForward(20) && (expr1New = expr1Copy.validate(ctx, type2Act, errsAlt)) != null && (idOp = this.findOpMethod(type1Act = expr1New.getType(), type2Act, typeRequired, errsAlt)) != null) {
                this.expr1.discard(true);
                this.expr1 = expr1New;
                expr1Copy = null;
                errsAct = errsAlt;
            }
        }
        if (expr1Copy != null) {
            expr1Copy.discard(true);
        }
        errsAct.merge();
        if (idOp != null) {
            SignatureConstant sig = idOp.getSignature();
            if (sig.containsAutoNarrowing(false)) {
                sig = sig.resolveAutoNarrowing(this.pool(), typeRequired, null);
            }
            atypeResults = sig.getRawReturns();
            cResults = atypeResults.length;
        }
        if (idOp == null || cResults < cExpected) {
            TypeConstant[] typeConstantArray;
            if (cResults < cExpected) {
                this.operator.log(errs, this.getSource(), Severity.ERROR, "COMPILER-44", cExpected, cResults);
            }
            if (fMulti) {
                TypeConstant[] typeConstantArray2 = new TypeConstant[2];
                typeConstantArray2[0] = type1Act;
                typeConstantArray = typeConstantArray2;
                typeConstantArray2[1] = type2Act;
            } else {
                TypeConstant[] typeConstantArray3 = new TypeConstant[1];
                typeConstantArray = typeConstantArray3;
                typeConstantArray3[0] = type1Act;
            }
            TypeConstant[] atypeFake = typeConstantArray;
            return this.finishValidations(ctx, atypeRequired, atypeFake, Expression.TypeFit.NoFit, null, errs);
        }
        this.m_idOp = idOp;
        if (this.operator.getId() == Token.Id.COND_XOR && atypeResults != null && atypeResults.length > 0 && !atypeResults[0].equals(this.pool().typeBoolean())) {
            this.operator.log(errs, this.getSource(), Severity.ERROR, "COMPILER-67", this.operator.getValueText(), atypeResults[0].getValueString());
            return null;
        }
        Constant[] aconstResult = null;
        if (expr1New.isConstant() && expr2New.isConstant()) {
            try {
                Constant[] constantArray;
                Constant constResult = expr1New.toConstant().apply(this.operator.getId(), expr2New.toConstant());
                if (fMulti) {
                    constantArray = ((ArrayConstant)constResult).getValue();
                } else {
                    Constant[] constantArray2 = new Constant[1];
                    constantArray = constantArray2;
                    constantArray2[0] = constResult;
                }
                aconstResult = constantArray;
            }
            catch (ArithmeticException e) {
                this.log(errs, Severity.ERROR, "COMPILER-45", typeRequired, this);
                return null;
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
        return this.finishValidations(ctx, atypeRequired, atypeResults, Expression.TypeFit.Fit, aconstResult, errs);
    }

    private TypeConstant guessLeftType(Context ctx, TypeConstant typeRequired) {
        if (typeRequired == null) {
            return null;
        }
        String sMethod = this.getDefaultMethodName();
        String sOp = this.operator.getId().TEXT;
        if (this.expr1.testFit(ctx, typeRequired, false, null).isFit()) {
            Set<MethodConstant> setOps = typeRequired.ensureTypeInfo().findOpMethods(sMethod, sOp, 1);
            for (MethodConstant idMethod : setOps) {
                if (!this.expr2.testFit(ctx, idMethod.getRawParams()[0], false, null).isFit()) continue;
                TypeConstant typeReturn = idMethod.getRawReturns()[0];
                if (typeReturn.containsAutoNarrowing(false)) {
                    typeReturn = typeReturn.resolveAutoNarrowing(this.pool(), true, typeRequired, null);
                }
                if (!this.isAssignable(ctx, typeReturn, typeRequired)) continue;
                return typeRequired;
            }
        }
        if (typeRequired.isParamsSpecified()) {
            for (TypeConstant typeParam : typeRequired.getParamTypesArray()) {
                if (!this.expr1.testFit(ctx, typeParam, false, null).isFit()) continue;
                Set<MethodConstant> setOps = typeParam.ensureTypeInfo().findOpMethods(sMethod, sOp, 1);
                for (MethodConstant idMethod : setOps) {
                    if (!this.expr2.testFit(ctx, idMethod.getRawParams()[0], false, null).isFit()) continue;
                    TypeConstant typeReturn = idMethod.getRawReturns()[0];
                    if (typeReturn.containsAutoNarrowing(false)) {
                        typeReturn = typeReturn.resolveAutoNarrowing(this.pool(), false, typeRequired, null);
                    }
                    if (!this.isAssignable(ctx, typeReturn, typeRequired)) continue;
                    return typeParam;
                }
            }
        }
        return null;
    }

    private TypeConstant selectRightType(Context ctx, TypeConstant typeRequired, TypeConstant typeLeft) {
        if (typeLeft == null) {
            return null;
        }
        Set<MethodConstant> setOps = typeLeft.ensureTypeInfo().findOpMethods(this.getDefaultMethodName(), this.operator.getId().TEXT, 1);
        if (!setOps.isEmpty()) {
            TypeConstant typeBest = null;
            Expression.TypeFit fitBest = Expression.TypeFit.NoFit;
            for (MethodConstant idMethod : setOps) {
                TypeConstant typeParam;
                Expression.TypeFit fit;
                if (typeRequired != null) {
                    TypeConstant typeReturn = idMethod.getRawReturns()[0];
                    if (typeReturn.containsAutoNarrowing(false)) {
                        typeReturn = typeReturn.resolveAutoNarrowing(this.pool(), true, typeRequired, null);
                    }
                    if (!this.isAssignable(ctx, typeReturn, typeRequired)) continue;
                }
                if (!(fit = this.expr2.testFit(ctx, typeParam = idMethod.getRawParams()[0], false, null)).isFit()) {
                    fit = this.expr2.testFitExhaustive(ctx, typeParam, null);
                }
                if (fit.betterThan(fitBest)) {
                    typeBest = typeParam;
                    fitBest = fit;
                    continue;
                }
                if (!fit.isFit() || typeParam.equals(typeBest)) continue;
                assert (typeBest != null);
                if (fit.isConverting()) {
                    if (typeParam.ensureTypeInfo().findConversion(typeBest) == null) continue;
                    typeBest = typeParam;
                    continue;
                }
                if (!typeParam.isA(typeBest)) continue;
                typeBest = typeParam;
            }
            return typeBest;
        }
        return null;
    }

    private MethodConstant findOpMethod(TypeConstant type1, TypeConstant type2, TypeConstant typeRequired, ErrorListener errs) {
        MethodConstant idBest = null;
        HashSet<MethodConstant> setOps = null;
        MethodConstant idConv = null;
        HashSet<MethodConstant> setConvs = null;
        TypeInfo info1 = type1.ensureTypeInfo(errs);
        String sMethod = this.getDefaultMethodName();
        String sOp = this.operator.getId().TEXT;
        for (MethodConstant method : info1.findOpMethods(sMethod, sOp, 1)) {
            TypeConstant typeParam = method.getRawParams()[0];
            TypeConstant typeReturn = method.getRawReturns()[0];
            if (typeReturn.containsAutoNarrowing(false)) {
                typeReturn = typeReturn.resolveAutoNarrowing(this.pool(), true, typeRequired, null);
            }
            if (!type2.isAssignableTo(typeParam) || typeRequired != null && !typeReturn.isAssignableTo(typeRequired)) continue;
            if (type2.isA(typeParam) && (typeRequired == null || typeReturn.isA(typeRequired))) {
                SignatureConstant sigMethod;
                if (setOps != null) {
                    setOps.add(method);
                    continue;
                }
                if (idBest == null) {
                    idBest = method;
                    continue;
                }
                SignatureConstant sigOp = idBest.getSignature();
                if (sigOp.equals(sigMethod = method.getSignature()) || sigMethod.isSubstitutableFor(sigOp, type1)) continue;
                if (sigOp.isSubstitutableFor(sigMethod, type1)) {
                    idBest = method;
                    continue;
                }
                setOps = new HashSet<MethodConstant>();
                setOps.add(idBest);
                setOps.add(method);
                idBest = null;
                continue;
            }
            if (setConvs != null) {
                setConvs.add(method);
                continue;
            }
            if (idConv == null) {
                idConv = method;
                continue;
            }
            if (idConv.getSignature().equals(method.getSignature())) continue;
            setConvs = new HashSet<MethodConstant>();
            setConvs.add(idConv);
            setConvs.add(method);
            idConv = null;
        }
        if (idBest != null) {
            return idBest;
        }
        if (setOps != null) {
            idBest = RelOpExpression.chooseBestMethod(setOps, type2);
            if (idBest == null) {
                this.operator.log(errs, this.getSource(), Severity.ERROR, "COMPILER-69", sOp, type1.getValueString());
            }
            return idBest;
        }
        if (idConv != null) {
            return idConv;
        }
        if (setConvs != null) {
            idBest = RelOpExpression.chooseBestMethod(setConvs, type2);
            if (idBest == null) {
                this.operator.log(errs, this.getSource(), Severity.ERROR, "COMPILER-69", sOp, type1.getValueString());
            }
            return idBest;
        }
        this.operator.log(errs, this.getSource(), Severity.ERROR, "COMPILER-50", type1.removeImmutable().removeAccess().getValueString(), type2.removeImmutable().removeAccess().getValueString(), typeRequired == null ? type1.getValueString() : typeRequired.getValueString());
        return null;
    }

    public static MethodConstant chooseBestMethod(Set<MethodConstant> setOps, TypeConstant typeActual) {
        MethodConstant idBest = null;
        for (MethodConstant idMethod : setOps) {
            TypeConstant typeParam = idMethod.getRawParams()[0];
            if (typeActual.equals(typeParam)) {
                return idMethod;
            }
            if (!typeActual.isA(typeParam)) continue;
            if (idBest == null) {
                idBest = idMethod;
                continue;
            }
            return null;
        }
        return idBest;
    }

    @Override
    public boolean isCompletable() {
        return this.expr1.isCompletable() && this.expr2.isCompletable();
    }

    @Override
    public boolean isRuntimeConstant() {
        return super.isRuntimeConstant() || this.expr1.isRuntimeConstant() && this.expr2.isRuntimeConstant();
    }

    @Override
    public void generateAssignment(Context ctx, MethodStructure.Code code, Expression.Assignable LVal, ErrorListener errs) {
        if (!LVal.isLocalArgument()) {
            super.generateAssignment(ctx, code, LVal, errs);
            return;
        }
        Argument argLVal = LVal.getLocalArgument();
        Argument arg1 = this.expr1.ensurePointInTime(code, this.expr1.generateArgument(ctx, code, true, true, errs), this.expr2);
        Argument arg2 = this.expr2.generateArgument(ctx, code, true, true, errs);
        switch (this.operator.getId()) {
            case BIT_OR: {
                code.add(new GP_Or(arg1, arg2, argLVal));
                return;
            }
            case COND_XOR: 
            case BIT_XOR: {
                code.add(new GP_Xor(arg1, arg2, argLVal));
                return;
            }
            case BIT_AND: {
                code.add(new GP_And(arg1, arg2, argLVal));
                return;
            }
            case I_RANGE_I: {
                code.add(new GP_IRangeI(arg1, arg2, argLVal));
                return;
            }
            case E_RANGE_I: {
                code.add(new GP_ERangeI(arg1, arg2, argLVal));
                return;
            }
            case I_RANGE_E: {
                code.add(new GP_IRangeE(arg1, arg2, argLVal));
                return;
            }
            case E_RANGE_E: {
                code.add(new GP_ERangeE(arg1, arg2, argLVal));
                return;
            }
            case SHL: {
                code.add(new GP_Shl(arg1, arg2, argLVal));
                return;
            }
            case SHR: {
                code.add(new GP_Shr(arg1, arg2, argLVal));
                return;
            }
            case USHR: {
                code.add(new GP_ShrAll(arg1, arg2, argLVal));
                return;
            }
            case ADD: {
                code.add(new GP_Add(arg1, arg2, argLVal));
                return;
            }
            case SUB: {
                code.add(new GP_Sub(arg1, arg2, argLVal));
                return;
            }
            case MUL: {
                code.add(new GP_Mul(arg1, arg2, argLVal));
                return;
            }
            case DIVREM: {
                code.add(new GP_DivRem(arg1, arg2, new Argument[]{argLVal, this.generateBlackHole(null)}));
                return;
            }
            case DIV: {
                code.add(new GP_Div(arg1, arg2, argLVal));
                return;
            }
            case MOD: {
                code.add(new GP_Mod(arg1, arg2, argLVal));
                return;
            }
        }
        throw new IllegalStateException();
    }

    @Override
    public void generateAssignments(Context ctx, MethodStructure.Code code, Expression.Assignable[] aLVal, ErrorListener errs) {
        switch (aLVal.length) {
            default: {
                throw new IllegalStateException();
            }
            case 2: {
                if (this.operator.getId() != Token.Id.DIVREM) {
                    throw new IllegalStateException();
                }
                if (aLVal[0].isLocalArgument() && aLVal[1].isLocalArgument()) {
                    Argument arg1 = this.expr1.ensurePointInTime(code, this.expr1.generateArgument(ctx, code, true, true, errs), this.expr2);
                    Argument arg2 = this.expr2.generateArgument(ctx, code, true, true, errs);
                    code.add(new GP_DivRem(arg1, arg2, new Argument[]{aLVal[0].getLocalArgument(), aLVal[1].getLocalArgument()}));
                    break;
                }
                super.generateAssignments(ctx, code, aLVal, errs);
                break;
            }
            case 1: {
                this.generateAssignment(ctx, code, aLVal[0], errs);
                break;
            }
            case 0: {
                this.generateAssignment(ctx, code, new Expression.Assignable(), errs);
            }
        }
    }

    @Override
    public ExprAST getExprAST(Context ctx) {
        ExprAST ast1 = this.expr1.getExprAST(ctx);
        ExprAST ast2 = this.expr2.getExprAST(ctx);
        return new InvokeExprAST(this.m_idOp, this.getTypes(), ast1, new ExprAST[]{ast2}, false);
    }

    public boolean isRange() {
        return switch (this.operator.getId()) {
            case Token.Id.I_RANGE_I, Token.Id.E_RANGE_I, Token.Id.I_RANGE_E, Token.Id.E_RANGE_E -> true;
            default -> false;
        };
    }

    public String getDefaultMethodName() {
        return switch (this.operator.getId()) {
            case Token.Id.BIT_AND -> "and";
            case Token.Id.BIT_OR -> "or";
            case Token.Id.COND_XOR, Token.Id.BIT_XOR -> "xor";
            case Token.Id.I_RANGE_I -> "to";
            case Token.Id.E_RANGE_I -> "exTo";
            case Token.Id.I_RANGE_E -> "toEx";
            case Token.Id.E_RANGE_E -> "exToEx";
            case Token.Id.SHL -> "shiftLeft";
            case Token.Id.SHR -> "shiftRight";
            case Token.Id.USHR -> "shiftAllRight";
            case Token.Id.ADD -> "add";
            case Token.Id.SUB -> "sub";
            case Token.Id.MUL -> "mul";
            case Token.Id.DIV -> "div";
            case Token.Id.MOD -> "mod";
            case Token.Id.DIVREM -> "divrem";
            default -> throw new IllegalStateException();
        };
    }

    @Override
    public String toString() {
        return this.f_tokBefore == null || this.f_tokAfter == null ? super.toString() : this.f_tokBefore.getId().TEXT + super.toString() + this.f_tokAfter.getId().TEXT;
    }
}

