/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.compiler.ast;

import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.List;
import org.xvm.asm.Argument;
import org.xvm.asm.Constant;
import org.xvm.asm.ConstantPool;
import org.xvm.asm.ErrorListener;
import org.xvm.asm.MethodStructure;
import org.xvm.asm.Register;
import org.xvm.asm.ast.ExprAST;
import org.xvm.asm.ast.ReturnStmtAST;
import org.xvm.asm.ast.UnpackExprAST;
import org.xvm.asm.constants.EnumValueConstant;
import org.xvm.asm.constants.SingletonConstant;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.asm.op.Jump;
import org.xvm.asm.op.JumpFalse;
import org.xvm.asm.op.Label;
import org.xvm.asm.op.Move;
import org.xvm.asm.op.Return_0;
import org.xvm.asm.op.Return_1;
import org.xvm.asm.op.Return_N;
import org.xvm.asm.op.Return_T;
import org.xvm.asm.op.Var_D;
import org.xvm.compiler.Token;
import org.xvm.compiler.ast.AstNode;
import org.xvm.compiler.ast.Context;
import org.xvm.compiler.ast.Expression;
import org.xvm.compiler.ast.InvocationExpression;
import org.xvm.compiler.ast.NameExpression;
import org.xvm.compiler.ast.Statement;
import org.xvm.compiler.ast.StatementExpression;
import org.xvm.compiler.ast.TernaryExpression;
import org.xvm.compiler.ast.TupleExpression;
import org.xvm.util.Severity;

public class ReturnStatement
extends Statement {
    protected Token keyword;
    protected List<Expression> exprs;
    protected transient boolean m_fConditionalTernary;
    protected transient boolean m_fTupleReturn;
    protected transient boolean m_fFutureReturn;
    private static final Field[] CHILD_FIELDS = ReturnStatement.fieldsForNames(ReturnStatement.class, "exprs");

    public ReturnStatement(Token keyword) {
        this(keyword, (List<Expression>)null);
    }

    public ReturnStatement(Token keyword, Expression expr) {
        this(keyword, Arrays.asList(expr));
    }

    public ReturnStatement(Token keyword, List<Expression> exprs) {
        this.keyword = keyword;
        this.exprs = exprs;
    }

    public List<Expression> getExpressions() {
        return this.exprs;
    }

    @Override
    public long getStartPosition() {
        return this.keyword.getStartPosition();
    }

    @Override
    public long getEndPosition() {
        return this.exprs == null ? this.keyword.getEndPosition() : this.exprs.get(this.exprs.size() - 1).getEndPosition();
    }

    @Override
    protected Field[] getChildFields() {
        return CHILD_FIELDS;
    }

    @Override
    protected boolean allowsConditional(Expression exprChild) {
        if (this.exprs.size() > 1) {
            return false;
        }
        AstNode container = this.getCodeContainer();
        if (container.isReturnConditional()) {
            return true;
        }
        TypeConstant[] atypeRet = container.getReturnTypes();
        int cRets = atypeRet == null ? 0 : atypeRet.length;
        return switch (cRets) {
            case 0 -> true;
            case 1 -> atypeRet[0].equals(this.pool().typeBoolean());
            default -> false;
        };
    }

    @Override
    protected boolean allowsShortCircuit(AstNode nodeChild) {
        return true;
    }

    @Override
    protected Statement validateImpl(Context ctx, ErrorListener errs) {
        ConstantPool pool = this.pool();
        boolean fValid = true;
        AstNode container = this.getCodeContainer();
        TypeConstant[] aRetTypes = container.getReturnTypes();
        boolean fConditional = container.isReturnConditional();
        int cRets = aRetTypes == null ? -1 : aRetTypes.length;
        List<Expression> listExprs = this.exprs;
        int cExprs = listExprs == null ? 0 : listExprs.size();
        TypeConstant[] atypeActual = null;
        boolean fClone = true;
        for (int i = 0; i < cRets; ++i) {
            TypeConstant typeRet = aRetTypes[i];
            if (!typeRet.containsAutoNarrowing(false)) continue;
            if (fClone) {
                aRetTypes = (TypeConstant[])aRetTypes.clone();
                fClone = false;
            }
            aRetTypes[i] = typeRet.resolveAutoNarrowing(pool, false, ctx.getThisType(), null);
        }
        if (cExprs == 0 || cRets == 0) {
            atypeActual = TypeConstant.NO_TYPES;
            if (cExprs > 0) {
                atypeActual = this.validateExpressions(ctx, listExprs, null, errs);
                boolean bl = fValid = atypeActual != null;
                if (fValid) {
                    if (cExprs == 1) {
                        Expression expr = listExprs.get(0);
                        if (expr.isCompletable() && !expr.isVoid() && !(expr instanceof InvocationExpression)) {
                            TupleExpression exprTuple;
                            NameExpression exprName;
                            if (expr instanceof NameExpression && (exprName = (NameExpression)expr).isDynamicVar() && expr.getType().isTuple()) {
                                this.m_fFutureReturn = true;
                            } else if (expr instanceof TupleExpression && (exprTuple = (TupleExpression)expr).getExpressions().isEmpty() && exprTuple.getType().isImmutable()) {
                                this.m_fTupleReturn = true;
                            } else {
                                this.log(errs, Severity.ERROR, "COMPILER-40", new Object[0]);
                                fValid = false;
                            }
                        }
                    } else {
                        this.log(errs, Severity.ERROR, "COMPILER-42", cRets, cExprs);
                        fValid = false;
                    }
                }
            } else if (cRets > 0) {
                this.log(errs, Severity.ERROR, "COMPILER-41", new Object[0]);
                fValid = false;
            }
        } else if (cExprs > 1) {
            atypeActual = this.validateExpressions(ctx, listExprs, aRetTypes, errs);
            boolean bl = fValid = atypeActual != null;
            if (cRets >= 0 && cExprs != cRets) {
                this.log(errs, Severity.ERROR, "COMPILER-42", cRets, cExprs);
            }
        } else {
            TypeConstant typeFuture;
            Expression exprNew;
            TypeConstant typeRequired;
            Expression exprOld = listExprs.get(0);
            TypeConstant typeConstant = typeRequired = cRets >= 1 ? aRetTypes[0] : null;
            if (fConditional && exprOld instanceof TernaryExpression) {
                this.m_fConditionalTernary = true;
                exprOld.markConditional();
                TypeConstant typeConstant2 = typeRequired = cRets == 2 ? aRetTypes[1] : null;
            }
            if (typeRequired != null) {
                ctx = ctx.enterInferring(typeRequired);
            }
            if (cRets < 0 || exprOld.testFitMulti(ctx, aRetTypes, false, null).isFit()) {
                exprNew = exprOld.validateMulti(ctx, aRetTypes, errs);
            } else if (fConditional && exprOld.testFit(ctx, pool.typeFalse(), false, null).isFit()) {
                exprNew = exprOld.validate(ctx, pool.typeFalse(), errs);
                if (!(exprNew == null || exprNew.isConstant() && exprNew.toConstant().equals(pool.valFalse()))) {
                    this.log(errs, Severity.ERROR, "COMPILER-47", new Object[0]);
                    fValid = false;
                }
            } else if (cRets == 1 && exprOld.testFit(ctx, typeFuture = pool.ensureFuture(aRetTypes[0]), false, null).isFit()) {
                exprNew = exprOld.validate(ctx, typeFuture, errs);
                this.m_fFutureReturn = true;
            } else {
                TypeConstant typeTuple = pool.ensureTupleType(aRetTypes);
                if (exprOld.testFit(ctx, typeTuple, false, null).isFit()) {
                    exprNew = exprOld.validate(ctx, typeTuple, errs);
                    this.m_fTupleReturn = true;
                } else {
                    exprNew = exprOld.validateMulti(ctx, aRetTypes, errs);
                }
            }
            if (typeRequired != null) {
                ctx = ctx.exit();
            }
            if (exprNew != exprOld) {
                fValid &= exprNew != null;
                if (exprNew != null) {
                    listExprs.set(0, exprNew);
                }
            }
            if (fValid) {
                atypeActual = this.m_fTupleReturn ? exprNew.getType().getParamTypesArray() : exprNew.getTypes();
            }
        }
        ctx.setReachable(false);
        if (fValid) {
            container.collectReturnTypes(atypeActual);
            return this;
        }
        return null;
    }

    @Override
    protected boolean emit(Context ctx, boolean fReachable, MethodStructure.Code code, ErrorListener errs) {
        ReturnStmtAST astResult;
        int cExprs;
        AstNode container = this.getCodeContainer();
        boolean fConditional = container.isReturnConditional();
        if (container instanceof StatementExpression) {
            int cExprs2;
            StatementExpression exprStmt = (StatementExpression)container;
            assert (!fConditional);
            Expression.Assignable[] aLVal = exprStmt.getAssignables();
            int cLVals = aLVal.length;
            ExprAST[] aAst = new ExprAST[cLVals];
            int n = cExprs2 = this.exprs == null ? 0 : this.exprs.size();
            for (int i = 0; i < cExprs2; ++i) {
                Expression expr = this.exprs.get(i);
                if (i < cLVals) {
                    expr.generateAssignment(ctx, code, aLVal[i], errs);
                } else {
                    expr.generateVoid(ctx, code, errs);
                }
                aAst[i] = expr.getExprAST(ctx);
            }
            code.add(new Jump(exprStmt.body.getEndLabel()));
            ctx.getHolder().setAst(this, new ReturnStmtAST(aAst));
            return false;
        }
        ConstantPool pool = this.pool();
        TypeConstant[] atypeRets = container.getReturnTypes();
        int cRets = atypeRets == null ? 0 : atypeRets.length;
        List<Expression> listExprs = this.exprs;
        int n = cExprs = listExprs == null ? 0 : listExprs.size();
        if (this.m_fTupleReturn) {
            assert (cExprs == 1);
            Expression expr = listExprs.get(0);
            Argument arg = expr.generateArgument(ctx, code, true, true, errs);
            code.add(new Return_T(arg));
            astResult = new ReturnStmtAST(new ExprAST[]{new UnpackExprAST(expr.getExprAST(ctx), atypeRets == null ? TypeConstant.NO_TYPES : atypeRets)});
        } else if (this.m_fConditionalTernary) {
            TernaryExpression exprTernary = (TernaryExpression)listExprs.get(0);
            exprTernary.generateConditionalReturn(ctx, code, errs);
            astResult = new ReturnStmtAST(exprTernary.getExprAST(ctx));
        } else {
            switch (cExprs) {
                case 0: {
                    code.add(new Return_0());
                    astResult = new ReturnStmtAST(ExprAST.NO_EXPRS);
                    break;
                }
                case 1: {
                    Expression expr = listExprs.get(0);
                    boolean fCheck = fConditional && !expr.isConditionalResult();
                    Argument[] aArgs = expr.generateArguments(ctx, code, true, !fCheck, errs);
                    int cArgs = aArgs.length;
                    switch (cRets) {
                        case 0: {
                            if (this.m_fFutureReturn) {
                                code.add(new Return_1(aArgs[0]));
                                break;
                            }
                            code.add(new Return_0());
                            break;
                        }
                        case 1: {
                            Argument argRet = aArgs[0];
                            if (this.m_fFutureReturn) {
                                Register regFuture = code.createRegister(pool.ensureFuture(argRet.getType().getParamType(0)));
                                code.add(new Var_D(regFuture));
                                code.add(new Move(argRet, regFuture));
                                code.add(new Return_1(regFuture));
                                break;
                            }
                            code.add(new Return_1(argRet));
                            break;
                        }
                        default: {
                            if (cArgs > 1) {
                                Label labelFalse;
                                Label label = labelFalse = fCheck ? new Label("false") : null;
                                if (fCheck) {
                                    code.add(new JumpFalse(aArgs[0], labelFalse));
                                }
                                if (cArgs == cRets) {
                                    code.add(new Return_N(aArgs));
                                } else {
                                    code.add(new Return_N(Arrays.copyOfRange(aArgs, 0, cRets)));
                                }
                                if (!fCheck) break;
                                code.add(labelFalse);
                                code.add(new Return_1(pool.valFalse()));
                                break;
                            }
                            assert (fConditional);
                            SingletonConstant valFalse = this.pool().valFalse();
                            if (expr.isConstant() && expr.toConstant().equals(valFalse)) {
                                code.add(new Return_1(valFalse));
                                break;
                            }
                            this.log(errs, Severity.ERROR, "COMPILER-43", ((Constant)valFalse).getValueString(), expr.getType().getValueString());
                        }
                    }
                    astResult = new ReturnStmtAST(new ExprAST[]{expr.getExprAST(ctx)});
                    break;
                }
                default: {
                    Object expr;
                    assert (cRets == cExprs);
                    Argument[] aArgs = new Argument[cRets];
                    ExprAST[] aASTs = new ExprAST[cRets];
                    for (int i = 0; i < cRets; ++i) {
                        expr = listExprs.get(i);
                        Argument arg = ((Expression)expr).generateArgument(ctx, code, true, !fConditional || i > 0, errs);
                        aArgs[i] = ((Expression)expr).ensurePointInTime(code, arg, listExprs, i);
                        aASTs[i] = ((Expression)expr).getExprAST(ctx);
                    }
                    if (fConditional && (expr = aArgs[0]) instanceof EnumValueConstant) {
                        EnumValueConstant enumValue = (EnumValueConstant)expr;
                        if (enumValue.equals(pool.valTrue())) {
                            code.add(new Return_N(aArgs));
                        } else {
                            code.add(new Return_1(pool.valFalse()));
                        }
                    } else {
                        Label labelFalse;
                        Label label = labelFalse = fConditional ? new Label("false") : null;
                        if (fConditional) {
                            code.add(new JumpFalse(aArgs[0], labelFalse));
                        }
                        code.add(new Return_N(aArgs));
                        if (fConditional) {
                            code.add(labelFalse);
                            code.add(new Return_1(pool.valFalse()));
                        }
                    }
                    astResult = new ReturnStmtAST(aASTs);
                    break;
                }
            }
        }
        ctx.getHolder().setAst(this, astResult);
        return false;
    }

    @Override
    public boolean isCompletable() {
        return this.exprs != null && this.exprs.stream().anyMatch(Expression::isShortCircuiting);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("return");
        if (this.exprs != null) {
            switch (this.exprs.size()) {
                case 0: {
                    break;
                }
                case 1: {
                    sb.append(' ').append(this.exprs.get(0));
                    break;
                }
                default: {
                    boolean first = true;
                    for (Expression expr : this.exprs) {
                        if (first) {
                            first = false;
                            sb.append(" ");
                        } else {
                            sb.append(", ");
                        }
                        sb.append(expr);
                    }
                }
            }
        }
        sb.append(';');
        return sb.toString();
    }

    @Override
    public String getDumpDesc() {
        return this.toString();
    }
}

