/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.compiler.ast;

import java.util.Map;
import org.xvm.asm.Argument;
import org.xvm.asm.ErrorListener;
import org.xvm.asm.MethodStructure;
import org.xvm.asm.PropertyStructure;
import org.xvm.asm.ast.ExprAST;
import org.xvm.asm.ast.InvokeExprAST;
import org.xvm.asm.ast.UnaryOpExprAST;
import org.xvm.asm.constants.MethodConstant;
import org.xvm.asm.constants.PropertyConstant;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.compiler.Token;
import org.xvm.compiler.ast.Context;
import org.xvm.compiler.ast.Expression;
import org.xvm.compiler.ast.NameExpression;
import org.xvm.compiler.ast.PrefixExpression;

public class SequentialAssignExpression
extends PrefixExpression {
    private final boolean m_fPre;
    private transient Expression.Assignable m_LValTarget;

    public SequentialAssignExpression(Token operator, Expression expr) {
        super(operator, expr);
        assert (operator.getId() == Token.Id.INC || operator.getId() == Token.Id.DEC);
        this.m_fPre = true;
    }

    public SequentialAssignExpression(Expression expr, Token operator) {
        super(operator, expr);
        assert (operator.getId() == Token.Id.INC || operator.getId() == Token.Id.DEC);
        this.m_fPre = false;
    }

    public boolean isPre() {
        return this.m_fPre;
    }

    public boolean isInc() {
        return this.operator.getId() == Token.Id.INC;
    }

    protected Expression.Sequential getSeq() {
        return this.isInc() ? (this.isPre() ? Expression.Sequential.PreInc : Expression.Sequential.PostInc) : (this.isPre() ? Expression.Sequential.PreDec : Expression.Sequential.PostDec);
    }

    @Override
    public TypeConstant getImplicitType(Context ctx) {
        return this.expr.getImplicitType(ctx);
    }

    @Override
    protected Expression validate(Context ctx, TypeConstant typeRequired, ErrorListener errs) {
        Expression.TypeFit fit = Expression.TypeFit.Fit;
        TypeConstant type = null;
        TypeConstant typeSequential = this.pool().typeSequential();
        TypeConstant typeRequest = typeRequired != null && typeRequired.isA(typeSequential) ? typeRequired : typeSequential;
        Expression exprNew = this.expr.validate(ctx, typeRequest, errs);
        if (exprNew == null) {
            fit = Expression.TypeFit.NoFit;
        } else {
            this.expr = exprNew;
            type = exprNew.getType();
            exprNew.requireAssignable(ctx, errs);
            exprNew.markAssignment(ctx, false, errs);
        }
        return this.finishValidation(ctx, typeRequired, type, fit, null, errs);
    }

    @Override
    public boolean isStandalone() {
        return true;
    }

    private Expression.Assignable ensureTarget(Context ctx, MethodStructure.Code code, ErrorListener errs) {
        Expression.Assignable LVal = this.m_LValTarget;
        if (LVal == null) {
            this.m_LValTarget = LVal = this.expr.generateAssignable(ctx, code, errs);
            assert (LVal.getForm() != Expression.AssignForm.BlackHole);
        }
        return LVal;
    }

    @Override
    public void generateVoid(Context ctx, MethodStructure.Code code, ErrorListener errs) {
        Expression.Assignable LValTarget = this.ensureTarget(ctx, code, errs);
        LValTarget.assignSequential(this.isInc() ? Expression.Sequential.Inc : Expression.Sequential.Dec, null, false, code, errs);
    }

    @Override
    public Argument generateArgument(Context ctx, MethodStructure.Code code, boolean fLocalPropOk, boolean fUsedOnce, ErrorListener errs) {
        Expression.Assignable LValTarget = this.ensureTarget(ctx, code, errs);
        return LValTarget.assignSequential(this.getSeq(), null, fUsedOnce, code, errs);
    }

    @Override
    public void generateAssignment(Context ctx, MethodStructure.Code code, Expression.Assignable LVal, ErrorListener errs) {
        Expression.Assignable LValTarget = this.ensureTarget(ctx, code, errs);
        LValTarget.assignSequential(this.getSeq(), LVal, false, code, errs);
    }

    @Override
    public boolean isTraceworthy() {
        return true;
    }

    @Override
    protected Expression.SideEffect mightAffect(Expression exprLeft, Argument arg) {
        return switch (this.expr.mightAffect(exprLeft, arg)) {
            case Expression.SideEffect.AnySeqOp, Expression.SideEffect.DefYes -> Expression.SideEffect.DefYes;
            default -> Expression.SideEffect.DefNo;
        };
    }

    @Override
    protected void selectTraceableExpressions(Map<String, Expression> mapExprs) {
    }

    @Override
    public ExprAST getExprAST(Context ctx) {
        PropertyConstant idProp;
        PropertyStructure prop;
        NameExpression exprName;
        UnaryOpExprAST.Operator op = this.isPre() ? (this.isInc() ? UnaryOpExprAST.Operator.PreInc : UnaryOpExprAST.Operator.PreDec) : (this.isInc() ? UnaryOpExprAST.Operator.PostInc : UnaryOpExprAST.Operator.PostDec);
        Expression expression = this.expr;
        if (expression instanceof NameExpression && (exprName = (NameExpression)expression).getMeaning() == NameExpression.Meaning.Property && (prop = (PropertyStructure)(idProp = (PropertyConstant)exprName.resolveRawArgument(ctx, false, ErrorListener.BLACKHOLE)).getComponent()) != null && prop.isAtomic()) {
            String sMethod;
            MethodConstant idOp = exprName.findAtomicInPlaceAssignMethod(ctx, sMethod, switch (op) {
                case UnaryOpExprAST.Operator.PreInc -> {
                    sMethod = "preIncrement";
                    yield "++#";
                }
                case UnaryOpExprAST.Operator.PreDec -> {
                    sMethod = "preDecrement";
                    yield "--#";
                }
                case UnaryOpExprAST.Operator.PostInc -> {
                    sMethod = "postIncrement";
                    yield "#++";
                }
                case UnaryOpExprAST.Operator.PostDec -> {
                    sMethod = "postDecrement";
                    yield "#--";
                }
                default -> throw new IllegalStateException("op=" + String.valueOf((Object)op));
            }, null);
            if (idOp != null) {
                UnaryOpExprAST astVar = new UnaryOpExprAST(this.expr.getExprAST(ctx), UnaryOpExprAST.Operator.Var, idProp.getRefType(null));
                return new InvokeExprAST(idOp, TypeConstant.NO_TYPES, astVar, ExprAST.NO_EXPRS, false);
            }
        }
        return new UnaryOpExprAST(this.expr.getExprAST(ctx), op, this.getType());
    }
}

