/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.compiler.ast;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import org.xvm.asm.Component;
import org.xvm.asm.ErrorListener;
import org.xvm.asm.constants.IdentityConstant;
import org.xvm.compiler.Compiler;
import org.xvm.compiler.ast.AstNode;
import org.xvm.compiler.ast.NameExpression;
import org.xvm.compiler.ast.NamedTypeExpression;
import org.xvm.util.Severity;

public class StageMgr {
    private Compiler.Stage m_target;
    private List<AstNode> m_listRevisit;
    private boolean m_fLastAttempt;
    private final ErrorListener m_errs;
    private AstNode m_cur;
    private byte m_nFlags;
    private AstNode.ChildIterator m_iterKids;
    private static final int QUEUED_SELF = 1;
    private static final int VISITED_KIDS = 2;
    private static final int DEFER_KIDS = 4;

    public StageMgr(AstNode node, Compiler.Stage stageTarget, ErrorListener errs) {
        assert (node != null);
        assert (stageTarget != null && stageTarget.isTargetable());
        this.m_listRevisit = Collections.singletonList(node);
        this.m_target = stageTarget;
        this.m_errs = errs == null ? ErrorListener.BLACKHOLE : errs;
    }

    public StageMgr(List<AstNode> list, Compiler.Stage stageTarget, ErrorListener errs) {
        assert (list != null && !list.isEmpty());
        assert (stageTarget != null && stageTarget.isTargetable());
        this.m_listRevisit = list;
        this.m_target = stageTarget;
        this.m_errs = errs == null ? ErrorListener.BLACKHOLE : errs;
    }

    public boolean isComplete() {
        return this.getErrorListener().isAbortDesired() || this.m_cur == null && this.m_listRevisit == null;
    }

    public boolean processComplete() {
        if (this.getErrorListener().isAbortDesired()) {
            return false;
        }
        if (this.m_listRevisit != null) {
            for (AstNode node : this.takeRevisitList()) {
                this.processInternal(node);
                if (!this.getErrorListener().isAbortDesired()) continue;
                return false;
            }
        }
        return this.m_listRevisit == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean fastForward(int cMaxIters) {
        boolean fDone = false;
        Compiler.Stage stageGoal = this.m_target;
        List<AstNode> listSingle = this.m_listRevisit;
        assert (listSingle.size() == 1);
        try {
            int cIters = 0;
            this.m_target = Compiler.Stage.Registered;
            while (!fDone && cIters <= cMaxIters) {
                this.m_listRevisit = listSingle;
                while (!this.processComplete()) {
                    if (++cIters == cMaxIters) {
                        this.markLastAttempt();
                        continue;
                    }
                    if (cIters <= cMaxIters) continue;
                }
                if (!this.isComplete()) continue;
                if (this.m_target == stageGoal) {
                    fDone = true;
                    break;
                }
                this.m_target = Compiler.Stage.valueOf(this.m_target.ordinal() + 2);
            }
        }
        finally {
            this.m_target = stageGoal;
        }
        return fDone;
    }

    public boolean isLastAttempt() {
        return this.m_fLastAttempt;
    }

    public void markLastAttempt() {
        this.m_fLastAttempt = true;
    }

    public ErrorListener getErrorListener() {
        return this.m_errs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean processInternal(AstNode node) {
        if (this.getErrorListener().isAbortDesired()) {
            return true;
        }
        boolean fDone = true;
        AstNode nodePrev = this.m_cur;
        byte nFlagsPrev = this.m_nFlags;
        try {
            this.m_cur = node;
            this.m_nFlags = 0;
            Compiler.Stage stageCur = node.getStage();
            stageCur.ensureValid();
            Compiler.Stage stageTarget = this.m_target;
            if (stageCur.compareTo(stageTarget) < 0) {
                Compiler.Stage stageRequired = this.requiredStage(stageTarget);
                if (stageCur.compareTo(stageRequired) < 0) {
                    throw new IllegalStateException("current stage=" + String.valueOf((Object)stageCur) + ", target stage=" + String.valueOf((Object)stageTarget) + ", required stage=" + String.valueOf((Object)stageRequired) + ", node=" + node.getDumpDesc());
                }
                node.setStage(stageTarget.getTransitionStage());
                switch (stageTarget) {
                    case Registered: {
                        node.registerStructures(this, this.m_errs);
                        break;
                    }
                    case Loaded: {
                        this.markComplete();
                        boolean bl = true;
                        return bl;
                    }
                    case Resolved: {
                        node.resolveNames(this, this.m_errs);
                        break;
                    }
                    case Validated: {
                        node.validateContent(this, this.m_errs);
                        break;
                    }
                    case Emitted: {
                        node.generateCode(this, this.m_errs);
                        break;
                    }
                    default: {
                        throw new IllegalStateException("unsupported target: " + String.valueOf((Object)stageTarget));
                    }
                }
                if (!this.isChildrenProcessed() && !this.isChildrenDeferred()) {
                    fDone &= this.processChildren();
                }
                if (this.isRevisitRequested()) {
                    fDone = false;
                } else {
                    this.markComplete();
                }
            }
        }
        finally {
            this.m_cur = nodePrev;
            this.m_nFlags = nFlagsPrev;
        }
        return fDone;
    }

    private Compiler.Stage requiredStage(Compiler.Stage target) {
        return switch (target) {
            case Compiler.Stage.Registered -> Compiler.Stage.Initial;
            case Compiler.Stage.Loaded, Compiler.Stage.Resolved -> Compiler.Stage.Registered;
            case Compiler.Stage.Validated -> Compiler.Stage.Resolved;
            case Compiler.Stage.Emitted -> Compiler.Stage.Validated;
            default -> throw new IllegalStateException("unsupported target: " + String.valueOf((Object)target));
        };
    }

    public AstNode ensureCurrentNode() {
        AstNode node = this.m_cur;
        if (node == null) {
            throw new IllegalStateException();
        }
        return node;
    }

    public void replaceSelf(AstNode node) {
        AstNode nodePrev = this.ensureCurrentNode();
        AstNode.ChildIterator iterKids = this.m_iterKids;
        if (iterKids == null) {
            AstNode nodeParent = nodePrev.getParent();
            if (nodeParent == null) {
                throw new IllegalStateException("not a replaceable child: " + nodePrev.getDumpDesc());
            }
            nodeParent.replaceChild(nodePrev, node);
        } else {
            iterKids.replaceWith(node);
        }
    }

    public void requestRevisit() {
        AstNode node = this.ensureCurrentNode();
        if (!this.isRevisitRequested()) {
            List<AstNode> list = this.m_listRevisit;
            if (list == null) {
                this.m_listRevisit = list = new ArrayList<AstNode>();
            }
            list.add(node);
            this.m_nFlags = (byte)(this.m_nFlags | 1);
        }
    }

    public boolean isRevisitRequested() {
        return (this.m_nFlags & 1) != 0;
    }

    public boolean processChildren() {
        return this.processChildrenExcept(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean processChildrenExcept(Predicate<AstNode> exclude) {
        boolean fDone = true;
        AstNode.ChildIterator iterPrev = this.m_iterKids;
        try {
            AstNode.ChildIterator iter;
            AstNode node = this.ensureCurrentNode();
            this.m_iterKids = iter = node.children();
            this.m_nFlags = (byte)(this.m_nFlags | 2);
            while (iter.hasNext()) {
                AstNode nodeChild = (AstNode)iter.next();
                if (exclude != null && exclude.test(nodeChild)) continue;
                fDone &= this.processInternal(nodeChild);
            }
        }
        finally {
            this.m_iterKids = iterPrev;
        }
        return fDone;
    }

    public boolean isChildrenProcessed() {
        return (this.m_nFlags & 2) != 0;
    }

    public void deferChildren() {
        this.m_nFlags = (byte)(this.m_nFlags | 4);
    }

    public boolean isChildrenDeferred() {
        return (this.m_nFlags & 4) != 0;
    }

    public void markComplete() {
        this.ensureCurrentNode().setStage(this.m_target);
    }

    public void logDeferredAsErrors(ErrorListener errs) {
        List<AstNode> listUnresolved = this.takeRevisitList();
        boolean fUnresolvedNames = false;
        for (AstNode node : listUnresolved) {
            if (!(node instanceof NameExpression) && !(node instanceof NamedTypeExpression)) continue;
            fUnresolvedNames = true;
            Component component = node.getComponent();
            IdentityConstant id = component == null ? null : component.getIdentityConstant();
            node.log(errs, Severity.FATAL, "COMPILER-30", id == null ? node.getSource().toString(node.getStartPosition(), node.getEndPosition()) : id.toString());
        }
        if (!fUnresolvedNames) {
            for (AstNode node : listUnresolved) {
                node.log(errs, Severity.FATAL, "COMPILER-30", node.toString());
            }
        }
    }

    private List<AstNode> takeRevisitList() {
        List<AstNode> listPrevious = this.m_listRevisit;
        this.m_listRevisit = null;
        return listPrevious == null ? Collections.emptyList() : listPrevious;
    }
}

