/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.compiler.ast;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.xvm.asm.Argument;
import org.xvm.asm.Assignment;
import org.xvm.asm.ErrorListener;
import org.xvm.asm.MethodStructure;
import org.xvm.asm.ast.BinaryAST;
import org.xvm.asm.op.Label;
import org.xvm.compiler.ast.AstNode;
import org.xvm.compiler.ast.ComponentStatement;
import org.xvm.compiler.ast.Context;
import org.xvm.compiler.ast.ImportStatement;
import org.xvm.compiler.ast.LabeledStatement;

public abstract class Statement
extends AstNode {
    private Label m_labelEnd;
    private transient Context m_ctx;
    private transient List<Break> m_listBreaks;

    @Override
    protected boolean usesSuper() {
        for (AstNode node : this.children()) {
            if (node instanceof ComponentStatement || !node.usesSuper()) continue;
            return true;
        }
        return false;
    }

    public Label getEndLabel() {
        Label label = this.m_labelEnd;
        if (label == null) {
            this.m_labelEnd = label = new Label(this.getCodeContainerCounter());
        }
        return label;
    }

    public boolean isNaturalGotoStatementTarget() {
        return false;
    }

    public Label ensureBreakLabel(AstNode nodeOrigin, Context ctxOrigin) {
        Context ctxDest = this.ensureValidationContext();
        Label label = this.getEndLabel();
        if (ctxOrigin.isReachable()) {
            HashMap<String, Assignment> mapAsn = new HashMap<String, Assignment>();
            HashMap<String, Argument> mapArg = new HashMap<String, Argument>();
            ctxOrigin.prepareJump(ctxDest, mapAsn, mapArg);
            this.addBreak(new Break(nodeOrigin, mapAsn, mapArg, label));
        }
        return label;
    }

    protected void addBreak(Break breakInfo) {
        if (this.m_listBreaks == null) {
            this.m_listBreaks = new ArrayList<Break>();
        }
        this.m_listBreaks.add(breakInfo);
    }

    protected boolean hasBreaks() {
        return this.m_listBreaks != null;
    }

    public Label ensureContinueLabel(AstNode nodeOrigin, Context ctxOrigin) {
        assert (this.isNaturalGotoStatementTarget());
        throw new IllegalStateException();
    }

    @Override
    protected Label ensureShortCircuitLabel(AstNode nodeOrigin, Context ctxOrigin) {
        AstNode nodeChild = this.findChild(nodeOrigin);
        assert (nodeChild != null);
        assert (this.allowsShortCircuit(nodeChild));
        return this.ensureBreakLabel(nodeOrigin, ctxOrigin);
    }

    protected final Statement validate(Context ctx, ErrorListener errs) {
        if (errs.isAbortDesired()) {
            return null;
        }
        this.m_ctx = ctx;
        Statement stmt = this.validateImpl(ctx, errs);
        this.m_ctx = null;
        if (this.m_listBreaks != null) {
            Iterator<Break> iter = this.m_listBreaks.iterator();
            while (iter.hasNext()) {
                Break breakInfo = iter.next();
                if (breakInfo.node.isDiscarded()) {
                    iter.remove();
                    continue;
                }
                ctx.merge(breakInfo.mapAssign(), breakInfo.mapNarrow());
                if (breakInfo.label == null) continue;
                breakInfo.label.restoreNarrowed(ctx);
            }
            if (!ctx.isReachable()) {
                ctx.setReachable(true);
            }
        }
        return stmt;
    }

    protected Context ensureValidationContext() {
        if (this.m_ctx == null) {
            throw new IllegalStateException();
        }
        return this.m_ctx;
    }

    protected abstract Statement validateImpl(Context var1, ErrorListener var2);

    protected final boolean completes(Context ctx, boolean fReachable, MethodStructure.Code code, ErrorListener errs) {
        boolean fCompletes;
        if (fReachable) {
            this.updateLineNumber(code);
        } else {
            code = code.blackhole();
        }
        boolean bl = fCompletes = fReachable && this.emit(ctx, fReachable, code, errs);
        if (this.m_labelEnd != null && !errs.hasSeriousErrors()) {
            code.add(this.m_labelEnd);
        }
        return fCompletes || fReachable && this.m_listBreaks != null && !this.m_listBreaks.isEmpty();
    }

    protected abstract boolean emit(Context var1, boolean var2, MethodStructure.Code var3, ErrorListener var4);

    public record Break(AstNode node, Map<String, Assignment> mapAssign, Map<String, Argument> mapNarrow, Label label) {
    }

    public static class AstHolder {
        private Statement stmt;
        private BinaryAST ast;

        BinaryAST getAst(Statement stmt) {
            assert (stmt != null);
            if (stmt instanceof LabeledStatement) {
                LabeledStatement stmtLbl = (LabeledStatement)stmt;
                return this.getAst(stmtLbl.stmt);
            }
            if (stmt instanceof ImportStatement || stmt instanceof ComponentStatement) {
                return null;
            }
            BinaryAST ast = this.ast;
            this.ast = null;
            return ast != null && stmt == this.stmt ? ast : BinaryAST.POISON;
        }

        void setAst(Statement stmt, BinaryAST ast) {
            assert (stmt != null && ast != null);
            this.stmt = stmt;
            this.ast = ast;
        }
    }
}

