/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.compiler.ast;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.xvm.asm.Argument;
import org.xvm.asm.Assignment;
import org.xvm.asm.ClassStructure;
import org.xvm.asm.Component;
import org.xvm.asm.ComponentResolver;
import org.xvm.asm.Constant;
import org.xvm.asm.ConstantPool;
import org.xvm.asm.Constants;
import org.xvm.asm.ErrorListener;
import org.xvm.asm.GenericTypeResolver;
import org.xvm.asm.MethodStructure;
import org.xvm.asm.ModuleStructure;
import org.xvm.asm.Op;
import org.xvm.asm.Parameter;
import org.xvm.asm.PropertyStructure;
import org.xvm.asm.Register;
import org.xvm.asm.TypedefStructure;
import org.xvm.asm.ast.AssignAST;
import org.xvm.asm.ast.BinaryAST;
import org.xvm.asm.ast.ConstantExprAST;
import org.xvm.asm.ast.ExprAST;
import org.xvm.asm.ast.ReturnStmtAST;
import org.xvm.asm.ast.StmtBlockAST;
import org.xvm.asm.constants.ClassConstant;
import org.xvm.asm.constants.IdentityConstant;
import org.xvm.asm.constants.MethodConstant;
import org.xvm.asm.constants.MethodInfo;
import org.xvm.asm.constants.MultiMethodConstant;
import org.xvm.asm.constants.PropertyConstant;
import org.xvm.asm.constants.PropertyInfo;
import org.xvm.asm.constants.SignatureConstant;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.asm.constants.TypeInfo;
import org.xvm.asm.op.Enter;
import org.xvm.asm.op.Exit;
import org.xvm.asm.op.Nop;
import org.xvm.asm.op.Return_0;
import org.xvm.asm.op.Var_C;
import org.xvm.asm.op.Var_CN;
import org.xvm.asm.op.Var_IN;
import org.xvm.compiler.Source;
import org.xvm.compiler.Token;
import org.xvm.compiler.ast.AstNode;
import org.xvm.compiler.ast.ComponentStatement;
import org.xvm.compiler.ast.Context;
import org.xvm.compiler.ast.ImportStatement;
import org.xvm.compiler.ast.LambdaExpression;
import org.xvm.compiler.ast.MethodDeclarationStatement;
import org.xvm.compiler.ast.NameResolver;
import org.xvm.compiler.ast.NewExpression;
import org.xvm.compiler.ast.Statement;
import org.xvm.compiler.ast.StatementExpression;
import org.xvm.compiler.ast.TypeCompositionStatement;
import org.xvm.util.ListMap;
import org.xvm.util.Severity;

public class StatementBlock
extends Statement {
    protected Source source;
    protected List<Statement> stmts;
    protected long lStartPos;
    protected long lEndPos;
    protected boolean boundary;
    protected boolean containsEnclosed;
    protected Map<String, ImportStatement> imports;
    protected List<ImportStatement> importsWild;
    private transient boolean m_fSuppressScope;
    private transient boolean m_fTerminatedAbnormally;
    private static final Field[] CHILD_FIELDS = StatementBlock.fieldsForNames(StatementBlock.class, "stmts");

    public StatementBlock(List<Statement> stmts) {
        this(stmts, null, stmts.isEmpty() ? 0L : stmts.getFirst().getStartPosition(), stmts.isEmpty() ? 0L : stmts.getLast().getEndPosition());
    }

    public StatementBlock(List<Statement> stmts, long lStartPos, long lEndPos) {
        this(stmts, null, lStartPos, lEndPos);
    }

    public StatementBlock(List<Statement> stmts, Source source, long lStartPos, long lEndPos) {
        this.stmts = stmts;
        this.source = source;
        this.lStartPos = lStartPos;
        this.lEndPos = lEndPos;
    }

    public List<Statement> getStatements() {
        return this.stmts;
    }

    /*
     * Unable to fully structure code
     */
    public void addStatement(Statement stmt) {
        stmt.setParent(this);
        fHasEnclosed = this.containsEnclosed;
        if (!(stmt instanceof StatementBlock)) ** GOTO lbl-1000
        block = (StatementBlock)stmt;
        if (block.boundary) {
            v0 = true;
        } else lbl-1000:
        // 2 sources

        {
            v0 = fAddEnclosed = false;
        }
        if (!StatementBlock.$assertionsDisabled && fHasEnclosed & fAddEnclosed) {
            throw new AssertionError();
        }
        if (fHasEnclosed) {
            this.stmts.add(this.stmts.size() - 1, stmt);
        } else {
            this.stmts.add(stmt);
            this.containsEnclosed |= fAddEnclosed;
        }
    }

    protected void markFileBoundary() {
        this.boundary = true;
    }

    public boolean isFileBoundary() {
        return this.boundary;
    }

    public void suppressScope() {
        this.m_fSuppressScope = true;
    }

    public boolean hasScope() {
        return !this.m_fSuppressScope;
    }

    protected void registerImport(ImportStatement stmt, ErrorListener errs) {
        if (stmt.isWildcard()) {
            if (this.importsWild == null) {
                this.importsWild = new ArrayList<ImportStatement>();
            }
            this.importsWild.add(stmt);
        } else {
            String sAlias;
            if (this.imports == null) {
                this.imports = new HashMap<String, ImportStatement>();
            }
            if (this.imports.containsKey(sAlias = stmt.getAliasName())) {
                this.log(errs, Severity.ERROR, "COMPILER-28", sAlias);
            }
            this.imports.put(stmt.getAliasName(), stmt);
        }
    }

    public ImportStatement getImport(String sName, Token name, ErrorListener errs) {
        ImportStatement stmt;
        if (this.imports != null && (stmt = this.imports.get(sName)) != null && (name == null || name.getStartPosition() > stmt.getStartPosition())) {
            return stmt;
        }
        if (this.importsWild != null) {
            ImportStatement stmtResult = null;
            for (ImportStatement stmt2 : this.importsWild) {
                Component child;
                ClassStructure clz;
                Constant constant;
                if (name != null && name.getStartPosition() < stmt2.getStartPosition() || !((constant = stmt2.getNameResolver().getConstant()) instanceof IdentityConstant)) continue;
                IdentityConstant id = (IdentityConstant)constant;
                if (!constant.isClass() || (clz = (ClassStructure)id.getComponent()) == null || !((child = clz.getChild(sName)) instanceof ClassStructure) && !(child instanceof TypedefStructure)) continue;
                if (stmtResult == null) {
                    stmtResult = stmt2;
                    continue;
                }
                stmt2.log(errs, Severity.ERROR, "COMPILER-28", sName);
                break;
            }
            return stmtResult;
        }
        return null;
    }

    @Override
    protected AstNode getCodeContainer() {
        AstNode parent = this.getParent();
        if (parent instanceof MethodDeclarationStatement || parent instanceof NewExpression || parent instanceof LambdaExpression || parent instanceof StatementExpression) {
            return parent;
        }
        return super.getCodeContainer();
    }

    @Override
    public Source getSource() {
        return this.source == null ? super.getSource() : this.source;
    }

    @Override
    public long getStartPosition() {
        return this.lStartPos;
    }

    @Override
    public long getEndPosition() {
        return this.lEndPos;
    }

    @Override
    protected Field[] getChildFields() {
        return CHILD_FIELDS;
    }

    public boolean isTerminatedAbnormally() {
        if (this.m_fTerminatedAbnormally) {
            return true;
        }
        StatementBlock parentBlock = this.getParentBlock();
        return parentBlock != null && parentBlock.isTerminatedAbnormally();
    }

    public boolean compileMethod(MethodStructure.Code code, ErrorListener errs) {
        return this.compileMethod(new RootContext(this, code.getMethodStructure()), code, errs);
    }

    public boolean compileMethod(RootContext ctx, MethodStructure.Code code, ErrorListener errs) {
        ErrorListener errsValidation = errs.branch(this);
        Statement that = this.validate(ctx.validatingContext(), errsValidation);
        errsValidation.merge();
        if (that == null || errsValidation.hasSeriousErrors() || errsValidation.isAbortDesired()) {
            return false;
        }
        boolean fCompletes = that.completes(ctx.emittingContext(code), true, code, errs);
        BinaryAST astRoot = ctx.getHolder().getAst(this);
        if (fCompletes) {
            TypeConstant[] atypeReturn = code.getMethodStructure().getReturnTypes();
            if (atypeReturn.length == 0 || StatementBlock.isVoid(atypeReturn)) {
                code.add(new Return_0());
                if (astRoot instanceof StmtBlockAST) {
                    StmtBlockAST astBlock = (StmtBlockAST)astRoot;
                    BinaryAST[] oldStmts = astBlock.getStmts();
                    int oldSize = oldStmts.length;
                    int newSize = oldSize + 1;
                    BinaryAST[] newStmts = new BinaryAST[newSize];
                    System.arraycopy(oldStmts, 0, newStmts, 0, oldSize);
                    newStmts[oldSize] = new ReturnStmtAST(ExprAST.NO_EXPRS);
                    astRoot = new StmtBlockAST(newStmts, true);
                }
            } else {
                errs.log(Severity.ERROR, "COMPILER-49", null, this.getSource(), this.getEndPosition(), this.getEndPosition());
            }
        } else {
            code.add(new Nop());
        }
        ctx.getMethod().setAst(astRoot, ctx.collectParameters());
        return true;
    }

    @Override
    protected Statement validateImpl(Context ctx, ErrorListener errs) {
        List<Statement> stmts = this.stmts;
        boolean fValid = true;
        if (stmts != null && !stmts.isEmpty()) {
            LambdaExpression exprLambda;
            MethodStructure method;
            AstNode parent;
            if (this.hasScope()) {
                ctx = new NestedBlockContext(ctx);
            }
            if ((parent = this.getParent()) instanceof LambdaExpression && (method = (exprLambda = (LambdaExpression)parent).getLambda()) != null) {
                for (Parameter param : method.getParamArray()) {
                    if (!param.isImplicitDeref()) continue;
                    String sName = param.getName();
                    Register regVar = (Register)ctx.getVar(sName);
                    Assignment asnVar = ctx.getVarAssignment(sName);
                    Register regVal = param.deref(regVar, method);
                    ctx.ensureNameMap().put(sName, regVal);
                    ctx.setVarAssignment(sName, asnVar);
                }
            }
            int c = stmts.size();
            for (int i = 0; i < c; ++i) {
                Statement stmtOld = stmts.get(i);
                Statement stmtNew = stmtOld.validate(ctx, errs);
                if (stmtNew != stmtOld) {
                    if (stmtNew == null) {
                        fValid = false;
                    } else {
                        this.stmts = StatementBlock.ensureArrayList(stmts);
                        stmts.set(i, stmtNew);
                    }
                }
                if (errs.isAbortDesired()) break;
            }
            if (this.hasScope()) {
                ctx.exit();
            }
        }
        return fValid ? this : null;
    }

    @Override
    protected boolean emit(Context ctx, boolean fReachable, MethodStructure.Code code, ErrorListener errs) {
        boolean fCompletable = fReachable;
        Statement.AstHolder holder = ctx.getHolder();
        List<Statement> stmts = this.stmts;
        BinaryAST[] asts = BinaryAST.NO_ASTS;
        if (stmts != null && !stmts.isEmpty()) {
            Map<String, Register> mapCapture;
            RootContext ctxRoot;
            AstNode parent = this.getParent();
            boolean fMethod = parent instanceof MethodDeclarationStatement;
            boolean fLambda = parent instanceof LambdaExpression;
            boolean fSuppressScope = fMethod | fLambda | this.m_fSuppressScope;
            ArrayList<BinaryAST> listAsts = new ArrayList<BinaryAST>(stmts.size());
            if (fLambda) {
                MethodStructure method = ((LambdaExpression)parent).getLambda();
                for (Parameter param : method.getParamArray()) {
                    if (!param.isImplicitDeref()) continue;
                    Register regVar = (Register)ctx.getVar(param.getName());
                    Register regVal = param.deref(regVar, method);
                    code.add(new Var_C(regVal, regVar));
                    AssignAST astAssign = new AssignAST(regVal.getRegAllocAST(), AssignAST.Operator.Deref, regVar.getRegisterAST());
                    listAsts.add(astAssign);
                }
            } else if (fMethod && (ctxRoot = (RootContext)ctx).isAnonInnerClass() && (mapCapture = ctxRoot.m_mapCaptureVars) != null) {
                assert (!code.hasOps());
                NewExpression exprNew = ctxRoot.getAnonymousInnerClassExpression();
                ClassStructure clzAnon = ctxRoot.getEnclosingClass();
                for (Map.Entry<String, Register> entry : mapCapture.entrySet()) {
                    String sName = entry.getKey();
                    Register reg = entry.getValue();
                    PropertyStructure prop = (PropertyStructure)clzAnon.getChild(sName);
                    PropertyConstant id = prop.getIdentityConstant();
                    ConstantExprAST astProp = new ConstantExprAST(id);
                    if (exprNew.isImplicitDeref(sName)) {
                        code.add(new Var_CN(reg, id.getNameConstant(), id));
                        listAsts.add(new AssignAST(reg.getRegAllocAST(), AssignAST.Operator.Deref, astProp));
                        continue;
                    }
                    code.add(new Var_IN(reg, id.getNameConstant(), id));
                    listAsts.add(new AssignAST(reg.getRegAllocAST(), AssignAST.Operator.Asn, astProp));
                }
            }
            if (!fSuppressScope) {
                code.add(new Enter());
            }
            boolean fLoggedUnreachable = false;
            for (Statement stmt : stmts) {
                if (!(fReachable || fLoggedUnreachable || stmt instanceof ComponentStatement)) {
                    stmt.log(errs, Severity.ERROR, "COMPILER-46", new Object[0]);
                    fLoggedUnreachable = true;
                }
                fCompletable &= stmt.completes(ctx, fReachable, code, errs);
                if (fReachable && !(stmt instanceof ComponentStatement)) {
                    BinaryAST bast = holder.getAst(stmt);
                    if (bast == BinaryAST.POISON) {
                        if (!errs.hasSeriousErrors()) {
                            stmt.log(errs, Severity.ERROR, "COMPILER-NI", "BAST for " + stmt.getClass().getSimpleName());
                        }
                        return false;
                    }
                    if (bast != null) {
                        listAsts.add(bast);
                    }
                }
                if (!fReachable || fCompletable) continue;
                if (stmt.isTodo()) {
                    this.m_fTerminatedAbnormally = true;
                    break;
                }
                fReachable = false;
            }
            if (!fSuppressScope) {
                code.add(new Exit());
            }
            asts = listAsts.toArray(BinaryAST.NO_ASTS);
        }
        holder.setAst(this, new StmtBlockAST(asts, this.hasScope()));
        return fCompletable;
    }

    @Override
    protected ImportStatement resolveImportBySingleName(String sName, ErrorListener errs) {
        if (this.isFileBoundary()) {
            return null;
        }
        ImportStatement stmtImport = this.getImport(sName, null, errs);
        return stmtImport == null ? super.resolveImportBySingleName(sName, errs) : stmtImport;
    }

    @Override
    public String toString() {
        if (this.stmts == null || this.stmts.isEmpty()) {
            return "{}";
        }
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        int firstNonEnum = 0;
        Statement statement = this.stmts.get(0);
        if (statement instanceof TypeCompositionStatement) {
            TypeCompositionStatement stmtType = (TypeCompositionStatement)statement;
            if (stmtType.category.getId() == Token.Id.ENUM_VAL) {
                boolean multiline = false;
                for (Statement stmt : this.stmts) {
                    if (!(stmt instanceof TypeCompositionStatement)) continue;
                    TypeCompositionStatement stmtTypeComp = (TypeCompositionStatement)stmt;
                    if (stmtTypeComp.category.getId() != Token.Id.ENUM_VAL) continue;
                    multiline |= stmtType.doc != null || stmtType.body != null;
                    ++firstNonEnum;
                }
                String sBetweenEnums = multiline ? ",\n" : ", ";
                for (int i = 0; i < firstNonEnum; ++i) {
                    if (i == 0) {
                        sb.append('\n');
                    } else {
                        sb.append(sBetweenEnums);
                    }
                    sb.append(this.stmts.get(i));
                }
                if (firstNonEnum < this.stmts.size()) {
                    sb.append(';');
                }
            }
        }
        int c = this.stmts.size();
        for (int i = firstNonEnum; i < c; ++i) {
            sb.append('\n').append(this.stmts.get(i));
        }
        sb.append("\n}");
        return sb.toString();
    }

    public static class RootContext
    extends Context {
        private final StatementBlock f_stmt;
        private final MethodStructure f_method;
        private final Statement.AstHolder f_holder;
        private Context m_ctxValidating;
        private boolean m_fEmitting;
        private Map<String, NewExpression.AnonInnerClassContext> m_mapCaptureContexts;
        private Map<String, Register> m_mapCaptureVars;

        public RootContext(StatementBlock stmt, MethodStructure method) {
            super(null, false);
            this.f_stmt = stmt;
            this.f_method = method;
            this.f_holder = new Statement.AstHolder();
        }

        @Override
        public MethodStructure getMethod() {
            return this.f_method;
        }

        public StatementBlock getStatementBlock() {
            return this.f_stmt;
        }

        @Override
        public Statement.AstHolder getHolder() {
            return this.f_holder;
        }

        public boolean isAnonInnerClass() {
            AstNode parent = this.getStatementBlock();
            while (!(parent instanceof TypeCompositionStatement)) {
                parent = parent.getParent();
            }
            return parent.getParent() instanceof NewExpression;
        }

        public NewExpression getAnonymousInnerClassExpression() {
            NewExpression exprNew;
            AstNode parent = this.getStatementBlock();
            while (!(parent instanceof TypeCompositionStatement)) {
                parent = parent.getParent();
            }
            AstNode astNode = parent.getParent();
            return astNode instanceof NewExpression ? (exprNew = (NewExpression)astNode) : null;
        }

        public ClassStructure getEnclosingClass() {
            AstNode parent = this.getStatementBlock();
            while (!(parent instanceof TypeCompositionStatement)) {
                parent = parent.getParent();
            }
            return (ClassStructure)parent.getComponent();
        }

        @Override
        public Source getSource() {
            return this.getStatementBlock().getSource();
        }

        @Override
        public TypeConstant getThisType() {
            if (this.isAnonInnerClass()) {
                NewExpression exprNew = this.getAnonymousInnerClassExpression();
                if (exprNew.isValidated()) {
                    return exprNew.getType();
                }
                NewExpression.AnonInnerClassContext ctxC = exprNew.getCaptureContext();
                if (ctxC != null) {
                    return ((Context)ctxC).getThisClass().getFormalType();
                }
            }
            return super.getThisType();
        }

        @Override
        public ClassStructure getThisClass() {
            if (this.isAnonInnerClass()) {
                NewExpression exprNew = this.getAnonymousInnerClassExpression();
                return (ClassStructure)exprNew.anon.getComponent();
            }
            return this.f_method.getContainingClass();
        }

        @Override
        public ConstantPool pool() {
            return this.f_method.getConstantPool();
        }

        @Override
        public Context enterFork(boolean fWhenTrue) {
            this.checkValidating();
            throw new IllegalStateException();
        }

        @Override
        public Context enter() {
            this.checkValidating();
            throw new IllegalStateException();
        }

        @Override
        public void registerVar(Token tokName, Register reg, ErrorListener errs) {
            this.checkValidating();
            throw new IllegalStateException();
        }

        @Override
        public void unregisterVar(Token tokName) {
            this.checkValidating();
            throw new IllegalStateException();
        }

        @Override
        public boolean isVarDeclaredInThisScope(String sName) {
            Argument arg = this.getNameMap().get(sName);
            if (arg instanceof Register) {
                Register reg = (Register)arg;
                return reg.isUnknown() || !reg.isPredefined();
            }
            return false;
        }

        @Override
        public Assignment getVarAssignment(String sName) {
            if (this.isReservedName(sName)) {
                return this.isReservedNameReadable(sName) ? Assignment.AssignedOnce : Assignment.Unassigned;
            }
            return super.getVarAssignment(sName);
        }

        @Override
        public boolean isVarReadable(String sName) {
            Assignment asn = this.getVarAssignment(sName);
            if (asn != null) {
                return asn.isDefinitelyAssigned();
            }
            return this.isReservedName(sName) && this.isReservedNameReadable(sName);
        }

        public boolean isReservedNameReadable(String sName) {
            this.checkValidating();
            switch (sName) {
                case "this": 
                case "this:class": 
                case "this:struct": {
                    return this.isMethod() || this.isConstructor();
                }
                case "this:target": 
                case "this:public": 
                case "this:protected": 
                case "this:private": {
                    return this.isMethod();
                }
                case "this:module": 
                case "this:service": {
                    return true;
                }
                case "super": {
                    MethodStructure method = this.getMethod();
                    if (!method.isSuperAllowed()) {
                        return false;
                    }
                    MethodConstant idMethod = method.getIdentityConstant();
                    Constants.Access access = idMethod.isTopLevel() ? Constants.Access.PROTECTED : Constants.Access.PRIVATE;
                    TypeConstant typeCtx = this.pool().ensureAccessTypeConstant(this.getThisClass().getFormalType(), access);
                    TypeInfo info = typeCtx.ensureTypeInfo();
                    MethodInfo infoMethod = info.getMethodById(idMethod);
                    return infoMethod != null && infoMethod.hasSuper(info);
                }
            }
            throw new IllegalArgumentException("no such reserved name: " + sName);
        }

        @Override
        public boolean requireThis(long lPos, ErrorListener errs) {
            boolean fHasThis;
            AstNode parent = this.f_stmt.getParent();
            if (parent instanceof LambdaExpression) {
                LambdaExpression exprLambda = (LambdaExpression)parent;
                v0 = exprLambda.isRequiredThis();
            } else {
                v0 = fHasThis = !this.isFunction();
            }
            if (!fHasThis && errs != null) {
                errs.log(Severity.ERROR, "COMPILER-52", null, this.getSource(), lPos, lPos);
            }
            return fHasThis;
        }

        @Override
        public void useFormalType(TypeConstant type, ErrorListener errs) {
            NewExpression.AnonInnerClassContext ctx;
            super.useFormalType(type, errs);
            if (this.isAnonInnerClass() && (ctx = this.getAnonymousInnerClassExpression().getCaptureContext()) != null) {
                ((Context)ctx).useFormalType(type, errs);
            }
        }

        @Override
        public boolean isVarWritable(String sName) {
            Argument arg = this.ensureNameMap().get(sName);
            if (arg instanceof Register) {
                Register reg = (Register)arg;
                return reg.isWritable();
            }
            return arg instanceof PropertyConstant;
        }

        @Override
        public boolean isVarHideable(String sName) {
            return super.isVarHideable(sName) || this.isAnonInnerClass() && this.getMethod().getParam(sName) == null;
        }

        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        protected Argument resolveRegularName(Context ctxFrom, String sName, Token name, ErrorListener errs) {
            Component component;
            NewExpression exprNew;
            this.checkValidating();
            Map<String, Argument> mapByName = this.ensureNameMap();
            Argument arg = mapByName.get(sName);
            if (arg != null) {
                return arg;
            }
            if (this.isAnonInnerClass() && (exprNew = this.getAnonymousInnerClassExpression()).isCapture(sName)) {
                PropertyStructure prop = (PropertyStructure)this.getEnclosingClass().getChild(sName);
                assert (prop.isSynthetic());
                TypeConstant type = exprNew.getCaptureType(sName);
                boolean fFinal = exprNew.isCaptureFinal(sName);
                Register reg = this.createRegister(type, sName);
                mapByName.put(sName, reg);
                this.ensureCaptureVars().put(sName, reg);
                this.ensureDefiniteAssignments().put(sName, fFinal ? Assignment.AssignedOnce : Assignment.Assigned);
                return reg;
            }
            ConstantPool pool = this.pool();
            AstNode node = this.f_stmt;
            Source source = node == null ? null : node.getSource();
            boolean fHasThis = this.isMethod() || this.isConstructor() && !this.isStaticPropertyInitializer();
            TypeConstant typeThis = fHasThis ? ctxFrom.getThisType() : null;
            int cSteps = 0;
            Constants.Access access = Constants.Access.PRIVATE;
            IdentityConstant idPrev = null;
            TypeInfo infoPrev = null;
            ErrorListener errsTemp = errs.branch(null);
            IdentityConstant idOuter = this.getEnclosingClass().getIdentityConstant();
            if (idOuter instanceof ClassConstant) {
                ClassConstant idClz = (ClassConstant)idOuter;
                idOuter = idClz.getOutermost();
            }
            IdentityConstant idOuterParent = idOuter.getNamespace();
            while (node != null) {
                StatementBlock block;
                ImportStatement stmtImport;
                if (node.isComponentNode()) {
                    Argument argument;
                    NewExpression exprNew2;
                    NewExpression.AnonInnerClassContext ctx;
                    TypeInfo info;
                    assert (node.canResolveNames());
                    component = node.getComponent();
                    assert (component != null);
                    IdentityConstant id = component.getIdentityConstant();
                    IdentityConstant idClz = id.getClassIdentity();
                    Component.SimpleCollector collector = new Component.SimpleCollector(errs);
                    Constant constFound = null;
                    if (component.resolveName(sName, access, collector) == ComponentResolver.ResolutionResult.RESOLVED) {
                        Constant constant = collector.getResolvedConstant();
                        switch (constant.getFormat()) {
                            case Property: 
                            case Method: 
                            case MultiMethod: {
                                constFound = constant;
                                break;
                            }
                            default: {
                                errsTemp.merge();
                                return constant;
                            }
                        }
                    }
                    if (idPrev != null && idClz == idPrev) {
                        info = infoPrev;
                    } else {
                        TypeConstant typeClz;
                        if (typeThis == null) {
                            typeClz = ((ClassStructure)idClz.getComponent()).getFormalType();
                            typeClz = pool.ensureAccessTypeConstant(typeClz, access);
                        } else {
                            typeClz = typeThis.isRelationalType() ? typeThis : pool.ensureAccessTypeConstant(typeThis, this.isConstructor() ? Constants.Access.STRUCT : Constants.Access.PRIVATE);
                        }
                        infoPrev = info = typeClz.ensureTypeInfo(errsTemp);
                        idPrev = idClz;
                    }
                    if (id == idClz) {
                        void var27_35;
                        Object var27_32 = null;
                        prop = info.findProperty(sName);
                        if (prop == null) {
                            if (info.containsMultiMethod(sName)) {
                                Set<MethodConstant> setMethods = info.findMethods(sName, -1, TypeInfo.MethodKind.Any);
                                assert (!setMethods.isEmpty());
                                MethodConstant idMethod = setMethods.iterator().next();
                                MethodInfo infoMethod = info.getMethodById(idMethod);
                                MultiMethodConstant multiMethodConstant = infoMethod.getIdentity().getParentConstant();
                            }
                        } else {
                            PropertyConstant propertyConstant = prop.getIdentity();
                        }
                        if (var27_35 != null) {
                            return new TargetInfo(sName, (IdentityConstant)var27_35, fHasThis, info.getType(), cSteps);
                        }
                        if (constFound != null) {
                            if (constFound instanceof PropertyConstant) {
                                this.f_stmt.log(errs, Severity.ERROR, "COMPILER-162", sName, info.getType().getValueString());
                                return null;
                            } else {
                                this.f_stmt.log(errs, Severity.ERROR, "COMPILER-177", sName, info.getType().getValueString());
                            }
                            return null;
                        }
                        fHasThis &= !info.isStatic();
                        typeThis = null;
                        ++cSteps;
                    } else if (id instanceof PropertyConstant) {
                        void var27_39;
                        PropertyConstant idProp = (PropertyConstant)id;
                        Object var27_36 = null;
                        prop = info.ensureNestedPropertiesByName(idProp).get(sName);
                        if (prop == null) {
                            if (info.containsNestedMultiMethod(idProp, sName)) {
                                MultiMethodConstant multiMethodConstant = pool.ensureMultiMethodConstant(id, sName);
                            }
                        } else {
                            PropertyConstant propertyConstant = prop.getIdentity().ensureNestedIdentity(pool, idProp);
                        }
                        if (var27_39 != null) return new TargetInfo(sName, (IdentityConstant)var27_39, fHasThis, info.getType(), cSteps);
                        PropertyInfo infoProp = info.findProperty(idProp, false);
                        assert (infoProp != null);
                        if (infoProp.hasField() && infoProp.isRefAnnotated()) {
                            ++cSteps;
                        }
                    } else if (id instanceof MethodConstant) {
                        void var27_43;
                        MethodConstant idMethod = (MethodConstant)id;
                        Object var27_40 = null;
                        prop = info.ensureNestedPropertiesByName(idMethod).get(sName);
                        if (prop == null) {
                            if (info.containsNestedMultiMethod(idMethod, sName)) {
                                MultiMethodConstant multiMethodConstant = pool.ensureMultiMethodConstant(id, sName);
                            }
                        } else {
                            PropertyConstant propertyConstant = prop.getIdentity();
                        }
                        if (var27_43 != null) {
                            return new TargetInfo(sName, (IdentityConstant)var27_43, fHasThis, info.getType(), cSteps);
                        }
                    } else assert (id instanceof MultiMethodConstant);
                    if (node instanceof NewExpression && (ctx = (exprNew2 = (NewExpression)node).getCaptureContext()) != null && (argument = ctx.getVar(sName)) != null) {
                        Register reg = this.createRegister(argument.getType(), name.getValueText());
                        super.registerVar(name, reg, errs);
                        this.ensureDefiniteAssignments().put(sName, ctx.getVarAssignment(sName));
                        this.ensureCaptureContexts().put(sName, ctx);
                        return reg;
                    }
                    if (id == idOuter && (idOuterParent == null || idOuterParent.isClass())) {
                        access = Constants.Access.PUBLIC;
                        fHasThis = false;
                    } else {
                        switch (component.getFormat()) {
                            case ENUM: 
                            case ENUMVALUE: 
                            case PACKAGE: 
                            case MODULE: 
                            case TYPEDEF: {
                                fHasThis = false;
                                break;
                            }
                            case INTERFACE: 
                            case CLASS: 
                            case CONST: 
                            case ANNOTATION: 
                            case MIXIN: 
                            case SERVICE: 
                            case PROPERTY: {
                                fHasThis &= !component.isStatic();
                                break;
                            }
                            case METHOD: {
                                MethodStructure method = (MethodStructure)component;
                                fHasThis &= !method.isFunction();
                            }
                        }
                    }
                }
                if (node instanceof StatementBlock && (stmtImport = (block = node).getImport(sName, node.getSource() == source ? name : null, errs)) != null) {
                    NameResolver resolver = stmtImport.getNameResolver();
                    if (resolver.getResult() != NameResolver.Result.RESOLVED) break;
                    Constant constant = resolver.getConstant();
                    return stmtImport.isWildcard() ? ((IdentityConstant)constant).getComponent().getChild(sName).getIdentityConstant() : constant;
                }
                node = node.getParent();
            }
            if ((component = pool.getImplicitlyImportedComponent(sName)) != null) {
                return component.getIdentityConstant();
            }
            errsTemp.merge();
            if (name == null) {
                this.f_stmt.log(errs, Severity.ERROR, "COMPILER-38", sName);
                return null;
            } else {
                name.log(errs, this.getSource(), Severity.ERROR, "COMPILER-38", sName);
            }
            return null;
        }

        @Override
        protected Argument getVar(String sName, Token name, Context.Branch branch, ErrorListener errs) {
            Argument arg = this.getLocalVar(sName, branch);
            return arg == null ? this.resolveReservedName(sName, name, errs) : arg;
        }

        @Override
        protected TypeConstant resolveFormalType(TypeConstant typeFormal, Context.Branch branch) {
            GenericTypeResolver resolver = this.getLocalResolver(branch);
            return resolver == null ? typeFormal : typeFormal.resolveGenerics(this.pool(), resolver);
        }

        @Override
        protected Argument resolveReservedName(String sName, Token name, ErrorListener errs) {
            int nReg;
            TypeConstant type;
            Register reg;
            Map<String, Argument> mapByName = this.ensureNameMap();
            Argument arg = mapByName.get(sName);
            if (arg instanceof Register && (reg = (Register)arg).isPredefined()) {
                return arg;
            }
            ConstantPool pool = this.pool();
            TypeConstant typeThis = this.getThisClass().getFormalType();
            int cSteps = 0;
            switch (sName) {
                case "this": {
                    if (this.isConstructor()) {
                        type = pool.ensureAccessTypeConstant(typeThis, Constants.Access.STRUCT);
                        nReg = -10;
                        break;
                    }
                    type = typeThis;
                    nReg = -5;
                    cSteps = this.getMethod().getThisSteps();
                    break;
                }
                case "this:target": {
                    type = typeThis;
                    nReg = -6;
                    cSteps = this.getMethod().getThisSteps();
                    break;
                }
                case "this:public": {
                    type = pool.ensureAccessTypeConstant(typeThis, Constants.Access.PUBLIC);
                    nReg = -7;
                    cSteps = this.getMethod().getThisSteps();
                    break;
                }
                case "this:protected": {
                    type = pool.ensureAccessTypeConstant(typeThis, Constants.Access.PROTECTED);
                    nReg = -8;
                    cSteps = this.getMethod().getThisSteps();
                    break;
                }
                case "this:private": {
                    type = pool.ensureAccessTypeConstant(typeThis, Constants.Access.PRIVATE);
                    nReg = -9;
                    cSteps = this.getMethod().getThisSteps();
                    break;
                }
                case "this:struct": {
                    type = pool.ensureIntersectionTypeConstant(pool.typeStruct(), pool.ensureAccessTypeConstant(typeThis, Constants.Access.STRUCT));
                    nReg = -10;
                    cSteps = this.getMethod().getThisSteps();
                    break;
                }
                case "this:class": {
                    type = pool.ensureParameterizedTypeConstant(pool.typeClass(), pool.ensureAccessTypeConstant(typeThis, Constants.Access.PUBLIC), pool.ensureAccessTypeConstant(typeThis, Constants.Access.PROTECTED), pool.ensureAccessTypeConstant(typeThis, Constants.Access.PRIVATE), pool.ensureIntersectionTypeConstant(pool.typeStruct(), pool.ensureAccessTypeConstant(typeThis, Constants.Access.STRUCT)));
                    nReg = -11;
                    cSteps = this.getMethod().getThisSteps();
                    break;
                }
                case "this:service": {
                    type = pool.typeService();
                    nReg = -12;
                    break;
                }
                case "super": {
                    SignatureConstant sigSuper;
                    MethodStructure method = this.getMethod();
                    if (!method.isSuperAllowed()) {
                        return null;
                    }
                    MethodConstant idMethod = method.getIdentityConstant();
                    Constants.Access access = idMethod.isTopLevel() ? Constants.Access.PROTECTED : Constants.Access.PRIVATE;
                    TypeConstant typeCtx = pool.ensureAccessTypeConstant(typeThis, access);
                    TypeInfo infoType = typeCtx.ensureTypeInfo();
                    MethodInfo infoMethod = infoType.getMethodById(idMethod);
                    SignatureConstant signatureConstant = sigSuper = infoMethod == null ? null : infoMethod.getSuper(infoType);
                    if (sigSuper == null) {
                        if (method.isConstructor() && this.getThisClass().containsAnnotation(pool.clzOverride())) {
                            sigSuper = idMethod.getSignature();
                        } else {
                            return null;
                        }
                    }
                    type = sigSuper.asFunctionType();
                    nReg = -13;
                    break;
                }
                case "this:module": {
                    return this.getModule().getIdentityConstant();
                }
                default: {
                    return null;
                }
            }
            arg = cSteps == 0 ? new Register(type, null, nReg) : new TargetInfo(sName, type, cSteps);
            mapByName.put(sName, arg);
            return arg;
        }

        @Override
        protected boolean hasInitialNames() {
            return true;
        }

        @Override
        protected void initNameMap(Map<String, Argument> mapByName) {
            MethodStructure method = this.f_method;
            MethodConstant idMethod = method.getIdentityConstant();
            Map<String, Assignment> mapAssigned = this.ensureDefiniteAssignments();
            int c = method.getParamCount();
            for (int i = 0; i < c; ++i) {
                Register reg;
                Parameter param = method.getParam(i);
                String sName = param.getName();
                if (sName.equals(Token.Id.ANY.TEXT)) continue;
                if (param.isTypeParameter()) {
                    reg = new Register(param.asTypeParameterType(idMethod).getType(), sName, i);
                    reg.markEffectivelyFinal();
                } else {
                    reg = new Register(param.getType(), sName, i);
                }
                mapByName.put(sName, reg);
                mapAssigned.put(sName, Assignment.AssignedOnce);
            }
        }

        @Override
        public boolean isMethod() {
            return !this.isFunction() && !this.isConstructor();
        }

        @Override
        public boolean isFunction() {
            Component parent = this.f_method;
            while (true) {
                switch (parent.getFormat()) {
                    case ENUM: 
                    case ENUMVALUE: 
                    case PACKAGE: 
                    case MODULE: 
                    case INTERFACE: 
                    case CLASS: 
                    case CONST: 
                    case ANNOTATION: 
                    case MIXIN: 
                    case SERVICE: {
                        return false;
                    }
                    case METHOD: {
                        MethodStructure method = parent;
                        if (method.isValidator() || method.isConstructor() && !method.isPropertyInitializer()) {
                            return false;
                        }
                        if (!method.isStatic()) break;
                        return true;
                    }
                    case PROPERTY: 
                    case MULTIMETHOD: {
                        break;
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
                parent = parent.getParent();
            }
        }

        @Override
        public boolean isConstructor() {
            return this.f_method.isConstructor() || this.f_method.isValidator();
        }

        public boolean isStaticPropertyInitializer() {
            return this.f_method.isPropertyInitializer() && this.f_method.isStatic();
        }

        ModuleStructure getModule() {
            Component parent = this.f_method;
            while (true) {
                if (parent instanceof ModuleStructure) break;
                parent = parent.getParent();
            }
            ModuleStructure mms = (ModuleStructure)parent;
            return mms;
        }

        @Override
        public Context exit() {
            this.checkValidating();
            throw new IllegalStateException();
        }

        @Override
        public Map<String, Assignment> prepareJump(Context ctxDest) {
            this.checkValidating();
            throw new IllegalStateException();
        }

        public Context validatingContext() {
            this.checkValidating();
            Context ctx = this.m_ctxValidating;
            if (ctx == null) {
                this.m_ctxValidating = ctx = super.enter();
            }
            return ctx;
        }

        public RootContext emittingContext(MethodStructure.Code code) {
            if (this.m_fEmitting) {
                return this;
            }
            this.checkValidating();
            Context ctx = this.m_ctxValidating;
            if (ctx != null) {
                ctx.exit();
                this.m_ctxValidating = null;
                for (Map.Entry<String, Assignment> entry : this.getDefiniteAssignments().entrySet()) {
                    Argument arg;
                    if (!entry.getValue().isEffectivelyFinal() || !((arg = this.ensureNameMap().get(entry.getKey())) instanceof Register)) continue;
                    Register reg = (Register)arg;
                    reg.markEffectivelyFinal();
                }
                if (this.m_mapCaptureContexts != null) {
                    for (Map.Entry<String, Object> entry : this.m_mapCaptureContexts.entrySet()) {
                        String sName = entry.getKey();
                        NewExpression.AnonInnerClassContext ctxCapture = (NewExpression.AnonInnerClassContext)entry.getValue();
                        Assignment asnOrig = ctxCapture.getVarAssignment(sName);
                        boolean fModified = this.getVarAssignment(sName) != asnOrig;
                        ctxCapture.markVarRead(true, sName, null, true, null);
                        if (!fModified) continue;
                        ctxCapture.setVarAssignment(sName, asnOrig.applyAssignmentFromCapture());
                    }
                    this.m_mapCaptureContexts = null;
                }
            }
            this.m_fEmitting = true;
            return this;
        }

        private void checkValidating() {
            if (this.m_fEmitting) {
                throw new IllegalStateException();
            }
        }

        private Map<String, NewExpression.AnonInnerClassContext> ensureCaptureContexts() {
            Map<String, NewExpression.AnonInnerClassContext> map = this.m_mapCaptureContexts;
            if (map == null) {
                this.m_mapCaptureContexts = map = new ListMap<String, NewExpression.AnonInnerClassContext>();
            }
            return map;
        }

        private Map<String, Register> ensureCaptureVars() {
            Map<String, Register> map = this.m_mapCaptureVars;
            if (map == null) {
                this.m_mapCaptureVars = map = new ListMap<String, Register>();
            }
            return map;
        }
    }

    public class NestedBlockContext
    extends Context {
        protected NestedBlockContext(Context ctxOuter) {
            super(ctxOuter, true);
        }

        @Override
        protected Argument resolveRegularName(Context ctxFrom, String sName, Token name, ErrorListener errs) {
            NameResolver resolver;
            ImportStatement stmtImport = StatementBlock.this.getImport(sName, name, errs);
            if (stmtImport != null && (resolver = stmtImport.getNameResolver()).getResult() == NameResolver.Result.RESOLVED) {
                Constant constant = resolver.getConstant();
                return stmtImport.isWildcard() ? ((IdentityConstant)constant).getComponent().getChild(sName).getIdentityConstant() : constant;
            }
            return super.resolveRegularName(ctxFrom, sName, name, errs);
        }
    }

    public static class TargetInfo
    implements Argument {
        private final String name;
        private final IdentityConstant id;
        private final boolean hasThis;
        private final TypeConstant typeTarget;
        private final int stepsOut;
        private final TypeConstant type;

        public TargetInfo(String name, IdentityConstant id, boolean hasThis, TypeConstant typeTarget, int stepsOut) {
            assert (id instanceof PropertyConstant || id instanceof MultiMethodConstant);
            this.name = name;
            this.id = id;
            this.hasThis = hasThis;
            this.typeTarget = typeTarget;
            this.stepsOut = stepsOut;
            if (id instanceof PropertyConstant) {
                PropertyConstant idProp = (PropertyConstant)id;
                PropertyInfo infoProp = typeTarget.ensureTypeInfo().findProperty(idProp);
                this.type = infoProp == null ? (idProp.isFormalType() ? idProp.getFormalType() : idProp.getType()) : infoProp.inferImmutable(typeTarget);
            } else {
                this.type = null;
            }
        }

        public TargetInfo(String name, MethodStructure method, TypeConstant typeTarget, int stepsOut) {
            this.name = name;
            this.id = method.getIdentityConstant();
            this.hasThis = !method.isFunction();
            this.typeTarget = typeTarget;
            this.stepsOut = stepsOut;
            this.type = null;
        }

        public TargetInfo(String name, TypeConstant typeTarget, int stepsOut) {
            assert (typeTarget.isExplicitClassIdentity(true));
            this.name = name;
            this.id = typeTarget.getSingleUnderlyingClass(true);
            this.hasThis = true;
            this.typeTarget = typeTarget;
            this.stepsOut = stepsOut;
            this.type = typeTarget;
        }

        public TargetInfo(TargetInfo that, TypeConstant typeNarrow) {
            this.name = that.name;
            this.id = that.id;
            this.hasThis = that.hasThis;
            this.typeTarget = that.typeTarget;
            this.stepsOut = that.stepsOut;
            this.type = typeNarrow;
        }

        public String getName() {
            return this.name;
        }

        public IdentityConstant getId() {
            return this.id;
        }

        public TypeConstant getTargetType() {
            return this.typeTarget;
        }

        public boolean hasThis() {
            return this.hasThis;
        }

        public int getStepsOut() {
            return this.stepsOut;
        }

        @Override
        public TypeConstant getType() {
            return this.type;
        }

        @Override
        public boolean isStack() {
            return false;
        }

        @Override
        public boolean isEffectivelyFinal() {
            return false;
        }

        @Override
        public Argument registerConstants(Op.ConstantRegistry registry) {
            throw new IllegalStateException();
        }

        public String toString() {
            return this.name + "->" + this.id.getValueString();
        }
    }
}

