/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.compiler.ast;

import java.lang.reflect.Field;
import org.xvm.asm.Argument;
import org.xvm.asm.ErrorListener;
import org.xvm.asm.MethodStructure;
import org.xvm.asm.ast.BinaryAST;
import org.xvm.asm.ast.ExprAST;
import org.xvm.asm.ast.StmtExprAST;
import org.xvm.asm.constants.TypeCollector;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.compiler.ast.Context;
import org.xvm.compiler.ast.Expression;
import org.xvm.compiler.ast.StatementBlock;
import org.xvm.util.Severity;

public class StatementExpression
extends Expression {
    protected StatementBlock body;
    private transient TypeConstant[] m_atypeRequired;
    private transient TypeCollector m_collector;
    private transient Expression.Assignable[] m_aLVal;
    private transient BinaryAST m_astBody;
    private static final Field[] CHILD_FIELDS = StatementExpression.fieldsForNames(StatementExpression.class, "body");

    public StatementExpression(StatementBlock body) {
        this.body = body;
    }

    @Override
    public long getStartPosition() {
        return this.body.getStartPosition();
    }

    @Override
    public long getEndPosition() {
        return this.body.getEndPosition();
    }

    @Override
    protected Field[] getChildFields() {
        return CHILD_FIELDS;
    }

    @Override
    public TypeConstant[] getReturnTypes() {
        return this.isValidated() ? this.getTypes() : this.m_atypeRequired;
    }

    @Override
    public boolean isReturnConditional() {
        return false;
    }

    @Override
    public void collectReturnTypes(TypeConstant[] atypeRet) {
        TypeCollector collector = this.m_collector;
        if (collector == null) {
            this.m_collector = collector = new TypeCollector(this.pool());
        }
        collector.add(atypeRet);
    }

    @Override
    protected boolean hasSingleValueImpl() {
        return false;
    }

    @Override
    protected boolean hasMultiValueImpl() {
        return true;
    }

    @Override
    public TypeConstant[] getImplicitTypes(Context ctx) {
        assert (this.m_atypeRequired == null && this.m_collector == null);
        if (this.isValidated()) {
            return this.getTypes();
        }
        StatementBlock blockTempOld = (StatementBlock)this.body.clone();
        blockTempOld.suppressScope();
        ctx = this.enterStatementContext(ctx);
        StatementBlock blockTempNew = (StatementBlock)blockTempOld.validate(ctx, ErrorListener.BLACKHOLE);
        ctx = ctx.exit();
        TypeConstant[] aTypes = null;
        if (blockTempNew != null && this.m_collector != null) {
            aTypes = this.m_collector.inferMulti(null);
        }
        this.m_collector = null;
        blockTempOld.discard(true);
        return aTypes;
    }

    @Override
    public Expression.TypeFit testFitMulti(Context ctx, TypeConstant[] atypeRequired, boolean fExhaustive, ErrorListener errs) {
        if (atypeRequired != null && atypeRequired.length == 0) {
            return Expression.TypeFit.Fit;
        }
        assert (this.m_atypeRequired == null && this.m_collector == null);
        if (this.isValidated()) {
            int cRequiredTypes = atypeRequired.length;
            TypeConstant[] aActualTypes = this.getTypes();
            int cActualTypes = aActualTypes.length;
            if (cRequiredTypes > cActualTypes) {
                return Expression.TypeFit.NoFit;
            }
            for (int i = 0; i < cRequiredTypes; ++i) {
                if (this.isA(ctx, aActualTypes[i], atypeRequired[i])) continue;
                return Expression.TypeFit.NoFit;
            }
            return Expression.TypeFit.Fit;
        }
        this.m_atypeRequired = atypeRequired;
        StatementBlock blockTempOld = (StatementBlock)this.body.clone();
        blockTempOld.suppressScope();
        ctx = this.enterStatementContext(ctx);
        StatementBlock blockTempNew = (StatementBlock)blockTempOld.validate(ctx, ErrorListener.BLACKHOLE);
        ctx = ctx.exit();
        Expression.TypeFit fit = Expression.TypeFit.NoFit;
        if (blockTempNew != null && this.m_collector != null) {
            TypeConstant[] aActualTypes = this.m_collector.inferMulti(atypeRequired);
            fit = this.calcFitMulti(ctx, aActualTypes, atypeRequired);
        }
        this.m_atypeRequired = null;
        this.m_collector = null;
        blockTempOld.discard(true);
        return fit;
    }

    @Override
    protected Expression validateMulti(Context ctx, TypeConstant[] atypeRequired, ErrorListener errs) {
        assert (this.m_atypeRequired == null && this.m_collector == null);
        this.m_atypeRequired = atypeRequired;
        Expression.TypeFit fit = Expression.TypeFit.Fit;
        TypeConstant[] atypeActual = null;
        StatementBlock bodyOld = this.body;
        bodyOld.suppressScope();
        ctx = this.enterStatementContext(ctx);
        StatementBlock bodyNew = (StatementBlock)bodyOld.validate(ctx, errs);
        ctx = ctx.exit();
        if (bodyNew == null) {
            fit = Expression.TypeFit.NoFit;
        } else {
            this.body = bodyNew;
            if (this.m_collector == null) {
                if (atypeRequired != null && atypeRequired.length == 0) {
                    atypeActual = atypeRequired;
                } else {
                    this.log(errs, Severity.ERROR, "COMPILER-49", new Object[0]);
                    fit = Expression.TypeFit.NoFit;
                }
            } else {
                atypeActual = this.m_collector.inferMulti(atypeRequired);
                this.m_collector = null;
                if (atypeActual == null) {
                    this.log(errs, Severity.ERROR, "COMPILER-43", atypeRequired == null || atypeRequired.length == 0 ? "void" : atypeRequired[0].getValueString(), "undefined");
                    fit = Expression.TypeFit.NoFit;
                }
            }
        }
        return this.finishValidations(ctx, atypeRequired, atypeActual, fit, null, errs);
    }

    @Override
    public void generateAssignments(Context ctx, MethodStructure.Code code, Expression.Assignable[] aLVal, ErrorListener errs) {
        this.m_aLVal = aLVal;
        if (this.body.completes(ctx, true, code, errs) && this.m_atypeRequired != null && this.m_atypeRequired.length > 0) {
            errs.log(Severity.ERROR, "COMPILER-49", null, this.getSource(), this.getEndPosition(), this.getEndPosition());
        }
        this.m_astBody = ctx.getHolder().getAst(this.body);
    }

    @Override
    public ExprAST getExprAST(Context ctx) {
        return new StmtExprAST(this.m_astBody, this.getTypes());
    }

    @Override
    protected Expression.SideEffect mightAffect(Expression exprLeft, Argument arg) {
        return super.mightAffect(exprLeft, arg) == Expression.SideEffect.DefNo ? Expression.SideEffect.DefNo : Expression.SideEffect.DefYes;
    }

    Expression.Assignable[] getAssignables() {
        return this.m_aLVal;
    }

    protected StatementExpressionContext enterStatementContext(Context ctx) {
        return new StatementExpressionContext(ctx);
    }

    @Override
    public String toString() {
        return this.body.toString();
    }

    @Override
    public String toDumpString() {
        return this.body.toDumpString();
    }

    protected static class StatementExpressionContext
    extends Context {
        public StatementExpressionContext(Context ctxOuter) {
            super(ctxOuter, true);
        }

        @Override
        public Context exit() {
            this.setReachable(true);
            return super.exit();
        }
    }
}

