/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.compiler.ast;

import java.lang.reflect.Field;
import java.util.List;
import org.xvm.asm.Constant;
import org.xvm.asm.ConstantPool;
import org.xvm.asm.ErrorListener;
import org.xvm.asm.MethodStructure;
import org.xvm.asm.ast.ExprAST;
import org.xvm.asm.ast.SwitchAST;
import org.xvm.asm.constants.TypeCollector;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.asm.op.Enter;
import org.xvm.asm.op.Exit;
import org.xvm.asm.op.Jump;
import org.xvm.asm.op.Label;
import org.xvm.compiler.Token;
import org.xvm.compiler.ast.AstNode;
import org.xvm.compiler.ast.CaseManager;
import org.xvm.compiler.ast.CaseStatement;
import org.xvm.compiler.ast.Context;
import org.xvm.compiler.ast.Expression;
import org.xvm.compiler.ast.ReturnStatement;
import org.xvm.util.Handy;
import org.xvm.util.Severity;

public class SwitchExpression
extends Expression {
    protected Token keyword;
    protected List<AstNode> cond;
    protected List<AstNode> contents;
    protected long lEndPos;
    private transient CaseManager<Expression> m_casemgr;
    private transient Constant[] m_aconstCases;
    private transient ExprAST[] m_abastBody;
    private static final Field[] CHILD_FIELDS = SwitchExpression.fieldsForNames(SwitchExpression.class, "cond", "contents");

    public SwitchExpression(Token keyword, List<AstNode> cond, List<AstNode> contents, long lEndPos) {
        this.keyword = keyword;
        this.cond = cond;
        this.contents = contents;
        this.lEndPos = lEndPos;
    }

    @Override
    public long getStartPosition() {
        return this.keyword.getStartPosition();
    }

    @Override
    public long getEndPosition() {
        return this.lEndPos;
    }

    @Override
    protected Field[] getChildFields() {
        return CHILD_FIELDS;
    }

    @Override
    protected boolean allowsConditional(Expression exprChild) {
        return this.getParent().allowsShortCircuit(this) && this.contents.contains(exprChild);
    }

    @Override
    protected boolean hasSingleValueImpl() {
        return false;
    }

    @Override
    protected boolean hasMultiValueImpl() {
        return true;
    }

    @Override
    public TypeConstant[] getImplicitTypes(Context ctx) {
        TypeCollector collector = new TypeCollector(this.pool());
        for (AstNode node : this.contents) {
            if (!(node instanceof Expression)) continue;
            Expression expr = (Expression)node;
            collector.add(expr.getImplicitTypes(ctx));
        }
        return collector.inferMulti(null);
    }

    @Override
    public Expression.TypeFit testFitMulti(Context ctx, TypeConstant[] atypeRequired, boolean fExhaustive, ErrorListener errs) {
        Expression.TypeFit fit = Expression.TypeFit.Fit;
        for (AstNode node : this.contents) {
            Expression expr;
            if (!(node instanceof Expression) || (fit = fit.combineWith((expr = (Expression)node).testFitMulti(ctx, atypeRequired, fExhaustive, errs))).isFit()) continue;
            return fit;
        }
        return fit;
    }

    @Override
    protected Expression validateMulti(Context ctx, TypeConstant[] atypeRequired, ErrorListener errs) {
        TypeConstant[] atypeRequest = atypeRequired == null ? this.getImplicitTypes(ctx) : atypeRequired;
        List<AstNode> listNodes = this.contents;
        CaseManager<Expression> mgr = new CaseManager<Expression>(this);
        this.m_casemgr = mgr;
        int nArity = mgr.computeArity(listNodes, errs);
        if (nArity == 0) {
            return null;
        }
        ctx = ctx.enter();
        boolean fValid = mgr.validateCondition(ctx, this.cond, nArity, errs);
        Context ctxCase = ctx.enterIf();
        ConstantPool pool = this.pool();
        TypeCollector collector = new TypeCollector(pool);
        boolean fInCase = false;
        int cExprs = 0;
        int cCases = 0;
        CaseStatement stmtPrev = null;
        int cNodes = listNodes.size();
        for (int iNode = 0; iNode < cNodes; ++iNode) {
            AstNode node = listNodes.get(iNode);
            if (node instanceof CaseStatement) {
                CaseStatement stmtCase = (CaseStatement)node;
                if (fInCase) {
                    ctxCase = ctxCase.enterOr();
                }
                fValid &= mgr.validateCase(ctxCase, stmtCase, errs);
                if (fInCase) {
                    ctxCase = ctxCase.exit();
                } else {
                    fInCase = true;
                }
                stmtPrev = stmtCase;
                cCases += stmtCase.getExpressionCount();
                continue;
            }
            if (!fInCase) {
                node.log(errs, Severity.ERROR, "COMPILER-79", new Object[0]);
                fValid = false;
                break;
            }
            fInCase = false;
            ++cExprs;
            ctxCase = ctxCase.enterFork(true);
            TypeConstant[] atypeReqScoped = atypeRequest;
            Context ctxScope = ctxCase.enter();
            if (fValid && mgr.hasTypeConditions() && cCases == 1 && mgr.addTypeInference(ctxScope, stmtPrev, errs) && atypeReqScoped != null && atypeReqScoped.length > 0) {
                atypeReqScoped = (TypeConstant[])atypeReqScoped.clone();
                int c = atypeReqScoped.length;
                for (int i = 0; i < c; ++i) {
                    atypeReqScoped[i] = ctxScope.resolveFormalType(atypeReqScoped[i]);
                }
            }
            Expression exprOld = (Expression)node;
            Expression exprNew = exprOld.validateMulti(ctxScope, atypeReqScoped, errs);
            ctxScope.discard();
            ctxCase = ctxCase.exit();
            mgr.endCaseGroup(exprNew == null ? exprOld : exprNew);
            if (iNode < cNodes - 1) {
                ctxCase = ctxCase.enterFork(false).enterIf();
            }
            if (exprNew == null) {
                fValid = false;
            } else {
                if (exprNew != exprOld) {
                    listNodes.set(iNode, exprNew);
                }
                if (exprNew.isCompletable()) {
                    collector.add(atypeRequest == null || atypeRequest.length == 0 ? exprNew.getTypes() : atypeRequest);
                }
            }
            cCases = 0;
        }
        int c = 2 * cExprs - 1;
        for (int i = 0; i < c; ++i) {
            ctxCase = ctxCase.exit();
        }
        fValid = fValid && mgr.validateEnd(ctxCase, errs);
        ctx = ctx.exit();
        TypeConstant[] atypeActual = TypeConstant.NO_TYPES;
        Constant[] aconstVal = null;
        if (fValid) {
            atypeActual = collector.inferMulti(atypeRequired);
            if (atypeActual.length == 0) {
                this.log(errs, Severity.ERROR, "COMPILER-168", new Object[0]);
                fValid = false;
            }
            if (mgr.isSwitchConstant()) {
                Expression exprResult = (Expression)mgr.getCookie(mgr.getSwitchConstantLabel());
                aconstVal = exprResult.toConstants();
            }
        }
        return fValid ? this.finishValidations(ctx, atypeRequired, atypeActual, Expression.TypeFit.Fit, aconstVal, errs) : null;
    }

    @Override
    public void generateAssignments(Context ctx, MethodStructure.Code code, Expression.Assignable[] aLVal, ErrorListener errs) {
        if (this.isConstant()) {
            super.generateAssignments(ctx, code, aLVal, errs);
        } else {
            boolean fScope = this.m_casemgr.hasDeclarations();
            if (fScope) {
                code.add(new Enter());
            }
            if (this.m_casemgr.usesIfLadder()) {
                this.m_casemgr.generateIfLadder(ctx, code, this.contents, errs);
            } else {
                this.m_casemgr.generateJumpTable(ctx, code, errs);
            }
            this.generateCaseBodies(ctx, code, aLVal, errs);
            if (fScope) {
                code.add(new Exit());
            }
        }
    }

    private void generateCaseBodies(Context ctx, MethodStructure.Code code, Expression.Assignable[] aLVal, ErrorListener errs) {
        List<AstNode> aNodes = this.contents;
        int cNodes = aNodes.size();
        Label labelCur = null;
        Label labelExit = new Label("switch_end");
        int cCases = this.m_casemgr.getCaseCount();
        Constant[] aconstCase = new Constant[cCases];
        ExprAST[] abastBody = new ExprAST[cCases];
        int iCase = -1;
        for (int i = 0; i < cNodes; ++i) {
            AstNode node = aNodes.get(i);
            if (node instanceof CaseStatement) {
                CaseStatement stmtCase = (CaseStatement)node;
                labelCur = stmtCase.getLabel();
                iCase = stmtCase.collectConstants(iCase, aconstCase);
                continue;
            }
            assert (iCase >= 0 && iCase < cCases);
            Expression expr = (Expression)node;
            expr.updateLineNumber(code);
            code.add(labelCur);
            expr.generateAssignments(ctx, code, aLVal, errs);
            code.add(new Jump(labelExit));
            assert (abastBody[iCase] == null);
            abastBody[iCase] = expr.getExprAST(ctx);
        }
        code.add(labelExit);
        this.m_aconstCases = aconstCase;
        this.m_abastBody = abastBody;
    }

    @Override
    public boolean isCompletable() {
        return this.isShortCircuiting() || this.m_casemgr == null || !this.m_casemgr.isConditionAborting();
    }

    @Override
    public boolean isConditionalResult() {
        ReturnStatement stmtReturn;
        AstNode astNode = this.getParent();
        return astNode instanceof ReturnStatement && (stmtReturn = (ReturnStatement)astNode).getCodeContainer().isReturnConditional();
    }

    @Override
    public boolean isShortCircuiting() {
        if (this.cond != null) {
            for (AstNode node : this.cond) {
                Expression expr;
                if (!(node instanceof Expression) || !(expr = (Expression)node).isShortCircuiting()) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public ExprAST getExprAST(Context ctx) {
        return this.isConstant() ? SwitchExpression.toExprAst(this.toConstant()) : new SwitchAST(this.m_casemgr.getConditionBAST(), this.m_casemgr.getConditionIsA(), this.m_aconstCases, this.m_abastBody, this.getTypes());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("switch (");
        if (this.cond != null && !this.cond.isEmpty()) {
            boolean fFirst = true;
            for (AstNode node : this.cond) {
                if (fFirst) {
                    fFirst = false;
                } else {
                    sb.append(", ");
                }
                sb.append(node);
            }
        }
        sb.append(")\n    {");
        for (AstNode node : this.contents) {
            if (node instanceof CaseStatement) {
                sb.append('\n').append(Handy.indentLines(node.toString(), "    "));
                continue;
            }
            sb.append(' ').append(node).append(';');
        }
        sb.append("\n}");
        return sb.toString();
    }
}

