/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.compiler.ast;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.xvm.asm.Argument;
import org.xvm.asm.Assignment;
import org.xvm.asm.Constant;
import org.xvm.asm.ErrorListener;
import org.xvm.asm.MethodStructure;
import org.xvm.asm.Register;
import org.xvm.asm.ast.BinaryAST;
import org.xvm.asm.ast.StmtBlockAST;
import org.xvm.asm.ast.SwitchAST;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.asm.op.Enter;
import org.xvm.asm.op.Exit;
import org.xvm.asm.op.Label;
import org.xvm.compiler.Token;
import org.xvm.compiler.ast.AstNode;
import org.xvm.compiler.ast.CaseManager;
import org.xvm.compiler.ast.CaseStatement;
import org.xvm.compiler.ast.ComponentStatement;
import org.xvm.compiler.ast.ConditionalStatement;
import org.xvm.compiler.ast.Context;
import org.xvm.compiler.ast.Statement;
import org.xvm.compiler.ast.StatementBlock;
import org.xvm.compiler.ast.TypeCompositionStatement;
import org.xvm.util.Handy;
import org.xvm.util.Severity;

public class SwitchStatement
extends ConditionalStatement {
    protected StatementBlock block;
    private transient CaseManager<CaseGroup> m_casemgr;
    private transient List<CaseGroup> m_listGroups;
    private transient Label m_labelContinue;
    private transient List<Statement.Break> m_listContinues;
    private final transient List<Map<String, Assignment>> m_listBreaks = new ArrayList<Map<String, Assignment>>();
    private static final Field[] CHILD_FIELDS = SwitchStatement.fieldsForNames(SwitchStatement.class, "conds", "block");

    public SwitchStatement(Token keyword, List<AstNode> conds, StatementBlock block) {
        super(keyword, conds);
        this.block = block;
    }

    @Override
    public boolean isNaturalGotoStatementTarget() {
        return true;
    }

    @Override
    public Label ensureContinueLabel(AstNode nodeOrigin, Context ctxOrigin) {
        Context ctxDest = this.ensureValidationContext();
        if (this.m_labelContinue == null) {
            assert (this.m_listContinues == null);
            int iGroup = this.m_casemgr.getCaseGroupCount() - 1;
            assert (iGroup >= 0);
            this.m_labelContinue = new Label("fall_through_from_case_group_" + iGroup);
            this.m_listContinues = new ArrayList<Statement.Break>();
        }
        if (ctxOrigin.isReachable()) {
            HashMap<String, Assignment> mapAsn = new HashMap<String, Assignment>();
            HashMap<String, Argument> mapArg = new HashMap<String, Argument>();
            ctxOrigin.prepareJump(ctxDest, mapAsn, mapArg);
            this.m_listContinues.add(new Statement.Break(nodeOrigin, mapAsn, mapArg, this.m_labelContinue));
        }
        return this.m_labelContinue;
    }

    @Override
    public long getEndPosition() {
        return this.block.getEndPosition();
    }

    @Override
    protected Field[] getChildFields() {
        return CHILD_FIELDS;
    }

    @Override
    protected Statement validateImpl(Context ctx, ErrorListener errs) {
        boolean fValid = true;
        CaseManager<CaseGroup> mgr = new CaseManager<CaseGroup>(this);
        List<Statement> listStmts = this.block.stmts;
        int nArity = mgr.computeArity(listStmts, errs);
        if (nArity == 0) {
            return null;
        }
        this.m_listGroups = new ArrayList<CaseGroup>();
        this.m_casemgr = mgr;
        SwitchContext ctxSwitch = new SwitchContext(ctx, mgr);
        fValid &= mgr.validateCondition(ctxSwitch, this.conds, nArity, errs);
        int cStmts = listStmts.size();
        boolean fInCase = false;
        Context ctxBlock = null;
        CaseGroup group = null;
        for (int i = 0; i < cStmts; ++i) {
            Statement stmt = listStmts.get(i);
            if (stmt instanceof CaseStatement) {
                CaseStatement stmtCase = (CaseStatement)stmt;
                if (ctxBlock != null) {
                    assert (group != null);
                    if (this.m_labelContinue == null && ctxBlock.isReachable()) {
                        listStmts.get(group.iFirstCase).log(errs, Severity.ERROR, "COMPILER-117", new Object[0]);
                        fValid = false;
                    }
                    group.fScope = ctxBlock.isAnyVarDeclaredInThisScope();
                    group.labelContinueTo = this.m_labelContinue;
                    group = null;
                    ((CaseBlockContext)ctxBlock).exit();
                    ctxBlock = null;
                }
                if (!fInCase) {
                    fInCase = true;
                    assert (group == null);
                    group = new CaseGroup();
                    group.iGroup = this.m_listGroups.size();
                    group.iFirstCase = i;
                    this.m_listGroups.add(group);
                }
                fValid &= mgr.validateCase(ctxSwitch, stmtCase, errs);
            } else {
                Statement stmtNew;
                if (fInCase) {
                    assert (group != null && group.iFirstStmt < 0);
                    group.iFirstStmt = i;
                    mgr.endCaseGroup(group);
                    fInCase = false;
                    assert (ctxBlock == null);
                    ctxBlock = ctxSwitch.enterBlock();
                    if (fValid && mgr.hasTypeConditions()) {
                        int cCases = 0;
                        CaseStatement stmtCase = null;
                        for (int iCase = group.iFirstCase; iCase < group.iFirstStmt; ++iCase) {
                            stmtCase = (CaseStatement)listStmts.get(iCase);
                            cCases += stmtCase.getExpressionCount();
                        }
                        if (cCases == 1) {
                            mgr.addTypeInference(ctxBlock, stmtCase, errs);
                        }
                    }
                    if (this.m_labelContinue != null) {
                        boolean fContinues = false;
                        for (Statement.Break continueInfo : this.m_listContinues) {
                            if (continueInfo.node().isDiscarded()) continue;
                            ctxBlock.merge(continueInfo.mapAssign(), continueInfo.mapNarrow());
                            fContinues = true;
                        }
                        if (fContinues) {
                            ctx.setReachable(true);
                        }
                        this.m_labelContinue = null;
                        this.m_listContinues = null;
                    }
                }
                if ((stmtNew = stmt.validate(ctxBlock, errs)) != stmt) {
                    if (stmtNew == null) {
                        fValid = false;
                    } else {
                        this.block.stmts = listStmts = SwitchStatement.ensureArrayList(listStmts);
                        listStmts.set(i, stmtNew);
                    }
                }
            }
            if (errs.isAbortDesired()) break;
        }
        if (ctxBlock != null) {
            if (this.m_labelContinue == null) {
                assert (group != null);
                group.fScope = ctxBlock.isAnyVarDeclaredInThisScope();
                group.labelContinueTo = null;
                if (ctxBlock.isReachable()) {
                    listStmts.get(group.iFirstCase).log(errs, Severity.ERROR, "COMPILER-117", new Object[0]);
                    fValid = false;
                }
            } else {
                listStmts.getLast().log(errs, Severity.ERROR, "COMPILER-191", new Object[0]);
                fValid = false;
            }
            ((CaseBlockContext)ctxBlock).exit();
        }
        fValid &= mgr.validateEnd(ctxSwitch, errs);
        if (this.m_listContinues != null) {
            for (Statement.Break continueInfo : this.m_listContinues) {
                if (continueInfo.node().isDiscarded()) continue;
                this.addBreak(continueInfo);
            }
            this.m_listContinues = null;
        }
        if (!this.m_listBreaks.isEmpty()) {
            ctxSwitch.mergeBreaks(this.m_listBreaks);
            this.m_listBreaks.clear();
        }
        ctx = ctxSwitch.exit();
        return fValid ? this : null;
    }

    @Override
    protected void addBreak(Statement.Break breakInfo) {
        this.m_listBreaks.add(breakInfo.mapAssign());
        super.addBreak(new Statement.Break(breakInfo.node(), Collections.emptyMap(), breakInfo.mapNarrow(), breakInfo.label()));
    }

    @Override
    protected boolean emit(Context ctx, boolean fReachable, MethodStructure.Code code, ErrorListener errs) {
        CaseManager<CaseGroup> mgr = this.m_casemgr;
        int cCases = mgr.getCaseCount();
        Constant[] aconstCase = new Constant[cCases];
        ArrayList<BinaryAST> listBodies = new ArrayList<BinaryAST>(cCases);
        if (mgr.isSwitchConstant()) {
            CaseGroup groupStart = mgr.getCookie(mgr.getSwitchConstantLabel());
            int cGroups = this.m_listGroups.size();
            int iCase = -1;
            for (int iGroup = groupStart.iGroup; iGroup < cGroups; ++iGroup) {
                iCase = this.emitCaseGroup(ctx, fReachable, code, iGroup, aconstCase, listBodies, iCase, errs);
                if (this.m_listGroups.get((int)iGroup).labelContinueTo == null) break;
            }
            if (!errs.hasSeriousErrors()) {
                ctx.getHolder().setAst(this, new StmtBlockAST(listBodies.toArray(BinaryAST.NO_ASTS), true));
            }
            return false;
        }
        if (mgr.hasDeclarations()) {
            code.add(new Enter());
        }
        if (mgr.usesIfLadder()) {
            mgr.generateIfLadder(ctx, code, this.block.stmts, errs);
        } else {
            mgr.generateJumpTable(ctx, code, errs);
        }
        int cGroups = this.m_listGroups.size();
        int iCase = -1;
        for (int iGroup = 0; iGroup < cGroups; ++iGroup) {
            iCase = this.emitCaseGroup(ctx, fReachable, code, iGroup, aconstCase, listBodies, iCase, errs);
        }
        if (mgr.hasDeclarations()) {
            code.add(new Exit());
        }
        if (this.m_labelContinue != null) {
            code.add(this.m_labelContinue);
        }
        ctx.getHolder().setAst(this, new SwitchAST(mgr.getConditionBAST(), mgr.getConditionIsA(), aconstCase, listBodies.toArray(BinaryAST.NO_ASTS)));
        return mgr.isCompletable();
    }

    private int emitCaseGroup(Context ctx, boolean fReachable, MethodStructure.Code code, int iGroup, Constant[] aconstCase, List<BinaryAST> listBodies, int iCase, ErrorListener errs) {
        Label labelContinueFrom;
        boolean fCompletes = fReachable;
        CaseGroup group = this.m_listGroups.get(iGroup);
        if (iGroup > 0 && (labelContinueFrom = this.m_listGroups.get((int)(iGroup - 1)).labelContinueTo) != null) {
            code.add(labelContinueFrom);
        }
        List<Statement> listStmts = this.block.stmts;
        int iFirstCase = group.iFirstCase;
        int iFirstStmt = group.iFirstStmt;
        code.add(((CaseStatement)listStmts.get(iFirstCase)).getLabel());
        for (int iStmt = iFirstCase; iStmt < iFirstStmt; ++iStmt) {
            CaseStatement stmtCase = (CaseStatement)listStmts.get(iStmt);
            iCase = stmtCase.collectConstants(iCase, aconstCase);
        }
        if (group.fScope) {
            code.add(new Enter());
        }
        ArrayList<BinaryAST> listAst = new ArrayList<BinaryAST>();
        int cStmts = listStmts.size();
        for (int iStmt = group.iFirstStmt; iStmt < cStmts; ++iStmt) {
            BinaryAST ast;
            Statement stmt = listStmts.get(iStmt);
            if (stmt instanceof CaseStatement) {
                if (!fReachable || !fCompletes) break;
                stmt.log(errs, Severity.ERROR, "COMPILER-117", new Object[0]);
                break;
            }
            if (fReachable && !fCompletes) {
                fReachable = false;
                if (!(stmt instanceof TypeCompositionStatement)) {
                    stmt.log(errs, Severity.ERROR, "COMPILER-46", new Object[0]);
                    break;
                }
            }
            fCompletes = stmt.completes(ctx, fCompletes, code, errs);
            if (stmt instanceof ComponentStatement || (ast = ctx.getHolder().getAst(stmt)) == null) continue;
            listAst.add(ast);
        }
        if (group.fScope) {
            code.add(new Exit());
        }
        listBodies.add(new StmtBlockAST(listAst.toArray(BinaryAST.NO_ASTS), true));
        return iCase;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("switch (");
        if (this.conds != null) {
            sb.append(this.conds.get(0));
            int c = this.conds.size();
            for (int i = 1; i < c; ++i) {
                sb.append(", ").append(this.conds.get(i));
            }
        }
        sb.append(")\n").append(Handy.indentLines(this.block.toString(), "    "));
        return sb.toString();
    }

    protected static class SwitchContext
    extends Context {
        private final CaseManager f_mgr;
        private final List<CaseBlockContext> f_listBlocks = new ArrayList<CaseBlockContext>();

        protected SwitchContext(Context ctxOuter, CaseManager mgr) {
            super(ctxOuter, true);
            this.f_mgr = mgr;
        }

        protected CaseBlockContext enterBlock() {
            CaseBlockContext ctxBlock = new CaseBlockContext(this);
            this.f_listBlocks.add(ctxBlock);
            return ctxBlock;
        }

        @Override
        public Context exit() {
            Context ctxOuter = this.getOuterContext();
            boolean fCompletes = this.f_mgr.isCompletable();
            this.promoteAssignments(ctxOuter);
            if (!fCompletes) {
                this.promoteNarrowedTypes();
                ctxOuter.setReachable(false);
            }
            return ctxOuter;
        }

        @Override
        protected void promoteNarrowedTypes() {
            List<CaseBlockContext> listBlocks = this.f_listBlocks;
            int cBlocks = listBlocks.size();
            if (cBlocks == 0) {
                return;
            }
            if (cBlocks == 1) {
                listBlocks.get(0).promoteNarrowedTypes();
                return;
            }
            HashMap<String, Integer> mapAllNames = new HashMap<String, Integer>();
            for (CaseBlockContext ctxBlock : listBlocks) {
                for (String string : ctxBlock.getNameMap().keySet()) {
                    if (ctxBlock.isVarDeclaredInThisScope(string)) continue;
                    mapAllNames.compute(string, (k, v) -> v == null ? 1 : v + 1);
                }
            }
            Map<String, Argument> mapThis = this.ensureNameMap();
            CaseBlockContext ctx0 = listBlocks.get(0);
            block2: for (Map.Entry entry : mapAllNames.entrySet()) {
                String sName = (String)entry.getKey();
                if ((Integer)entry.getValue() != cBlocks) {
                    Register reg;
                    Argument argOrig = this.getVar(sName);
                    if (!(argOrig instanceof Register) || (reg = (Register)argOrig).isInPlace()) continue;
                    mapThis.put(sName, reg.restoreType());
                    continue;
                }
                Argument argPrev = ctx0.getNameMap().get(sName);
                for (int i = 1; i < cBlocks; ++i) {
                    TypeConstant typeNext;
                    Argument argNext = listBlocks.get(i).getNameMap().get(sName);
                    TypeConstant typePrev = argPrev.getType();
                    if (typePrev.isA(typeNext = argNext.getType())) {
                        mapThis.put(sName, argNext);
                        argPrev = argNext;
                        continue;
                    }
                    if (typeNext.isA(typePrev)) {
                        mapThis.put(sName, argPrev);
                        continue;
                    }
                    mapThis.remove(sName);
                    continue block2;
                }
            }
            if (!mapThis.isEmpty()) {
                super.promoteNarrowedTypes();
            }
        }

        protected void mergeBreaks(List<Map<String, Assignment>> listAdd) {
            HashMap<String, Integer> mapAllNames = new HashMap<String, Integer>();
            HashMap<String, Assignment> mapThis = new HashMap<String, Assignment>();
            for (Map<String, Assignment> mapAdd : listAdd) {
                for (String string : mapAdd.keySet()) {
                    mapThis.computeIfAbsent(string, this::getVarAssignment);
                    mapAllNames.compute(string, (k, v) -> v == null ? 1 : v + 1);
                }
            }
            boolean fCompletes = this.f_mgr.isCompletable();
            int cBlocks = listAdd.size();
            for (Map map : listAdd) {
                for (Map.Entry entry : map.entrySet()) {
                    String sName = (String)entry.getKey();
                    Assignment asnThat = (Assignment)((Object)entry.getValue());
                    Assignment asnThis = (Assignment)((Object)mapThis.get(sName));
                    if ((Integer)mapAllNames.get(sName) == cBlocks && !fCompletes) {
                        if (asnThis.isDefinitelyAssigned()) {
                            mapThis.put(sName, asnThis.join(asnThat));
                            continue;
                        }
                        mapThis.put(sName, asnThat);
                        continue;
                    }
                    if (asnThis.isDefinitelyUnassigned()) continue;
                    mapThis.put(sName, asnThis.join(asnThat));
                }
            }
            this.ensureDefiniteAssignments().putAll(mapThis);
        }

        @Override
        protected void unlink(Context ctxDiscarded) {
            List<CaseBlockContext> list = this.f_listBlocks;
            for (int i = list.size() - 1; i >= 0; --i) {
                if (list.get(i) != ctxDiscarded) continue;
                list.remove(i);
            }
        }
    }

    protected static class CaseBlockContext
    extends Context {
        protected CaseBlockContext(SwitchContext ctxOuter) {
            super(ctxOuter, true);
        }

        @Override
        public Context exit() {
            Context ctxOuter = this.getOuterContext();
            this.promoteAssignments(ctxOuter);
            return ctxOuter;
        }
    }

    protected static class CaseGroup {
        int iGroup = -1;
        int iFirstCase = -1;
        int iFirstStmt = -1;
        boolean fScope;
        Label labelContinueTo;

        protected CaseGroup() {
        }
    }
}

