/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.compiler.ast;

import java.lang.reflect.Field;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import org.xvm.asm.Argument;
import org.xvm.asm.ErrorListener;
import org.xvm.asm.ast.ExprAST;
import org.xvm.asm.ast.UnaryOpExprAST;
import org.xvm.compiler.Compiler;
import org.xvm.compiler.ast.Context;
import org.xvm.compiler.ast.Expression;
import org.xvm.compiler.ast.PackExpression;
import org.xvm.compiler.ast.ToIntExpression;
import org.xvm.compiler.ast.TraceExpression;

public abstract class SyntheticExpression
extends Expression {
    protected Expression expr;
    private static final Field[] CHILD_FIELDS = SyntheticExpression.fieldsForNames(SyntheticExpression.class, "expr");

    public SyntheticExpression(Expression expr) {
        this.expr = expr;
        expr.getParent().adopt(this);
        this.adopt(expr);
    }

    public Expression getUnderlyingExpression() {
        return this.expr;
    }

    @Override
    public Compiler.Stage getStage() {
        Compiler.Stage stageThat;
        Compiler.Stage stageThis = super.getStage();
        return stageThis.compareTo(stageThat = this.expr.getStage()) > 0 ? stageThis : stageThat;
    }

    @Override
    public long getStartPosition() {
        return this.expr.getStartPosition();
    }

    @Override
    public long getEndPosition() {
        return this.expr.getEndPosition();
    }

    @Override
    protected Field[] getChildFields() {
        return CHILD_FIELDS;
    }

    @Override
    public boolean isAssignable(Context ctx) {
        return this.expr.isAssignable(ctx);
    }

    @Override
    public void requireAssignable(Context ctx, ErrorListener errs) {
        this.expr.requireAssignable(ctx, errs);
    }

    @Override
    public void markAssignment(Context ctx, boolean fCond, ErrorListener errs) {
        this.expr.markAssignment(ctx, fCond, errs);
    }

    @Override
    public boolean isCompletable() {
        return this.expr.isCompletable();
    }

    @Override
    public boolean isShortCircuiting() {
        return this.expr.isShortCircuiting();
    }

    @Override
    public ExprAST getExprAST(Context ctx) {
        if (this.isConstant()) {
            return this.expr.getExprAST(ctx);
        }
        SyntheticExpression syntheticExpression = this;
        Objects.requireNonNull(syntheticExpression);
        SyntheticExpression syntheticExpression2 = syntheticExpression;
        int n = 0;
        UnaryOpExprAST.Operator op = switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{PackExpression.class, ToIntExpression.class, TraceExpression.class}, (SyntheticExpression)syntheticExpression2, n)) {
            case 0 -> {
                PackExpression ignored = (PackExpression)syntheticExpression2;
                yield UnaryOpExprAST.Operator.Pack;
            }
            case 1 -> {
                ToIntExpression ignored = (ToIntExpression)syntheticExpression2;
                yield UnaryOpExprAST.Operator.ToInt;
            }
            case 2 -> {
                TraceExpression ignored = (TraceExpression)syntheticExpression2;
                yield UnaryOpExprAST.Operator.Trace;
            }
            default -> throw new UnsupportedOperationException();
        };
        return new UnaryOpExprAST(this.expr.getExprAST(ctx), op, this.getType());
    }

    @Override
    protected Expression.SideEffect mightAffect(Expression exprLeft, Argument arg) {
        return this.expr.mightAffect(exprLeft, arg);
    }

    @Override
    public abstract String toString();

    @Override
    public String getDumpDesc() {
        return this.toString();
    }
}

