/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.compiler.ast;

import java.lang.reflect.Field;
import java.util.List;
import org.xvm.asm.Assignment;
import org.xvm.asm.Constant;
import org.xvm.asm.ConstantPool;
import org.xvm.asm.ErrorListener;
import org.xvm.asm.MethodStructure;
import org.xvm.asm.Register;
import org.xvm.asm.ast.ExprAST;
import org.xvm.asm.ast.TemplateExprAST;
import org.xvm.asm.constants.MethodConstant;
import org.xvm.asm.constants.StringConstant;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.asm.constants.TypeInfo;
import org.xvm.asm.op.Enter;
import org.xvm.asm.op.Exit;
import org.xvm.asm.op.Invoke_01;
import org.xvm.asm.op.Invoke_10;
import org.xvm.asm.op.New_1;
import org.xvm.compiler.Token;
import org.xvm.compiler.ast.AstNode;
import org.xvm.compiler.ast.Context;
import org.xvm.compiler.ast.Expression;
import org.xvm.compiler.ast.TypeExpression;
import org.xvm.util.Handy;

public class TemplateExpression
extends Expression {
    protected TypeExpression type;
    protected List<Expression> exprs;
    protected long lStartPos;
    protected long lEndPos;
    private Register m_reg$;
    private static final Field[] CHILD_FIELDS = TemplateExpression.fieldsForNames(TemplateExpression.class, "type", "exprs");

    public TemplateExpression(List<Expression> exprs, long lStartPos, long lEndPos) {
        this.exprs = exprs;
        this.lStartPos = lStartPos;
        this.lEndPos = lEndPos;
    }

    public List<Expression> getExpressions() {
        return this.exprs;
    }

    @Override
    public long getStartPosition() {
        return this.lStartPos;
    }

    @Override
    public long getEndPosition() {
        return this.lEndPos;
    }

    @Override
    protected Field[] getChildFields() {
        return CHILD_FIELDS;
    }

    @Override
    public TypeConstant getImplicitType(Context ctx) {
        return this.pool().typeString();
    }

    @Override
    protected boolean allowsShortCircuit(AstNode nodeChild) {
        return false;
    }

    @Override
    protected Expression validate(Context ctx, TypeConstant typeRequired, ErrorListener errs) {
        boolean fValid = true;
        boolean fConst = true;
        ctx = ctx.enter();
        TypeConstant T_OBJECT = this.pool().typeObject();
        TypeConstant T_STRING = this.pool().typeString();
        TypeConstant[] A_OBJECT = new TypeConstant[]{T_OBJECT};
        TypeConstant[] A_STRING = new TypeConstant[]{T_STRING};
        this.m_reg$ = ctx.createRegister(this.pool().typeStringBuffer(), "$");
        Token tok$ = new Token(this.getStartPosition(), this.getStartPosition(), Token.Id.IDENTIFIER, "$");
        ctx.registerVar(tok$, this.m_reg$, errs);
        ctx.setVarAssignment("$", Assignment.AssignedOnce);
        int cExprs = this.exprs.size();
        for (int i = 0; i < cExprs; ++i) {
            Expression exprOld;
            TypeConstant[] atypeExpr = (exprOld = this.exprs.get(i)).testFit(ctx, T_STRING, false, null).isFit() ? A_STRING : (exprOld.testFit(ctx, T_OBJECT, false, null).isFit() ? A_OBJECT : TypeConstant.NO_TYPES);
            Expression exprNew = exprOld.validateMulti(ctx, atypeExpr, errs);
            if (exprNew == null) {
                fValid = false;
                continue;
            }
            if (exprNew != exprOld) {
                this.exprs.set(i, exprNew);
            }
            fConst &= exprNew.isConstant();
        }
        StringConstant constVal = null;
        if (fValid && fConst) {
            ConstantPool pool = this.pool();
            StringBuilder sb = new StringBuilder();
            for (Expression expr : this.exprs) {
                Constant constExpr;
                TypeConstant[] atype = expr.getTypes();
                if (atype.length <= 0) continue;
                Constant constant = constExpr = atype[0].getDefiningConstant().equals(pool.clzProperty()) ? null : expr.toConstant().convertTo(T_STRING);
                if (constExpr == null) {
                    fConst = false;
                    break;
                }
                sb.append(((StringConstant)constExpr).getValue());
            }
            constVal = fConst ? pool.ensureStringConstant(sb.toString()) : null;
        }
        ctx = ctx.exit();
        return this.finishValidation(ctx, typeRequired, T_STRING, fValid ? Expression.TypeFit.Fit : Expression.TypeFit.NoFit, constVal, errs);
    }

    @Override
    public void generateAssignment(Context ctx, MethodStructure.Code code, Expression.Assignable LVal, ErrorListener errs) {
        if (this.isConstant()) {
            LVal.assign(this.toConstant(), code, errs);
            return;
        }
        if (!LVal.isLocalArgument()) {
            super.generateAssignment(ctx, code, LVal, errs);
            return;
        }
        code.add(new Enter());
        int cchMin = 0;
        ConstantPool pool = this.pool();
        for (Expression expr : this.exprs) {
            if (!this.isStringConst(expr)) continue;
            cchMin += this.getStringConst(expr).length();
        }
        TypeConstant typeBuf = pool.typeStringBuffer();
        TypeInfo infoBuf = typeBuf.ensureTypeInfo(errs);
        TypeConstant typeInt = pool.typeInt64();
        MethodConstant idNewBuf = infoBuf.findConstructor(new TypeConstant[]{typeInt});
        assert (idNewBuf != null);
        code.add(new New_1(idNewBuf, pool.ensureIntConstant(cchMin), this.m_reg$));
        TypeConstant typeStr = pool.typeStringable();
        TypeInfo infoStr = typeStr.ensureTypeInfo(errs);
        Expression.Assignable lvalStr = this.createTempVar(code, typeStr, true);
        TypeConstant typeObj = pool.typeObject();
        Expression.Assignable lvalObj = this.createTempVar(code, typeObj, true);
        MethodConstant idAppendTo = infoStr.findCallable("appendTo", true, false, null, null);
        MethodConstant idAppend = infoBuf.findCallable("append", true, false, null, null);
        for (Expression expr : this.exprs) {
            if (this.isStringConst(expr)) {
                code.add(new Invoke_10(expr.toConstant(), idAppendTo, this.m_reg$));
                continue;
            }
            if (expr.isVoid()) {
                expr.generateVoid(ctx, code, errs);
                continue;
            }
            if (this.isStringable(expr)) {
                expr.generateAssignment(ctx, code, lvalStr, errs);
                code.add(new Invoke_10(lvalStr.getLocalArgument(), idAppendTo, this.m_reg$));
                continue;
            }
            expr.generateAssignment(ctx, code, lvalObj, errs);
            code.add(new Invoke_10(this.m_reg$, idAppend, lvalObj.getLocalArgument()));
        }
        MethodConstant idToString = infoBuf.findCallable("toString", true, false, new TypeConstant[]{pool.typeString()}, null);
        code.add(new Invoke_01(this.m_reg$, idToString, LVal.getLocalArgument()));
        code.add(new Exit());
    }

    @Override
    public ExprAST getExprAST(Context ctx) {
        int cExprs = this.exprs.size();
        ExprAST[] aExpr = new ExprAST[1 + cExprs];
        aExpr[0] = this.m_reg$.getRegAllocAST();
        for (int i = 0; i < cExprs; ++i) {
            aExpr[i + 1] = this.exprs.get(i).getExprAST(ctx);
        }
        return new TemplateExprAST(aExpr);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("$\"");
        for (Expression expr : this.exprs) {
            if (this.isStringConst(expr)) {
                for (char ch : this.getStringConst(expr).toCharArray()) {
                    Handy.appendChar(sb, ch);
                }
                continue;
            }
            sb.append('{').append(expr).append('}');
        }
        sb.append('\"');
        return sb.toString();
    }

    @Override
    public String getDumpDesc() {
        return this.toString();
    }

    boolean isStringConst(Expression expr) {
        return expr.toConstant() instanceof StringConstant && expr.getTypes().length > 0;
    }

    String getStringConst(Expression expr) {
        return ((StringConstant)expr.toConstant()).getValue();
    }

    boolean isStringable(Expression expr) {
        return expr.getTypes().length > 0 && expr.getType().isA(this.pool().typeStringable());
    }
}

