/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.compiler.ast;

import java.lang.reflect.Field;
import org.xvm.asm.Argument;
import org.xvm.asm.ConstantPool;
import org.xvm.asm.ErrorListener;
import org.xvm.asm.MethodStructure;
import org.xvm.asm.ast.ExprAST;
import org.xvm.asm.ast.TernaryExprAST;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.asm.op.Jump;
import org.xvm.asm.op.JumpFalse;
import org.xvm.asm.op.Label;
import org.xvm.asm.op.Return_1;
import org.xvm.asm.op.Return_N;
import org.xvm.compiler.ast.Context;
import org.xvm.compiler.ast.Expression;

public class TernaryExpression
extends Expression {
    protected Expression cond;
    protected Expression exprThen;
    protected Expression exprElse;
    private transient boolean m_fConditional;
    private transient Plan m_plan = Plan.Symmetrical;
    private static final Field[] CHILD_FIELDS = TernaryExpression.fieldsForNames(TernaryExpression.class, "cond", "exprThen", "exprElse");

    public TernaryExpression(Expression cond, Expression exprThen, Expression exprElse) {
        this.cond = cond;
        this.exprThen = exprThen;
        this.exprElse = exprElse;
    }

    @Override
    public long getStartPosition() {
        return this.cond.getStartPosition();
    }

    @Override
    public long getEndPosition() {
        return this.exprElse.getEndPosition();
    }

    @Override
    protected Field[] getChildFields() {
        return CHILD_FIELDS;
    }

    @Override
    public void markConditional() {
        this.m_fConditional = true;
        this.exprThen.markConditional();
        this.exprElse.markConditional();
    }

    @Override
    protected boolean allowsConditional(Expression exprChild) {
        return this.getParent().allowsConditional(this) && (exprChild == this.exprThen || exprChild == this.exprElse);
    }

    @Override
    protected boolean hasSingleValueImpl() {
        return false;
    }

    @Override
    protected boolean hasMultiValueImpl() {
        return true;
    }

    @Override
    public TypeConstant[] getImplicitTypes(Context ctx) {
        TypeConstant[] atypeElse;
        TypeConstant[] atypeThen = this.exprThen.getImplicitTypes(ctx);
        int c = atypeThen.length;
        if (c != (atypeElse = this.exprElse.getImplicitTypes(ctx)).length) {
            return TypeConstant.NO_TYPES;
        }
        return this.selectCommonTypes(atypeThen, atypeElse);
    }

    @Override
    public Expression.TypeFit testFitMulti(Context ctx, TypeConstant[] atypeRequired, boolean fExhaustive, ErrorListener errs) {
        switch (this.generatePlan(ctx, fExhaustive).ordinal()) {
            case 1: {
                return this.exprElse.testFitMulti(ctx, atypeRequired, fExhaustive, errs);
            }
            case 2: {
                return this.exprThen.testFitMulti(ctx, atypeRequired, fExhaustive, errs);
            }
            case 0: {
                Expression.TypeFit fitThen = this.exprThen.testFitMulti(ctx, atypeRequired, fExhaustive, errs);
                Expression.TypeFit fitElse = this.exprElse.testFitMulti(ctx, atypeRequired, fExhaustive, errs);
                if (fitThen.isFit() && fitElse.isFit()) {
                    return fitThen.combineWith(fitElse);
                }
                if ((fitThen.isFit() || fitElse.isFit()) && fExhaustive) {
                    return this.testFitMultiExhaustive(ctx, atypeRequired, errs);
                }
                return Expression.TypeFit.NoFit;
            }
        }
        throw new IllegalStateException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Expression validateMulti(Context ctx, TypeConstant[] atypeRequired, ErrorListener errs) {
        TypeConstant[] atypeElse;
        TypeConstant[] atypeThen;
        Expression.TypeFit fit = Expression.TypeFit.Fit;
        ConstantPool pool = this.pool();
        Expression exprNewCond = this.cond.validate(ctx = ctx.enterIf(), pool.typeBoolean(), errs);
        if (exprNewCond == null) {
            fit = Expression.TypeFit.NoFit;
        } else {
            this.cond = exprNewCond;
        }
        Usage use = null;
        Plan plan = this.generatePlan(ctx, false);
        switch (plan.ordinal()) {
            case 1: {
                atypeThen = new TypeConstant[]{pool.typeFalse()};
                atypeElse = atypeRequired == null ? TypeConstant.NO_TYPES : atypeRequired;
                break;
            }
            case 2: {
                atypeThen = atypeRequired == null ? TypeConstant.NO_TYPES : atypeRequired;
                atypeElse = new TypeConstant[]{pool.typeFalse()};
                break;
            }
            default: {
                if (atypeRequired != null && atypeRequired.length > 0) {
                    use = Usage.Required;
                    atypeElse = atypeRequired;
                    atypeThen = atypeRequired;
                    break;
                }
                Context ctxThen = ctx.enterFork(true);
                Context ctxElse = ctx.enterFork(false);
                try {
                    TypeConstant[] atypeCommonR;
                    atypeThen = this.exprThen.getImplicitTypes(ctxThen);
                    atypeElse = this.exprElse.getImplicitTypes(ctxElse);
                    int cThen = atypeThen.length;
                    int cElse = atypeElse.length;
                    Expression.TypeFit fitThen = cElse > 0 ? this.exprThen.testFitMulti(ctxThen, atypeElse, false, null) : Expression.TypeFit.NoFit;
                    Expression.TypeFit fitElse = cThen > 0 ? this.exprElse.testFitMulti(ctxElse, atypeThen, false, null) : Expression.TypeFit.NoFit;
                    use = this.computeUsage(fitThen, fitElse);
                    if (use != null) break;
                    TypeConstant[] atypeThenR = this.resolveConstraints(atypeThen);
                    TypeConstant[] atypeElseR = this.resolveConstraints(atypeElse);
                    if (atypeElseR != null) {
                        fitThen = this.exprThen.testFitMulti(ctxThen, atypeElseR, false, null);
                    }
                    if (atypeThenR != null) {
                        fitElse = this.exprElse.testFitMulti(ctxElse, atypeThenR, false, null);
                    }
                    if ((use = this.computeUsage(fitThen, fitElse)) != null) {
                        if (use == Usage.Then || use == Usage.Any) {
                            atypeThen = atypeThenR;
                        }
                        if (use != Usage.Else && use != Usage.Any) break;
                        atypeElse = atypeElseR;
                        break;
                    }
                    if (cThen == 0) {
                        use = Usage.Else;
                        break;
                    }
                    if (cElse == 0) {
                        use = Usage.Then;
                        break;
                    }
                    use = Usage.Union;
                    if (atypeThenR != null && atypeElseR != null && this.exprThen.testFitMulti(ctxThen, atypeCommonR = this.selectCommonTypes(atypeThenR, atypeElseR), false, null).isFit() && this.exprElse.testFitMulti(ctxElse, atypeCommonR, false, null).isFit()) {
                        atypeElse = atypeCommonR;
                        atypeThen = atypeCommonR;
                        break;
                    }
                    atypeElse = this.selectCommonTypes(atypeThen, atypeElse);
                    atypeThen = atypeElse;
                    break;
                }
                finally {
                    ctxThen.discard();
                    ctxElse.discard();
                }
            }
        }
        if (use == Usage.Any) {
            int c = Math.min(atypeThen.length, atypeElse.length);
            for (int i = 0; i < c; ++i) {
                int cE;
                TypeConstant typeT = atypeThen[i];
                TypeConstant typeE = atypeElse[i];
                int cT = typeT.getParamsCount();
                if (cT == (cE = typeE.getParamsCount())) continue;
                use = cT > cE ? Usage.Then : Usage.Else;
                break;
            }
        }
        TypeConstant[] atypeThenV = null;
        TypeConstant[] atypeElseV = null;
        ctx = ctx.enterFork(true);
        Expression exprNewThen = this.exprThen.validateMulti(ctx, use == Usage.Else ? atypeElse : atypeThen, errs);
        ctx = ctx.exit();
        if (exprNewThen == null) {
            fit = Expression.TypeFit.NoFit;
        } else {
            this.exprThen = exprNewThen;
            atypeThenV = exprNewThen.getTypes();
            if (this.isSpecified(atypeThen) || use == Usage.Union) {
                atypeThen = atypeThenV;
            }
        }
        ctx = ctx.enterFork(false);
        Expression exprNewElse = this.exprElse.validateMulti(ctx, use == Usage.Then ? atypeThen : atypeElse, errs);
        ctx = ctx.exit();
        if (exprNewElse == null) {
            fit = Expression.TypeFit.NoFit;
        } else {
            this.exprElse = exprNewElse;
            atypeElseV = exprNewElse.getTypes();
            if (this.isSpecified(atypeElse) || use == Usage.Union) {
                atypeElse = atypeElseV;
            }
        }
        ctx.exit();
        TypeConstant[] atypeResult = TypeConstant.NO_TYPES;
        if (fit.isFit()) {
            if (exprNewCond.isConstant()) {
                return exprNewCond.toConstant().equals(pool.valTrue()) ? this.replaceThisWith(exprNewThen) : this.replaceThisWith(exprNewElse);
            }
            switch (plan.ordinal()) {
                case 1: {
                    atypeResult = TernaryExpression.ensureConditionalType(pool, atypeElse);
                    break;
                }
                case 2: {
                    atypeResult = TernaryExpression.ensureConditionalType(pool, atypeThen);
                    break;
                }
                default: {
                    atypeResult = switch (use.ordinal()) {
                        default -> throw new MatchException(null, null);
                        case 0 -> this.selectWiderTypes(atypeThenV, atypeElseV, atypeRequired);
                        case 1 -> this.selectNarrowerTypes(atypeThen, atypeElse);
                        case 2 -> atypeThen;
                        case 3 -> atypeElse;
                        case 4 -> this.selectCommonTypes(atypeThen, atypeElse);
                    };
                }
            }
        }
        return this.finishValidations(ctx, atypeRequired, atypeResult, fit, null, errs);
    }

    private boolean isSpecified(TypeConstant[] atype) {
        if (atype == null) {
            return false;
        }
        for (TypeConstant type : atype) {
            if (type.equals(this.pool().typeObject())) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isAssignable(Context ctx) {
        return this.exprThen.isAssignable(ctx) && this.exprElse.isAssignable(ctx);
    }

    @Override
    public boolean isCompletable() {
        return this.cond.isCompletable() && (this.exprThen.isCompletable() || this.exprElse.isCompletable());
    }

    @Override
    public boolean isShortCircuiting() {
        return this.cond.isShortCircuiting() || this.exprThen.isShortCircuiting() || this.exprElse.isShortCircuiting();
    }

    @Override
    public void generateAssignments(Context ctx, MethodStructure.Code code, Expression.Assignable[] aLVal, ErrorListener errs) {
        Label labelElse = new Label("else");
        Label labelEnd = new Label("end");
        this.cond.generateConditionalJump(ctx, code, labelElse, false, errs);
        this.exprThen.generateAssignments(ctx, code, aLVal, errs);
        code.add(new Jump(labelEnd));
        code.add(labelElse);
        this.exprElse.generateAssignments(ctx, code, aLVal, errs);
        code.add(labelEnd);
    }

    public void generateConditionalReturn(Context ctx, MethodStructure.Code code, ErrorListener errs) {
        Label labelElse = new Label("else");
        switch (this.m_plan.ordinal()) {
            case 1: {
                boolean fCheck = !this.exprElse.isConditionalResult();
                this.cond.generateConditionalJump(ctx, code, labelElse, true, errs);
                Argument[] aArg = this.exprElse.generateArguments(ctx, code, true, !fCheck, errs);
                if (fCheck) {
                    this.addTrueCheck(code, aArg[0], labelElse);
                }
                code.add(new Return_N(aArg));
                code.add(labelElse);
                code.add(new Return_1(this.pool().valFalse()));
                break;
            }
            case 2: {
                boolean fCheck = !this.exprThen.isConditionalResult();
                this.cond.generateConditionalJump(ctx, code, labelElse, false, errs);
                Argument[] aArg = this.exprThen.generateArguments(ctx, code, true, !fCheck, errs);
                if (fCheck) {
                    this.addTrueCheck(code, aArg[0], labelElse);
                }
                code.add(new Return_N(aArg));
                code.add(labelElse);
                code.add(new Return_1(this.pool().valFalse()));
                break;
            }
            default: {
                boolean fCheckThen = !this.exprThen.isConditionalResult();
                boolean fCheckElse = !this.exprElse.isConditionalResult();
                Label labelFalse = fCheckThen || fCheckElse ? new Label("false") : null;
                this.cond.generateConditionalJump(ctx, code, labelElse, false, errs);
                Argument[] aArgThen = this.exprThen.generateArguments(ctx, code, true, !fCheckThen, errs);
                if (fCheckThen) {
                    fCheckThen = this.addTrueCheck(code, aArgThen[0], labelFalse);
                }
                code.add(new Return_N(aArgThen));
                code.add(labelElse);
                Argument[] aArgElse = this.exprElse.generateArguments(ctx, code, true, !fCheckElse, errs);
                if (fCheckElse) {
                    fCheckElse = this.addTrueCheck(code, aArgElse[0], labelFalse);
                }
                code.add(new Return_N(aArgElse));
                if (!fCheckThen && !fCheckElse) break;
                code.add(labelFalse);
                code.add(new Return_1(this.pool().valFalse()));
                break;
            }
        }
    }

    @Override
    public ExprAST getExprAST(Context ctx) {
        return new TernaryExprAST(this.cond.getExprAST(ctx), this.exprThen.getExprAST(ctx), this.exprElse.getExprAST(ctx), this.getTypes());
    }

    public Plan getPlan() {
        return this.m_plan;
    }

    private Usage computeUsage(Expression.TypeFit fitThen, Expression.TypeFit fitElse) {
        if (fitThen.isFit()) {
            if (fitElse.isFit()) {
                if (fitThen == Expression.TypeFit.Fit) {
                    return fitElse == Expression.TypeFit.Fit ? Usage.Any : Usage.Else;
                }
                return Usage.Then;
            }
            return Usage.Else;
        }
        if (fitElse.isFit()) {
            return Usage.Then;
        }
        return null;
    }

    private TypeConstant[] selectNarrowerTypes(TypeConstant[] atypeThen, TypeConstant[] atypeElse) {
        int cThen = atypeThen.length;
        int cElse = atypeElse.length;
        if (cThen > cElse) {
            return atypeThen;
        }
        if (cElse > cThen) {
            return atypeElse;
        }
        for (int i = 0; i < cThen; ++i) {
            TypeConstant typeThen = atypeThen[i];
            TypeConstant typeElse = atypeElse[i];
            if (!typeThen.isAssignableTo(typeElse)) {
                return atypeElse;
            }
            if (typeElse.isAssignableTo(typeThen)) continue;
            return atypeThen;
        }
        return atypeThen;
    }

    private TypeConstant[] selectWiderTypes(TypeConstant[] atypeThen, TypeConstant[] atypeElse, TypeConstant[] atypeRequired) {
        int cRequired = atypeRequired.length;
        int cThen = atypeThen.length;
        int cElse = atypeElse.length;
        if (cRequired == 1 && cThen == 1 && cElse == 1) {
            TypeConstant typeThen = atypeThen[0];
            TypeConstant typeElse = atypeElse[0];
            return typeThen.isAssignableTo(typeElse) ? atypeElse : (typeElse.isAssignableTo(typeThen) ? atypeThen : atypeRequired);
        }
        TypeConstant[] atypeResult = (TypeConstant[])atypeRequired.clone();
        for (int i = 0; i < cRequired; ++i) {
            TypeConstant typeElse;
            TypeConstant typeReq = atypeRequired[i];
            TypeConstant typeThen = i < cThen ? atypeThen[i] : typeReq;
            TypeConstant typeConstant = typeElse = i < cElse ? atypeElse[i] : typeReq;
            if (typeThen.isAssignableTo(typeElse)) {
                atypeResult[i] = typeElse;
                continue;
            }
            if (!typeElse.isAssignableTo(typeThen)) continue;
            atypeResult[i] = typeThen;
        }
        return atypeResult;
    }

    private TypeConstant[] resolveConstraints(TypeConstant[] atype) {
        int cTypes = atype.length;
        TypeConstant[] atypeR = null;
        for (int i = 0; i < cTypes; ++i) {
            TypeConstant type = atype[i];
            if (!type.containsFormalType(true)) continue;
            if (atypeR == null) {
                atypeR = new TypeConstant[cTypes];
            }
            atypeR[i] = type.resolveConstraints();
        }
        return atypeR;
    }

    private Plan generatePlan(Context ctx, boolean fExhaustive) {
        if (this.m_fConditional) {
            TypeConstant typeFalse = this.pool().typeFalse();
            if (this.exprElse.testFit(ctx, typeFalse, fExhaustive, null).isFit()) {
                this.m_plan = Plan.ElseIsFalse;
                return this.m_plan;
            }
            if (this.exprThen.testFit(ctx, typeFalse, fExhaustive, null).isFit()) {
                this.m_plan = Plan.ThenIsFalse;
                return this.m_plan;
            }
        }
        this.m_plan = Plan.Symmetrical;
        return this.m_plan;
    }

    private static TypeConstant[] ensureConditionalType(ConstantPool pool, TypeConstant[] atypeCond) {
        switch (atypeCond.length) {
            case 0: {
                return atypeCond;
            }
            case 1: {
                TypeConstant typeTuple = atypeCond[0];
                if (!typeTuple.isTuple() || typeTuple.getParamsCount() == 0) {
                    return TypeConstant.NO_TYPES;
                }
                TypeConstant[] atypeResult = typeTuple.getParamTypesArray();
                return atypeResult[0].isA(pool.typeBoolean()) ? atypeResult : TypeConstant.NO_TYPES;
            }
        }
        return atypeCond[0].isA(pool.typeBoolean()) ? atypeCond : TypeConstant.NO_TYPES;
    }

    private boolean addTrueCheck(MethodStructure.Code code, Argument arg, Label label) {
        if (arg.equals(this.pool().valTrue())) {
            return false;
        }
        code.add(new JumpFalse(arg, label));
        return true;
    }

    @Override
    public String toString() {
        return String.valueOf(this.cond) + " ? " + String.valueOf(this.exprThen) + " : " + String.valueOf(this.exprElse);
    }

    public static enum Plan {
        Symmetrical,
        ThenIsFalse,
        ElseIsFalse;

    }

    private static enum Usage {
        Required,
        Any,
        Then,
        Else,
        Union;

    }
}

