/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.compiler.ast;

import java.lang.reflect.Field;
import org.xvm.asm.Argument;
import org.xvm.asm.ConstantPool;
import org.xvm.asm.ErrorListener;
import org.xvm.asm.MethodStructure;
import org.xvm.asm.Register;
import org.xvm.asm.ast.ConstantExprAST;
import org.xvm.asm.ast.ExprAST;
import org.xvm.asm.ast.ThrowExprAST;
import org.xvm.asm.constants.ClassConstant;
import org.xvm.asm.constants.MethodConstant;
import org.xvm.asm.constants.StringConstant;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.asm.op.Label;
import org.xvm.asm.op.New_N;
import org.xvm.asm.op.Throw;
import org.xvm.compiler.Token;
import org.xvm.compiler.ast.AstNode;
import org.xvm.compiler.ast.Context;
import org.xvm.compiler.ast.Expression;
import org.xvm.util.Severity;

public class ThrowExpression
extends Expression {
    protected Token keyword;
    protected Expression expr;
    protected Expression message;
    private final long lEndPos;
    private static final Field[] CHILD_FIELDS = ThrowExpression.fieldsForNames(ThrowExpression.class, "expr", "message");

    public ThrowExpression(Token keyword, Expression expr, Expression message) {
        this(keyword, expr, message, null);
    }

    public ThrowExpression(Token keyword, Expression expr, Expression message, Token endToken) {
        this.keyword = keyword;
        this.expr = expr;
        this.message = message;
        this.lEndPos = endToken != null ? endToken.getEndPosition() : (message != null ? message.getEndPosition() : (expr != null ? expr.getEndPosition() : keyword.getEndPosition()));
    }

    public Expression getException() {
        return this.expr;
    }

    public Expression getMessage() {
        return this.message;
    }

    @Override
    public long getStartPosition() {
        return this.keyword.getStartPosition();
    }

    @Override
    public long getEndPosition() {
        return this.lEndPos;
    }

    @Override
    protected Field[] getChildFields() {
        return CHILD_FIELDS;
    }

    @Override
    public boolean isTodo() {
        return this.keyword.getId() == Token.Id.TODO;
    }

    @Override
    protected boolean hasMultiValueImpl() {
        return true;
    }

    @Override
    public TypeConstant getImplicitType(Context ctx) {
        return null;
    }

    @Override
    public TypeConstant[] getImplicitTypes(Context ctx) {
        return TypeConstant.NO_TYPES;
    }

    @Override
    public Expression.TypeFit testFit(Context ctx, TypeConstant typeRequired, boolean fExhaustive, ErrorListener errs) {
        return Expression.TypeFit.Fit;
    }

    @Override
    public Expression.TypeFit testFitMulti(Context ctx, TypeConstant[] atypeRequired, boolean fExhaustive, ErrorListener errs) {
        return Expression.TypeFit.Fit;
    }

    @Override
    protected Expression validate(Context ctx, TypeConstant typeRequired, ErrorListener errs) {
        boolean fValid = this.validateThrow(ctx, errs);
        Expression.TypeFit fit = fValid ? Expression.TypeFit.Fit : Expression.TypeFit.NoFit;
        TypeConstant typeActual = typeRequired == null ? this.pool().typeException() : typeRequired;
        ctx.setReachable(false);
        return this.finishValidation(ctx, typeRequired, typeActual, fit, null, errs);
    }

    @Override
    protected Expression validateMulti(Context ctx, TypeConstant[] atypeRequired, ErrorListener errs) {
        boolean fValid = this.validateThrow(ctx, errs);
        TypeConstant[] atypeActual = atypeRequired == null ? TypeConstant.NO_TYPES : atypeRequired;
        Expression.TypeFit fit = fValid ? Expression.TypeFit.Fit : Expression.TypeFit.NoFit;
        ctx.setReachable(false);
        return this.finishValidations(ctx, atypeRequired, atypeActual, fit, null, errs);
    }

    @Override
    public boolean isStandalone() {
        return true;
    }

    @Override
    public boolean isAssignableTo(TypeConstant typeThat) {
        return true;
    }

    @Override
    public boolean isTypeBoolean() {
        return true;
    }

    protected boolean validateThrow(Context ctx, ErrorListener errs) {
        Expression exprNew;
        boolean fValid = true;
        boolean fAssert = false;
        TypeConstant typeRequired = null;
        switch (this.keyword.getId()) {
            case ASSERT: 
            case ASSERT_ARG: 
            case ASSERT_BOUNDS: 
            case ASSERT_TODO: {
                typeRequired = ctx.pool().typeBoolean();
                fAssert = true;
                break;
            }
            case ASSERT_RND: 
            case ASSERT_ONCE: 
            case ASSERT_TEST: 
            case ASSERT_DBG: {
                this.log(errs, Severity.ERROR, "COMPILER-158", new Object[0]);
                fValid = false;
                break;
            }
            case TODO: {
                break;
            }
            case THROW: {
                typeRequired = ctx.pool().typeException();
                break;
            }
            default: {
                this.log(errs, Severity.FATAL, "COMPILER-01", "(throw keyword=" + String.valueOf(this.keyword) + ")");
                fValid = false;
            }
        }
        if (fValid && this.expr != null) {
            exprNew = this.expr.validate(ctx, typeRequired, errs);
            if (exprNew != this.expr) {
                fValid &= exprNew != null;
                if (exprNew != null) {
                    this.expr = exprNew;
                }
            }
            if (fAssert && fValid && !exprNew.isConstantFalse()) {
                this.log(errs, Severity.ERROR, "COMPILER-158", new Object[0]);
                fValid = false;
            }
        }
        if (this.message != null && (exprNew = this.message.validate(ctx, this.pool().typeString(), errs)) != this.message) {
            fValid &= exprNew != null;
            if (exprNew != null) {
                this.message = exprNew;
            }
        }
        return fValid;
    }

    @Override
    public boolean isRuntimeConstant() {
        return true;
    }

    @Override
    public boolean isAssignable(Context ctx) {
        if (this.isTodo()) {
            return true;
        }
        return super.isAssignable(ctx);
    }

    @Override
    public boolean isCompletable() {
        return this.isShortCircuiting();
    }

    @Override
    protected boolean allowsShortCircuit(AstNode nodeChild) {
        if (this.isTodo()) {
            return false;
        }
        return super.allowsShortCircuit(nodeChild);
    }

    @Override
    public boolean isShortCircuiting() {
        return this.expr != null && this.expr.isShortCircuiting();
    }

    @Override
    public void generateVoid(Context ctx, MethodStructure.Code code, ErrorListener errs) {
        this.generateThrow(ctx, code, errs);
    }

    @Override
    public Argument generateArgument(Context ctx, MethodStructure.Code code, boolean fLocalPropOk, boolean fUsedOnce, ErrorListener errs) {
        this.generateThrow(ctx, code, errs);
        return this.generateBlackHole(this.getValueCount() == 0 ? this.pool().typeObject() : this.getType());
    }

    @Override
    public Argument[] generateArguments(Context ctx, MethodStructure.Code code, boolean fLocalPropOk, boolean fUsedOnce, ErrorListener errs) {
        this.generateThrow(ctx, code, errs);
        TypeConstant[] aTypes = this.getTypes();
        int cArgs = aTypes.length;
        Argument[] aArgs = new Register[cArgs];
        for (int i = 0; i < cArgs; ++i) {
            aArgs[i] = this.generateBlackHole(aTypes[i]);
        }
        return aArgs;
    }

    @Override
    public void generateConditionalJump(Context ctx, MethodStructure.Code code, Label label, boolean fWhenTrue, ErrorListener errs) {
        this.generateThrow(ctx, code, errs);
    }

    protected void generateThrow(Context ctx, MethodStructure.Code code, ErrorListener errs) {
        Argument argEx;
        if (this.keyword.getId() == Token.Id.THROW) {
            assert (this.message == null);
            argEx = this.expr.generateArgument(ctx, code, true, true, errs);
        } else {
            assert (this.expr == null);
            ConstantPool pool = this.pool();
            ClassConstant constEx = this.computeExceptionClass();
            MethodConstant constNew = constEx.findConstructor(pool.typeString\u0967(), pool.typeException\u0967());
            StringConstant argMsg = this.message == null ? pool.ensureStringConstant(this.computeMessage()) : this.message.generateArgument(ctx, code, false, false, errs);
            argEx = code.createRegister(constEx.getType());
            code.add(new New_N(constNew, new Argument[]{argMsg, pool.valNull()}, argEx));
        }
        code.add(new Throw(argEx));
    }

    @Override
    public ExprAST getExprAST(Context ctx) {
        ExprAST astMsg;
        ExprAST astEx;
        if (this.keyword.getId() == Token.Id.THROW) {
            assert (this.message == null);
            astEx = this.expr.getExprAST(ctx);
            astMsg = null;
        } else {
            assert (this.expr == null);
            ConstantPool pool = this.pool();
            ClassConstant constEx = this.computeExceptionClass();
            astEx = new ConstantExprAST(constEx);
            astMsg = this.message == null ? new ConstantExprAST(pool.ensureStringConstant(this.computeMessage())) : this.message.getExprAST(ctx);
        }
        TypeConstant typeResult = this.getType();
        if (typeResult == null) {
            typeResult = this.pool().typeObject();
        }
        return new ThrowExprAST(typeResult, astEx, astMsg);
    }

    private ClassConstant computeExceptionClass() {
        return this.pool().ensureEcstasyClassConstant(switch (this.keyword.getId()) {
            case Token.Id.ASSERT -> "IllegalState";
            case Token.Id.ASSERT_ARG -> "IllegalArgument";
            case Token.Id.ASSERT_BOUNDS -> "OutOfBounds";
            case Token.Id.ASSERT_TODO, Token.Id.TODO -> "NotImplemented";
            default -> throw new IllegalStateException("keyword=" + String.valueOf(this.keyword));
        });
    }

    private String computeMessage() {
        return this.keyword.getId() == Token.Id.TODO ? "TODO" : "Assertion failed";
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.isTodo() && this.message != null) {
            sb.append(this.message);
        } else {
            sb.append(this.keyword);
            if (this.expr != null) {
                sb.append(' ').append(this.expr);
            }
            if (this.message != null) {
                sb.append(" as ").append(this.message);
            }
        }
        sb.append(';');
        return sb.toString();
    }

    @Override
    public String getDumpDesc() {
        return this.toString();
    }
}

