/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.compiler.ast;

import org.xvm.asm.Argument;
import org.xvm.asm.Constant;
import org.xvm.asm.ConstantPool;
import org.xvm.asm.ErrorListener;
import org.xvm.asm.MethodStructure;
import org.xvm.asm.constants.IdentityConstant;
import org.xvm.asm.constants.IntConstant;
import org.xvm.asm.constants.MethodConstant;
import org.xvm.asm.constants.PropertyConstant;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.asm.op.GP_Sub;
import org.xvm.asm.op.Invoke_01;
import org.xvm.asm.op.P_Get;
import org.xvm.compiler.ast.Context;
import org.xvm.compiler.ast.Expression;
import org.xvm.compiler.ast.SyntheticExpression;
import org.xvm.util.PackedInteger;

public class ToIntExpression
extends SyntheticExpression {
    private final PackedInteger m_pintOffset;

    public ToIntExpression(Expression expr, PackedInteger pintOffset, ErrorListener errs) {
        super(expr);
        assert (expr.getType().isIntConvertible());
        IntConstant val = null;
        if (expr.isConstant()) {
            Constant constOrig = expr.toConstant();
            PackedInteger pintVal = constOrig.getIntValue();
            if (pintOffset != null) {
                pintVal = pintVal.sub(pintOffset);
            }
            val = this.pool().ensureIntConstant(pintVal);
        }
        this.m_pintOffset = pintOffset;
        this.finishValidation(null, null, expr.pool().typeInt64(), expr.getTypeFit().addConversion(), val, errs);
    }

    public IdentityConstant getExtractor() {
        switch (this.expr.getType().getEcstasyClassName()) {
            case "numbers.Int8": 
            case "numbers.Int16": 
            case "numbers.Int32": 
            case "numbers.Int64": 
            case "numbers.Int128": 
            case "numbers.IntN": 
            case "numbers.UInt8": 
            case "numbers.UInt16": 
            case "numbers.UInt32": 
            case "numbers.UInt64": 
            case "numbers.UInt128": 
            case "numbers.UIntN": {
                return null;
            }
            case "numbers.Bit": 
            case "numbers.Nibble": 
            case "text.Char": {
                MethodConstant id = this.expr.getType().ensureTypeInfo().findCallable("toInt64", true, false, this.getTypes(), TypeConstant.NO_TYPES);
                assert (id != null);
                return id;
            }
        }
        PropertyConstant id = this.expr.getType().ensureTypeInfo().findProperty("ordinal").getIdentity();
        assert (id != null);
        return id;
    }

    public PackedInteger getOffset() {
        return this.m_pintOffset;
    }

    public Constant getOffsetConstant() {
        String sFormat;
        PackedInteger pint = this.getOffset();
        if (pint == null || pint.equals(PackedInteger.ZERO)) {
            return null;
        }
        ConstantPool pool = this.pool();
        return switch (sFormat = this.expr.getType().getEcstasyClassName()) {
            case "numbers.Int8" -> pool.ensureByteConstant(Constant.Format.Int8, pint.getInt());
            case "numbers.UInt8" -> pool.ensureByteConstant(Constant.Format.UInt8, pint.getInt());
            case "numbers.Int16" -> pool.ensureIntConstant(pint, Constant.Format.Int16);
            case "numbers.Int32" -> pool.ensureIntConstant(pint, Constant.Format.Int32);
            case "numbers.Int64" -> pool.ensureIntConstant(pint, Constant.Format.Int64);
            case "numbers.Int128" -> pool.ensureIntConstant(pint, Constant.Format.Int128);
            case "numbers.IntN" -> pool.ensureIntConstant(pint, Constant.Format.IntN);
            case "numbers.UInt16" -> pool.ensureIntConstant(pint, Constant.Format.UInt16);
            case "numbers.UInt32" -> pool.ensureIntConstant(pint, Constant.Format.UInt32);
            case "numbers.UInt64" -> pool.ensureIntConstant(pint, Constant.Format.UInt64);
            case "numbers.UInt128" -> pool.ensureIntConstant(pint, Constant.Format.UInt128);
            case "numbers.UIntN" -> pool.ensureIntConstant(pint, Constant.Format.UIntN);
            default -> pool.ensureIntConstant(pint);
        };
    }

    public MethodConstant getConvertMethod() {
        switch (this.expr.getType().getEcstasyClassName()) {
            case "numbers.Int8": 
            case "numbers.Int16": 
            case "numbers.Int32": 
            case "numbers.Int128": 
            case "numbers.IntN": 
            case "numbers.UInt8": 
            case "numbers.UInt16": 
            case "numbers.UInt32": 
            case "numbers.UInt64": 
            case "numbers.UInt128": 
            case "numbers.UIntN": {
                MethodConstant id = this.expr.getType().ensureTypeInfo().findCallable("toInt64", true, false, this.getTypes(), TypeConstant.NO_TYPES);
                assert (id != null);
                return id;
            }
        }
        return null;
    }

    @Override
    public TypeConstant getImplicitType(Context ctx) {
        return this.getType();
    }

    @Override
    protected Expression validate(Context ctx, TypeConstant typeRequired, ErrorListener errs) {
        return this;
    }

    @Override
    public void generateVoid(Context ctx, MethodStructure.Code code, ErrorListener errs) {
        this.expr.generateVoid(ctx, code, errs);
    }

    @Override
    public Argument generateArgument(Context ctx, MethodStructure.Code code, boolean fLocalPropOk, boolean fUsedOnce, ErrorListener errs) {
        return !this.isConstant() && this.getExtractor() == null && this.getOffsetConstant() == null && this.getConvertMethod() == null ? this.expr.generateArgument(ctx, code, fLocalPropOk, fUsedOnce, errs) : super.generateArgument(ctx, code, fLocalPropOk, fUsedOnce, errs);
    }

    @Override
    public void generateAssignment(Context ctx, MethodStructure.Code code, Expression.Assignable LVal, ErrorListener errs) {
        if (this.isConstant()) {
            super.generateAssignment(ctx, code, LVal, errs);
        }
        IdentityConstant idExtract = this.getExtractor();
        Constant constOffset = this.getOffsetConstant();
        MethodConstant idConvert = this.getConvertMethod();
        Argument argExtracted = this.expr.generateArgument(ctx, code, false, true, errs);
        if (idExtract != null) {
            Argument argExtractFrom = argExtracted;
            Expression.Assignable LValExtractTo = this.createTempVar(code, this.getType(), true);
            argExtracted = LValExtractTo.getLocalArgument();
            code.add(idExtract instanceof PropertyConstant ? new P_Get((PropertyConstant)idExtract, argExtractFrom, argExtracted) : new Invoke_01(argExtractFrom, (MethodConstant)idExtract, argExtracted));
        }
        Argument argAdjusted = argExtracted;
        if (constOffset != null) {
            Argument argAdjustFrom = argAdjusted;
            Expression.Assignable LValAdjustTo = this.createTempVar(code, argExtracted.getType(), true);
            argAdjusted = LValAdjustTo.getLocalArgument();
            code.add(new GP_Sub(argAdjustFrom, constOffset, argAdjusted));
        }
        if (idConvert == null) {
            LVal.assign(argAdjusted, code, errs);
        } else {
            Expression.Assignable LValConverted = LVal.isLocalArgument() ? LVal : this.createTempVar(code, this.getType(), true);
            code.add(new Invoke_01(argAdjusted, idConvert, LValConverted.getLocalArgument()));
            if (LVal != LValConverted) {
                LVal.assign(LValConverted.getLocalArgument(), code, errs);
            }
        }
    }

    @Override
    public String toString() {
        MethodConstant idConvert;
        PackedInteger pintOffset;
        StringBuilder sb = new StringBuilder();
        sb.append(this.expr);
        IdentityConstant idExtract = this.getExtractor();
        if (idExtract != null) {
            sb.append('.').append(idExtract.getName());
            if (idExtract instanceof MethodConstant) {
                sb.append("()");
            }
        }
        if ((pintOffset = this.getOffset()) != null) {
            if (pintOffset.equals(PackedInteger.ZERO)) {
                pintOffset = null;
            } else {
                sb.append(" - ").append(pintOffset);
            }
        }
        if ((idConvert = this.getConvertMethod()) != null) {
            if (pintOffset != null) {
                sb.insert(0, '(').append(')');
            }
            sb.append('.').append(idConvert.getName()).append("()");
        }
        return sb.toString();
    }
}

