/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.compiler.ast;

import org.xvm.asm.Argument;
import org.xvm.asm.ErrorListener;
import org.xvm.asm.MethodStructure;
import org.xvm.asm.Register;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.compiler.ast.Context;
import org.xvm.compiler.ast.Expression;
import org.xvm.compiler.ast.SyntheticExpression;

public class TraceExpression
extends SyntheticExpression {
    private Argument[] m_aArgs;

    public TraceExpression(Expression expr) {
        super(expr);
        assert (expr.isValidated());
        this.finishValidations(null, null, expr.getTypes(), expr.getTypeFit(), expr.toConstants(), ErrorListener.BLACKHOLE);
    }

    public Argument[] getArguments() {
        assert (this.m_aArgs != null);
        return this.m_aArgs;
    }

    @Override
    protected boolean hasSingleValueImpl() {
        return this.expr.hasSingleValueImpl();
    }

    @Override
    protected boolean hasMultiValueImpl() {
        return this.expr.hasMultiValueImpl();
    }

    @Override
    public TypeConstant getImplicitType(Context ctx) {
        return this.getType();
    }

    @Override
    public TypeConstant[] getImplicitTypes(Context ctx) {
        return this.getTypes();
    }

    @Override
    protected Expression validate(Context ctx, TypeConstant typeRequired, ErrorListener errs) {
        return this;
    }

    @Override
    protected Expression validateMulti(Context ctx, TypeConstant[] atypeRequired, ErrorListener errs) {
        return this;
    }

    @Override
    public void generateVoid(Context ctx, MethodStructure.Code code, ErrorListener errs) {
        this.genCode(ctx, code, errs);
    }

    @Override
    public Argument generateArgument(Context ctx, MethodStructure.Code code, boolean fLocalPropOk, boolean fUsedOnce, ErrorListener errs) {
        this.genCode(ctx, code, errs);
        return this.m_aArgs[0];
    }

    @Override
    public Argument[] generateArguments(Context ctx, MethodStructure.Code code, boolean fLocalPropOk, boolean fUsedOnce, ErrorListener errs) {
        this.genCode(ctx, code, errs);
        return this.m_aArgs;
    }

    @Override
    public void generateAssignment(Context ctx, MethodStructure.Code code, Expression.Assignable LVal, ErrorListener errs) {
        this.genCode(ctx, code, errs);
        LVal.assign(this.m_aArgs[0], code, errs);
    }

    @Override
    public void generateAssignments(Context ctx, MethodStructure.Code code, Expression.Assignable[] aLVal, ErrorListener errs) {
        this.genCode(ctx, code, errs);
        int c = aLVal.length;
        for (int i = 0; i < c; ++i) {
            aLVal[i].assign(this.m_aArgs[i], code, errs);
        }
    }

    void genCode(Context ctx, MethodStructure.Code code, ErrorListener errs) {
        if (this.isConstant()) {
            this.m_aArgs = this.toConstants();
        } else {
            TypeConstant[] aTypes = this.getTypes();
            int cTypes = aTypes.length;
            Expression.Assignable[] aLVals = new Expression.Assignable[cTypes];
            Register[] aRegs = new Register[cTypes];
            for (int i = 0; i < cTypes; ++i) {
                Expression.Assignable LVal;
                TypeConstant type = aTypes[i];
                aLVals[i] = LVal = this.createTempVar(code, type, false);
                aRegs[i] = LVal.getRegister();
            }
            this.m_aArgs = aRegs;
            this.expr.generateAssignments(ctx, code, aLVals, errs);
        }
    }

    @Override
    public String toString() {
        return this.expr.toString();
    }
}

