/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.compiler.ast;

import java.lang.reflect.Field;
import java.util.List;
import java.util.Map;
import org.xvm.asm.Argument;
import org.xvm.asm.Assignment;
import org.xvm.asm.ConstantPool;
import org.xvm.asm.ErrorListener;
import org.xvm.asm.MethodStructure;
import org.xvm.asm.Register;
import org.xvm.asm.ast.BinaryAST;
import org.xvm.asm.ast.ExprAST;
import org.xvm.asm.ast.RegAllocAST;
import org.xvm.asm.ast.StmtBlockAST;
import org.xvm.asm.ast.TryCatchStmtAST;
import org.xvm.asm.ast.TryFinallyStmtAST;
import org.xvm.asm.constants.FormalConstant;
import org.xvm.asm.constants.MethodConstant;
import org.xvm.asm.constants.StringConstant;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.asm.constants.TypeInfo;
import org.xvm.asm.op.CatchEnd;
import org.xvm.asm.op.CatchStart;
import org.xvm.asm.op.Enter;
import org.xvm.asm.op.Exit;
import org.xvm.asm.op.FinallyEnd;
import org.xvm.asm.op.FinallyStart;
import org.xvm.asm.op.GuardAll;
import org.xvm.asm.op.GuardEnd;
import org.xvm.asm.op.GuardStart;
import org.xvm.asm.op.Invoke_10;
import org.xvm.asm.op.JumpNType;
import org.xvm.asm.op.JumpNotNull;
import org.xvm.asm.op.Label;
import org.xvm.asm.op.Throw;
import org.xvm.compiler.Token;
import org.xvm.compiler.ast.AssignmentStatement;
import org.xvm.compiler.ast.CatchStatement;
import org.xvm.compiler.ast.Context;
import org.xvm.compiler.ast.LabelAble;
import org.xvm.compiler.ast.LabeledStatement;
import org.xvm.compiler.ast.Statement;
import org.xvm.compiler.ast.StatementBlock;
import org.xvm.util.Handy;
import org.xvm.util.Severity;

public class TryStatement
extends Statement
implements LabelAble {
    protected Token keyword;
    protected List<AssignmentStatement> resources;
    protected StatementBlock block;
    protected List<CatchStatement> catches;
    protected StatementBlock catchall;
    private transient Context m_ctxValidatingFinally;
    private transient ErrorListener m_errsValidatingFinally;
    private transient Register m_regFinallyException;
    private static final Field[] CHILD_FIELDS = TryStatement.fieldsForNames(TryStatement.class, "resources", "block", "catches", "catchall");

    public TryStatement(Token keyword, List<AssignmentStatement> resources, StatementBlock block, List<CatchStatement> catches, StatementBlock catchall) {
        assert (block != null);
        this.keyword = keyword;
        this.resources = resources == null || resources.isEmpty() ? null : resources;
        this.block = block;
        this.catches = catches == null || catches.isEmpty() ? null : catches;
        this.catchall = catchall;
    }

    @Override
    public long getStartPosition() {
        return this.keyword.getStartPosition();
    }

    @Override
    public long getEndPosition() {
        return this.catchall == null ? (this.catches == null ? this.block.getEndPosition() : this.catches.get(this.catches.size() - 1).getEndPosition()) : this.catchall.getEndPosition();
    }

    @Override
    protected Field[] getChildFields() {
        return CHILD_FIELDS;
    }

    @Override
    public boolean hasLabelVar(String sName) {
        return "exception".equals(sName) && (this.m_ctxValidatingFinally != null || this.m_regFinallyException != null);
    }

    @Override
    public Register getLabelVar(Context ctx, String sName) {
        assert (this.hasLabelVar(sName));
        Register reg = this.m_regFinallyException;
        if (reg == null) {
            String sLabel = ((LabeledStatement)this.getParent()).getName();
            String sRegName = sLabel + "." + sName;
            Token tok = new Token(this.keyword.getStartPosition(), this.keyword.getEndPosition(), Token.Id.IDENTIFIER, sRegName);
            this.m_regFinallyException = reg = ctx.createRegister(this.pool().typeException\u0967(), sRegName);
            this.m_ctxValidatingFinally.registerVar(tok, reg, this.m_errsValidatingFinally);
        }
        return reg;
    }

    @Override
    protected Statement validateImpl(Context ctx, ErrorListener errs) {
        boolean fValid = true;
        if (this.resources == null) {
            if (this.catches == null && this.catchall == null) {
                this.log(errs, Severity.ERROR, "COMPILER-196", new Object[0]);
                fValid = false;
            }
        } else {
            ctx = ctx.enter();
            int c = this.resources.size();
            for (int i = 0; i < c; ++i) {
                AssignmentStatement useOld = this.resources.get(i);
                AssignmentStatement useNew = (AssignmentStatement)useOld.validate(ctx, errs);
                if (useNew == null) {
                    fValid = false;
                } else if (useNew != useOld) {
                    this.resources.set(i, useNew);
                }
                ctx = ctx.enter();
            }
        }
        Context ctxOrig = ctx;
        Context ctxCatchAll = null;
        int cCatches = this.catches == null ? 0 : this.catches.size();
        TryContext ctxTryBlock = new TryContext(ctxOrig);
        this.block.validate(ctxTryBlock, errs);
        Map<String, Assignment> mapTryAsn = ctxTryBlock.prepareJump(ctxOrig);
        if (this.catchall != null) {
            ctxCatchAll = ctxOrig.enter();
            ctxCatchAll.merge(mapTryAsn);
            ctxCatchAll.setReachable(true);
        }
        if (cCatches > 0) {
            Context ctxNext;
            boolean fReachable = ctxTryBlock.isReachable();
            Context context = ctxNext = fReachable ? new Context.IfContext(this, ctxOrig){

                @Override
                protected void promoteNarrowedType(String sName, Argument arg, Context.Branch branch) {
                    if (!this.isVarDeclaredInThisScope(sName)) {
                        this.getOuterContext().restoreOriginalType(sName);
                    }
                }

                @Override
                protected void promoteNarrowedGenericType(FormalConstant constFormal, TypeConstant type, Context.Branch branch) {
                }
            } : new Context.IfContext(ctxOrig);
            if (fReachable) {
                ctxNext.merge(mapTryAsn);
                ctxNext.setReachable(true);
            }
            for (int i = 0; i < cCatches; ++i) {
                Context ctxCatch = ctxNext.enterFork(true);
                CatchStatement catchOld = this.catches.get(i);
                CatchStatement catchNew = (CatchStatement)catchOld.validate(ctxCatch, errs);
                fReachable |= ctxCatch.isReachable();
                ctxNext = ctxCatch.exit();
                if (catchNew == null) {
                    fValid = false;
                } else {
                    if (catchNew != catchOld) {
                        this.catches.set(i, catchNew);
                    }
                    TypeConstant typeE = catchNew.getCatchType();
                    for (int iPrev = 0; iPrev < i; ++iPrev) {
                        TypeConstant typeEPrev = this.catches.get((int)iPrev).target.getType();
                        if (!typeE.isA(typeEPrev)) continue;
                        catchNew.target.log(errs, Severity.ERROR, "COMPILER-118", typeE.getValueString(), typeEPrev.getValueString());
                        break;
                    }
                }
                ctxNext = ctxNext.enterFork(false);
                if (i == cCatches - 1) {
                    ctxNext.setReachable(false);
                    while (i-- >= 0) {
                        ctxNext = ctxNext.exit().exit();
                    }
                    break;
                }
                ctxNext = ctxNext.enterIf();
            }
            assert (ctxNext == ctxOrig);
            if (ctxTryBlock.isReachable()) {
                ctxTryBlock.exitReachable();
            } else {
                ctxTryBlock.discard();
            }
            ctxOrig.setReachable(fReachable);
        } else {
            ctx = ctxTryBlock.exit();
            assert (ctx == ctxOrig);
        }
        if (this.catchall != null) {
            Context ctxFinally;
            this.m_ctxValidatingFinally = ctxFinally = ctxCatchAll.enter();
            this.m_errsValidatingFinally = errs;
            StatementBlock catchallNew = (StatementBlock)this.catchall.validate(ctxFinally, errs);
            this.m_ctxValidatingFinally = null;
            this.m_errsValidatingFinally = null;
            ctxFinally.promoteAssignments(ctxOrig);
            if (catchallNew == null) {
                fValid = false;
            } else {
                this.catchall = catchallNew;
            }
        }
        if (this.resources != null) {
            int c = this.resources.size();
            for (int i = 0; i < c; ++i) {
                ctx = ctx.exit();
            }
            ctx = ctx.exit();
        }
        return fValid ? this : null;
    }

    @Override
    protected boolean emit(Context ctx, boolean fReachable, MethodStructure.Code code, ErrorListener errs) {
        boolean fCompletes = fReachable;
        ConstantPool pool = this.pool();
        Statement.AstHolder holder = ctx.getHolder();
        ExprAST[] aAstResources = null;
        BinaryAST[] aAstCatches = null;
        BinaryAST astCatchAll = null;
        FinallyStart[] aFinallyStart = null;
        if (this.resources != null) {
            code.add(new Enter());
            int c = this.resources.size();
            aFinallyStart = new FinallyStart[c];
            aAstResources = new ExprAST[c];
            for (int i = 0; i < c; ++i) {
                FinallyStart opFinally;
                Statement stmt = this.resources.get(i);
                fCompletes = stmt.completes(ctx, fCompletes, code, errs);
                aAstResources[i] = (ExprAST)holder.getAst(stmt);
                aFinallyStart[i] = opFinally = new FinallyStart(code.createRegister(pool.typeException\u0967()));
                code.add(new GuardAll(opFinally));
            }
        }
        FinallyStart opFinallyBlock = null;
        Label labelCatchEnd = this.getEndLabel();
        if (this.catchall != null) {
            Register regFinallyException = this.m_regFinallyException == null ? code.createRegister(pool.typeException\u0967()) : this.m_regFinallyException;
            opFinallyBlock = new FinallyStart(regFinallyException);
            labelCatchEnd = new Label(this.getCodeContainerCounter());
            code.add(new GuardAll(opFinallyBlock));
        } else if (this.resources != null) {
            labelCatchEnd = new Label(this.getCodeContainerCounter());
        }
        RegAllocAST[] aAllocCatch = null;
        if (this.catches != null) {
            int cCatches = this.catches.size();
            CatchStart[] aCatchStart = new CatchStart[cCatches];
            aAllocCatch = new RegAllocAST[cCatches];
            for (int i = 0; i < cCatches; ++i) {
                CatchStatement stmt = this.catches.get(i);
                aCatchStart[i] = stmt.ensureCatchStart();
                aAllocCatch[i] = stmt.getCatchRegister().getRegAllocAST();
            }
            code.add(new GuardStart(aCatchStart));
        }
        this.block.suppressScope();
        boolean fBlockCompletes = this.block.completes(ctx, fCompletes, code, errs);
        BinaryAST astBlock = holder.getAst(this.block);
        boolean fAnyCatchCompletes = false;
        if (this.catches != null) {
            code.add(new GuardEnd(labelCatchEnd));
            int c = this.catches.size();
            aAstCatches = new BinaryAST[c];
            for (int i = 0; i < c; ++i) {
                CatchStatement stmtCatch = this.catches.get(i);
                stmtCatch.setCatchLabel(labelCatchEnd);
                fAnyCatchCompletes |= stmtCatch.completes(ctx, fCompletes, code, errs);
                aAstCatches[i] = new StmtBlockAST(new BinaryAST[]{aAllocCatch[i], holder.getAst(stmtCatch)}, true);
            }
        }
        boolean fTryCompletes = fBlockCompletes | fAnyCatchCompletes;
        if (this.catchall != null) {
            this.catchall.suppressScope();
            code.add(labelCatchEnd);
            code.add(opFinallyBlock);
            boolean fFinallyCompletes = this.catchall.completes(ctx, fCompletes, code, errs);
            astCatchAll = holder.getAst(this.catchall);
            FinallyEnd opFinallyEnd = new FinallyEnd();
            opFinallyEnd.setCompletes(fTryCompletes &= fFinallyCompletes);
            code.add(opFinallyEnd);
        }
        if (this.resources != null) {
            if (this.catchall == null) {
                code.add(labelCatchEnd);
            }
            TypeConstant typeCloseable = pool.typeCloseable();
            MethodConstant methodClose = typeCloseable.ensureTypeInfo(errs).findMethods("close", 1, TypeInfo.MethodKind.Method).iterator().next();
            for (int i = this.resources.size() - 1; i >= 0; --i) {
                code.add(aFinallyStart[i]);
                Register regException = code.lastRegister();
                Register regCatch = code.createRegister(pool.typeException());
                StringConstant constName = pool.ensureStringConstant("(close-exception)");
                CatchStart opCatch = new CatchStart(regCatch, constName);
                code.add(new GuardStart(new CatchStart[]{opCatch}));
                Argument argResource = this.resources.get(i).getLValueExpression().generateArgument(ctx, code, false, false, errs);
                Label labelSkipClose = new Label("skip_close");
                Label labelFallThrough = new Label(this.getCodeContainerCounter());
                if (!argResource.getType().isA(typeCloseable)) {
                    code.add(new JumpNType(argResource, typeCloseable, labelSkipClose));
                }
                code.add(new Invoke_10(argResource, methodClose, regException));
                code.add(labelSkipClose);
                code.add(new GuardEnd(labelFallThrough));
                code.add(opCatch);
                Label labelSkipThrow = new Label("skip_throw");
                code.add(new JumpNotNull(regException, labelSkipThrow));
                code.add(new Throw(regCatch));
                code.add(labelSkipThrow);
                code.add(new CatchEnd(labelFallThrough));
                code.add(labelFallThrough);
                FinallyEnd opFinallyEnd = new FinallyEnd();
                opFinallyEnd.setCompletes(fTryCompletes);
                code.add(opFinallyEnd);
            }
            code.add(new Exit());
        }
        holder.setAst(this, astCatchAll == null ? new TryCatchStmtAST(aAstResources, astBlock, aAstCatches) : new TryFinallyStmtAST(aAstResources, astBlock, aAstCatches, this.m_regFinallyException == null ? null : this.m_regFinallyException.getRegAllocAST(), astCatchAll));
        return fTryCompletes;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.keyword.getId().TEXT);
        if (this.resources != null) {
            sb.append(" (");
            boolean first = true;
            for (Statement statement : this.resources) {
                if (first) {
                    first = false;
                } else {
                    sb.append(", ");
                }
                sb.append(statement);
            }
            sb.append(')');
        }
        sb.append('\n').append(Handy.indentLines(this.block.toString(), "    "));
        if (this.catches != null) {
            for (CatchStatement catchOne : this.catches) {
                sb.append('\n').append(catchOne);
            }
        }
        if (this.catchall != null) {
            sb.append("\nfinally\n").append(Handy.indentLines(this.catchall.toString(), "    "));
        }
        return sb.toString();
    }

    @Override
    public String getDumpDesc() {
        return this.keyword.getId().TEXT;
    }

    protected static class TryContext
    extends Context {
        protected TryContext(Context ctxOuter) {
            super(ctxOuter, true);
        }

        protected void exitReachable() {
            Context ctxOuter = this.getOuterContext();
            ctxOuter.merge(this.getDefiniteAssignments());
            ctxOuter.setReachable(true);
            this.promoteNarrowedTypes();
        }

        @Override
        protected void promoteNarrowedType(String sName, Argument arg, Context.Branch branch) {
            if (branch == Context.Branch.Always && !this.isVarDeclaredInThisScope(sName)) {
                TypeConstant typeOrig;
                Context ctxOuter = this.getOuterContext();
                Argument argOrig = ctxOuter.getVar(sName);
                assert (argOrig != null);
                TypeConstant typeArg = arg.getType();
                if (!typeArg.isA(typeOrig = argOrig.getType())) {
                    assert (argOrig instanceof Register);
                    ctxOuter.replaceArgument(sName, branch, ((Register)argOrig).restoreType());
                }
            }
        }
    }
}

