/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.compiler.ast;

import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.xvm.asm.Argument;
import org.xvm.asm.Constant;
import org.xvm.asm.ConstantPool;
import org.xvm.asm.ErrorListener;
import org.xvm.asm.MethodStructure;
import org.xvm.asm.Register;
import org.xvm.asm.ast.ConstantExprAST;
import org.xvm.asm.ast.ExprAST;
import org.xvm.asm.ast.TupleExprAST;
import org.xvm.asm.constants.ArrayConstant;
import org.xvm.asm.constants.StringConstant;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.asm.constants.UnionTypeConstant;
import org.xvm.asm.op.Var_T;
import org.xvm.asm.op.Var_TN;
import org.xvm.compiler.Compiler;
import org.xvm.compiler.ast.Context;
import org.xvm.compiler.ast.Expression;
import org.xvm.compiler.ast.TypeExpression;
import org.xvm.compiler.ast.UnpackExpression;
import org.xvm.compiler.ast.VariableDeclarationStatement;
import org.xvm.util.Severity;

public class TupleExpression
extends Expression {
    protected TypeExpression type;
    protected List<Expression> exprs;
    protected long m_lStartPos;
    protected long m_lEndPos;
    private static final Field[] CHILD_FIELDS = TupleExpression.fieldsForNames(TupleExpression.class, "type", "exprs");

    public TupleExpression(TypeExpression type, List<Expression> exprs, long lStartPos, long lEndPos) {
        this.type = type;
        this.exprs = exprs == null ? Collections.emptyList() : exprs;
        this.m_lStartPos = lStartPos;
        this.m_lEndPos = lEndPos;
    }

    TupleExpression(Expression[] aExprs, ErrorListener errs) {
        int cExprs = aExprs.length;
        assert (cExprs > 0);
        Expression expr0 = aExprs[0];
        this.type = null;
        this.exprs = Arrays.asList(aExprs);
        this.m_lStartPos = expr0.getStartPosition();
        this.m_lEndPos = aExprs[cExprs - 1].getEndPosition();
        expr0.getParent().adopt(this);
        Compiler.Stage stage = expr0.getStage();
        boolean fValidated = expr0.isValidated();
        TypeConstant[] aTypes = fValidated ? new TypeConstant[cExprs] : null;
        boolean fConstant = fValidated && expr0.isConstant();
        Constant[] aVals = fConstant ? new Constant[cExprs] : null;
        for (int i = 0; i < cExprs; ++i) {
            Expression exprChild = aExprs[i];
            assert (exprChild.getStage() == stage);
            assert (exprChild.isValidated() == fValidated);
            this.adopt(exprChild);
            if (!fValidated) continue;
            aTypes[i] = exprChild.getType();
            if (!fConstant) continue;
            if (exprChild.isConstant()) {
                aVals[i] = exprChild.toConstant();
                continue;
            }
            aVals = null;
            fConstant = false;
        }
        this.setStage(stage);
        if (fValidated) {
            this.finishValidations(null, null, aTypes, Expression.TypeFit.Fit, aVals, errs);
        }
    }

    public TypeExpression getTypeExpression() {
        return this.type;
    }

    public List<Expression> getExpressions() {
        return this.exprs;
    }

    public Expression[] getExpressionArray() {
        return this.exprs.toArray(new Expression[0]);
    }

    @Override
    public long getStartPosition() {
        return this.m_lStartPos;
    }

    @Override
    public long getEndPosition() {
        return this.m_lEndPos;
    }

    @Override
    protected Field[] getChildFields() {
        return CHILD_FIELDS;
    }

    @Override
    protected boolean hasSingleValueImpl() {
        return false;
    }

    @Override
    protected boolean hasMultiValueImpl() {
        return true;
    }

    @Override
    public TypeConstant getImplicitType(Context ctx) {
        TypeConstant typeTuple;
        ConstantPool pool = this.pool();
        TypeConstant typeConstant = typeTuple = this.type == null ? pool.typeTuple() : this.type.ensureTypeConstant(ctx, null);
        if (typeTuple.containsUnresolved() || !typeTuple.isTuple()) {
            return typeTuple;
        }
        List<Expression> listFieldExprs = this.exprs;
        if (listFieldExprs.isEmpty()) {
            return pool.typeTuple();
        }
        int cFields = listFieldExprs.size();
        TypeConstant[] atypeFields = new TypeConstant[cFields];
        if (typeTuple.isParamsSpecified()) {
            TypeConstant[] atypeSpecified = typeTuple.getParamTypesArray();
            int cSpecified = atypeSpecified.length;
            System.arraycopy(atypeSpecified, 0, atypeFields, 0, Math.min(cFields, cSpecified));
        }
        for (int i = 0; i < cFields; ++i) {
            TypeConstant typeSpecified = atypeFields[i];
            TypeConstant typeImplicit = listFieldExprs.get(i).getImplicitType(ctx);
            if (typeSpecified != null && typeImplicit != null) {
                atypeFields[i] = typeImplicit.isA(typeSpecified) ? typeImplicit : typeSpecified;
                continue;
            }
            if (typeImplicit != null) {
                atypeFields[i] = typeImplicit;
                continue;
            }
            if (typeSpecified != null) continue;
            atypeFields[i] = pool.typeObject();
        }
        return typeTuple.adoptParameters(pool, atypeFields);
    }

    @Override
    public Expression.TypeFit testFitMulti(Context ctx, TypeConstant[] atypeRequired, boolean fExhaustive, ErrorListener errs) {
        TypeConstant typeTuple = this.getImplicitType(ctx);
        if (atypeRequired.length == 1) {
            TypeConstant typeRequired = atypeRequired[0];
            if (typeRequired.isTuple()) {
                atypeRequired = typeRequired.getParamTypesArray();
                if (atypeRequired.length == 0) {
                    return Expression.TypeFit.Fit;
                }
            } else {
                Expression.TypeFit fit = this.calcFit(ctx, typeTuple, typeRequired);
                if (fit.isFit()) {
                    return fit;
                }
            }
        }
        return this.calcFitMulti(ctx, typeTuple.getParamTypesArray(), atypeRequired);
    }

    @Override
    protected Expression validateMulti(Context ctx, TypeConstant[] atypeRequired, ErrorListener errs) {
        boolean fMultiplexing;
        TypeConstant typeRequired;
        ConstantPool pool = this.pool();
        List<Expression> listFieldExprs = this.exprs;
        int cFields = listFieldExprs == null ? 0 : listFieldExprs.size();
        TypeConstant[] aSpecTypes = TypeConstant.NO_TYPES;
        int cSpecTypes = 0;
        TypeConstant[] aReqTypes = TypeConstant.NO_TYPES;
        int cReqTypes = 0;
        boolean fValid = true;
        TypeConstant typeResult = null;
        if (this.type != null) {
            TypeExpression exprOld = this.type;
            TypeConstant typeTupleType = pool.typeTuple().getType();
            TypeExpression exprNew = (TypeExpression)exprOld.validate(ctx, typeTupleType, errs);
            if (exprNew == null) {
                fValid = false;
            } else {
                this.type = exprNew;
                TypeConstant typeSpecified = exprNew.ensureTypeConstant(ctx, errs).resolveAutoNarrowingBase();
                if (typeSpecified.isTuple()) {
                    typeResult = typeSpecified;
                    if (typeSpecified.isParamsSpecified() && (cSpecTypes = (aSpecTypes = typeSpecified.getParamTypesArray()).length) > cFields) {
                        this.type.log(errs, Severity.ERROR, "COMPILER-66", cFields, cSpecTypes);
                        fValid = false;
                    }
                } else {
                    this.type.log(errs, Severity.ERROR, "COMPILER-43", pool.typeTuple(), typeSpecified);
                    fValid = false;
                }
            }
        }
        if (atypeRequired == null || atypeRequired.length == 0) {
            typeRequired = pool.typeTuple();
            fMultiplexing = true;
        } else if (atypeRequired.length == 1) {
            UnionTypeConstant typeUnion;
            TypeConstant typeTuple;
            typeRequired = atypeRequired[0];
            if (typeRequired.isTuple()) {
                aReqTypes = typeRequired.getParamTypesArray();
                cReqTypes = aReqTypes.length;
            } else if (!typeRequired.equals(pool.typeObject()) && typeRequired instanceof UnionTypeConstant && (typeTuple = (typeUnion = (UnionTypeConstant)typeRequired).extractTuple()) != null) {
                aReqTypes = typeTuple.getParamTypesArray();
                cReqTypes = aReqTypes.length;
            }
            fMultiplexing = true;
        } else {
            aReqTypes = atypeRequired;
            cReqTypes = aReqTypes.length;
            typeRequired = pool.ensureTupleType(aReqTypes);
            fMultiplexing = false;
        }
        if (cReqTypes > cFields) {
            this.log(errs, Severity.ERROR, "COMPILER-66", cReqTypes, cFields);
            fValid = false;
        }
        int cMaxTypes = Math.max(cFields, Math.max(cSpecTypes, cReqTypes));
        TypeConstant[] aFieldTypes = new TypeConstant[cMaxTypes];
        Constant[] aFieldVals = cMaxTypes == 0 ? Constant.NO_CONSTS : null;
        for (int i = 0; i < cMaxTypes; ++i) {
            Expression exprOld;
            TypeConstant typeSpec = i < cSpecTypes ? aSpecTypes[i] : null;
            TypeConstant typeReq = i < cReqTypes ? aReqTypes[i] : typeSpec;
            TypeConstant typeField = null;
            Expression expression = exprOld = i < cFields ? listFieldExprs.get(i) : null;
            if (exprOld != null) {
                if (typeReq != null) {
                    ctx = ctx.enterInferring(typeReq);
                }
                Expression exprNew = exprOld.validate(ctx, typeReq, errs);
                if (typeReq != null) {
                    ctx = ctx.exit();
                }
                if (exprNew == null) {
                    fValid = false;
                } else {
                    if (exprNew != exprOld) {
                        listFieldExprs.set(i, exprNew);
                    }
                    if (!(typeField = exprNew.getType()).equals(typeReq)) {
                        typeField = typeField.widenEnumValueTypes();
                    }
                    if (i == 0 || aFieldVals != null) {
                        Constant constVal = exprNew.toConstant();
                        if (constVal == null) {
                            aFieldVals = null;
                        } else {
                            if (aFieldVals == null) {
                                aFieldVals = new Constant[cMaxTypes];
                            }
                            aFieldVals[i] = constVal;
                        }
                    }
                }
            }
            if (typeField == null) {
                TypeConstant typeConstant = typeField = typeReq == null ? pool.typeObject() : typeReq;
                if (aFieldVals != null) {
                    aFieldVals[i] = this.generateFakeConstant(typeField);
                }
            }
            aFieldTypes[i] = typeField;
        }
        if (fValid) {
            typeResult = (typeResult == null ? pool.typeTuple() : typeResult).adoptParameters(pool, aFieldTypes);
            ArrayConstant constVal = null;
            if (aFieldVals != null) {
                typeResult = typeResult.freeze();
                constVal = pool.ensureTupleConstant(typeResult, aFieldVals);
            }
            Expression exprNew = this.finishValidation(ctx, typeRequired, typeResult, Expression.TypeFit.Fit, constVal, errs);
            if (!fMultiplexing) {
                assert (this == exprNew);
                exprNew = new UnpackExpression(this, errs);
            }
            return exprNew;
        }
        return null;
    }

    @Override
    public boolean isCompletable() {
        for (Expression expr : this.exprs) {
            if (expr.isCompletable()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isShortCircuiting() {
        for (Expression expr : this.exprs) {
            if (!expr.isShortCircuiting()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void generateVoid(Context ctx, MethodStructure.Code code, ErrorListener errs) {
        for (Expression expr : this.exprs) {
            expr.generateVoid(ctx, code, errs);
        }
    }

    @Override
    public boolean supportsCompactInit(VariableDeclarationStatement lvalue) {
        return true;
    }

    @Override
    public void generateCompactInit(Context ctx, MethodStructure.Code code, VariableDeclarationStatement lvalue, ErrorListener errs) {
        if (this.isConstant()) {
            super.generateCompactInit(ctx, code, lvalue, errs);
        } else {
            StringConstant idName = this.pool().ensureStringConstant(lvalue.getName());
            code.add(new Var_TN(lvalue.getRegister(), idName, this.collectArguments(ctx, code, errs)));
        }
    }

    @Override
    public Argument[] generateArguments(Context ctx, MethodStructure.Code code, boolean fLocalPropOk, boolean fUsedOnce, ErrorListener errs) {
        if (this.isConstant()) {
            return this.toConstants();
        }
        Register reg = code.createRegister(this.getType());
        code.add(new Var_T(reg, this.collectArguments(ctx, code, errs)));
        return new Argument[]{reg};
    }

    private Argument[] collectArguments(Context ctx, MethodStructure.Code code, ErrorListener errs) {
        List<Expression> listExprs = this.exprs;
        int cArgs = listExprs.size();
        Argument[] aArgs = new Argument[cArgs];
        for (int i = 0; i < cArgs; ++i) {
            Expression expr = listExprs.get(i);
            Argument arg = expr.generateArgument(ctx, code, true, false, errs);
            aArgs[i] = expr.ensurePointInTime(code, arg, listExprs, i);
        }
        return aArgs;
    }

    @Override
    public ExprAST getExprAST(Context ctx) {
        if (this.isConstant()) {
            return new ConstantExprAST(this.toConstant());
        }
        List<Expression> listExprs = this.exprs;
        int cArgs = listExprs.size();
        ExprAST[] aAstArg = new ExprAST[cArgs];
        for (int i = 0; i < cArgs; ++i) {
            aAstArg[i] = listExprs.get(i).getExprAST(ctx);
        }
        return new TupleExprAST(this.getType(), aAstArg);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('(');
        if (!this.exprs.isEmpty()) {
            boolean first = true;
            for (Expression expr : this.exprs) {
                if (first) {
                    first = false;
                } else {
                    sb.append(", ");
                }
                sb.append(expr);
            }
        }
        sb.append(')');
        return sb.toString();
    }

    @Override
    public String getDumpDesc() {
        return this.toString();
    }
}

