/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.compiler.ast;

import java.lang.reflect.Field;
import java.util.List;
import org.xvm.asm.ErrorListener;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.compiler.ast.Context;
import org.xvm.compiler.ast.Expression;
import org.xvm.compiler.ast.FunctionTypeExpression;
import org.xvm.compiler.ast.TypeExpression;

public class TupleTypeExpression
extends TypeExpression {
    protected List<TypeExpression> paramTypes;
    protected long lStartPos;
    protected long lEndPos;
    private static final Field[] CHILD_FIELDS = TupleTypeExpression.fieldsForNames(TupleTypeExpression.class, "paramTypes");

    public TupleTypeExpression(List<TypeExpression> params, long lStartPos, long lEndPos) {
        this.paramTypes = params;
        this.lStartPos = lStartPos;
        this.lEndPos = lEndPos;
    }

    public List<TypeExpression> getParamTypes() {
        return this.paramTypes;
    }

    @Override
    public long getStartPosition() {
        return this.lStartPos;
    }

    @Override
    public long getEndPosition() {
        return this.lEndPos;
    }

    @Override
    protected Field[] getChildFields() {
        return CHILD_FIELDS;
    }

    @Override
    protected TypeConstant instantiateTypeConstant(Context ctx, ErrorListener errs) {
        return this.pool().ensureTupleType(FunctionTypeExpression.toTypeConstantArray(this.paramTypes));
    }

    @Override
    protected Expression validate(Context ctx, TypeConstant typeRequired, ErrorListener errs) {
        List<TypeExpression> listTypes = this.paramTypes;
        boolean fValid = true;
        int c = listTypes.size();
        for (int i = 0; i < c; ++i) {
            TypeExpression exprOld = listTypes.get(i);
            TypeExpression exprNew = (TypeExpression)exprOld.validate(ctx, null, errs);
            if (exprNew == null) {
                fValid = false;
                continue;
            }
            if (exprNew == exprOld) continue;
            listTypes.set(i, exprNew);
        }
        return fValid ? super.validate(ctx, typeRequired, errs) : null;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('<');
        boolean first = true;
        for (TypeExpression type : this.paramTypes) {
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            sb.append(type);
        }
        sb.append('>');
        return sb.toString();
    }

    @Override
    public String getDumpDesc() {
        return this.toString();
    }
}

