/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.compiler.ast;

import java.io.File;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.xvm.asm.Annotation;
import org.xvm.asm.Argument;
import org.xvm.asm.ClassStructure;
import org.xvm.asm.Component;
import org.xvm.asm.ComponentBifurcator;
import org.xvm.asm.Constant;
import org.xvm.asm.ConstantPool;
import org.xvm.asm.Constants;
import org.xvm.asm.ErrorListener;
import org.xvm.asm.FileStructure;
import org.xvm.asm.MethodStructure;
import org.xvm.asm.ModuleStructure;
import org.xvm.asm.MultiMethodStructure;
import org.xvm.asm.PackageStructure;
import org.xvm.asm.PropertyStructure;
import org.xvm.asm.Register;
import org.xvm.asm.Version;
import org.xvm.asm.VersionTree;
import org.xvm.asm.ast.AssignAST;
import org.xvm.asm.ast.BiExprAST;
import org.xvm.asm.ast.BinaryAST;
import org.xvm.asm.ast.CallExprAST;
import org.xvm.asm.ast.CondOpExprAST;
import org.xvm.asm.ast.ConstantExprAST;
import org.xvm.asm.ast.ExprAST;
import org.xvm.asm.ast.IfStmtAST;
import org.xvm.asm.ast.InitAST;
import org.xvm.asm.ast.IsExprAST;
import org.xvm.asm.ast.PropertyExprAST;
import org.xvm.asm.ast.RegisterAST;
import org.xvm.asm.ast.StmtBlockAST;
import org.xvm.asm.constants.ClassConstant;
import org.xvm.asm.constants.ConditionalConstant;
import org.xvm.asm.constants.IdentityConstant;
import org.xvm.asm.constants.MethodConstant;
import org.xvm.asm.constants.ParameterizedTypeConstant;
import org.xvm.asm.constants.PropertyConstant;
import org.xvm.asm.constants.PropertyInfo;
import org.xvm.asm.constants.RegisterConstant;
import org.xvm.asm.constants.SingletonConstant;
import org.xvm.asm.constants.StringConstant;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.asm.constants.TypeInfo;
import org.xvm.asm.op.Construct_0;
import org.xvm.asm.op.Construct_1;
import org.xvm.asm.op.Construct_N;
import org.xvm.asm.op.JumpNType;
import org.xvm.asm.op.L_Get;
import org.xvm.asm.op.L_Set;
import org.xvm.asm.op.Label;
import org.xvm.asm.op.Return_0;
import org.xvm.asm.op.SynInit;
import org.xvm.compiler.Compiler;
import org.xvm.compiler.Lexer;
import org.xvm.compiler.Source;
import org.xvm.compiler.Token;
import org.xvm.compiler.ast.AnnotationExpression;
import org.xvm.compiler.ast.AstNode;
import org.xvm.compiler.ast.ComponentStatement;
import org.xvm.compiler.ast.CompositionNode;
import org.xvm.compiler.ast.Context;
import org.xvm.compiler.ast.Expression;
import org.xvm.compiler.ast.NameExpression;
import org.xvm.compiler.ast.NamedTypeExpression;
import org.xvm.compiler.ast.NewExpression;
import org.xvm.compiler.ast.Parameter;
import org.xvm.compiler.ast.PropertyDeclarationStatement;
import org.xvm.compiler.ast.StageMgr;
import org.xvm.compiler.ast.Statement;
import org.xvm.compiler.ast.StatementBlock;
import org.xvm.compiler.ast.TypeExpression;
import org.xvm.util.Handy;
import org.xvm.util.ListMap;
import org.xvm.util.ListSet;
import org.xvm.util.Severity;

public class TypeCompositionStatement
extends ComponentStatement {
    private final transient Map<Component.Contribution, List<Expression>> m_mapContribArgs = new ListMap<Component.Contribution, List<Expression>>(2);
    protected Source source;
    protected Expression condition;
    protected List<Token> modifiers;
    protected List<AnnotationExpression> annotations;
    protected Token category;
    protected Token name;
    protected List<Token> qualified;
    protected List<Parameter> typeParams;
    protected List<Parameter> constructorParams;
    protected List<TypeExpression> typeArgs;
    protected List<Expression> args;
    protected List<CompositionNode> compositions;
    protected StatementBlock body;
    protected Token doc;
    protected StatementBlock enclosed;
    private boolean m_fAnon;
    private boolean m_fVirtChild;
    private static final Field[] CHILD_FIELDS = TypeCompositionStatement.fieldsForNames(TypeCompositionStatement.class, "condition", "annotations", "typeParams", "constructorParams", "typeArgs", "args", "compositions", "body");

    public TypeCompositionStatement(Source source, long lStartPos, long lEndPos, Expression condition, List<Token> modifiers, List<AnnotationExpression> annotations, Token category, Token name, List<Token> qualified, List<Parameter> typeParams, List<Parameter> constructorParams, List<CompositionNode> compositions, StatementBlock body, Token doc) {
        super(lStartPos, lEndPos);
        this.source = source;
        this.condition = condition;
        this.modifiers = modifiers;
        this.annotations = annotations;
        this.category = category;
        this.name = name;
        this.qualified = qualified;
        this.typeParams = typeParams;
        this.constructorParams = constructorParams;
        this.compositions = compositions;
        this.body = body;
        this.doc = doc;
    }

    public TypeCompositionStatement(List<AnnotationExpression> annotations, Token name, List<TypeExpression> typeArgs, List<Expression> args, StatementBlock body, Token doc, long lStartPos, long lEndPos) {
        super(lStartPos, lEndPos);
        this.annotations = annotations;
        this.category = new Token(name.getStartPosition(), name.getStartPosition(), Token.Id.ENUM_VAL);
        this.name = name;
        this.typeArgs = typeArgs;
        this.args = args;
        this.body = body;
        this.doc = doc;
    }

    public TypeCompositionStatement(NewExpression parent, List<AnnotationExpression> annotations, Token category, Token name, List<Parameter> typeParams, List<CompositionNode> compositions, List<Expression> args, StatementBlock body, long lStartPos, long lEndPos) {
        super(lStartPos, lEndPos);
        this.annotations = annotations;
        this.category = category;
        this.name = name;
        this.typeParams = typeParams;
        this.compositions = compositions;
        this.args = args;
        this.body = body;
        this.m_fAnon = true;
        this.setParent(parent);
        this.introduceParentage();
    }

    public TypeCompositionStatement(ModuleStructure module, Source source, TypeExpression type) {
        super(0L, 0L);
        this.source = source;
        this.category = new Token(0L, 0L, Token.Id.MODULE);
        this.name = new Token(0L, 0L, Token.Id.IDENTIFIER, module.getSimpleName());
        this.qualified = Arrays.stream(Handy.parseDelimitedString(module.getName(), '.')).map(s -> new Token(0L, 0L, Token.Id.IDENTIFIER, s)).collect(Collectors.toCollection(ArrayList::new));
        this.typeArgs = new ArrayList<TypeExpression>(List.of(type));
        this.introduceParentage();
        this.setComponent(module);
        this.setStage(Compiler.Stage.Emitted);
    }

    @Override
    public Source getSource() {
        return this.source == null ? super.getSource() : this.source;
    }

    @Override
    public Constants.Access getDefaultAccess() {
        Constants.Access access = TypeCompositionStatement.getAccess(this.modifiers);
        return access == null ? super.getDefaultAccess() : access;
    }

    public Token getCategory() {
        return this.category;
    }

    public String getName() {
        if (this.category.getId() == Token.Id.MODULE) {
            StringBuilder sb = new StringBuilder();
            for (Token suffix : this.qualified) {
                sb.append('.').append(suffix.getValue());
            }
            return sb.substring(1);
        }
        return (String)this.name.getValue();
    }

    public Zone getDeclarationZone() {
        Component structThis = this.getComponent();
        switch (structThis.getFormat()) {
            case MODULE: 
            case PACKAGE: {
                return Zone.TopLevel;
            }
            case CLASS: 
            case INTERFACE: 
            case SERVICE: 
            case CONST: 
            case ENUM: 
            case ANNOTATION: 
            case MIXIN: {
                Component structParent = structThis.getParent();
                return switch (structParent.getFormat()) {
                    case Component.Format.MODULE, Component.Format.PACKAGE -> Zone.TopLevel;
                    case Component.Format.CLASS, Component.Format.INTERFACE, Component.Format.SERVICE, Component.Format.CONST, Component.Format.ENUM, Component.Format.ENUMVALUE, Component.Format.ANNOTATION, Component.Format.MIXIN -> Zone.InClass;
                    case Component.Format.METHOD -> Zone.InMethod;
                    case Component.Format.PROPERTY -> Zone.InProperty;
                    default -> throw new IllegalStateException("this=" + String.valueOf((Object)structThis.getFormat()) + ", parent=" + String.valueOf((Object)structParent.getFormat()));
                };
            }
            case ENUMVALUE: {
                return Zone.InClass;
            }
        }
        throw new IllegalStateException("this=" + String.valueOf((Object)structThis.getFormat()));
    }

    @Override
    protected Field[] getChildFields() {
        return CHILD_FIELDS;
    }

    @Override
    public boolean isAutoNarrowingAllowed(TypeExpression type) {
        Parameter param;
        if (this.constructorParams == null) {
            return false;
        }
        AstNode nodeChild = this.findChild(type);
        return nodeChild instanceof Parameter && this.constructorParams.contains(param = (Parameter)nodeChild);
    }

    @Override
    protected void discard(boolean fRecurse) {
        super.discard(fRecurse);
        Component component = this.getComponent();
        if (component != null) {
            this.pool().invalidateTypeInfos(component.getIdentityConstant());
        }
    }

    @Override
    protected AstNode getCodeContainer() {
        return null;
    }

    public void addEnclosed(Statement stmt) {
        if (stmt == null) {
            return;
        }
        if (this.enclosed == null) {
            this.enclosed = this.adopt(new StatementBlock(new ArrayList<Statement>()));
            this.enclosed.markFileBoundary();
            this.ensureBody().addStatement(this.enclosed);
        }
        this.enclosed.addStatement(stmt);
    }

    public StatementBlock ensureBody() {
        if (this.body == null) {
            this.body = this.adopt(new StatementBlock(new ArrayList<Statement>()));
        }
        return this.body;
    }

    /*
     * Could not resolve type clashes
     */
    @Override
    protected void registerStructures(StageMgr mgr, ErrorListener errs) {
        ClassStructure component;
        ConstantPool pool;
        boolean fInner;
        Component container;
        String sName;
        block175: {
            String sFile;
            block177: {
                TypeCompositionStatement stmtModule;
                String sOrig;
                block176: {
                    AstNode nodeModule;
                    ConditionalConstant constCond;
                    if (this.getComponent() != null) {
                        return;
                    }
                    AstNode parent = this.getParent();
                    if (parent == null) {
                        assert (this.category.getId() == Token.Id.MODULE);
                        this.introduceParentage();
                    }
                    sName = (String)this.name.getValue();
                    Constants.Access access = this.getDefaultAccess();
                    container = parent == null ? null : parent.getComponent();
                    fInner = false;
                    pool = this.pool();
                    ConditionalConstant conditionalConstant = constCond = this.condition == null ? null : this.condition.toConditionalConstant();
                    if (container != null) {
                        if (container instanceof ModuleStructure && sName.equals("ecstasy")) {
                            this.name.log(errs, this.getSource(), Severity.ERROR, "COMPILER-31", "ecstasy");
                        } else {
                            block0 : switch (this.category.getId()) {
                                case MODULE: 
                                case PACKAGE: 
                                case ENUM: 
                                case ENUM_VAL: {
                                    break;
                                }
                                default: {
                                    IdentityConstant idParent = container.getIdentityConstant();
                                    switch (idParent.getFormat()) {
                                        case Module: 
                                        case Package: {
                                            break block0;
                                        }
                                        case Method: 
                                        case Property: 
                                        case Class: {
                                            fInner = true;
                                            break block0;
                                        }
                                    }
                                    throw new IllegalStateException("idParent=" + String.valueOf(idParent));
                                }
                            }
                        }
                    }
                    component = null;
                    switch (this.category.getId()) {
                        case MODULE: {
                            if (constCond != null) {
                                this.condition.log(errs, Severity.ERROR, "COMPILER-23", new Object[0]);
                                break;
                            }
                            if (container == null) {
                                ModuleStructure modX;
                                String sModule = this.getName();
                                if (!Lexer.isValidQualifiedModule(sModule)) {
                                    errs.log(Severity.FATAL, "COMPILER-07", new String[]{sModule}, this.source, this.qualified.get(0).getStartPosition(), this.qualified.get(this.qualified.size() - 1).getEndPosition());
                                    return;
                                }
                                FileStructure struct = new FileStructure(sModule);
                                component = struct.getModule();
                                pool = struct.getConstantPool();
                                if (this.getName().equals("ecstasy.xtclang.org")) {
                                    modX = (ModuleStructure)component;
                                } else {
                                    modX = struct.ensureModule("ecstasy.xtclang.org");
                                    modX.fingerprintRequired();
                                }
                                PackageStructure pkgX = component.createPackage(Constants.Access.PUBLIC, "ecstasy", null);
                                pkgX.setSynthetic(true);
                                pkgX.setStatic(true);
                                pkgX.setImportedModule(modX);
                                break;
                            }
                            this.log(errs, Severity.ERROR, "COMPILER-02", new Object[0]);
                            break;
                        }
                        case PACKAGE: {
                            if (container == null) {
                                assert (errs.hasSeriousErrors());
                                return;
                            }
                            if (container.isPackageContainer()) {
                                component = container.createPackage(access, sName, constCond);
                                break;
                            }
                            this.log(errs, Severity.ERROR, "COMPILER-03", container.toString());
                            break;
                        }
                        case ENUM: 
                        case ENUM_VAL: 
                        case CLASS: 
                        case INTERFACE: 
                        case SERVICE: 
                        case CONST: 
                        case ANNOTATION: 
                        case MIXIN: {
                            if (container != null && container.isClassContainer()) {
                                Component.Format format = switch (this.category.getId()) {
                                    case Token.Id.CLASS -> Component.Format.CLASS;
                                    case Token.Id.INTERFACE -> Component.Format.INTERFACE;
                                    case Token.Id.SERVICE -> Component.Format.SERVICE;
                                    case Token.Id.CONST -> Component.Format.CONST;
                                    case Token.Id.ENUM -> Component.Format.ENUM;
                                    case Token.Id.ENUM_VAL -> Component.Format.ENUMVALUE;
                                    case Token.Id.ANNOTATION -> Component.Format.ANNOTATION;
                                    case Token.Id.MIXIN -> Component.Format.MIXIN;
                                    default -> throw new IllegalStateException();
                                };
                                component = container.createClass(this.getDefaultAccess(), format, sName, constCond);
                                if (!this.m_fAnon) break;
                                component.setSynthetic(true);
                                break;
                            }
                            if (errs.hasSeriousErrors()) break;
                            this.log(errs, Severity.ERROR, "COMPILER-04", container);
                            break;
                        }
                        default: {
                            throw new IllegalStateException("unable to guess structure for: " + this.category.getId().TEXT);
                        }
                    }
                    this.setComponent(component);
                    if (component == null) {
                        if (!errs.hasSeriousErrors()) {
                            this.log(errs, Severity.ERROR, "COMPILER-148", sName);
                        }
                        return;
                    }
                    if (this.doc != null) {
                        component.setDocumentation(TypeCompositionStatement.extractDocumentation(this.doc));
                    }
                    if (this.source == null || (sOrig = this.source.getFileName()) == null) break block175;
                    for (nodeModule = this; nodeModule != null; nodeModule = nodeModule.getParent()) {
                        if (!(nodeModule instanceof TypeCompositionStatement)) continue;
                        stmtModule = nodeModule;
                        if (stmtModule.category.getId() == Token.Id.MODULE) break;
                    }
                    if (nodeModule == null) break block175;
                    stmtModule = nodeModule;
                    sFile = sOrig.replace(File.separatorChar, '/');
                    if (this != stmtModule) break block176;
                    int ofFile = sFile.lastIndexOf(47) + 1;
                    String sDir = sOrig.substring(0, ofFile);
                    ((ModuleStructure)component).setSourceDir(pool.ensureLiteralConstant(Constant.Format.Path, sDir));
                    sFile = sFile.substring(ofFile);
                    break block177;
                }
                String sDir = ((ModuleStructure)stmtModule.getComponent()).getSourceDir().getValue();
                if (sDir == null || !sOrig.startsWith(sDir)) break block175;
                sFile = sFile.substring(sDir.length());
            }
            component.setSourcePath(pool.ensureLiteralConstant(Constant.Format.Path, sFile));
        }
        Zone zone = this.getDeclarationZone();
        int nAllowed = 0;
        switch (component.getFormat()) {
            case CLASS: 
            case INTERFACE: 
            case SERVICE: 
            case CONST: 
            case ANNOTATION: 
            case MIXIN: {
                if (component.getFormat() != Component.Format.CLASS || zone != Zone.TopLevel) {
                    nAllowed |= 0x800;
                }
            }
            case PACKAGE: 
            case ENUM: {
                if (zone == Zone.InMethod) break;
                nAllowed |= 0x300;
            }
        }
        boolean fExplicitlyStatic = false;
        if (this.modifiers != null && !this.modifiers.isEmpty()) {
            int nSpecified = 0;
            boolean fExplicitlyPublic = false;
            boolean fExplicitlyProtected = false;
            boolean fExplicitlyPrivate = false;
            for (Token token : this.modifiers) {
                boolean fAlready;
                int nBits = switch (token.getId()) {
                    case Token.Id.PUBLIC -> {
                        fAlready = fExplicitlyPublic;
                        fExplicitlyPublic = true;
                        yield 768;
                    }
                    case Token.Id.PROTECTED -> {
                        fAlready = fExplicitlyProtected;
                        fExplicitlyProtected = true;
                        yield 768;
                    }
                    case Token.Id.PRIVATE -> {
                        fAlready = fExplicitlyPrivate;
                        fExplicitlyPrivate = true;
                        yield 768;
                    }
                    case Token.Id.STATIC -> {
                        fAlready = fExplicitlyStatic;
                        fExplicitlyStatic = true;
                        yield 2048;
                    }
                    default -> throw new IllegalStateException("token=" + String.valueOf(token));
                };
                if (fAlready) {
                    token.log(errs, this.getSource(), Severity.ERROR, "COMPILER-08", new Object[0]);
                } else if ((nAllowed & nBits) == 0) {
                    token.log(errs, this.getSource(), Severity.ERROR, "COMPILER-09", new Object[0]);
                } else if ((nSpecified & nBits) != 0) {
                    token.log(errs, this.getSource(), Severity.ERROR, "COMPILER-10", new Object[0]);
                }
                nSpecified |= nBits;
            }
            if (fExplicitlyPublic ^ fExplicitlyProtected ^ fExplicitlyPrivate) {
                assert (component.getAccess() == Constants.Access.PUBLIC == fExplicitlyPublic);
                assert (component.getAccess() == Constants.Access.PROTECTED == fExplicitlyProtected);
                assert (component.getAccess() == Constants.Access.PRIVATE == fExplicitlyPrivate);
            }
        }
        boolean fImplicitlyStatic = component.getFormat().isImplicitlyStatic();
        switch (zone.ordinal()) {
            case 3: {
                PropertyStructure prop = (PropertyStructure)component.getParent();
                fImplicitlyStatic |= prop.isStatic() || prop.getContainingClass().isSingleton();
                break;
            }
            case 2: {
                MethodStructure method = (MethodStructure)component.getParent();
                fImplicitlyStatic |= method.isFunction() || method.getContainingClass().isSingleton();
                break;
            }
            case 1: {
                if (fExplicitlyStatic) break;
                ClassStructure clzParent = (ClassStructure)container;
                switch (component.getFormat()) {
                    case CONST: {
                        if (clzParent.isConst() || clzParent.isService()) break;
                        this.log(errs, Severity.ERROR, "COMPILER-16", new Object[0]);
                        fExplicitlyStatic = true;
                        break;
                    }
                    case SERVICE: {
                        if (clzParent.isConst() || clzParent.isService()) break;
                        this.log(errs, Severity.ERROR, "COMPILER-17", new Object[0]);
                        fExplicitlyStatic = true;
                    }
                }
                boolean bl = this.m_fVirtChild = fInner && !fExplicitlyStatic;
                assert (!this.m_fAnon || fInner && !this.m_fVirtChild);
                break;
            }
        }
        if (fExplicitlyStatic || fImplicitlyStatic) {
            component.setStatic(true);
        }
        boolean fSingleton = false;
        switch (component.getFormat()) {
            case MODULE: 
            case PACKAGE: {
                fSingleton = true;
                this.disallowTypeParams(errs);
                this.requireConstructorParamValues(errs);
                break;
            }
            case ENUMVALUE: {
                fSingleton = true;
                this.disallowTypeParams(errs);
                assert (container.getFormat() == Component.Format.ENUM);
                ClassStructure enumeration = (ClassStructure)container;
                if (enumeration.getTypeParamCount() == (this.typeArgs == null ? 0 : this.typeArgs.size())) break;
                this.log(errs, Severity.ERROR, "COMPILER-18", new Object[0]);
                break;
            }
            case SERVICE: 
            case CONST: {
                if (fExplicitlyStatic && zone == Zone.TopLevel) {
                    fSingleton = true;
                    this.disallowTypeParams(errs);
                    this.requireConstructorParamValues(errs);
                    break;
                }
            }
            case CLASS: 
            case INTERFACE: 
            case ENUM: 
            case ANNOTATION: 
            case MIXIN: {
                if (this.typeParams == null || this.typeParams.isEmpty()) break;
                HashSet<String> setNames = new HashSet<String>();
                for (Parameter param : this.typeParams) {
                    String sParam = param.getName();
                    if (setNames.add(sParam)) {
                        TypeExpression exprType = param.getType();
                        TypeConstant constType = exprType == null ? pool.typeObject() : exprType.ensureTypeConstant();
                        component.addTypeParam(sParam, constType);
                        continue;
                    }
                    this.log(errs, Severity.ERROR, "COMPILER-19", sName);
                }
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        assert (component.isSingleton() == fSingleton);
        if (this.annotations != null && !this.annotations.isEmpty()) {
            if (this.compositions == null || this.compositions.isEmpty()) {
                this.compositions = new ArrayList<CompositionNode>();
            }
            for (AnnotationExpression annotation : this.annotations) {
                annotation.ensureAnnotation(pool);
                this.compositions.add(new CompositionNode.Annotates(annotation));
            }
        }
        boolean fAlreadyExtends = false;
        boolean fAlreadyImports = false;
        boolean fAlreadyIntos = false;
        TypeConstant typeDefaultInto = null;
        Object typeDefaultImpl = null;
        TypeConstant typeDefaultSuper = null;
        if (!this.m_fVirtChild) {
            switch (component.getFormat()) {
                case INTERFACE: {
                    break;
                }
                case ENUMVALUE: {
                    assert (container != null && container.getFormat() == Component.Format.ENUM);
                    typeDefaultImpl = null;
                    typeDefaultSuper = container.getIdentityConstant().getType();
                    break;
                }
                case ANNOTATION: 
                case MIXIN: {
                    typeDefaultImpl = null;
                    typeDefaultInto = pool.typeObject();
                    break;
                }
                default: {
                    typeDefaultImpl = null;
                }
            }
        }
        int cImports = 0;
        boolean fHasDefault = false;
        Component.Format format = component.getFormat();
        ComponentBifurcator bifurcator = new ComponentBifurcator(component);
        ConditionalConstant condPrev = null;
        ArrayList<Component> componentList = new ArrayList<Component>();
        componentList.add(component);
        block71: for (CompositionNode composition : this.compositions == null ? Collections.emptyList() : this.compositions) {
            ConditionalConstant condCur;
            Expression exprCond = composition.getCondition();
            ConditionalConstant conditionalConstant = condCur = exprCond == null ? null : exprCond.toConditionalConstant();
            if (!Handy.equals(condCur, condPrev)) {
                componentList.clear();
                bifurcator.collectMatchingComponents(condCur, componentList);
                condPrev = condCur;
            }
            Token.Id keyword = composition.getKeyword().getId();
            switch (keyword) {
                case EXTENDS: {
                    Object struct2;
                    TypeConstant type;
                    if (format == Component.Format.INTERFACE) {
                        type = composition.getType().ensureTypeConstant();
                        for (Object struct2 : componentList) {
                            composition.setContribution(((Component)struct2).addContribution(Component.Composition.Implements, type));
                        }
                        continue block71;
                    }
                    assert (format != Component.Format.ENUMVALUE);
                    if (fAlreadyExtends) {
                        composition.log(errs, Severity.ERROR, "COMPILER-11", this.category.getId().TEXT);
                        break;
                    }
                    fAlreadyExtends = composition.condition == null;
                    typeDefaultInto = null;
                    type = composition.getType().ensureTypeConstant();
                    CompositionNode.Extends node = (CompositionNode.Extends)composition;
                    struct2 = componentList.iterator();
                    while (struct2.hasNext()) {
                        ClassStructure struct3 = (ClassStructure)struct2.next();
                        Component.Contribution contrib = struct3.addContribution(Component.Composition.Extends, type);
                        composition.setContribution(contrib);
                        this.m_mapContribArgs.put(contrib, node.args);
                    }
                    continue block71;
                }
                case IMPORT: {
                    ConditionalConstant condSum;
                    ++cImports;
                    if (format != Component.Format.PACKAGE) {
                        composition.log(errs, Severity.ERROR, "COMPILER-15", keyword.TEXT);
                        break;
                    }
                    if (fAlreadyImports) {
                        composition.log(errs, Severity.ERROR, "COMPILER-20", new Object[0]);
                        break;
                    }
                    fAlreadyImports = true;
                    if (composition.condition != null) {
                        composition.log(errs, Severity.ERROR, "COMPILER-23", new Object[0]);
                    }
                    CompositionNode.Import compImport = (CompositionNode.Import)composition;
                    NamedTypeExpression type = (NamedTypeExpression)compImport.type;
                    String sModule = type.getName();
                    if (!type.isValidModuleName()) {
                        composition.log(errs, Severity.ERROR, "COMPILER-07", sModule);
                        break;
                    }
                    FileStructure fileStruct = component.getFileStructure();
                    List<Version> listPrefer = compImport.getPreferVersionList();
                    VersionTree<Boolean> vtreeAllow = compImport.getAllowVersionTree();
                    Version version = vtreeAllow.isEmpty() ? null : vtreeAllow.findLowestVersion();
                    boolean fNewFingerprint = false;
                    ModuleStructure moduleImport = fileStruct.findModule(sModule);
                    if (moduleImport == null) {
                        fNewFingerprint = true;
                        moduleImport = fileStruct.ensureModule(pool.ensureModuleConstant(sModule, version));
                    } else if (moduleImport.isMainModule()) {
                        if (!listPrefer.isEmpty() || !vtreeAllow.isEmpty()) {
                            composition.log(errs, Severity.ERROR, "COMPILER-26", new Object[0]);
                        }
                    } else {
                        assert (moduleImport.isFingerprint());
                        VersionTree<Boolean> vtreePrev = moduleImport.getFingerprintVersions();
                        if (vtreePrev.isEmpty() == vtreeAllow.isEmpty()) {
                            if (!vtreePrev.isEmpty()) {
                                Version verPrev = vtreePrev.findLowestVersion();
                                if (verPrev.isSubstitutableFor(version) || version.isSubstitutableFor(verPrev)) {
                                    composition.log(errs, Severity.ERROR, "COMPILER-25", new Object[0]);
                                } else {
                                    fNewFingerprint = true;
                                    moduleImport = fileStruct.ensureModule(pool.ensureModuleConstant(sModule, version));
                                }
                            }
                        } else {
                            composition.log(errs, Severity.ERROR, "COMPILER-25", new Object[0]);
                        }
                    }
                    ((PackageStructure)component).setImportedModule(moduleImport);
                    if (fNewFingerprint) {
                        switch (compImport.getImplicitModifier()) {
                            case OPTIONAL: {
                                moduleImport.fingerprintOptional();
                                break;
                            }
                            case DESIRED: {
                                moduleImport.fingerprintDesired();
                                break;
                            }
                            case EMBEDDED: 
                            case REQUIRED: {
                                moduleImport.fingerprintRequired();
                                break;
                            }
                            default: {
                                throw new IllegalStateException();
                            }
                        }
                        if (!listPrefer.isEmpty()) {
                            List<Version> listOld = moduleImport.getFingerprintVersionPrefs();
                            if (listOld.isEmpty()) {
                                moduleImport.setFingerprintVersionPrefs(listPrefer);
                            } else if (!listOld.equals(listPrefer)) {
                                composition.log(errs, Severity.ERROR, "COMPILER-25", new Object[0]);
                            }
                        }
                        if (!vtreeAllow.isEmpty()) {
                            VersionTree<Boolean> vtreeOld = moduleImport.getFingerprintVersions();
                            if (vtreeOld.isEmpty()) {
                                moduleImport.setFingerprintVersions(vtreeAllow);
                            } else if (!vtreeOld.equals(vtreeAllow)) {
                                composition.log(errs, Severity.ERROR, "COMPILER-25", new Object[0]);
                            }
                        }
                    }
                    if ((condSum = component.getAggregateCondition()) == null || fNewFingerprint) {
                        moduleImport.setCondition(condSum);
                        break;
                    }
                    ConditionalConstant condPre = moduleImport.getCondition();
                    if (condPre == null) continue block71;
                    moduleImport.setCondition(condPre.addOr(condSum));
                    break;
                }
                case INTO: {
                    if (format == Component.Format.MIXIN || format == Component.Format.ANNOTATION) {
                        if (fAlreadyIntos) {
                            composition.log(errs, Severity.ERROR, "COMPILER-21", new Object[0]);
                            break;
                        }
                        fAlreadyIntos = composition.condition == null;
                        for (ClassStructure struct : componentList) {
                            composition.setContribution(struct.addContribution(Component.Composition.Into, composition.getType().ensureTypeConstant()));
                        }
                        continue block71;
                    }
                    composition.log(errs, Severity.ERROR, "COMPILER-15", keyword.TEXT);
                    break;
                }
                case IMPLEMENTS: {
                    if (format == Component.Format.INTERFACE) {
                        composition.log(errs, Severity.ERROR, "COMPILER-15", keyword.TEXT);
                        break;
                    }
                    for (ClassStructure struct : componentList) {
                        TypeConstant typeImplements = composition.getType().ensureTypeConstant();
                        if (typeImplements.equals(typeDefaultImpl)) {
                            typeDefaultImpl = null;
                        }
                        composition.setContribution(struct.addContribution(Component.Composition.Implements, typeImplements));
                    }
                    continue block71;
                }
                case DELEGATES: {
                    Object sTarget;
                    TypeConstant typeTarget = composition.getType().ensureTypeConstant();
                    Expression exprTarget = ((CompositionNode.Delegates)composition).getDelegatee();
                    if (!(exprTarget instanceof NameExpression)) {
                        exprTarget.log(errs, Severity.ERROR, "COMPILER-194", new Object[0]);
                        break;
                    }
                    NameExpression exprName = (NameExpression)exprTarget;
                    if (exprName.isSimpleName()) {
                        sTarget = exprName.getName();
                    } else {
                        sTarget = "delegate:" + typeTarget.getValueString();
                        long lStartPos = exprTarget.getStartPosition();
                        long lEndPos = exprTarget.getEndPosition();
                        PropertyDeclarationStatement propTarget = new PropertyDeclarationStatement(lStartPos, lEndPos, composition.getCondition(), null, null, composition.getType(), new Token(lStartPos, lEndPos, Token.Id.IDENTIFIER, sTarget), null, exprTarget, null, null);
                        propTarget.markSynthetic();
                        exprTarget.setParent(propTarget);
                        this.ensureBody().addStatement(propTarget);
                    }
                    PropertyConstant idTarget = pool.ensurePropertyConstant(component.getIdentityConstant(), (String)sTarget);
                    ((CompositionNode.Delegates)composition).setPropertyName((String)sTarget);
                    for (Object struct : componentList) {
                        composition.setContribution(((Component)struct).addDelegation(typeTarget, idTarget));
                    }
                    continue block71;
                }
                case ANNOTATION: {
                    Object struct;
                    CompositionNode.Annotates anno = (CompositionNode.Annotates)composition;
                    struct = componentList.iterator();
                    while (struct.hasNext()) {
                        ClassStructure struct4 = (ClassStructure)struct.next();
                        struct4.addAnnotation(anno.ensureAnnotation(pool));
                    }
                    continue block71;
                }
                case INCORPORATES: {
                    CompositionNode.Incorporates incorp = (CompositionNode.Incorporates)composition;
                    if (format == Component.Format.INTERFACE) {
                        composition.log(errs, Severity.ERROR, "COMPILER-15", keyword.TEXT);
                        break;
                    }
                    ListMap<String, TypeConstant> mapConstraints = null;
                    if (incorp.isConditional()) {
                        mapConstraints = new ListMap<String, TypeConstant>();
                        for (Parameter constraint : incorp.getConstraints()) {
                            TypeExpression type = constraint.getType();
                            mapConstraints.put(constraint.getName(), type == null ? null : type.ensureTypeConstant());
                        }
                    }
                    for (ClassStructure struct : componentList) {
                        Component.Contribution contrib = struct.addIncorporates(composition.getType().ensureTypeConstant(), mapConstraints);
                        composition.setContribution(contrib);
                        this.m_mapContribArgs.put(contrib, incorp.args);
                    }
                    continue block71;
                }
                case DEFAULT: {
                    if (fHasDefault) {
                        composition.log(errs, Severity.ERROR, "COMPILER-64", sName);
                        break;
                    }
                    NamedTypeExpression typeDefault = new NamedTypeExpression(null, Collections.singletonList(this.name), null, null, null, this.name.getEndPosition());
                    Expression exprValue = ((CompositionNode.Default)composition).getValueExpression();
                    long lStartPos = composition.getStartPosition();
                    long lEndPos = composition.getEndPosition();
                    PropertyDeclarationStatement propDefault = new PropertyDeclarationStatement(lStartPos, lEndPos, composition.getCondition(), Collections.singletonList(new Token(lStartPos, lStartPos, Token.Id.STATIC)), null, typeDefault, composition.keyword, null, exprValue, null, null);
                    propDefault.markSynthetic();
                    typeDefault.setParent(propDefault);
                    exprValue.setParent(propDefault);
                    this.ensureBody().addStatement(propDefault);
                    fHasDefault = true;
                    break;
                }
                default: {
                    throw new IllegalStateException("illegal composition: " + String.valueOf(composition));
                }
            }
        }
        componentList.clear();
        bifurcator.collectMatchingComponents(null, componentList);
        if (!(fAlreadyExtends || typeDefaultImpl == null && typeDefaultSuper == null)) {
            for (ClassStructure struct : componentList) {
                assert (struct.findContribution(Component.Composition.Extends) == null);
                if (typeDefaultSuper != null) {
                    Component.Contribution contrib = struct.addContribution(Component.Composition.Extends, typeDefaultSuper);
                    this.m_mapContribArgs.put(contrib, null);
                }
                if (typeDefaultImpl == null) continue;
                struct.addContribution(Component.Composition.Implements, typeDefaultImpl);
            }
        }
        if (!fAlreadyIntos && typeDefaultInto != null) {
            for (ClassStructure struct : componentList) {
                assert (struct.getContributionsAsList().stream().noneMatch(contribution -> contribution.getComposition() == Component.Composition.Into));
                struct.addContribution(Component.Composition.Into, typeDefaultInto);
            }
        }
        if (cImports > 0 && (cImports != this.compositions.size() || this.body != null || this.modifiers != null && !this.modifiers.isEmpty() || this.typeParams != null && !this.typeParams.isEmpty() || this.constructorParams != null && !this.constructorParams.isEmpty())) {
            this.log(errs, Severity.ERROR, "COMPILER-22", new Object[0]);
        }
        mgr.processChildren();
        List<Parameter> listParams = this.constructorParams;
        if (listParams != null && !listParams.isEmpty()) {
            Map<String, Component> mapChildren = component.getChildByNameMap();
            for (Parameter param : listParams) {
                String sParam = param.getName();
                Component child = mapChildren.get(sParam);
                if (child == null) {
                    PropertyDeclarationStatement prop = new PropertyDeclarationStatement(param.getStartPosition(), param.getEndPosition(), null, null, null, param.getType(), param.getNameToken(), null, param.getValue(), null, null);
                    prop.markSynthetic();
                    if (this.body == null) {
                        this.body = this.adopt(new StatementBlock(new ArrayList<Statement>(1)));
                        new StageMgr(this.body, Compiler.Stage.Registered, errs).fastForward(1);
                    }
                    this.body.addStatement(prop);
                    new StageMgr(prop, Compiler.Stage.Registered, errs).fastForward(1);
                    continue;
                }
                if (child instanceof PropertyStructure) continue;
                param.log(errs, Severity.ERROR, "COMPILER-31", sParam);
            }
        }
    }

    private void reportRequireClass(ClassStructure component, Component.Contribution contrib, TypeConstant typeContrib, ErrorListener errs) {
        this.findComposition(contrib).log(errs, Severity.ERROR, switch (contrib.getComposition()) {
            case Component.Composition.Implements -> {
                if (component.getFormat() != Component.Format.INTERFACE) {
                    yield "VERIFY-12";
                }
            }
            case Component.Composition.Extends -> "VERIFY-10";
            case Component.Composition.Incorporates -> "VERIFY-16";
            default -> throw new IllegalStateException();
        }, component.getIdentityConstant().getPathString(), typeContrib.getValueString());
    }

    private void reportAmbiguousConstructor(List<Parameter> listParams, TypeConstant[] atypeParams, ErrorListener errs) {
        int cParams = atypeParams.length;
        StringBuilder sb = new StringBuilder("construct(");
        for (int i = 0; i < cParams; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(atypeParams[i].getValueString());
        }
        sb.append(')');
        long lStart = this.name.getStartPosition();
        long lEnd = this.name.getEndPosition();
        if (cParams > 0) {
            lStart = listParams.get(0).getStartPosition();
            lEnd = listParams.get(cParams - 1).getEndPosition();
        }
        errs.log(Severity.ERROR, "COMPILER-63", new String[]{sb.toString()}, this.getSource(), lStart, lEnd);
    }

    private void addImplicitTypeConstraints(ClassStructure component, ErrorListener errs) {
        assert (component.isParameterized());
        ArrayList<String> listUnconstrained = null;
        for (Map.Entry<StringConstant, TypeConstant> entry : component.getTypeParams().entrySet()) {
            String string = entry.getKey().getValue();
            TypeConstant typeConstraint = entry.getValue();
            if (!typeConstraint.equals(this.pool().typeObject())) continue;
            if (listUnconstrained == null) {
                listUnconstrained = new ArrayList<String>();
            }
            listUnconstrained.add(string);
        }
        if (listUnconstrained == null) {
            this.findImplicitConstraint(component, "", null, true, errs);
            return;
        }
        Map<String, TypeConstant> mapConstraints = null;
        for (String string : listUnconstrained) {
            mapConstraints = this.findImplicitConstraint(component, string, mapConstraints, true, errs);
        }
        if (mapConstraints != null) {
            for (Map.Entry entry : mapConstraints.entrySet()) {
                component.updateConstraint((String)entry.getKey(), (TypeConstant)entry.getValue());
            }
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @Override
    public void resolveNames(StageMgr mgr, ErrorListener errs) {
        boolean bl;
        boolean fExplicitDefault;
        Map<String, Component> mapChildren;
        List<Expression> listArgs;
        Component.Format format;
        ClassStructure component;
        block81: {
            TypeConstant[] atypeParams;
            int n;
            IdentityConstant identityConstant;
            List<Parameter> listParams;
            MultiMethodStructure multiMethodStructure;
            block90: {
                Iterator<MethodStructure> iterator;
                block89: {
                    boolean fModuleImport;
                    block88: {
                        block87: {
                            boolean fAlreadyLogged;
                            ListSet<Component.Contribution> setContrib;
                            block79: {
                                block80: {
                                    IdentityConstant identityConstant2;
                                    IdentityConstant identityConstant3;
                                    block82: {
                                        component = (ClassStructure)this.getComponent();
                                        if (component == null) {
                                            assert (errs.hasSeriousErrors());
                                            return;
                                        }
                                        for (ClassStructure clz = component; clz != null; clz = clz.getContainingClass()) {
                                            if (!clz.containsUnresolvedContribution()) continue;
                                            mgr.requestRevisit();
                                            return;
                                        }
                                        Component.Contribution contribCyclical = component.hasCyclicalContribution();
                                        if (contribCyclical != null) {
                                            errs.log(Severity.FATAL, "VERIFY-11", new Object[]{contribCyclical.getComponent().getIdentityConstant().getValueString(), contribCyclical.toString()}, this.getSource(), this.compositions.get(0).getStartPosition(), this.compositions.get(this.compositions.size() - 1).getEndPosition());
                                            return;
                                        }
                                        for (Component.Contribution contrib2 : component.getContributionsAsList()) {
                                            TypeConstant typeContrib = contrib2.getTypeConstant();
                                            Component.Composition composition = contrib2.getComposition();
                                            switch (composition) {
                                                case Implements: 
                                                case Extends: 
                                                case Incorporates: {
                                                    Component.Format formatContrib;
                                                    Component.Format formatThis;
                                                    if (!typeContrib.isExplicitClassIdentity(true)) {
                                                        this.reportRequireClass(component, contrib2, typeContrib, errs);
                                                        return;
                                                    }
                                                    if (typeContrib.isAccessSpecified() || typeContrib.isAnnotated()) {
                                                        this.findComposition(contrib2).log(errs, Severity.ERROR, "VERIFY-88", component.getIdentityConstant().getValueString(), typeContrib.getValueString());
                                                        return;
                                                    }
                                                    if (composition != Component.Composition.Extends || (formatThis = component.getFormat()).isExtendsLegal(formatContrib = typeContrib.getExplicitClassFormat())) break;
                                                    this.findComposition(contrib2).log(errs, Severity.ERROR, "VERIFY-23", new Object[]{component.getIdentityConstant().getValueString(), formatThis, typeContrib.getValueString(), formatContrib});
                                                    return;
                                                }
                                            }
                                        }
                                        if (this.m_fVirtChild) {
                                            for (AstNode parent = this.getParent(); parent != null; parent = parent.getParent()) {
                                                if (!(parent instanceof ComponentStatement) || parent.getStage().isAtLeast(Compiler.Stage.Resolved)) continue;
                                                mgr.requestRevisit();
                                                return;
                                            }
                                        }
                                        if ((format = component.getFormat()) == Component.Format.MODULE) {
                                            component.getConstantPool().buildValidPoolSet();
                                        }
                                        fModuleImport = false;
                                        if (format != Component.Format.PACKAGE) break block82;
                                        for (CompositionNode compositionNode : this.compositions) {
                                            block83: {
                                                ArrayList<Component.Injection> listInject;
                                                SingletonConstant constInjector;
                                                PackageStructure structPkg;
                                                block85: {
                                                    Iterator<Parameter> iterator2;
                                                    ConstantPool pool;
                                                    block86: {
                                                        NamedTypeExpression namedTypeExpression;
                                                        block84: {
                                                            ClassStructure clz;
                                                            Iterator<CompositionNode> id;
                                                            Component component2;
                                                            ModuleStructure moduleStructure;
                                                            if (!(compositionNode instanceof CompositionNode.Import)) continue;
                                                            CompositionNode.Import compImport = (CompositionNode.Import)compositionNode;
                                                            structPkg = (PackageStructure)component;
                                                            ModuleStructure moduleStructure2 = structPkg == null ? null : structPkg.getImportedModule();
                                                            ModuleStructure moduleStructure3 = moduleStructure = moduleStructure2 == null ? null : moduleStructure2.getFingerprintOrigin();
                                                            if (moduleStructure == null) {
                                                                NamedTypeExpression namedTypeExpression2 = (NamedTypeExpression)compImport.type;
                                                                namedTypeExpression2.log(errs, Severity.ERROR, "COMPILER-24", namedTypeExpression2.getName());
                                                            }
                                                            if ((namedTypeExpression = compImport.getInjector()) == null) break block83;
                                                            Constant idInjector = namedTypeExpression.getIdentityConstant();
                                                            if (idInjector.containsUnresolved()) {
                                                                mgr.requestRevisit();
                                                                return;
                                                            }
                                                            if (!idInjector.isClass() || !(idInjector instanceof IdentityConstant) || !((component2 = ((IdentityConstant)((Object)(id = (IdentityConstant)idInjector))).getComponent()) instanceof ClassStructure) || !(clz = (ClassStructure)component2).isSingleton()) break block84;
                                                            pool = this.pool();
                                                            constInjector = pool.ensureSingletonConstConstant((IdentityConstant)((Object)id));
                                                            listInject = null;
                                                            List<Parameter> listParam = compImport.getSpecificInjections();
                                                            if (listParam == null) break block85;
                                                            listInject = new ArrayList<Component.Injection>(listParam.size());
                                                            iterator2 = listParam.iterator();
                                                            break block86;
                                                        }
                                                        namedTypeExpression.log(errs, Severity.ERROR, "COMPILER-192", new Object[0]);
                                                        break;
                                                    }
                                                    while (iterator2.hasNext()) {
                                                        Parameter param = iterator2.next();
                                                        TypeConstant constType = param.getType().ensureTypeConstant();
                                                        String sName = param.getName();
                                                        StringConstant constName = sName == null ? null : pool.ensureStringConstant(sName);
                                                        listInject.add(new Component.Injection(constType, constName));
                                                    }
                                                }
                                                structPkg.setImportedModuleInjector(constInjector, listInject);
                                            }
                                            fModuleImport = true;
                                        }
                                    }
                                    if (!this.m_fVirtChild) break block87;
                                    setContrib = new ListSet<Component.Contribution>();
                                    if (!component.resolveVirtualSuper(setContrib)) {
                                        mgr.requestRevisit();
                                        return;
                                    }
                                    boolean bl2 = false;
                                    fAlreadyLogged = false;
                                    switch (format) {
                                        case INTERFACE: {
                                            if (setContrib.stream().anyMatch(contrib -> contrib.getComposition() == Component.Composition.Extends)) {
                                                this.category.log(errs, this.getSource(), Severity.ERROR, "COMPILER-112", this.name.getValueText());
                                                fAlreadyLogged = true;
                                                break block79;
                                            } else if (setContrib.isEmpty()) {
                                                boolean bl3 = false;
                                                break block79;
                                            } else {
                                                for (CompositionNode compositionNode : this.compositions) {
                                                    TypeConstant typeConstant = compositionNode.getType().ensureTypeConstant();
                                                    if (compositionNode.keyword.getId() != Token.Id.EXTENDS || !setContrib.stream().anyMatch(contrib -> contrib.getTypeConstant().equals(typeConstant))) continue;
                                                    compositionNode.log(errs, Severity.ERROR, "COMPILER-113", this.name.getValueText());
                                                    fAlreadyLogged = true;
                                                    break;
                                                }
                                                boolean bl4 = true;
                                            }
                                            break block79;
                                        }
                                        case CLASS: 
                                        case SERVICE: 
                                        case CONST: 
                                        case ANNOTATION: 
                                        case MIXIN: {
                                            Component.Contribution contribution;
                                            Component.Contribution contribImplicit = null;
                                            for (Component.Contribution contribution2 : setContrib) {
                                                if (contribution2.getComposition() == Component.Composition.Extends) {
                                                    if (contribImplicit != null) {
                                                        this.name.log(errs, this.getSource(), Severity.ERROR, "COMPILER-115", this.name.getValueText());
                                                        fAlreadyLogged = true;
                                                        break;
                                                    }
                                                    contribImplicit = contribution2;
                                                    List<Parameter> list = this.constructorParams;
                                                    if (list == null) continue;
                                                    listArgs = new ArrayList<Expression>(list.size());
                                                    for (Parameter listParam : list) {
                                                        listArgs.add(new NameExpression(this, listParam.name, null));
                                                    }
                                                    this.m_mapContribArgs.put(contribution2, listArgs);
                                                    continue;
                                                }
                                                if (fAlreadyLogged) continue;
                                                this.name.log(errs, this.getSource(), Severity.ERROR, "COMPILER-114", this.name.getValueText());
                                                fAlreadyLogged = true;
                                            }
                                            if ((contribution = component.findContribution(Component.Composition.Extends)) == null) {
                                                if (contribImplicit == null) {
                                                    if (format != Component.Format.ANNOTATION && format != Component.Format.MIXIN) {
                                                        List<Component.Contribution> list = component.getContributionsAsList();
                                                        TypeConstant typeConstant = this.pool().typeObject();
                                                        if (list.isEmpty() || list.stream().noneMatch(contribPrev -> contribPrev.getComposition() == Component.Composition.Implements && contribPrev.getTypeConstant().equals(typeConstant))) {
                                                            component.addContribution(Component.Composition.Implements, typeConstant);
                                                        }
                                                    }
                                                    boolean bl5 = false;
                                                    break block79;
                                                } else {
                                                    boolean bl6 = true;
                                                }
                                                break block79;
                                            } else if (contribImplicit != null) {
                                                if (contribution.equals(contribImplicit)) {
                                                    IdentityConstant identityConstant4 = component.getIdentityConstant();
                                                    IdentityConstant identityConstant5 = contribImplicit.getTypeConstant().getSingleUnderlyingClass(false);
                                                    break;
                                                }
                                                for (CompositionNode compositionNode : this.compositions) {
                                                    if (compositionNode.keyword.getId() != Token.Id.EXTENDS) continue;
                                                    compositionNode.log(errs, Severity.ERROR, "COMPILER-111", this.name.getValueText());
                                                    fAlreadyLogged = true;
                                                    break;
                                                }
                                                boolean bl7 = true;
                                            }
                                            break block79;
                                        }
                                        default: {
                                            throw new IllegalStateException();
                                        }
                                    }
                                    do {
                                        void var13_73;
                                        void var12_49;
                                        identityConstant3 = var12_49.getParentConstant();
                                        identityConstant2 = var13_73.getParentConstant();
                                        if (identityConstant3.getFormat() != identityConstant2.getFormat()) break block80;
                                    } while (!(identityConstant3 instanceof ClassConstant));
                                    ClassStructure clzSuper = ((ClassStructure)identityConstant3.getComponent()).getSuper();
                                    if (clzSuper.getIdentityConstant().equals(identityConstant2)) {
                                        for (CompositionNode composition : this.compositions) {
                                            if (composition.keyword.getId() != Token.Id.EXTENDS) continue;
                                            composition.log(errs, Severity.ERROR, "COMPILER-113", this.name.getValueText());
                                            fAlreadyLogged = true;
                                            break;
                                        }
                                    }
                                }
                                boolean bl8 = false;
                            }
                            if (!fAlreadyLogged) {
                                void var8_19;
                                boolean fHasOverride = false;
                                if (this.annotations != null) {
                                    ClassConstant classConstant = this.pool().clzOverride();
                                    for (AnnotationExpression annotationExpression : this.annotations) {
                                        if (!Handy.equals(classConstant, annotationExpression.toTypeExpression().ensureTypeConstant().getSingleUnderlyingClass(false))) continue;
                                        fHasOverride = true;
                                        if (var8_19 != false) break;
                                        annotationExpression.log(errs, Severity.ERROR, "COMPILER-110", this.name.getValueText());
                                        break;
                                    }
                                }
                                if (var8_19 != false && !fHasOverride) {
                                    this.name.log(errs, this.getSource(), Severity.ERROR, "COMPILER-109", this.name.getValueText());
                                }
                                for (Component.Contribution contribution : setContrib) {
                                    Component.Composition composition = contribution.getComposition();
                                    component.addContribution(composition, contribution.getTypeConstant());
                                    if (composition != Component.Composition.Extends) continue;
                                    this.m_mapContribArgs.putIfAbsent(contribution, null);
                                }
                            }
                        }
                        mgr.processChildren();
                        mapChildren = component.getChildByNameMap();
                        multiMethodStructure = (MultiMethodStructure)mapChildren.get("construct");
                        listParams = this.constructorParams;
                        fExplicitDefault = false;
                        boolean bl9 = false;
                        if (listParams != null && !listParams.isEmpty()) break block88;
                        if (multiMethodStructure == null) break block81;
                        iterator = multiMethodStructure.methods().iterator();
                        break block89;
                    }
                    if (fModuleImport) {
                        listParams.get(0).log(errs, Severity.ERROR, "COMPILER-22", new Object[0]);
                    }
                    identityConstant = component.getIdentityConstant();
                    n = listParams.size();
                    atypeParams = new TypeConstant[n];
                    break block90;
                }
                while (iterator.hasNext()) {
                    MethodStructure methodStructure = iterator.next();
                    if (methodStructure.getParamCount() > methodStructure.getDefaultParamCount()) continue;
                    if (fExplicitDefault) {
                        this.reportAmbiguousConstructor(listParams, TypeConstant.NO_TYPES, errs);
                        break block81;
                    }
                    fExplicitDefault = true;
                }
                break block81;
            }
            for (int i = 0; i < n; ++i) {
                PropertyConstant idFormal;
                Parameter param = listParams.get(i);
                TypeConstant typeParam = param.getType().ensureTypeConstant();
                if (typeParam.containsUnresolved()) {
                    mgr.requestRevisit();
                    return;
                }
                String sParam = param.getName();
                PropertyStructure prop = (PropertyStructure)mapChildren.get(sParam);
                assert (prop != null);
                if (prop.getType().containsUnresolved()) {
                    mgr.requestRevisit();
                    return;
                }
                if (component.isStatic() && typeParam.isGenericType() && !(idFormal = (PropertyConstant)typeParam.getDefiningConstant()).getParentConstant().equals(identityConstant)) {
                    param.log(errs, Severity.ERROR, "COMPILER-179", idFormal.getName(), component.getName());
                }
                atypeParams[i] = typeParam;
            }
            if (multiMethodStructure != null) {
                block22: for (MethodStructure constructor : multiMethodStructure.methods()) {
                    org.xvm.asm.Parameter[] aConsParams = constructor.getParamArray();
                    int cConsParams = aConsParams.length;
                    if (n > cConsParams || n < cConsParams - constructor.getDefaultParamCount()) continue;
                    for (int i = 0; i < n; ++i) {
                        TypeConstant typeConsParam = aConsParams[i].getType();
                        if (typeConsParam.containsUnresolved()) {
                            mgr.requestRevisit();
                            return;
                        }
                        if (!atypeParams[i].equals(typeConsParam)) continue block22;
                    }
                    if (bl) {
                        this.reportAmbiguousConstructor(listParams, atypeParams, errs);
                        break;
                    }
                    constructor.markAsShorthand();
                    bl = true;
                }
            }
            if (!bl) {
                ConstantPool pool = this.pool();
                org.xvm.asm.Parameter[] aParams = new org.xvm.asm.Parameter[n];
                for (int i = 0; i < n; ++i) {
                    Parameter param = listParams.get(i);
                    aParams[i] = new org.xvm.asm.Parameter(pool, atypeParams[i], param.getName(), null, false, i, false);
                    if (param.value == null) continue;
                    aParams[i].markDefaultValue();
                }
                MethodStructure constructor = component.createMethod(true, Constants.Access.PUBLIC, Annotation.NO_ANNOTATIONS, org.xvm.asm.Parameter.NO_PARAMS, "construct", aParams, true, false);
                constructor.setSynthetic(true);
                constructor.markAsShorthand();
                MultiMethodStructure multiMethodStructure2 = (MultiMethodStructure)constructor.getParent();
            }
        }
        if (fExplicitDefault || bl) {
            for (CompositionNode compositionNode : this.compositions) {
                List<Expression> list;
                if (compositionNode instanceof CompositionNode.Extends) {
                    CompositionNode.Extends nodeExtends = (CompositionNode.Extends)compositionNode;
                    list = nodeExtends.args;
                } else if (compositionNode instanceof CompositionNode.Incorporates) {
                    CompositionNode.Incorporates nodeIncorp = (CompositionNode.Incorporates)compositionNode;
                    list = nodeIncorp.args;
                } else {
                    list = null;
                }
                if ((listArgs = list) == null || listArgs.isEmpty()) continue;
                compositionNode.log(errs, Severity.ERROR, "COMPILER-188", new Object[0]);
            }
        }
        if (format != Component.Format.INTERFACE && !mapChildren.containsKey("construct")) {
            MethodStructure methodStructure = component.createMethod(true, Constants.Access.PUBLIC, Annotation.NO_ANNOTATIONS, org.xvm.asm.Parameter.NO_PARAMS, "construct", org.xvm.asm.Parameter.NO_PARAMS, true, false);
            methodStructure.setSynthetic(true);
            methodStructure.markAsShorthand();
        } else if (component.isSingleton()) {
            boolean bl10;
            void var8_22;
            boolean bl11 = false;
            block26: for (MethodStructure constructor : var8_22.methods()) {
                for (org.xvm.asm.Parameter param : constructor.getParamArray()) {
                    if (!param.hasDefaultValue()) continue block26;
                }
                bl10 = true;
                break;
            }
            if (!bl10) {
                this.name.log(errs, this.getSource(), Severity.ERROR, "COMPILER-62", component.getName());
            }
        }
        if (component.isParameterized()) {
            this.addImplicitTypeConstraints(component, errs);
        } else if (format == Component.Format.MIXIN || format == Component.Format.ANNOTATION) {
            errs = errs.branch(this);
            component.addImplicitTypeParameters(this.pool(), errs);
            errs.merge();
        }
        if (format == Component.Format.CONST) {
            component.synthesizeConstInterface(false);
        }
    }

    @Override
    public void validateContent(StageMgr mgr, ErrorListener errs) {
        SingletonConstant constInjector;
        PackageStructure pkg;
        if (!mgr.processChildren()) {
            mgr.requestRevisit();
            return;
        }
        ConstantPool pool = this.pool();
        ClassStructure component = (ClassStructure)this.getComponent();
        if (component instanceof PackageStructure && (pkg = (PackageStructure)component).isModuleImport() && (constInjector = pkg.getModuleInjector()) != null) {
            if (!constInjector.getType().isA(pool.ensureEcstasyTypeConstant("mgmt.ResourceProvider"))) {
                this.log(errs, Severity.ERROR, "COMPILER-193", new Object[0]);
                return;
            }
            ErrorListener errsTemp = errs.branch(this);
            TypeInfo infoInjector = constInjector.getType().ensureTypeInfo(errsTemp);
            if (!infoInjector.isNewable(true, errsTemp)) {
                String sTarget = infoInjector.getType().removeAccess().getValueString();
                infoInjector.reportNotNewable(sTarget, null, true, errsTemp);
                errsTemp.merge();
                return;
            }
        }
        ClassStructure clzSuper = component.getSuper();
        boolean fAllowOverride = true;
        List<Parameter> listParams = this.constructorParams;
        switch (component.getFormat()) {
            case INTERFACE: {
                clzSuper = null;
                break;
            }
            case ENUM: {
                clzSuper = (ClassStructure)pool.clzEnum().getComponent();
                fAllowOverride = false;
                break;
            }
            case SERVICE: {
                if (clzSuper != null) break;
                clzSuper = (ClassStructure)pool.clzService().getComponent();
            }
        }
        if (clzSuper != null && listParams != null) {
            TypeConstant typeSuper = pool.ensureAccessTypeConstant(clzSuper.getFormalType(), Constants.Access.PROTECTED);
            TypeInfo infoSuper = typeSuper.ensureTypeInfo(errs);
            Map<String, Component> mapChildren = component.getChildByNameMap();
            boolean fInvalidate = false;
            for (Parameter param : listParams) {
                PropertyInfo infoProp;
                String sProp = param.getName();
                PropertyStructure prop = (PropertyStructure)mapChildren.get(sProp);
                if (!prop.isSynthetic() || (infoProp = infoSuper.findProperty(sProp)) == null) continue;
                if (!fAllowOverride) {
                    param.log(errs, Severity.ERROR, "COMPILER-189", sProp);
                }
                if (!infoProp.isVar() && !infoProp.isAbstract()) {
                    prop.addAnnotation(pool.clzOverride(), new Constant[0]);
                    prop.addAnnotation(pool.clzRO(), new Constant[0]);
                    fInvalidate = true;
                }
                TypeConstant typeThis = prop.getType().resolveTypedefs();
                TypeConstant typeBase = infoProp.getType().removeAccess().resolveGenerics(pool, typeThis);
                if (typeBase.isA(typeThis) && typeThis.isA(typeBase)) continue;
                param.log(errs, Severity.ERROR, "COMPILER-190", sProp, clzSuper.getName());
            }
            if (fInvalidate) {
                pool.invalidateTypeInfos(component.getIdentityConstant());
            }
        }
        TypeConstant typeThis = component.getFormalType();
        TypeConstant typeClass = pool.ensureParameterizedTypeConstant(pool.typeClass(), component.getIdentityConstant().getType());
        TypeInfo info = this.ensureTypeInfo(typeThis.ensureAccess(Constants.Access.PRIVATE), errs);
        if (info.hasErrors() && !errs.hasSeriousErrors()) {
            typeThis.invalidateTypeInfo();
            this.ensureTypeInfo(typeThis, errs);
        }
        if (this.validateAnnotations(component.collectAnnotations(false), typeThis, errs) && this.validateAnnotations(component.collectAnnotations(true), typeClass, errs) && component.isParameterized()) {
            this.resolveAnnotationTypes(component, errs);
        }
    }

    private boolean validateAnnotations(Annotation[] aAnno, TypeConstant typeTarget, ErrorListener errs) {
        int c = aAnno.length;
        for (int i = 0; i < c; ++i) {
            Annotation anno = aAnno[i];
            TypeConstant typeAnno = anno.getAnnotationType();
            if (typeAnno.getExplicitClassFormat() != Component.Format.ANNOTATION) {
                this.findAnnotationExpression(anno, this.annotations).log(errs, Severity.ERROR, "VERIFY-27", anno.getValueString());
                return false;
            }
            TypeConstant typeInto = typeAnno.getExplicitClassInto(true);
            if (!typeTarget.isA(typeInto)) {
                this.findAnnotationExpression(anno, this.annotations).log(errs, Severity.ERROR, "VERIFY-32", typeTarget.getValueString(), typeAnno.getValueString(), typeInto.getValueString());
                return false;
            }
            for (int j = i + 1; j < c; ++j) {
                Annotation anno2 = aAnno[j];
                TypeConstant typeAnno2 = anno2.getAnnotationType();
                if (!typeAnno2.equals(typeAnno)) continue;
                this.findAnnotationExpression(anno, this.annotations).log(errs, Severity.ERROR, "VERIFY-28", anno.getValueString());
                return false;
            }
        }
        return true;
    }

    private void resolveAnnotationTypes(ClassStructure component, ErrorListener errs) {
        block3: for (Component.Contribution contrib : component.getContributionsAsList()) {
            switch (contrib.getComposition()) {
                case Annotation: {
                    break;
                }
                default: {
                    continue block3;
                }
            }
            TypeConstant typeAnno = contrib.getTypeConstant();
            if (typeAnno.isParamsSpecified()) continue;
            if (typeAnno.isSingleUnderlyingClass(false)) {
                ClassStructure clzAnno = (ClassStructure)typeAnno.getSingleUnderlyingClass(true).getComponent();
                contrib.narrowType(clzAnno.getFormalType().resolveGenerics(this.pool(), component.getFormalType()));
                continue;
            }
            this.log(errs, Severity.ERROR, "VERIFY-07", typeAnno.getValueString());
        }
    }

    private Map<String, TypeConstant> findImplicitConstraint(ClassStructure clz, String sName, Map<String, TypeConstant> mapConstraints, Boolean fAllowInto, ErrorListener errs) {
        ConstantPool pool = this.pool();
        block5: for (Component.Contribution contrib : clz.getContributionsAsList()) {
            TypeConstant typeContrib;
            switch (contrib.getComposition()) {
                case Into: {
                    if (fAllowInto.booleanValue()) break;
                    continue block5;
                }
                case Incorporates: {
                    fAllowInto = false;
                    break;
                }
                case Implements: 
                case Extends: {
                    break;
                }
                default: {
                    continue block5;
                }
            }
            if (!(typeContrib = contrib.getTypeConstant()).isExplicitClassIdentity(true) || contrib.getTypeParams() != null) continue;
            ClassStructure clzContrib = (ClassStructure)typeContrib.getSingleUnderlyingClass(true).getComponent();
            if (typeContrib.isParameterizedDeep()) {
                TypeConstant typeConstraint = clzContrib.getTypeParams().get(pool.ensureStringConstant(sName));
                if (typeConstraint == null) continue;
                if (typeConstraint.equals(pool.typeObject())) {
                    mapConstraints = this.findImplicitConstraint(clzContrib, sName, mapConstraints, fAllowInto, ErrorListener.BLACKHOLE);
                    continue;
                }
                if (mapConstraints == null) {
                    mapConstraints = new ListMap<String, TypeConstant>();
                } else {
                    TypeConstant typePrev = mapConstraints.get(sName);
                    if (typePrev != null) {
                        typeConstraint = typePrev.combine(pool, typeConstraint);
                    }
                }
                mapConstraints.put(sName, typeConstraint);
                return mapConstraints;
            }
            if (!clzContrib.isParameterizedDeep()) continue;
            this.log(errs, Severity.ERROR, "COMPILER-54", typeContrib.getValueString());
        }
        return mapConstraints;
    }

    @Override
    protected Statement validateImpl(Context ctx, ErrorListener errs) {
        return this;
    }

    @Override
    protected boolean emit(Context ctx, boolean fReachable, MethodStructure.Code code, ErrorListener errs) {
        return true;
    }

    @Override
    public void generateCode(StageMgr mgr, ErrorListener errs) {
        MethodStructure constructor;
        if (!mgr.processChildren()) {
            mgr.requestRevisit();
            return;
        }
        ClassStructure component = (ClassStructure)this.getComponent();
        if (component.getFormat() != Component.Format.INTERFACE && (constructor = component.findMethod("construct", MethodStructure::isShorthandConstructor)) != null && constructor.isSynthetic() && !constructor.hasOps()) {
            StatementBlock.RootContext ctxConstruct = this.createConstructorContext(constructor);
            Context ctx = ctxConstruct.validatingContext();
            if (this.constructorParams != null && !this.constructorParams.isEmpty() && !this.validateDefaultParameters(ctx, constructor, errs)) {
                return;
            }
            ConstantPool pool = this.pool();
            List listContribs = null;
            List listTypes = null;
            List listIds = null;
            List listArgLists = null;
            for (Map.Entry<Component.Contribution, List<Expression>> entry : this.m_mapContribArgs.entrySet()) {
                TypeConstant typeSuper;
                Component.Contribution contrib = entry.getKey();
                List<Expression> listSuperArgs = switch (contrib.getComposition()) {
                    case Component.Composition.Extends -> {
                        typeSuper = pool.ensureAccessTypeConstant(contrib.getTypeConstant(), Constants.Access.PROTECTED);
                        if (this.args == null) {
                            yield entry.getValue();
                        }
                        yield this.args;
                    }
                    case Component.Composition.Incorporates -> {
                        if (!$assertionsDisabled && this.args != null) {
                            throw new AssertionError();
                        }
                        typeSuper = (contrib.isConditional() ? this.resolveConditionalMixin(ctx, contrib) : contrib.getTypeConstant()).adjustAccess(component.getIdentityConstant());
                        yield entry.getValue();
                    }
                    default -> {
                        typeSuper = null;
                        yield null;
                    }
                };
                if (typeSuper == null) continue;
                MethodConstant idSuper = this.findSuperConstructor(ctx, typeSuper, listSuperArgs, errs);
                if (idSuper == null) {
                    return;
                }
                MethodStructure constructSuper = typeSuper.ensureTypeInfo().getMethodById(idSuper).getHead().getMethodStructure();
                assert (constructSuper != null);
                if ((listSuperArgs = this.validateSuperParameters(ctx, constructor, idSuper, constructSuper, listSuperArgs, errs)) == null) {
                    return;
                }
                idSuper = constructSuper.getIdentityConstant();
                listContribs = this.ensureList(listContribs);
                listContribs.add(contrib);
                listTypes = this.ensureList(listTypes);
                listTypes.add(typeSuper);
                listIds = this.ensureList(listIds);
                listIds.add(idSuper);
                listArgLists = this.ensureList(listArgLists);
                listArgLists.add(listSuperArgs);
            }
            this.generateConstructor(ctxConstruct, constructor, listContribs, listTypes, listIds, listArgLists, errs);
        }
        if (this.compositions == null) {
            return;
        }
        for (CompositionNode composition : this.compositions) {
            if (!(composition instanceof CompositionNode.Delegates)) continue;
            CompositionNode.Delegates compDelegate = (CompositionNode.Delegates)composition;
            String sProp = compDelegate.getPropertyName();
            TypeConstant typePri = this.pool().ensureAccessTypeConstant(component.getFormalType(), Constants.Access.PRIVATE);
            TypeInfo infoThis = typePri.ensureTypeInfo(errs);
            PropertyInfo infoProp = infoThis.findProperty(sProp);
            if (infoProp == null) {
                composition.log(errs, Severity.ERROR, "COMPILER-131", sProp);
                return;
            }
            TypeConstant typeDelegate = composition.getType().ensureTypeConstant();
            TypeConstant typeProp = infoProp.getType();
            if (typeProp.isA(typeDelegate)) continue;
            composition.log(errs, Severity.ERROR, "COMPILER-132", sProp, typeDelegate.getValueString(), typeProp.getValueString());
            return;
        }
    }

    private StatementBlock.RootContext createConstructorContext(MethodStructure constructor) {
        StatementBlock blockBody = this.body;
        if (this.body == null) {
            blockBody = this.adopt(new StatementBlock(Collections.emptyList()));
        }
        return new StatementBlock.RootContext(blockBody, constructor);
    }

    private boolean validateDefaultParameters(Context ctx, MethodStructure constructor, ErrorListener errs) {
        boolean fValid = true;
        List<Parameter> listParams = this.constructorParams;
        int cParams = listParams.size();
        for (int i = 0; i < cParams; ++i) {
            org.xvm.asm.Parameter param = constructor.getParam(i);
            if (!param.hasDefaultValue()) continue;
            TypeConstant typeParam = param.getType();
            Expression exprOld = listParams.get((int)i).value;
            assert (exprOld != null);
            if (exprOld.isValidated()) continue;
            ctx = ctx.enterInferring(typeParam);
            Expression exprNew = exprOld.validate(ctx, typeParam, errs);
            ctx = ctx.exit();
            if (exprNew == null) {
                fValid = false;
                continue;
            }
            if (exprNew.isConstant()) {
                param.setDefaultValue(exprNew.toConstant());
                continue;
            }
            exprOld.log(errs, Severity.ERROR, "COMPILER-47", new Object[0]);
            fValid = false;
        }
        return fValid;
    }

    private <T> List<T> ensureList(List<T> list) {
        return list == null ? new ArrayList() : list;
    }

    private TypeConstant resolveConditionalMixin(Context ctx, Component.Contribution contrib) {
        Map<StringConstant, TypeConstant> mapConstraints = contrib.getTypeParams();
        assert (mapConstraints != null);
        TypeConstant typeContrib = contrib.getTypeConstant();
        if (typeContrib instanceof ParameterizedTypeConstant) {
            typeContrib = typeContrib.getUnderlyingType();
        }
        assert (typeContrib.isSingleUnderlyingClass(false));
        ClassStructure clzContrib = (ClassStructure)typeContrib.getSingleUnderlyingClass(false).getComponent();
        ConstantPool pool = this.pool();
        TypeInfo infoThis = ctx.getThisClass().getFormalType().ensureTypeInfo();
        TypeConstant[] atypeResolved = new TypeConstant[clzContrib.getTypeParamCount()];
        int ix = 0;
        for (Map.Entry<StringConstant, TypeConstant> entry : mapConstraints.entrySet()) {
            StringConstant constName = entry.getKey();
            TypeConstant typeConstraint = entry.getValue();
            PropertyInfo infoFormal = infoThis.findProperty(constName.getValue());
            if (infoFormal == null) {
                atypeResolved[ix++] = typeConstraint == null ? pool.typeObject() : typeConstraint;
                continue;
            }
            typeConstraint = typeConstraint == null ? infoFormal.getConstraintType() : typeConstraint.combine(pool, infoFormal.getConstraintType());
            atypeResolved[ix++] = typeConstraint;
            ctx.replaceGenericType(infoFormal.getIdentity(), Context.Branch.Always, typeConstraint.getType());
        }
        return pool.ensureParameterizedTypeConstant(typeContrib, atypeResolved);
    }

    private MethodConstant findSuperConstructor(Context ctx, TypeConstant typeSuper, List<Expression> listSuperArgs, ErrorListener errs) {
        TypeInfo infoSuper = typeSuper.ensureTypeInfo(errs);
        MethodConstant idSuper = this.findMethod(ctx, typeSuper, infoSuper, "construct", listSuperArgs, TypeInfo.MethodKind.Constructor, true, false, null, errs);
        if (idSuper == null) {
            this.log(errs, Severity.ERROR, "COMPILER-103", this.getComponent().getIdentityConstant().getValueString(), typeSuper.getValueString());
            return null;
        }
        return idSuper;
    }

    private List<Expression> validateSuperParameters(Context ctx, MethodStructure constructor, MethodConstant idSuper, MethodStructure constructSuper, List<Expression> listSuperArgs, ErrorListener errs) {
        Constant[] aconstSuper = null;
        if (listSuperArgs != null && !listSuperArgs.isEmpty()) {
            if (this.containsNamedArgs(listSuperArgs) && (listSuperArgs = this.rearrangeNamedArgs(constructSuper, listSuperArgs, errs)) == null) {
                return null;
            }
            boolean fValid = true;
            TypeConstant[] atypeArgs = idSuper.getRawParams();
            int c = listSuperArgs.size();
            for (int i = 0; i < c; ++i) {
                Constant constant;
                Expression exprOld = listSuperArgs.get(i);
                if (exprOld.isValidated()) continue;
                Expression exprNew = exprOld.validate(ctx, atypeArgs[i], errs);
                if (exprNew == null) {
                    fValid = false;
                    continue;
                }
                if (exprNew != exprOld) {
                    listSuperArgs.set(i, exprNew);
                }
                if ((constant = exprNew.toConstant()) == null || constant instanceof RegisterConstant) continue;
                if (aconstSuper == null) {
                    aconstSuper = new Constant[c];
                }
                aconstSuper[i] = constant;
            }
            if (!fValid) {
                return null;
            }
        }
        if (this.getComponent().getFormat() == Component.Format.ANNOTATION) {
            constructor.setShorthandInitialization(idSuper, aconstSuper);
        }
        return listSuperArgs == null ? Collections.EMPTY_LIST : listSuperArgs;
    }

    private void disallowTypeParams(ErrorListener errs) {
        List<Parameter> listParams = this.typeParams;
        if (listParams != null && !listParams.isEmpty()) {
            listParams.get(0).log(errs, Severity.ERROR, "COMPILER-12", new Object[0]);
        }
    }

    private void requireConstructorParamValues(ErrorListener errs) {
        List<Parameter> listParams = this.constructorParams;
        if (listParams != null && !listParams.isEmpty()) {
            for (Parameter param : listParams) {
                if (param.value != null) continue;
                param.log(errs, Severity.ERROR, "COMPILER-14", new Object[0]);
            }
        }
    }

    private AstNode findComposition(Component.Contribution contrib) {
        for (CompositionNode composition : this.compositions) {
            if (composition.getContribution() != contrib) continue;
            return composition;
        }
        return this;
    }

    private void generateConstructor(StatementBlock.RootContext ctxConstruct, MethodStructure constructor, List<Component.Contribution> listContribs, List<TypeConstant> listTypes, List<MethodConstant> listIds, List<List<Expression>> listArgLists, ErrorListener errs) {
        ConstantPool pool = this.pool();
        ClassStructure component = (ClassStructure)this.getComponent();
        MethodStructure.Code code = constructor.ensureCode();
        StatementBlock.RootContext ctxEmit = ctxConstruct.emittingContext(code);
        ArrayList<BinaryAST> listAsts = new ArrayList<BinaryAST>();
        if (this.args == null) {
            int cParams = constructor.getParamCount();
            for (int iParam = 0; iParam < cParams; ++iParam) {
                org.xvm.asm.Parameter param = constructor.getParam(iParam);
                String sParam = param.getName();
                boolean fSuper = false;
                if (listTypes != null) {
                    for (TypeConstant typeSuper : listTypes) {
                        PropertyInfo propSuper = typeSuper.ensureTypeInfo(errs).findProperty(sParam);
                        if (propSuper == null || propSuper.isAbstract()) continue;
                        fSuper = true;
                        break;
                    }
                }
                if (fSuper) continue;
                TypeInfo infoThis = pool.ensureAccessTypeConstant(component.getFormalType(), Constants.Access.STRUCT).ensureTypeInfo(errs);
                PropertyInfo propThis = infoThis.findProperty(sParam);
                if (propThis == null || !propThis.isVar()) {
                    this.constructorParams.get(iParam).log(errs, Severity.ERROR, "COMPILER-101", sParam);
                    continue;
                }
                TypeConstant typeProp = propThis.getType();
                TypeConstant typeVal = param.getType();
                if (param.getType().isA(typeProp)) {
                    PropertyConstant idProp = propThis.getIdentity();
                    Argument arg = ctxEmit.getVar(sParam);
                    code.add(new L_Set(idProp, arg));
                    ExprAST regThis = ctxConstruct.getThisRegisterAST();
                    listAsts.add(new AssignAST(new PropertyExprAST(regThis, idProp), AssignAST.Operator.Asn, TypeCompositionStatement.toExprAst(arg)));
                    continue;
                }
                this.constructorParams.get(iParam).log(errs, Severity.ERROR, "COMPILER-102", sParam, typeVal.getValueString(), typeProp.getValueString());
            }
        }
        if (listContribs == null) {
            if (constructor.isAnonymousClassWrapperConstructor()) {
                code.add(new SynInit());
                listAsts.add(InitAST.INSTANCE);
            }
        } else {
            int cSupers = listContribs.size();
            for (int iSuper = 0; iSuper < cSupers; ++iSuper) {
                MethodConstant idSuper = listIds.get(iSuper);
                MethodStructure constructSuper = (MethodStructure)idSuper.getComponent();
                if (constructSuper.isNoOp() && constructor.getIdentityConstant().getModuleConstant().equals(constructSuper.getIdentityConstant().getModuleConstant())) continue;
                Component.Contribution contrib = listContribs.get(iSuper);
                List<Expression> listSuperArgs = listArgLists.get(iSuper);
                int cSuperArgs = constructSuper.getParamCount();
                Argument[] aSuperArgs = new Argument[cSuperArgs];
                int cArgs = listSuperArgs == null ? 0 : listSuperArgs.size();
                Label labelSkipSuper = null;
                BiExprAST astCond = null;
                if (contrib.getComposition() == Component.Composition.Extends) {
                    if (constructor.isAnonymousClassWrapperConstructor() && !constructSuper.isAnonymousClassWrapperConstructor()) {
                        code.add(new SynInit());
                        listAsts.add(InitAST.INSTANCE);
                    }
                } else {
                    Map<StringConstant, TypeConstant> mapConstraints = contrib.getTypeParams();
                    if (mapConstraints != null) {
                        labelSkipSuper = new Label("skip_super");
                        TypeInfo infoThis = component.getFormalType().ensureTypeInfo(errs);
                        for (Map.Entry<StringConstant, TypeConstant> entry : mapConstraints.entrySet()) {
                            PropertyInfo propFormal = infoThis.findProperty(entry.getKey().getValue());
                            assert (propFormal != null && propFormal.isFormalType());
                            TypeConstant typeConstraint = entry.getValue().getType();
                            PropertyConstant idFormal = propFormal.getIdentity();
                            Register regActualType = new Register(typeConstraint, null, -1);
                            code.add(new L_Get(idFormal, regActualType));
                            code.add(new JumpNType(regActualType, typeConstraint, labelSkipSuper));
                            PropertyExprAST astFormal = new PropertyExprAST(ctxConstruct.getThisRegisterAST(), idFormal);
                            IsExprAST astIs = new IsExprAST((ExprAST)astFormal, new ConstantExprAST(typeConstraint), null);
                            astCond = astCond == null ? astIs : new CondOpExprAST(astCond, BiExprAST.Operator.CondAnd, astIs);
                        }
                    }
                }
                ExprAST[] aAstArgs = new ExprAST[cSuperArgs];
                for (int i = 0; i < cSuperArgs; ++i) {
                    if (i < cArgs) {
                        Expression exprArg = listSuperArgs.get(i);
                        aSuperArgs[i] = exprArg.generateArgument(ctxEmit, code, true, true, errs);
                        aAstArgs[i] = exprArg.getExprAST(ctxEmit);
                        continue;
                    }
                    org.xvm.asm.Parameter param = constructSuper.getParam(i);
                    assert (param.hasDefaultValue());
                    aSuperArgs[i] = Register.DEFAULT;
                    aAstArgs[i] = RegisterAST.defaultReg(param.getType());
                }
                switch (cSuperArgs) {
                    case 0: {
                        code.add(new Construct_0(idSuper));
                        break;
                    }
                    case 1: {
                        code.add(new Construct_1(idSuper, aSuperArgs[0]));
                        break;
                    }
                    default: {
                        code.add(new Construct_N(idSuper, aSuperArgs));
                    }
                }
                if (labelSkipSuper != null) {
                    code.add(labelSkipSuper);
                }
                CallExprAST astCallSuper = new CallExprAST(new ConstantExprAST(idSuper), TypeConstant.NO_TYPES, aAstArgs, false);
                listAsts.add(astCond == null ? astCallSuper : new IfStmtAST(astCond, astCallSuper, null));
            }
        }
        code.add(new Return_0());
        constructor.setAst(new StmtBlockAST(listAsts.toArray(BinaryAST.NO_ASTS), false), ctxConstruct.collectParameters());
    }

    /*
     * Enabled aggressive block sorting
     */
    public static String extractDocumentation(Token token) {
        if (token == null) {
            return null;
        }
        String sDoc = (String)token.getValue();
        if (sDoc == null || sDoc.length() <= 1 || sDoc.charAt(0) != '*') {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        int nState = 0;
        block6: for (char ch : sDoc.substring(1).toCharArray()) {
            switch (nState) {
                case 0: {
                    if (!Lexer.isLineTerminator(ch)) {
                        if (Lexer.isWhitespace(ch)) continue block6;
                        if (ch != '*') break;
                        nState = 1;
                        continue block6;
                    }
                }
                case 1: {
                    if (!Lexer.isLineTerminator(ch)) {
                        if (!Lexer.isWhitespace(ch)) break;
                        nState = 2;
                        continue block6;
                    }
                }
                case 2: {
                    if (!Lexer.isLineTerminator(ch)) break;
                    if (!sb.isEmpty()) {
                        sb.append('\n');
                    }
                    nState = ch == '\r' ? 3 : 0;
                    continue block6;
                }
                case 3: {
                    if (ch == '\n' || Lexer.isWhitespace(ch)) {
                        nState = 0;
                        continue block6;
                    }
                    if (ch != '*') break;
                    nState = 1;
                    continue block6;
                }
            }
            nState = 2;
            sb.append(ch);
        }
        int cch = sb.length();
        while (cch > 0 && Lexer.isWhitespace(sb.charAt(--cch))) {
            sb.setLength(cch);
        }
        return sb.toString();
    }

    public String toSignatureString() {
        StringBuilder sb = new StringBuilder();
        if (this.category.getId() == Token.Id.ENUM_VAL) {
            if (this.annotations != null) {
                for (AnnotationExpression annotationExpression : this.annotations) {
                    sb.append(annotationExpression).append(' ');
                }
            }
            sb.append(this.name.getValue());
            if (this.typeParams != null) {
                sb.append('<');
                boolean first = true;
                for (TypeExpression typeParam : this.typeArgs) {
                    if (first) {
                        first = false;
                    } else {
                        sb.append(", ");
                    }
                    sb.append(typeParam);
                }
                sb.append('>');
            }
            if (this.args != null) {
                sb.append('(');
                boolean first = true;
                for (Expression arg : this.args) {
                    if (first) {
                        first = false;
                    } else {
                        sb.append(", ");
                    }
                    sb.append(arg);
                }
                sb.append(')');
            }
        } else {
            if (this.modifiers != null) {
                for (Token token : this.modifiers) {
                    sb.append(token.getId().TEXT).append(' ');
                }
            }
            if (this.annotations != null) {
                for (AnnotationExpression annotationExpression : this.annotations) {
                    sb.append(annotationExpression).append(' ');
                }
            }
            sb.append(this.category.getId().TEXT).append(' ');
            if (this.qualified == null) {
                sb.append(this.name.getValue());
            } else {
                boolean first = true;
                for (Token token : this.qualified) {
                    if (first) {
                        first = false;
                    } else {
                        sb.append('.');
                    }
                    sb.append(token.getValue());
                }
            }
            if (this.typeParams != null) {
                sb.append('<');
                boolean first = true;
                for (Parameter param : this.typeParams) {
                    if (first) {
                        first = false;
                    } else {
                        sb.append(", ");
                    }
                    sb.append(param.toTypeParamString());
                }
                sb.append('>');
            }
            if (this.constructorParams != null) {
                sb.append('(');
                boolean first = true;
                for (Parameter param : this.constructorParams) {
                    if (first) {
                        first = false;
                    } else {
                        sb.append(", ");
                    }
                    sb.append(param);
                }
                sb.append(')');
            }
        }
        return sb.toString();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.doc != null) {
            Object sDoc = String.valueOf(this.doc.getValue());
            if (((String)sDoc).length() > 100) {
                sDoc = ((String)sDoc).substring(0, 97) + "...";
            }
            Handy.appendString(sb.append("/*"), (String)sDoc).append("*/\n");
        }
        sb.append(this.toSignatureString());
        if (this.category.getId() == Token.Id.ENUM_VAL) {
            if (this.body != null) {
                sb.append('\n').append(Handy.indentLines(this.body.toString(), "    "));
            }
        } else {
            for (CompositionNode composition : this.compositions) {
                sb.append("\n        ").append(composition);
            }
            if (this.body == null) {
                sb.append(';');
            } else {
                String sBody = this.body.toString();
                if (sBody.indexOf(10) >= 0) {
                    sb.append('\n').append(Handy.indentLines(sBody, "    "));
                } else {
                    sb.append(' ').append(sBody);
                }
            }
        }
        return sb.toString();
    }

    @Override
    public String getDumpDesc() {
        return this.toSignatureString();
    }

    public static enum Zone {
        TopLevel,
        InClass,
        InMethod,
        InProperty;

        private static final Zone[] ZONES;

        public static Zone valueOf(int i) {
            return ZONES[i];
        }

        static {
            ZONES = Zone.values();
        }
    }
}

