/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.compiler.ast;

import org.xvm.asm.Constant;
import org.xvm.asm.ErrorListener;
import org.xvm.asm.ast.ConstantExprAST;
import org.xvm.asm.ast.ExprAST;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.compiler.ast.AnonInnerClass;
import org.xvm.compiler.ast.AstNode;
import org.xvm.compiler.ast.Context;
import org.xvm.compiler.ast.Expression;
import org.xvm.compiler.ast.StageMgr;
import org.xvm.util.Severity;

public abstract class TypeExpression
extends Expression {
    private TypeConstant m_constType;
    private Context m_ctxPrev;

    @Override
    public TypeExpression toTypeExpression() {
        return this;
    }

    public TypeConstant ensureTypeConstant() {
        return this.ensureTypeConstant(null, null);
    }

    public TypeConstant ensureTypeConstant(Context ctx, ErrorListener errs) {
        TypeConstant constType = this.m_constType;
        if (constType != null && ctx != null && ctx != this.m_ctxPrev) {
            constType = null;
            this.m_ctxPrev = ctx;
        }
        if (constType == null) {
            constType = this.isValidated() ? this.getType().getParamType(0) : this.instantiateTypeConstant(ctx, errs == null ? ErrorListener.BLACKHOLE : errs);
            this.m_constType = constType;
        }
        return constType;
    }

    protected abstract TypeConstant instantiateTypeConstant(Context var1, ErrorListener var2);

    protected TypeConstant getTypeConstant() {
        return this.m_constType;
    }

    protected void setTypeConstant(TypeConstant constType) {
        this.resetTypeConstant();
        this.m_constType = constType;
    }

    protected void resetTypeConstant() {
        this.m_constType = null;
        AstNode parent = this.getParent();
        if (parent instanceof TypeExpression) {
            TypeExpression exprType = (TypeExpression)parent;
            exprType.resetTypeConstant();
        }
    }

    public boolean isIntroductoryType() {
        return false;
    }

    public boolean isDynamic() {
        return false;
    }

    public TypeExpression unwrapIntroductoryType() {
        assert (!this.isIntroductoryType());
        return null;
    }

    public void replaceIntroducedType(TypeExpression type) {
        assert (!this.isIntroductoryType());
        throw new IllegalStateException();
    }

    public final AnonInnerClass inferAnonInnerClass(ErrorListener errs) {
        AnonInnerClass info = new AnonInnerClass(this, errs);
        this.collectAnonInnerClassInfo(info);
        return info;
    }

    protected void collectAnonInnerClassInfo(AnonInnerClass info) {
        this.log(info.getErrorListener(true), Severity.ERROR, "COMPILER-96", new Object[0]);
    }

    @Override
    public void resolveNames(StageMgr mgr, ErrorListener errs) {
        if (mgr.processChildren()) {
            this.ensureTypeConstant();
        } else {
            mgr.requestRevisit();
        }
    }

    @Override
    public TypeConstant getImplicitType(Context ctx) {
        TypeConstant type = this.ensureTypeConstant(ctx, null);
        if (type == null) {
            throw new IllegalStateException("type has not yet been determined for this: " + String.valueOf(this));
        }
        return type.getType();
    }

    @Override
    protected Expression.TypeFit calcFit(Context ctx, TypeConstant typeIn, TypeConstant typeOut) {
        return typeIn.isTypeOfType() && (typeOut == null || typeOut.isTypeOfType()) ? super.calcFit(ctx, TypeExpression.getSafeDataType(typeIn), TypeExpression.getSafeDataType(typeOut)) : super.calcFit(ctx, typeIn, typeOut);
    }

    @Override
    protected Expression validate(Context ctx, TypeConstant typeRequired, ErrorListener errs) {
        TypeConstant typeInferred;
        TypeConstant type = this.ensureTypeConstant(ctx, errs);
        if (typeRequired != null && (typeInferred = super.inferTypeFromRequired(type, typeRequired.getParamType(0))) != null) {
            type = typeInferred;
        }
        TypeConstant typeType = type.getType();
        return this.finishValidation(ctx, typeRequired, typeType, Expression.TypeFit.Fit, typeType, errs);
    }

    @Override
    protected Expression finishValidation(Context ctx, TypeConstant typeRequired, TypeConstant typeActual, Expression.TypeFit fit, Constant constVal, ErrorListener errs) {
        Expression expr = super.finishValidation(ctx, typeRequired, typeActual, fit, constVal, errs);
        if (expr instanceof TypeExpression) {
            TypeExpression exprType = (TypeExpression)expr;
            exprType.resetTypeConstant();
        }
        return expr;
    }

    @Override
    public ExprAST getExprAST(Context ctx) {
        TypeConstant type = this.getType();
        return new ConstantExprAST(type);
    }

    protected static TypeConstant getSafeDataType(TypeConstant type) {
        return type != null && type.isParamsSpecified() ? type.getParamType(0) : null;
    }
}

