/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.compiler.ast;

import java.lang.reflect.Field;
import org.xvm.asm.Component;
import org.xvm.asm.Constants;
import org.xvm.asm.ErrorListener;
import org.xvm.asm.MethodStructure;
import org.xvm.asm.TypedefStructure;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.compiler.Token;
import org.xvm.compiler.ast.ComponentStatement;
import org.xvm.compiler.ast.Context;
import org.xvm.compiler.ast.Expression;
import org.xvm.compiler.ast.StageMgr;
import org.xvm.compiler.ast.Statement;
import org.xvm.compiler.ast.TypeExpression;
import org.xvm.util.Severity;

public class TypedefStatement
extends ComponentStatement {
    protected Expression cond;
    protected Token modifier;
    protected Token alias;
    protected TypeExpression type;
    private static final Field[] CHILD_FIELDS = TypedefStatement.fieldsForNames(TypedefStatement.class, "cond", "type");

    public TypedefStatement(Expression cond, Token keyword, TypeExpression type, Token alias) {
        super(keyword.getStartPosition(), alias.getEndPosition());
        this.cond = cond;
        this.modifier = keyword.getId() == Token.Id.TYPEDEF ? null : keyword;
        this.type = type;
        this.alias = alias;
    }

    @Override
    public Constants.Access getDefaultAccess() {
        if (this.modifier != null) {
            switch (this.modifier.getId()) {
                case PUBLIC: {
                    return Constants.Access.PUBLIC;
                }
                case PROTECTED: {
                    return Constants.Access.PROTECTED;
                }
                case PRIVATE: {
                    return Constants.Access.PRIVATE;
                }
            }
        }
        return super.getDefaultAccess();
    }

    @Override
    protected Field[] getChildFields() {
        return CHILD_FIELDS;
    }

    @Override
    protected void registerStructures(StageMgr mgr, ErrorListener errs) {
        if (this.getComponent() == null) {
            Component container = this.getParent().getComponent();
            String sName = (String)this.alias.getValue();
            if (container != null && container.isClassContainer()) {
                Constants.Access access = this.getDefaultAccess();
                TypeConstant constType = this.type.ensureTypeConstant();
                TypedefStructure typedef = container.createTypedef(access, constType, sName);
                this.setComponent(typedef);
            } else if (!errs.hasSeriousErrors()) {
                this.log(errs, Severity.ERROR, "COMPILER-34", sName, container);
            }
        }
    }

    @Override
    protected Statement validateImpl(Context ctx, ErrorListener errs) {
        return this;
    }

    @Override
    protected boolean emit(Context ctx, boolean fReachable, MethodStructure.Code code, ErrorListener errs) {
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.cond != null) {
            sb.append("if (").append(this.cond).append(") { ");
        }
        if (this.modifier != null) {
            sb.append(this.modifier).append(' ');
        }
        sb.append("typedef ").append(this.type).append(' ').append(this.alias.getValue()).append(';');
        if (this.cond != null) {
            sb.append(" }");
        }
        return sb.toString();
    }

    @Override
    public String getDumpDesc() {
        return this.toString();
    }
}

