/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.compiler.ast;

import org.xvm.asm.Argument;
import org.xvm.asm.Constant;
import org.xvm.asm.ErrorListener;
import org.xvm.asm.MethodStructure;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.asm.op.GP_Compl;
import org.xvm.compiler.Token;
import org.xvm.compiler.ast.Context;
import org.xvm.compiler.ast.Expression;
import org.xvm.compiler.ast.PrefixExpression;

public class UnaryComplementExpression
extends PrefixExpression {
    public UnaryComplementExpression(Token operator, Expression expr) {
        super(operator, expr);
    }

    @Override
    public TypeConstant getImplicitType(Context ctx) {
        return this.operator.getId() == Token.Id.NOT ? this.pool().typeBoolean() : this.expr.getImplicitType(ctx);
    }

    @Override
    protected Expression validate(Context ctx, TypeConstant typeRequired, ErrorListener errs) {
        Expression.TypeFit fit = Expression.TypeFit.Fit;
        Constant constVal = null;
        Expression exprRight = this.expr;
        TypeConstant typeRight = null;
        boolean fBoolean = false;
        if (this.operator.getId() == Token.Id.NOT) {
            typeRight = this.pool().typeBoolean();
            fBoolean = true;
        } else if (typeRequired != null && exprRight.testFit(ctx, typeRequired, false, null).isFit() && !typeRequired.ensureTypeInfo(errs).findOpMethods("not", "~", 0).isEmpty()) {
            typeRight = typeRequired;
            fBoolean = typeRight.isA(this.pool().typeBoolean());
        }
        if (fBoolean) {
            ctx = ctx.enterNot();
        }
        typeRight = this.findBestOp(ctx, typeRequired, typeRight, "not", "~", errs);
        if (fBoolean) {
            ctx = ctx.exit();
        }
        if (typeRight == null) {
            fit = Expression.TypeFit.NoFit;
        } else if (exprRight.isConstant()) {
            try {
                constVal = exprRight.toConstant().apply(this.operator.getId(), null);
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
        return this.finishValidation(ctx, typeRequired, typeRight, fit, constVal, errs);
    }

    @Override
    public void generateAssignment(Context ctx, MethodStructure.Code code, Expression.Assignable LVal, ErrorListener errs) {
        if (LVal.isLocalArgument()) {
            Argument arg = this.expr.generateArgument(ctx, code, true, true, errs);
            code.add(new GP_Compl(arg, LVal.getLocalArgument()));
        } else {
            super.generateAssignment(ctx, code, LVal, errs);
        }
    }
}

