/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.compiler.ast;

import org.xvm.asm.Argument;
import org.xvm.asm.Constant;
import org.xvm.asm.ErrorListener;
import org.xvm.asm.MethodStructure;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.asm.op.GP_Neg;
import org.xvm.compiler.Token;
import org.xvm.compiler.ast.Context;
import org.xvm.compiler.ast.Expression;
import org.xvm.compiler.ast.LiteralExpression;
import org.xvm.compiler.ast.PrefixExpression;

public class UnaryMinusExpression
extends PrefixExpression {
    public UnaryMinusExpression(Token operator, Expression expr) {
        super(operator, expr);
    }

    @Override
    public TypeConstant getImplicitType(Context ctx) {
        return this.expr.getImplicitType(ctx);
    }

    @Override
    protected Expression validate(Context ctx, TypeConstant typeRequired, ErrorListener errs) {
        Expression exprRight = this.expr;
        if (exprRight instanceof LiteralExpression) {
            assert (!exprRight.isValidated());
            exprRight = ((LiteralExpression)exprRight).adoptUnaryPrefix(this.operator, errs);
            return (exprRight = exprRight.validate(ctx, typeRequired, errs)) == null ? null : this.replaceThisWith(exprRight);
        }
        Expression.TypeFit fit = Expression.TypeFit.Fit;
        Constant constVal = null;
        TypeConstant typeRight = null;
        if (typeRequired != null && exprRight.testFit(ctx, typeRequired, false, null).isFit() && !typeRequired.ensureTypeInfo(errs).findOpMethods("neg", "-#", 0).isEmpty()) {
            typeRight = typeRequired;
        }
        if ((typeRight = this.findBestOp(ctx, typeRequired, typeRight, "neg", "-#", errs)) == null) {
            fit = Expression.TypeFit.NoFit;
        } else if (exprRight.isConstant()) {
            try {
                constVal = exprRight.toConstant().apply(this.operator.getId(), null);
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
        return this.finishValidation(ctx, typeRequired, typeRight, fit, constVal, errs);
    }

    @Override
    public void generateAssignment(Context ctx, MethodStructure.Code code, Expression.Assignable LVal, ErrorListener errs) {
        if (LVal.isLocalArgument()) {
            Argument arg = this.expr.generateArgument(ctx, code, true, true, errs);
            code.add(new GP_Neg(arg, LVal.getLocalArgument()));
        } else {
            super.generateAssignment(ctx, code, LVal, errs);
        }
    }
}

