/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.compiler.ast;

import org.xvm.asm.ErrorListener;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.compiler.Token;
import org.xvm.compiler.ast.Context;
import org.xvm.compiler.ast.Expression;
import org.xvm.compiler.ast.LiteralExpression;
import org.xvm.compiler.ast.PrefixExpression;
import org.xvm.util.Severity;

public class UnaryPlusExpression
extends PrefixExpression {
    public UnaryPlusExpression(Token operator, Expression expr) {
        super(operator, expr);
    }

    @Override
    public TypeConstant getImplicitType(Context ctx) {
        return this.expr.getImplicitType(ctx);
    }

    @Override
    protected Expression validate(Context ctx, TypeConstant typeRequired, ErrorListener errs) {
        TypeConstant typeRight;
        Expression exprRight = this.expr;
        boolean fPrepend = exprRight instanceof LiteralExpression;
        if (fPrepend) {
            assert (!exprRight.isValidated());
            exprRight = ((LiteralExpression)exprRight).adoptUnaryPrefix(this.operator, errs);
        }
        if ((exprRight = exprRight.validate(ctx, typeRequired, errs)) != null && !fPrepend && !(typeRight = exprRight.getType()).isA(this.pool().typeNumber())) {
            this.log(errs, Severity.ERROR, "COMPILER-67", this.operator.getValueText(), typeRight.getValueString());
            return null;
        }
        return this.replaceThisWith(exprRight);
    }
}

