/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.compiler.ast;

import java.util.List;
import org.xvm.asm.Argument;
import org.xvm.asm.Constant;
import org.xvm.asm.ConstantPool;
import org.xvm.asm.ErrorListener;
import org.xvm.asm.MethodStructure;
import org.xvm.asm.Register;
import org.xvm.asm.ast.ConstantExprAST;
import org.xvm.asm.ast.ExprAST;
import org.xvm.asm.ast.MultiExprAST;
import org.xvm.asm.ast.UnpackExprAST;
import org.xvm.asm.constants.ArrayConstant;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.asm.op.I_Get;
import org.xvm.compiler.ast.Context;
import org.xvm.compiler.ast.Expression;
import org.xvm.compiler.ast.SyntheticExpression;
import org.xvm.compiler.ast.TupleExpression;

public class UnpackExpression
extends SyntheticExpression {
    public UnpackExpression(Expression exprTuple, ErrorListener errs) {
        super(exprTuple);
        if (exprTuple.isValidated()) {
            this.adoptValidation(null, exprTuple, errs);
        }
    }

    @Override
    protected boolean hasSingleValueImpl() {
        return false;
    }

    @Override
    protected boolean hasMultiValueImpl() {
        return true;
    }

    @Override
    public TypeConstant[] getImplicitTypes(Context ctx) {
        return this.isValidated() ? this.getTypes() : this.expr.getImplicitType(ctx).getParamTypesArray();
    }

    @Override
    public Expression.TypeFit testFitMulti(Context ctx, TypeConstant[] atypeRequired, boolean fExhaustive, ErrorListener errs) {
        TypeConstant typeTuple = this.pool().ensureTupleType(atypeRequired);
        return this.expr.testFit(ctx, typeTuple, fExhaustive, errs);
    }

    @Override
    protected Expression validateMulti(Context ctx, TypeConstant[] atypeRequired, ErrorListener errs) {
        Expression expression;
        Expression exprOld = this.expr;
        TypeConstant typeTuple = this.pool().ensureTupleType(atypeRequired);
        Expression exprNew = exprOld.validate(ctx, typeTuple, errs);
        if (exprNew == null) {
            expression = null;
        } else {
            this.expr = exprNew;
            expression = this.adoptValidation(ctx, this.expr, errs);
        }
        return expression;
    }

    @Override
    public void generateVoid(Context ctx, MethodStructure.Code code, ErrorListener errs) {
        this.expr.generateVoid(ctx, code, errs);
    }

    @Override
    public Argument[] generateArguments(Context ctx, MethodStructure.Code code, boolean fLocalPropOk, boolean fUsedOnce, ErrorListener errs) {
        if (this.isConstant()) {
            return this.toConstants();
        }
        Expression expression = this.expr;
        if (expression instanceof TupleExpression) {
            TupleExpression exprTuple = (TupleExpression)expression;
            List<Expression> listExprs = exprTuple.getExpressions();
            int cExprs = listExprs.size();
            Argument[] aArgs = new Argument[cExprs];
            for (int i = 0; i < cExprs; ++i) {
                Expression expr = listExprs.get(i);
                Argument arg = expr.generateArgument(ctx, code, false, false, errs);
                aArgs[i] = expr.ensurePointInTime(code, arg, listExprs, i);
            }
            return aArgs;
        }
        Argument argTuple = this.expr.generateArgument(ctx, code, true, false, errs);
        ConstantPool pool = this.pool();
        TypeConstant[] aTypes = this.getTypes();
        int cValues = aTypes.length;
        Argument[] aRegs = new Register[cValues];
        for (int i = 0; i < cValues; ++i) {
            Expression.Assignable LValue = this.createTempVar(code, aTypes[i], false);
            Register regValue = LValue.getRegister();
            code.add(new I_Get(argTuple, pool.ensureIntConstant(i), regValue));
            aRegs[i] = regValue;
        }
        return aRegs;
    }

    @Override
    public ExprAST getExprAST(Context ctx) {
        if (this.isConstant()) {
            Constant[] aconst = this.toConstants();
            int cVals = aconst.length;
            ExprAST[] aAst = new ExprAST[cVals];
            for (int i = 0; i < cVals; ++i) {
                aAst[i] = new ConstantExprAST(aconst[i]);
            }
            return new MultiExprAST(aAst);
        }
        return new UnpackExprAST(this.expr.getExprAST(ctx), this.getTypes());
    }

    protected Expression adoptValidation(Context ctx, Expression exprTuple, ErrorListener errs) {
        TypeConstant typeTuple = exprTuple.getType();
        assert (typeTuple.isTuple() && typeTuple.isParamsSpecified());
        TypeConstant[] atypeField = typeTuple.getParamTypesArray();
        Constant[] aconstVal = null;
        if (exprTuple.isConstant()) {
            Constant constTuple = exprTuple.toConstant();
            assert (constTuple.getFormat() == Constant.Format.Tuple);
            aconstVal = ((ArrayConstant)constTuple).getValue();
        }
        return this.finishValidations(ctx, null, atypeField, this.expr.getTypeFit().addUnpack(), aconstVal, errs);
    }

    @Override
    public String toString() {
        return "Unpacked: " + this.getUnderlyingExpression().toString();
    }
}

