/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.compiler.ast;

import java.lang.reflect.Field;
import java.util.List;
import org.xvm.asm.Annotation;
import org.xvm.asm.Argument;
import org.xvm.asm.Constant;
import org.xvm.asm.ConstantPool;
import org.xvm.asm.ErrorListener;
import org.xvm.asm.MethodStructure;
import org.xvm.asm.Register;
import org.xvm.asm.constants.ClassConstant;
import org.xvm.asm.constants.ExpressionConstant;
import org.xvm.asm.constants.RegisterConstant;
import org.xvm.asm.constants.StringConstant;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.asm.op.Move;
import org.xvm.asm.op.Var;
import org.xvm.asm.op.Var_DN;
import org.xvm.asm.op.Var_N;
import org.xvm.compiler.Token;
import org.xvm.compiler.ast.AnnotatedTypeExpression;
import org.xvm.compiler.ast.AnnotationExpression;
import org.xvm.compiler.ast.Context;
import org.xvm.compiler.ast.Expression;
import org.xvm.compiler.ast.NameExpression;
import org.xvm.compiler.ast.StageMgr;
import org.xvm.compiler.ast.Statement;
import org.xvm.compiler.ast.TypeExpression;
import org.xvm.compiler.ast.VariableTypeExpression;
import org.xvm.util.Severity;

public class VariableDeclarationStatement
extends Statement {
    public static final VariableDeclarationStatement[] NONE = new VariableDeclarationStatement[0];
    protected TypeExpression type;
    protected Token name;
    protected boolean term;
    private transient Register m_reg;
    private transient NameExpression m_exprName;
    private transient boolean m_fConstAnno;
    private static final Field[] CHILD_FIELDS = VariableDeclarationStatement.fieldsForNames(VariableDeclarationStatement.class, "type");

    public VariableDeclarationStatement(TypeExpression type, Token name, boolean term) {
        this.name = name;
        this.type = type;
        this.term = term;
    }

    public String getName() {
        return this.name.getValueText();
    }

    public Token getNameToken() {
        return this.name;
    }

    public TypeConstant getType() {
        return this.type.getTypeConstant();
    }

    public boolean hasRefAnnotations() {
        AnnotatedTypeExpression exprAnno;
        TypeExpression typeExpression = this.type;
        return typeExpression instanceof AnnotatedTypeExpression && !(exprAnno = (AnnotatedTypeExpression)typeExpression).getRefAnnotations().isEmpty();
    }

    Register getRegister() {
        return this.m_reg;
    }

    @Override
    public long getStartPosition() {
        return this.type.getStartPosition();
    }

    @Override
    public long getEndPosition() {
        return this.name.getEndPosition();
    }

    @Override
    protected Field[] getChildFields() {
        return CHILD_FIELDS;
    }

    @Override
    protected boolean isRValue(Expression exprChild) {
        return exprChild != this.m_exprName;
    }

    @Override
    public boolean isLValueSyntax() {
        return true;
    }

    @Override
    public Expression getLValueExpression() {
        NameExpression exprName = this.m_exprName;
        if (exprName == null) {
            this.m_exprName = exprName = new NameExpression(this, this.name, this.m_reg);
        }
        return exprName;
    }

    @Override
    public void updateLValueFromRValueTypes(Context ctx, Context.Branch branch, boolean fCond, TypeConstant[] aTypes) {
        assert (aTypes != null && aTypes.length >= 1);
        TypeExpression exprType = this.type;
        if (exprType instanceof VariableTypeExpression) {
            VariableTypeExpression exprVar = (VariableTypeExpression)exprType;
            TypeConstant type = aTypes[0];
            exprType.setTypeConstant(type);
            Register reg = this.m_reg;
            if (reg != null) {
                reg.specifyActualType(type);
                if (exprVar.getToken().getId() == Token.Id.VAL) {
                    reg.markEffectivelyFinal();
                }
            }
        }
        this.getLValueExpression().updateLValueFromRValueTypes(ctx, branch, fCond, aTypes);
    }

    @Override
    public void resetLValueTypes(Context ctx) {
        this.getLValueExpression().resetLValueTypes(ctx);
    }

    @Override
    public void resolveNames(StageMgr mgr, ErrorListener errs) {
        if (this.name.getId() == Token.Id.ANY) {
            this.name = this.name.withValue("_:" + this.getCodeContainerCounter());
        }
        super.resolveNames(mgr, errs);
    }

    @Override
    protected Statement validateImpl(Context ctx, ErrorListener errs) {
        TypeExpression exprOld = this.type;
        ConstantPool pool = this.pool();
        TypeExpression exprNew = (TypeExpression)exprOld.validate(ctx, pool.typeType(), errs);
        if (exprNew == null) {
            return null;
        }
        this.type = exprNew;
        TypeConstant typeVar = exprNew.ensureTypeConstant(ctx, errs).removeAutoNarrowing().normalizeParameters();
        Register reg = this.m_reg = ctx.createRegister(typeVar, this.getName());
        ctx.registerVar(this.name, reg, errs);
        if (exprNew instanceof AnnotatedTypeExpression) {
            int cRefAnnos;
            AnnotatedTypeExpression exprAnnoType = (AnnotatedTypeExpression)exprNew;
            List<AnnotationExpression> listRefAnnos = exprAnnoType.getRefAnnotations();
            int n = cRefAnnos = listRefAnnos == null ? 0 : listRefAnnos.size();
            if (cRefAnnos > 0) {
                if (exprAnnoType.isInjected()) {
                    ctx.markVarWrite(this.name, false, errs);
                    reg.markEffectivelyFinal();
                }
                boolean fVar = exprAnnoType.isVar();
                boolean fConst = true;
                boolean fUnassigned = false;
                boolean fInflate = false;
                TypeConstant typeReg = pool.ensureParameterizedTypeConstant(fVar ? pool.typeVar() : pool.typeRef(), typeVar);
                int ixFinal = -1;
                int ixVolatile = -1;
                for (int i = cRefAnnos - 1; i >= 0; --i) {
                    AnnotationExpression exprAnno = listRefAnnos.get(i);
                    Annotation anno = exprAnno.ensureAnnotation(pool);
                    ClassConstant clzAnno = (ClassConstant)anno.getAnnotationClass();
                    if (clzAnno.equals(pool.clzFinal())) {
                        reg.markFinal();
                        ixFinal = i;
                    } else if (clzAnno.equals(pool.clzUnassigned())) {
                        fUnassigned = true;
                    } else if (clzAnno.equals(pool.clzFuture())) {
                        fInflate = true;
                    } else {
                        fUnassigned = anno.hasExplicitGetter();
                        fInflate = true;
                    }
                    typeReg = pool.ensureAnnotatedTypeConstant(typeReg, anno);
                    fConst &= exprAnno.isConstant();
                    if (ixVolatile >= 0 || !typeReg.isA(pool.clzVolatile().getType())) continue;
                    ixVolatile = i;
                }
                if (fUnassigned) {
                    reg.markAllowUnassigned();
                }
                if (fInflate) {
                    reg.specifyRegType(typeReg);
                    if (ixFinal >= 0 && ixVolatile >= 0) {
                        this.log(errs, Severity.ERROR, "COMPILER-198", listRefAnnos.get(ixFinal), listRefAnnos.get(ixVolatile));
                    }
                }
                this.m_fConstAnno = fConst;
            }
        }
        return this;
    }

    @Override
    protected boolean emit(Context ctx, boolean fReachable, MethodStructure.Code code, ErrorListener errs) {
        ConstantPool pool = this.pool();
        StringConstant constName = pool.ensureStringConstant(this.getName());
        Register reg = this.m_reg;
        if (reg.isVar()) {
            TypeExpression typeExpression;
            if (!this.m_fConstAnno && (typeExpression = this.type) instanceof AnnotatedTypeExpression) {
                AnnotatedTypeExpression exprAnnoType = (AnnotatedTypeExpression)typeExpression;
                TypeConstant typeReg = pool.ensureParameterizedTypeConstant(exprAnnoType.isVar() ? pool.typeVar() : pool.typeRef(), reg.getOriginalType());
                List<AnnotationExpression> listRefAnnotations = exprAnnoType.getRefAnnotations();
                for (int i = listRefAnnotations.size() - 1; i >= 0; --i) {
                    AnnotationExpression exprAnno = listRefAnnotations.get(i);
                    Annotation anno = exprAnno.ensureAnnotation(pool);
                    if (!exprAnno.isConstant()) {
                        Constant[] aConst = anno.getParams();
                        int c = aConst.length;
                        for (int j = 0; j < c; ++j) {
                            Register regArg;
                            Constant constArg = aConst[j];
                            if (!(constArg instanceof ExpressionConstant)) continue;
                            ExpressionConstant constExpr = (ExpressionConstant)constArg;
                            Expression exprArg = constExpr.getExpression();
                            Argument argArg = exprArg.generateArgument(ctx, code, true, false, errs);
                            if (argArg instanceof Register) {
                                Register regA;
                                regArg = regA = (Register)argArg;
                            } else {
                                regArg = code.createRegister(exprArg.getType());
                                code.add(new Var(regArg));
                                code.add(new Move(argArg, regArg));
                            }
                            aConst[j] = new RegisterConstant(pool, regArg);
                        }
                        anno = pool.ensureAnnotation(anno.getAnnotationClass(), aConst);
                    }
                    typeReg = pool.ensureAnnotatedTypeConstant(typeReg, anno);
                }
                reg.specifyRegType(typeReg);
            }
            code.add(new Var_DN(reg, constName));
        } else {
            code.add(new Var_N(reg, constName));
        }
        ctx.getHolder().setAst(this, reg.getRegAllocAST());
        return fReachable;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.type).append(' ').append(this.getName());
        if (this.term) {
            sb.append(';');
        }
        return sb.toString();
    }

    @Override
    public String getDumpDesc() {
        return this.toString();
    }
}

