/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.compiler.ast;

import java.lang.reflect.Field;
import java.util.Collections;
import java.util.Map;
import org.xvm.asm.Version;
import org.xvm.compiler.Token;
import org.xvm.compiler.ast.AstNode;
import org.xvm.compiler.ast.LiteralExpression;

public class VersionOverride
extends AstNode {
    protected Token verb;
    protected LiteralExpression exprVer;
    private static final Field[] CHILD_FIELDS = VersionOverride.fieldsForNames(VersionOverride.class, "exprVer");

    public VersionOverride(LiteralExpression exprVer) {
        this(null, exprVer);
    }

    public VersionOverride(Token verb, LiteralExpression exprVer) {
        assert (exprVer != null && exprVer.literal.getId() == Token.Id.LIT_VERSION);
        this.verb = verb;
        this.exprVer = exprVer;
    }

    public Version getVersion() {
        return this.exprVer.getVersion();
    }

    public boolean isAllowed() {
        return this.verb == null || this.verb.getId() != Token.Id.AVOID;
    }

    public boolean isPreferred() {
        return this.verb != null && this.verb.getId() == Token.Id.PREFER;
    }

    @Override
    public long getStartPosition() {
        return this.verb == null ? this.exprVer.getStartPosition() : this.verb.getStartPosition();
    }

    @Override
    public long getEndPosition() {
        return this.exprVer.getEndPosition();
    }

    @Override
    protected Field[] getChildFields() {
        return CHILD_FIELDS;
    }

    @Override
    public String toString() {
        return this.verb == null ? this.exprVer.toString() : this.verb.getId().TEXT + " " + this.exprVer.toString();
    }

    @Override
    public String getDumpDesc() {
        return this.toString();
    }

    @Override
    public Map<String, Object> getDumpChildren() {
        return Collections.emptyMap();
    }
}

