/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.compiler.ast;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.xvm.asm.Argument;
import org.xvm.asm.Assignment;
import org.xvm.asm.ConstantPool;
import org.xvm.asm.ErrorListener;
import org.xvm.asm.MethodStructure;
import org.xvm.asm.Op;
import org.xvm.asm.Register;
import org.xvm.asm.ast.BinaryAST;
import org.xvm.asm.ast.DoWhileStmtAST;
import org.xvm.asm.ast.ExprAST;
import org.xvm.asm.ast.LoopStmtAST;
import org.xvm.asm.ast.RegAllocAST;
import org.xvm.asm.ast.StmtBlockAST;
import org.xvm.asm.ast.WhileStmtAST;
import org.xvm.asm.constants.StringConstant;
import org.xvm.asm.op.Enter;
import org.xvm.asm.op.Exit;
import org.xvm.asm.op.IP_Inc;
import org.xvm.asm.op.JumpFalse;
import org.xvm.asm.op.JumpTrue;
import org.xvm.asm.op.Label;
import org.xvm.asm.op.Loop;
import org.xvm.asm.op.LoopEnd;
import org.xvm.asm.op.Move;
import org.xvm.asm.op.Var_IN;
import org.xvm.compiler.Token;
import org.xvm.compiler.ast.AssignmentStatement;
import org.xvm.compiler.ast.AstNode;
import org.xvm.compiler.ast.ConditionalStatement;
import org.xvm.compiler.ast.Context;
import org.xvm.compiler.ast.Expression;
import org.xvm.compiler.ast.LabelAble;
import org.xvm.compiler.ast.LabeledStatement;
import org.xvm.compiler.ast.Statement;
import org.xvm.compiler.ast.StatementBlock;
import org.xvm.util.Handy;
import org.xvm.util.Severity;

public class WhileStatement
extends ConditionalStatement
implements LabelAble {
    protected StatementBlock block;
    protected long lEndPos;
    private transient Label m_labelContinue;
    private transient Context m_ctxLabelVars;
    private transient ErrorListener m_errsLabelVars;
    private transient Register m_regFirst;
    private transient Register m_regCount;
    private transient List<Statement.Break> m_listContinues;
    private transient ExprAST m_astCond;
    private transient RegAllocAST[] m_aAllocSpecial;
    private static final Field[] CHILD_FIELDS = WhileStatement.fieldsForNames(WhileStatement.class, "conds", "block");

    public WhileStatement(Token keyword, List<AstNode> conds, StatementBlock block) {
        this(keyword, conds, block, block.getEndPosition());
    }

    public WhileStatement(Token keyword, List<AstNode> conds, StatementBlock block, long lEndPos) {
        super(keyword, conds);
        this.block = block;
        this.lEndPos = lEndPos;
    }

    public boolean isDoWhile() {
        return this.keyword.getId() == Token.Id.DO;
    }

    @Override
    public boolean isNaturalGotoStatementTarget() {
        return true;
    }

    @Override
    public Label ensureContinueLabel(AstNode nodeOrigin, Context ctxOrigin) {
        Context ctxDest = this.ensureValidationContext();
        Label label = this.getContinueLabel();
        if (ctxOrigin.isReachable()) {
            HashMap<String, Assignment> mapAsn = new HashMap<String, Assignment>();
            HashMap<String, Argument> mapArg = new HashMap<String, Argument>();
            ctxOrigin.prepareJump(ctxDest, mapAsn, mapArg);
            if (this.m_listContinues == null) {
                this.m_listContinues = new ArrayList<Statement.Break>();
            }
            this.m_listContinues.add(new Statement.Break(nodeOrigin, mapAsn, mapArg, label));
        }
        return label;
    }

    public Label getContinueLabel() {
        Label label = this.m_labelContinue;
        if (label == null) {
            this.m_labelContinue = label = new Label("continue_" + (this.isDoWhile() ? "do_" : "") + "while_" + this.getLabelId());
        }
        return label;
    }

    @Override
    public long getEndPosition() {
        return this.lEndPos;
    }

    @Override
    protected Field[] getChildFields() {
        return CHILD_FIELDS;
    }

    @Override
    public boolean hasLabelVar(String sName) {
        return "first".equals(sName) || "count".equals(sName);
    }

    @Override
    public Register getLabelVar(Context ctx, String sName) {
        Register reg;
        assert (this.hasLabelVar(sName));
        boolean fFirst = "first".equals(sName);
        Register register = reg = fFirst ? this.m_regFirst : this.m_regCount;
        if (reg == null) {
            assert (this.m_ctxLabelVars != null);
            String sLabel = ((LabeledStatement)this.getParent()).getName();
            String sRegName = sLabel + "." + sName;
            Token tok = new Token(this.keyword.getStartPosition(), this.keyword.getEndPosition(), Token.Id.IDENTIFIER, sRegName);
            reg = ctx.createRegister(fFirst ? this.pool().typeBoolean() : this.pool().typeInt64(), sRegName);
            this.m_ctxLabelVars.registerVar(tok, reg, this.m_errsLabelVars);
            if (fFirst) {
                this.m_regFirst = reg;
            } else {
                this.m_regCount = reg;
            }
        }
        return reg;
    }

    @Override
    protected Statement validateImpl(Context ctx, ErrorListener errs) {
        Context ctxFork;
        boolean fAlwaysTrue;
        int cExits;
        boolean fValid;
        StatementBlock blockOrig;
        List condsOrig;
        Context ctxOrig;
        block32: {
            boolean fDoWhile = this.isDoWhile();
            ErrorListener errsOrig = errs;
            ctxOrig = ctx;
            HashMap<String, Assignment> mapLoopAsn = new HashMap<String, Assignment>();
            HashMap<String, Argument> mapLoopArg = new HashMap<String, Argument>();
            int cConds = this.getConditionCount();
            condsOrig = this.conds;
            this.block.suppressScope();
            blockOrig = this.block;
            boolean fLoops = true;
            int cTries = 0;
            while (true) {
                fValid = true;
                boolean fRepeat = false;
                this.conds = new ArrayList(cConds);
                for (AstNode cond : condsOrig) {
                    this.conds.add(cond.clone());
                }
                this.block = (StatementBlock)blockOrig.clone();
                errs = errsOrig.branch(this);
                ctx = ctxOrig.enter();
                ctx.merge(mapLoopAsn, mapLoopArg);
                ctx.setReachable(true);
                cExits = 1;
                this.m_ctxLabelVars = ctx;
                this.m_errsLabelVars = errs;
                this.m_listContinues = null;
                if (fLoops) {
                    ctx = ctx.enterLoop();
                    ++cExits;
                }
                fAlwaysTrue = false;
                ctxFork = null;
                for (int iPart = 1; iPart <= 2; ++iPart) {
                    if (iPart == 2 == fDoWhile) {
                        ctx = ctx.enterIf();
                        cExits += cConds;
                        for (int i = 0; i < cConds; ++i) {
                            AstNode exprCond;
                            AstNode condNew;
                            AstNode condOld = (AstNode)this.conds.get(i);
                            if (i > 0) {
                                ctx = ctx.enterAndIf();
                            }
                            if (condOld instanceof AssignmentStatement) {
                                AssignmentStatement stmtCond = (AssignmentStatement)condOld;
                                if (stmtCond.isNegated()) {
                                    ctx = ctx.enterNot();
                                }
                                condNew = stmtCond.validate(ctx, errs);
                                if (stmtCond.isNegated()) {
                                    ctx = ctx.exit();
                                }
                            } else {
                                condNew = ((Expression)condOld).validate(ctx, this.pool().typeBoolean(), errs);
                            }
                            if (condNew == null) {
                                fValid = false;
                                continue;
                            }
                            if (condNew != condOld) {
                                this.conds.set(i, condNew);
                            }
                            if (!(condNew instanceof Expression) || !((Expression)(exprCond = condNew)).isConstant()) continue;
                            if (((Expression)exprCond).isConstantFalse()) {
                                if (fDoWhile) {
                                    if (!fLoops) continue;
                                    fLoops = false;
                                    fRepeat = true;
                                    continue;
                                }
                                condNew.log(errs, Severity.ERROR, "COMPILER-128", new Object[0]);
                                fValid = false;
                                continue;
                            }
                            assert (((Expression)condNew).isConstantTrue());
                            fAlwaysTrue = true;
                        }
                        if (fAlwaysTrue) {
                            if (this.block.getStatements().isEmpty()) {
                                this.log(errs, Severity.ERROR, "COMPILER-155", new Object[0]);
                                errs.merge();
                                return null;
                            }
                            ctx = ctx.enterInfiniteLoop();
                        } else {
                            ctx = ctxFork = ctx.enterFork(true);
                        }
                        ++cExits;
                        continue;
                    }
                    boolean fReachable = ctx.isReachable();
                    StatementBlock blockNew = (StatementBlock)this.block.validate(ctx, errs);
                    if (blockNew == null) {
                        fValid = false;
                    } else {
                        this.block = blockNew;
                    }
                    boolean fContinues = false;
                    if (this.m_listContinues != null) {
                        Iterator<Statement.Break> iter = this.m_listContinues.iterator();
                        while (iter.hasNext()) {
                            Statement.Break continueInfo = iter.next();
                            if (continueInfo.node().isDiscarded()) {
                                iter.remove();
                                continue;
                            }
                            fContinues = true;
                            ctx.merge(continueInfo.mapAssign(), continueInfo.mapNarrow());
                        }
                        if (fContinues) {
                            ctx.setReachable(true);
                        }
                    }
                    if (!fLoops || !fReachable || ctx.isReachable() || fContinues) continue;
                    fLoops = false;
                    fRepeat = true;
                }
                HashMap<String, Assignment> mapAsnAfter = new HashMap<String, Assignment>();
                HashMap<String, Argument> mapArgAfter = new HashMap<String, Argument>();
                ctx.prepareJump(ctxOrig, mapAsnAfter, mapArgAfter);
                if (!fRepeat && mapAsnAfter.equals(mapLoopAsn)) break block32;
                if (++cTries >= 10) break;
                mapLoopAsn = mapAsnAfter;
                mapLoopArg = mapArgAfter;
                for (AstNode cond : this.conds) {
                    cond.discard(true);
                }
                this.block.discard(true);
            }
            if (!errs.hasSeriousErrors()) {
                this.log(errs, Severity.ERROR, "COMPILER-01", new Object[0]);
            }
            fValid = false;
        }
        for (AstNode cond : condsOrig) {
            cond.discard(true);
        }
        blockOrig.discard(true);
        this.m_ctxLabelVars = null;
        this.m_errsLabelVars = null;
        if (ctxFork != null && !this.hasBreaks()) {
            ctxFork.setReachable(false);
        }
        while (cExits-- > 0) {
            ctx = ctx.exit();
        }
        assert (ctx == ctxOrig);
        if (fAlwaysTrue) {
            ctx.setReachable(false);
        }
        errs.merge();
        return fValid ? this : null;
    }

    @Override
    protected boolean emit(Context ctx, boolean fReachable, MethodStructure.Code code, ErrorListener errs) {
        BinaryAST astBlock;
        boolean fCompletes = fReachable;
        boolean fDoWhile = this.isDoWhile();
        Register regFirst = this.m_regFirst;
        Register regCount = this.m_regCount;
        boolean fHasLabelVars = regFirst != null || regCount != null;
        Statement.AstHolder holder = ctx.getHolder();
        boolean fAlwaysTrue = true;
        boolean fAlwaysFalse = true;
        for (AstNode cond : this.conds) {
            Expression exprCond;
            if (cond instanceof Expression && (exprCond = (Expression)cond).isConstant()) {
                if (exprCond.isConstantFalse()) {
                    fAlwaysTrue = false;
                    break;
                }
                assert (exprCond.isConstantTrue());
                fAlwaysFalse = false;
                continue;
            }
            fAlwaysTrue = false;
            fAlwaysFalse = false;
            break;
        }
        if (fAlwaysFalse) {
            if (!fDoWhile) {
                this.block.completes(ctx, false, code, errs);
                holder.setAst(this, StmtBlockAST.EMPTY);
                return fCompletes;
            }
            code.add(new Enter());
            this.emitLabelVarCreation(code, regFirst, regCount);
            fCompletes = this.block.completes(ctx, fCompletes, code, errs);
            code.add(new Exit());
            code.add(this.getContinueLabel());
            BinaryAST astBody = holder.getAst(this.block);
            if (this.m_aAllocSpecial != null) {
                int cAllocs = this.m_aAllocSpecial.length;
                BinaryAST[] aAst = new BinaryAST[cAllocs + 1];
                System.arraycopy(this.m_aAllocSpecial, 0, aAst, 0, cAllocs);
                aAst[cAllocs] = astBody;
                holder.setAst(this, new StmtBlockAST(aAst, true));
            } else {
                holder.setAst(this, astBody);
            }
            return fCompletes;
        }
        if (fAlwaysTrue) {
            code.add(new Enter());
            this.emitLabelVarCreation(code, regFirst, regCount);
            code.add(new Loop());
            Op opLast = code.getLastOp();
            this.block.suppressScope();
            this.block.completes(ctx, fCompletes, code, errs);
            if (code.getLastOp() == opLast) {
                this.log(errs, Severity.ERROR, "COMPILER-155", new Object[0]);
            }
            code.add(this.getContinueLabel());
            this.emitLabelVarUpdate(code, regFirst, regCount);
            code.add(new LoopEnd());
            code.add(new Exit());
            holder.setAst(this, new LoopStmtAST(this.m_aAllocSpecial, holder.getAst(this.block)));
            return false;
        }
        if (fDoWhile) {
            code.add(new Enter());
            this.emitLabelVarCreation(code, regFirst, regCount);
            code.add(new Loop());
            this.block.completes(ctx, fCompletes, code, errs);
            astBlock = holder.getAst(this.block);
            code.add(this.getContinueLabel());
            fCompletes = this.emitConditionTest(ctx, fCompletes, code, errs);
            this.emitLabelVarUpdate(code, regFirst, regCount);
            code.add(new LoopEnd());
            code.add(new Exit());
            holder.setAst(this, new DoWhileStmtAST(this.m_aAllocSpecial, astBlock, this.m_astCond));
            return fCompletes;
        }
        code.add(new Enter());
        this.emitLabelVarCreation(code, regFirst, regCount);
        code.add(new Loop());
        fCompletes = this.emitConditionTest(ctx, fCompletes, code, errs);
        this.block.completes(ctx, fCompletes, code, errs);
        astBlock = holder.getAst(this.block);
        code.add(this.getContinueLabel());
        this.emitLabelVarUpdate(code, regFirst, regCount);
        code.add(new LoopEnd());
        code.add(new Exit());
        holder.setAst(this, new WhileStmtAST(this.m_aAllocSpecial, null, this.m_astCond, astBlock));
        return fCompletes;
    }

    private void emitLabelVarCreation(MethodStructure.Code code, Register regFirst, Register regCount) {
        StringConstant name;
        ConstantPool pool = this.pool();
        RegAllocAST[] aAlloc = null;
        if (regFirst != null) {
            name = pool.ensureStringConstant(((LabeledStatement)this.getParent()).getName() + ".first");
            code.add(new Var_IN(regFirst, name, pool.valTrue()));
            aAlloc = new RegAllocAST[regCount == null ? 1 : 2];
            aAlloc[0] = regFirst.getRegAllocAST();
        }
        if (regCount != null) {
            name = pool.ensureStringConstant(((LabeledStatement)this.getParent()).getName() + ".count");
            code.add(new Var_IN(regCount, name, pool.val0()));
            RegAllocAST astCount = regCount.getRegAllocAST();
            if (aAlloc == null) {
                aAlloc = new RegAllocAST[]{astCount};
            } else {
                aAlloc[1] = astCount;
            }
        }
        this.m_aAllocSpecial = aAlloc;
    }

    private void emitLabelVarUpdate(MethodStructure.Code code, Register regFirst, Register regCount) {
        if (regFirst != null) {
            code.add(new Move(this.pool().valFalse(), regFirst));
        }
        if (regCount != null) {
            code.add(new IP_Inc(regCount));
        }
    }

    private boolean emitConditionTest(Context ctx, boolean fReachable, MethodStructure.Code code, ErrorListener errs) {
        boolean fCompletes = fReachable;
        Statement.AstHolder holder = ctx.getHolder();
        int cConds = this.getConditionCount();
        ExprAST[] aCondASTs = new ExprAST[cConds];
        for (int i = 0; i < cConds; ++i) {
            AstNode cond = this.getCondition(i);
            if (cond instanceof AssignmentStatement) {
                AssignmentStatement stmtCond = (AssignmentStatement)cond;
                fCompletes &= stmtCond.completes(ctx, fCompletes, code, errs);
                code.add(stmtCond.isNegated() ? new JumpTrue(stmtCond.getConditionRegister(), this.getEndLabel()) : new JumpFalse(stmtCond.getConditionRegister(), this.getEndLabel()));
                aCondASTs[i] = (ExprAST)holder.getAst(stmtCond);
                continue;
            }
            Expression exprCond = (Expression)cond;
            exprCond.generateConditionalJump(ctx, code, this.getEndLabel(), false, errs);
            fCompletes &= exprCond.isCompletable();
            aCondASTs[i] = exprCond.getExprAST(ctx);
        }
        this.m_astCond = BinaryAST.makeCondition(aCondASTs);
        return fCompletes;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.keyword.getId() == Token.Id.WHILE || this.keyword.getId() == Token.Id.FOR) {
            sb.append(this.keyword.getId().TEXT).append(" (").append(this.conds.get(0));
            int c = this.conds.size();
            for (int i = 1; i < c; ++i) {
                sb.append(", ").append(this.conds.get(i));
            }
            sb.append(")\n").append(Handy.indentLines(this.block.toString(), "    "));
        } else {
            assert (this.keyword.getId() == Token.Id.DO);
            sb.append("do").append('\n').append(Handy.indentLines(this.block.toString(), "    ")).append("\nwhile (");
            sb.append(this.conds.get(0));
            int c = this.conds.size();
            for (int i = 1; i < c; ++i) {
                sb.append(", ").append(this.conds.get(i));
            }
            sb.append(");");
        }
        return sb.toString();
    }

    @Override
    public String getDumpDesc() {
        return this.keyword.getId().TEXT;
    }
}

