/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.javajit;

import java.lang.classfile.CodeBuilder;
import java.lang.classfile.Label;
import java.lang.classfile.TypeKind;
import java.lang.constant.ClassDesc;
import java.lang.constant.ConstantDesc;
import java.lang.constant.ConstantDescs;
import java.lang.constant.MethodTypeDesc;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import org.xvm.asm.Annotation;
import org.xvm.asm.Constant;
import org.xvm.asm.ConstantPool;
import org.xvm.asm.Constants;
import org.xvm.asm.MethodStructure;
import org.xvm.asm.Op;
import org.xvm.asm.Parameter;
import org.xvm.asm.constants.AnnotatedTypeConstant;
import org.xvm.asm.constants.MethodBody;
import org.xvm.asm.constants.MethodInfo;
import org.xvm.asm.constants.PropertyConstant;
import org.xvm.asm.constants.PropertyInfo;
import org.xvm.asm.constants.RegisterConstant;
import org.xvm.asm.constants.StringConstant;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.asm.constants.TypeInfo;
import org.xvm.javajit.Builder;
import org.xvm.javajit.Ctx;
import org.xvm.javajit.JitFlavor;
import org.xvm.javajit.JitMethodDesc;
import org.xvm.javajit.JitParamDesc;
import org.xvm.javajit.JitTypeDesc;
import org.xvm.javajit.Scope;
import org.xvm.javajit.TypeSystem;

public class BuildContext {
    public final Builder builder;
    public final TypeSystem typeSystem;
    public final TypeInfo typeInfo;
    public final MethodBody[] callChain;
    public final MethodStructure methodStruct;
    public final JitMethodDesc jmd;
    public final boolean isOptimized;
    public final boolean isFunction;
    public final boolean isConstructor;
    public final Map<Integer, Slot> slots = new HashMap<Integer, Slot>();
    public int lineNumber;
    public int maxLocal;
    private Scope scope;
    private int tailSlot;
    private final Deque<Slot> tailStack = new ArrayDeque<Slot>();
    private final Map<Slot, Label> unassignedSlots = new IdentityHashMap<Slot, Label>();

    public BuildContext(Builder builder, TypeInfo typeInfo, MethodInfo methodInfo) {
        this.builder = builder;
        this.typeSystem = builder.typeSystem;
        this.typeInfo = typeInfo;
        this.callChain = methodInfo.getChain();
        this.methodStruct = this.callChain[0].getMethodStructure();
        this.jmd = methodInfo.getJitDesc(this.typeSystem);
        this.isFunction = methodInfo.isFunction();
        this.isConstructor = methodInfo.isConstructor();
        this.isOptimized = this.jmd.optimizedMD != null;
    }

    public BuildContext(Builder builder, TypeInfo typeInfo, PropertyInfo propInfo, boolean isGetter) {
        this.builder = builder;
        this.typeSystem = builder.typeSystem;
        this.typeInfo = typeInfo;
        this.callChain = isGetter ? propInfo.ensureOptimizedGetChain(typeInfo, null) : propInfo.ensureOptimizedSetChain(typeInfo, null);
        this.methodStruct = this.callChain[0].getMethodStructure();
        this.jmd = isGetter ? propInfo.getGetterJitDesc(this.typeSystem) : propInfo.getSetterJitDesc(this.typeSystem);
        this.isFunction = propInfo.isConstant();
        this.isConstructor = false;
        this.isOptimized = this.jmd.optimizedMD != null;
    }

    public ConstantPool pool() {
        return this.typeSystem.pool();
    }

    public Constant getConstant(int argId) {
        assert (argId <= -16);
        return this.methodStruct.getLocalConstants()[-16 - argId];
    }

    public String getString(int argId) {
        return ((StringConstant)this.getConstant(argId)).getValue();
    }

    public TypeConstant getType(int argId) {
        return this.resolveType((TypeConstant)this.getConstant(argId));
    }

    public TypeConstant resolveType(TypeConstant type) {
        if (type.containsFormalType(true) && type.containsFormalType(true)) {
            System.err.println("ERROR: Unresolved type " + String.valueOf(type));
        }
        if (this.isFunction || type.containsAutoNarrowing(true)) {
            // empty if block
        }
        return type;
    }

    public void enterMethod(CodeBuilder code) {
        this.lineNumber = 1;
        this.scope = new Scope(this, code);
        code.lineNumber(this.methodStruct.getSourceLineNumber() + 1).labelBinding(this.scope.startLabel).localVariable(code.parameterSlot(0), "$ctx", Builder.CD_Ctx, this.scope.startLabel, this.scope.endLabel);
        int extraArgs = this.jmd.getImplicitParamCount();
        TypeConstant thisType = this.typeInfo.getType();
        ClassDesc CD_this = thisType.ensureClassDesc(this.typeSystem);
        if (this.isConstructor) {
            this.slots.put(-5, new SingleSlot(extraArgs - 1, thisType.ensureAccess(Constants.Access.STRUCT), CD_this, "thi$"));
        } else if (!this.isFunction) {
            this.slots.put(-5, new SingleSlot(0, thisType, CD_this, "this$"));
        }
        JitParamDesc[] params = this.isOptimized ? this.jmd.optimizedParams : this.jmd.standardParams;
        int c = params.length;
        block4: for (int i = 0; i < c; ++i) {
            JitParamDesc paramDesc = params[i];
            int varIndex = paramDesc.index;
            Parameter param = this.methodStruct.getParam(varIndex);
            String name = param.getName();
            TypeConstant type = param.getType();
            int slot = code.parameterSlot(extraArgs + i);
            code.localVariable(slot, name, paramDesc.cd, this.scope.startLabel, this.scope.endLabel);
            switch (paramDesc.flavor) {
                case Specific: 
                case Widened: 
                case Primitive: 
                case SpecificWithDefault: 
                case WidenedWithDefault: {
                    this.slots.put(varIndex, new SingleSlot(slot, type, paramDesc.cd, name));
                    continue block4;
                }
                case MultiSlotPrimitive: 
                case PrimitiveWithDefault: {
                    int extSlot = code.parameterSlot(extraArgs + i + 1);
                    this.slots.put(varIndex, new DoubleSlot(slot, extSlot, paramDesc.flavor, type, paramDesc.cd, name));
                    ++i;
                }
            }
        }
        this.tailSlot = (this.isFunction ? 0 : 1) + extraArgs + this.methodStruct.getMaxVars() * 2;
    }

    public void exitMethod(CodeBuilder code) {
        code.labelBinding(this.scope.endLabel);
    }

    public void enterScope(CodeBuilder code) {
        this.scope = this.scope.enter();
    }

    public void exitScope(CodeBuilder code) {
        this.scope = this.scope.exit();
        this.slots.entrySet().removeIf(entry -> (Integer)entry.getKey() > this.scope.topVar);
    }

    public Label ensureLabel(CodeBuilder code, int opAddress) {
        Op[] ops = this.methodStruct.getOps();
        Op op = ops[opAddress];
        if (op instanceof org.xvm.asm.op.Label) {
            org.xvm.asm.op.Label label = (org.xvm.asm.op.Label)op;
            return label.getLabel();
        }
        Label javaLabel = code.newLabel();
        org.xvm.asm.op.Label xvmLabel = new org.xvm.asm.op.Label(opAddress);
        xvmLabel.setLabel(javaLabel);
        xvmLabel.append(op);
        ops[opAddress] = xvmLabel;
        return javaLabel;
    }

    public CodeBuilder loadCtx(CodeBuilder code) {
        code.aload(code.parameterSlot(0));
        return code;
    }

    public CodeBuilder loadCtorCtx(CodeBuilder code) {
        assert (this.isConstructor);
        code.aload(code.parameterSlot(1));
        return code;
    }

    public Slot loadThis(CodeBuilder code) {
        assert (this.isConstructor || !this.isFunction);
        Slot slot = this.slots.get(-5);
        code.aload(slot.slot());
        return slot;
    }

    public Slot loadArgument(CodeBuilder code, int argId) {
        if (argId >= 0) {
            Slot slot = this.getSlot(argId);
            assert (slot != null);
            ClassDesc cd = slot.cd();
            if (slot instanceof DoubleSlot) {
                DoubleSlot doubleSlot = (DoubleSlot)slot;
                switch (doubleSlot.flavor) {
                    case PrimitiveWithDefault: {
                        Parameter parameter = this.methodStruct.getParam(argId);
                        assert (parameter.hasDefaultValue());
                        Label ifTrue = code.newLabel();
                        Label endIf = code.newLabel();
                        code.iload(doubleSlot.extSlot).iconst_0().if_icmpne(ifTrue).loadLocal(Builder.toTypeKind(cd), doubleSlot.slot).goto_(endIf).labelBinding(ifTrue);
                        this.builder.loadConstant(code, parameter.getDefaultValue());
                        code.labelBinding(endIf);
                        return new SingleSlot(-1, slot.type(), cd, slot.name());
                    }
                    case MultiSlotPrimitive: {
                        code.loadLocal(Builder.toTypeKind(cd), doubleSlot.slot);
                        code.loadLocal(TypeKind.BOOLEAN, doubleSlot.extSlot);
                        return slot;
                    }
                }
            }
            code.loadLocal(Builder.toTypeKind(cd), slot.slot());
            return slot;
        }
        return argId <= -16 ? this.loadConstant(code, argId) : this.loadPredefineArgument(code, argId);
    }

    public Slot loadArgument(CodeBuilder code, int argId, JitTypeDesc targetDesc) {
        Slot slot = this.loadArgument(code, argId);
        if (slot.cd().isPrimitive() && !targetDesc.cd.isPrimitive()) {
            if (slot instanceof DoubleSlot) {
                DoubleSlot doubleSlot = (DoubleSlot)slot;
                assert (doubleSlot.flavor == JitFlavor.MultiSlotPrimitive);
                Label ifTrue = code.newLabel();
                Label endIf = code.newLabel();
                code.iconst_0().if_icmpne(ifTrue);
                this.builder.box(code, slot.type().removeNullable(), slot.cd());
                code.goto_(endIf).labelBinding(ifTrue);
                Builder.pop(code, doubleSlot.cd);
                Builder.loadNull(code);
                code.labelBinding(endIf);
                slot = new SingleSlot(-1, targetDesc.type, targetDesc.cd, slot.name() + "?");
            } else {
                this.builder.box(code, slot.type(), slot.cd());
                slot = new SingleSlot(-1, targetDesc.type, targetDesc.cd, slot.name());
            }
        }
        return slot;
    }

    public Slot loadConstant(CodeBuilder code, int argId) {
        return this.builder.loadConstant(code, this.getConstant(argId));
    }

    public Slot loadPredefineArgument(CodeBuilder code, int argId) {
        switch (argId) {
            case -1: {
                Slot slot = this.popSlot();
                this.loadValue(code, slot);
                return slot;
            }
            case -5: {
                return this.loadThis(code);
            }
        }
        throw new UnsupportedOperationException("id=" + argId);
    }

    public void loadValue(CodeBuilder code, Slot slot) {
        if (slot.isIgnore()) {
            throw new IllegalStateException();
        }
        if (slot instanceof DoubleSlot) {
            DoubleSlot doubleSlot = (DoubleSlot)slot;
            code.iload(doubleSlot.extSlot());
        }
        Builder.load(code, slot.cd(), slot.slot());
    }

    public void storeValue(CodeBuilder code, Slot slot) {
        if (slot instanceof DoubleSlot) {
            DoubleSlot doubleSlot = (DoubleSlot)slot;
            code.istore(doubleSlot.extSlot());
        }
        if (slot.isIgnore()) {
            Builder.pop(code, slot.cd());
        } else {
            Builder.store(code, slot.cd(), slot.slot());
        }
        Label varStart = this.unassignedSlots.remove(slot);
        if (varStart != null) {
            code.labelBinding(varStart);
        }
    }

    public Slot introduceVar(CodeBuilder code, int varIndex, int typeId, int nameId) {
        TypeConstant type = (TypeConstant)this.getConstant(typeId);
        String name = nameId == 0 ? "" : ((StringConstant)this.getConstant(nameId)).getValue();
        return this.introduceVar(code, varIndex, type, name);
    }

    public Slot introduceVar(CodeBuilder code, int varIndex, TypeConstant type, String name) {
        Record slot;
        if (varIndex < 0) {
            throw new IllegalArgumentException("Invalid var index: " + varIndex);
        }
        name = ((String)name).isEmpty() ? "v$" + varIndex : ((String)name).replace('#', '$').replace('.', '$');
        Label varStart = code.newLabel();
        ClassDesc cd = JitTypeDesc.getMultiSlotPrimitiveClass(type);
        if (cd != null) {
            int slotIndex = this.scope.allocateLocal(varIndex, Builder.toTypeKind(cd));
            int slotExt = this.scope.allocateLocal(varIndex, TypeKind.BOOLEAN);
            code.localVariable(slotIndex, (String)name, cd, varStart, this.scope.endLabel);
            code.localVariable(slotExt, (String)name + "$ext", ConstantDescs.CD_boolean, varStart, this.scope.endLabel);
            slot = new DoubleSlot(slotIndex, slotExt, JitFlavor.MultiSlotPrimitive, type, cd, (String)name);
        } else {
            cd = JitParamDesc.getJitClass(this.typeSystem, type);
            int slotIndex = this.scope.allocateLocal(varIndex, Builder.toTypeKind(cd));
            code.localVariable(slotIndex, (String)name, cd, varStart, this.scope.endLabel);
            slot = new SingleSlot(slotIndex, type, cd, (String)name);
        }
        this.slots.put(varIndex, (Slot)((Object)slot));
        this.unassignedSlots.put((Slot)((Object)slot), varStart);
        return slot;
    }

    public Slot introduceRef(CodeBuilder code, String name, TypeConstant type, int varIndex) {
        if (type instanceof AnnotatedTypeConstant) {
            AnnotatedTypeConstant annoType = (AnnotatedTypeConstant)type;
            type = type.getUnderlyingType();
            Annotation anno = annoType.getAnnotation();
            if (anno.getAnnotationClass().equals(this.pool().clzInject())) {
                RegisterConstant regConst;
                String resourceName;
                Constant optsConst;
                TypeConstant resourceType = type.getParamType(0);
                Constant[] params = anno.getParams();
                int paramCount = params.length;
                Constant nameConst = paramCount > 0 ? params[0] : null;
                Constant constant = optsConst = paramCount > 1 ? params[1] : null;
                if (nameConst instanceof StringConstant) {
                    StringConstant stringConst = (StringConstant)nameConst;
                    v1 = stringConst.getValue();
                } else {
                    v1 = resourceName = name;
                }
                if (!(optsConst == null || optsConst instanceof RegisterConstant && (regConst = (RegisterConstant)optsConst).getRegisterIndex() == -4)) {
                    throw new UnsupportedOperationException("retrieve opts");
                }
                Label varStart = code.newLabel();
                ClassDesc resourceCD = resourceType.ensureClassDesc(this.typeSystem);
                int slotIndex = this.scope.allocateLocal(varIndex, TypeKind.REFERENCE);
                SingleSlot slot = new SingleSlot(slotIndex, resourceType, resourceCD, name);
                code.localVariable(slotIndex, name, resourceCD, varStart, this.scope.endLabel);
                this.slots.put(varIndex, slot);
                int typeIndex = this.typeSystem.registerConstant(resourceType);
                this.loadCtx(code).dup().loadConstant(typeIndex).invokevirtual(Builder.CD_Ctx, "getConstant", Ctx.MD_getConstant).checkcast(Builder.CD_TypeConstant).ldc((ConstantDesc)((Object)resourceName)).aconst_null().invokevirtual(Builder.CD_Ctx, "inject", Ctx.MD_inject).astore(slot.slot()).labelBinding(varStart);
                return slot;
            }
        }
        throw new UnsupportedOperationException("name=" + name + "; type=" + String.valueOf(type));
    }

    public void loadArguments(CodeBuilder code, JitMethodDesc jmd, int[] anArgValue) {
        int c;
        boolean isOptimized = jmd.isOptimized;
        int n = c = anArgValue == null ? 0 : anArgValue.length;
        block4: for (int i = 0; i < c; ++i) {
            int iArg = anArgValue[i];
            JitParamDesc pd = isOptimized ? jmd.getOptimizedParam(i) : jmd.standardParams[i];
            switch (pd.flavor) {
                case SpecificWithDefault: {
                    if (iArg != -4) break;
                    code.aconst_null();
                    continue block4;
                }
                case PrimitiveWithDefault: {
                    if (iArg == -4) {
                        assert (isOptimized);
                        Builder.defaultLoad(code, pd.cd);
                        code.iconst_1();
                        continue block4;
                    }
                    this.loadArgument(code, iArg);
                    code.iconst_0();
                    continue block4;
                }
                default: {
                    assert (iArg != -4);
                    break;
                }
            }
            this.loadArgument(code, iArg, pd);
        }
    }

    public void buildGetProperty(CodeBuilder code, Slot targetSlot, int propIdIndex, int retIndex) {
        MethodTypeDesc md;
        if (!targetSlot.isSingle()) {
            throw new UnsupportedOperationException("Multislot P_Get");
        }
        PropertyConstant propId = (PropertyConstant)this.getConstant(propIdIndex);
        PropertyInfo propInfo = propId.getPropertyInfo();
        JitMethodDesc jmd = propInfo.getGetterJitDesc(this.typeSystem);
        Object getterName = propInfo.getGetterId().ensureJitMethodName(this.typeSystem);
        if (jmd.isOptimized) {
            md = jmd.optimizedMD;
            getterName = (String)getterName + "$p";
        } else {
            md = jmd.standardMD;
        }
        this.loadCtx(code);
        code.invokevirtual(targetSlot.cd(), (String)getterName, md);
        this.assignReturns(code, jmd, 1, new int[]{retIndex});
    }

    public void buildSetProperty(CodeBuilder code, Slot targetSlot, int propIdIndex, int valIndex) {
        MethodTypeDesc md;
        if (!targetSlot.isSingle()) {
            throw new UnsupportedOperationException("Multislot P_Set");
        }
        PropertyConstant propId = (PropertyConstant)this.getConstant(propIdIndex);
        PropertyInfo propInfo = propId.getPropertyInfo();
        JitMethodDesc jmd = propInfo.getSetterJitDesc(this.typeSystem);
        Object setterName = propInfo.getSetterId().ensureJitMethodName(this.typeSystem);
        if (jmd.isOptimized) {
            md = jmd.optimizedMD;
            setterName = (String)setterName + "$p";
        } else {
            md = jmd.standardMD;
        }
        this.loadCtx(code);
        Slot valueSlot = this.loadArgument(code, valIndex);
        if (!valueSlot.isSingle()) {
            throw new UnsupportedOperationException("Multislot L_Set");
        }
        code.invokevirtual(targetSlot.cd(), (String)setterName, md);
    }

    public void assignReturns(CodeBuilder code, JitMethodDesc jmd, int cReturns, int[] anVar) {
        boolean isOptimized = jmd.isOptimized;
        block6: for (int i = 0; i < cReturns; ++i) {
            Label endIf;
            Label ifTrue;
            JitParamDesc pdExt;
            int iOpt = isOptimized ? jmd.getOptimizedReturnIndex(i) : -1;
            JitParamDesc pdRet = isOptimized ? jmd.optimizedReturns[iOpt] : jmd.standardReturns[i];
            int nVar = anVar[i];
            TypeConstant typeRet = pdRet.type;
            ClassDesc cdRet = pdRet.cd;
            Slot slot = this.ensureSlot(nVar, typeRet, cdRet, "");
            if (i == 0) {
                switch (pdRet.flavor) {
                    case MultiSlotPrimitive: {
                        assert (isOptimized);
                        pdExt = jmd.optimizedReturns[iOpt + 1];
                        Builder.loadFromContext(code, ConstantDescs.CD_boolean, pdExt.altIndex);
                        if (slot.isSingle()) {
                            ifTrue = code.newLabel();
                            endIf = code.newLabel();
                            code.iconst_0().if_icmpne(ifTrue);
                            this.builder.box(code, typeRet, cdRet);
                            code.goto_(endIf).labelBinding(ifTrue).pop();
                            Builder.loadNull(code);
                            code.labelBinding(endIf);
                        }
                        this.storeValue(code, slot);
                        break;
                    }
                    default: {
                        this.storeValue(code, slot);
                        break;
                    }
                }
                continue;
            }
            switch (pdRet.flavor) {
                case MultiSlotPrimitive: {
                    assert (isOptimized);
                    pdExt = jmd.optimizedReturns[iOpt + 1];
                    Builder.loadFromContext(code, cdRet, pdExt.altIndex);
                    if (slot.isSingle()) {
                        ifTrue = code.newLabel();
                        endIf = code.newLabel();
                        code.iconst_0().if_icmpeq(ifTrue);
                        this.builder.box(code, typeRet, cdRet);
                        code.goto_(endIf);
                        code.labelBinding(ifTrue).pop();
                        Builder.loadNull(code);
                        code.labelBinding(endIf);
                    }
                    this.storeValue(code, slot);
                    continue block6;
                }
                default: {
                    Builder.loadFromContext(code, cdRet, pdRet.altIndex);
                    this.storeValue(code, slot);
                }
            }
        }
    }

    public Slot getSlot(int varIndex) {
        return this.slots.get(varIndex);
    }

    public Slot ensureSlot(int varIndex, TypeConstant type) {
        return this.ensureSlot(varIndex, type, JitTypeDesc.getJitClass(this.typeSystem, type), "name");
    }

    public Slot ensureSlot(int varIndex, TypeConstant type, ClassDesc cd, String name) {
        return varIndex == -1 ? this.pushSlot(type, cd, name) : this.slots.computeIfAbsent(varIndex, ix -> new SingleSlot(this.scope.allocateLocal((int)ix, Builder.toTypeKind(cd)), type, cd, name));
    }

    public Slot pushSlot(TypeConstant type, ClassDesc cd, String name) {
        SingleSlot slot = new SingleSlot(this.tailSlot, type, cd, name);
        this.tailSlot += Builder.toTypeKind(cd).slotSize();
        this.tailStack.push(slot);
        return slot;
    }

    public Slot pushExtSlot(TypeConstant type, ClassDesc cd, JitFlavor flavor, String name) {
        int slotIndex = this.tailSlot;
        this.tailSlot += Builder.toTypeKind(cd).slotSize();
        int slotExt = this.tailSlot++;
        DoubleSlot slot = new DoubleSlot(slotIndex, slotExt, flavor, type, cd, name);
        this.tailStack.push(slot);
        return slot;
    }

    public Slot popSlot() {
        Slot slot = this.tailStack.pop();
        this.tailSlot -= Builder.toTypeKind(slot.cd()).slotSize();
        if (slot instanceof DoubleSlot) {
            --this.tailSlot;
        }
        return slot;
    }

    public void popTempVar(CodeBuilder code) {
        Slot slot = this.popSlot();
        code.loadLocal(Builder.toTypeKind(slot.cd()), slot.slot());
    }

    public void pushTempVar(CodeBuilder code, TypeConstant type, ClassDesc cd) {
        Slot slot = this.pushSlot(type, cd, "");
        code.storeLocal(Builder.toTypeKind(cd), slot.slot());
    }

    public record SingleSlot(int slot, TypeConstant type, ClassDesc cd, String name) implements Slot
    {
        @Override
        public boolean isSingle() {
            return true;
        }
    }

    public record DoubleSlot(int slot, int extSlot, JitFlavor flavor, TypeConstant type, ClassDesc cd, String name) implements Slot
    {
        @Override
        public boolean isSingle() {
            return false;
        }
    }

    public static interface Slot {
        public int slot();

        public TypeConstant type();

        public ClassDesc cd();

        public String name();

        public boolean isSingle();

        default public boolean isIgnore() {
            return this.slot() == -2;
        }

        default public boolean isThis() {
            return this.slot() == -5;
        }
    }
}

