/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.javajit;

import java.lang.classfile.ClassBuilder;
import java.lang.classfile.CodeBuilder;
import java.lang.classfile.TypeKind;
import java.lang.constant.ClassDesc;
import java.lang.constant.ConstantDesc;
import java.lang.constant.ConstantDescs;
import java.lang.constant.MethodTypeDesc;
import org.xvm.asm.Constant;
import org.xvm.asm.ConstantPool;
import org.xvm.asm.constants.EnumValueConstant;
import org.xvm.asm.constants.IntConstant;
import org.xvm.asm.constants.LiteralConstant;
import org.xvm.asm.constants.NamedCondition;
import org.xvm.asm.constants.SingletonConstant;
import org.xvm.asm.constants.StringConstant;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.asm.constants.TypeInfo;
import org.xvm.javajit.BuildContext;
import org.xvm.javajit.Container;
import org.xvm.javajit.Ctx;
import org.xvm.javajit.JitFlavor;
import org.xvm.javajit.JitMethodDesc;
import org.xvm.javajit.JitParamDesc;
import org.xvm.javajit.JitTypeDesc;
import org.xvm.javajit.TypeSystem;

public abstract class Builder {
    public final TypeSystem typeSystem;
    public static final String N_Object = "org.xtclang.ecstasy.Object";
    public static final String N_Boolean = "org.xtclang.ecstasy.Boolean";
    public static final String N_Nullable = "org.xtclang.ecstasy.Nullable";
    public static final String N_xConst = "org.xtclang.ecstasy.xConst";
    public static final String N_xFunction = "org.xtclang.ecstasy.xFunction";
    public static final String N_xModule = "org.xtclang.ecstasy.xModule";
    public static final String N_xObj = "org.xtclang.ecstasy.xObj";
    public static final String N_xService = "org.xtclang.ecstasy.xService";
    public static final String N_xType = "org.xtclang.ecstasy.xType";
    public static final String N_Char = "org.xtclang.ecstasy.text.Char";
    public static final String N_String = "org.xtclang.ecstasy.text.String";
    public static final String N_Int64 = "org.xtclang.ecstasy.numbers.Int64";
    public static final String NEW = "$new";
    public static final String INIT = "$init";
    public static final String OPT = "$p";
    public static final String EXT = "$ext";
    public static final ClassDesc CD_xConst = ClassDesc.of("org.xtclang.ecstasy.xConst");
    public static final ClassDesc CD_xFunction = ClassDesc.of("org.xtclang.ecstasy.xFunction");
    public static final ClassDesc CD_xModule = ClassDesc.of("org.xtclang.ecstasy.xModule");
    public static final ClassDesc CD_xObj = ClassDesc.of("org.xtclang.ecstasy.xObj");
    public static final ClassDesc CD_Boolean = ClassDesc.of("org.xtclang.ecstasy.Boolean");
    public static final ClassDesc CD_Char = ClassDesc.of("org.xtclang.ecstasy.text.Char");
    public static final ClassDesc CD_Int64 = ClassDesc.of("org.xtclang.ecstasy.numbers.Int64");
    public static final ClassDesc CD_Nullable = ClassDesc.of("org.xtclang.ecstasy.Nullable");
    public static final ClassDesc CD_Object = ClassDesc.of("org.xtclang.ecstasy.Object");
    public static final ClassDesc CD_String = ClassDesc.of("org.xtclang.ecstasy.text.String");
    public static final ClassDesc CD_Container = ClassDesc.of(Container.class.getName());
    public static final ClassDesc CD_Ctx = ClassDesc.of(Ctx.class.getName());
    public static final ClassDesc CD_CtorCtx = ClassDesc.of(Ctx.CtorCtx.class.getName());
    public static final ClassDesc CD_TypeConstant = ClassDesc.of(TypeConstant.class.getName());
    public static final ClassDesc CD_TypeSystem = ClassDesc.of(TypeSystem.class.getName());
    public static final ClassDesc CD_JavaString = ClassDesc.of(String.class.getName());
    public static final ClassDesc CD_JavaObject = ClassDesc.of(Object.class.getName());
    public static final String Instance = "$INSTANCE";
    public static final MethodTypeDesc MD_Boolean_box = MethodTypeDesc.of(CD_Boolean, ConstantDescs.CD_boolean);
    public static final MethodTypeDesc MD_Char_box = MethodTypeDesc.of(CD_Char, ConstantDescs.CD_int);
    public static final MethodTypeDesc MD_Int64_box = MethodTypeDesc.of(CD_Int64, ConstantDescs.CD_long);
    public static final MethodTypeDesc MD_Initializer = MethodTypeDesc.of(ConstantDescs.CD_void, CD_Ctx);

    public Builder(TypeSystem typeSystem) {
        this.typeSystem = typeSystem;
    }

    public void assembleImpl(String className, ClassBuilder classBuilder) {
        throw new UnsupportedOperationException();
    }

    public void assemblePure(String className, ClassBuilder classBuilder) {
        throw new UnsupportedOperationException();
    }

    public MethodTypeDesc computeMethodDesc(TypeConstant[] paramTypes, TypeConstant[] returnTypes) {
        int paramCount = paramTypes.length;
        ClassDesc[] paramCDs = new ClassDesc[paramCount + 1];
        paramCDs[0] = ClassDesc.of(Ctx.class.getName());
        for (int i = 0; i < paramCount; ++i) {
            paramCDs[i + 1] = paramTypes[i].ensureClassDesc(this.typeSystem);
        }
        return MethodTypeDesc.of(returnTypes.length == 0 ? ConstantDescs.CD_void : returnTypes[0].ensureClassDesc(this.typeSystem), paramCDs);
    }

    public BuildContext.Slot loadConstant(CodeBuilder code, Constant constant) {
        if (constant instanceof StringConstant) {
            StringConstant stringConst = (StringConstant)constant;
            MethodTypeDesc MD_of = MethodTypeDesc.of(CD_String, CD_Ctx, CD_JavaString);
            code.aload(code.parameterSlot(0)).ldc((ConstantDesc)((Object)stringConst.getValue())).invokestatic(CD_String, "of", MD_of);
            return new BuildContext.SingleSlot(-1, constant.getType(), CD_String, "");
        }
        if (constant instanceof IntConstant) {
            IntConstant intConstant = (IntConstant)constant;
            code.ldc((ConstantDesc)Long.valueOf(intConstant.getValue().getLong()));
            return new BuildContext.SingleSlot(-1, constant.getType(), ConstantDescs.CD_long, "");
        }
        if (constant instanceof EnumValueConstant) {
            EnumValueConstant enumConstant = (EnumValueConstant)constant;
            ConstantPool pool = constant.getConstantPool();
            if (enumConstant.getType().isOnlyNullable()) {
                Builder.loadNull(code);
                return new BuildContext.SingleSlot(-1, pool.typeNullable(), CD_Nullable, "");
            }
            if (enumConstant.getType().isA(pool.typeBoolean())) {
                if (enumConstant.getIntValue().getInt() == 0) {
                    code.iconst_0();
                } else {
                    code.iconst_1();
                }
                return new BuildContext.SingleSlot(-1, pool.typeBoolean(), ConstantDescs.CD_boolean, "");
            }
        }
        if (constant instanceof LiteralConstant) {
            LiteralConstant litConstant = (LiteralConstant)constant;
            switch (litConstant.getFormat()) {
                case IntLiteral: {
                    break;
                }
            }
        }
        if (constant instanceof SingletonConstant) {
            SingletonConstant singleton = (SingletonConstant)constant;
            TypeConstant type = singleton.getType();
            JitTypeDesc jtd = type.getJitDesc(this.typeSystem);
            assert (jtd.flavor == JitFlavor.Specific);
            ClassDesc cd = jtd.cd;
            code.getstatic(cd, Instance, cd);
            return new BuildContext.SingleSlot(-1, type, cd, "");
        }
        if (constant instanceof NamedCondition) {
            NamedCondition cond = (NamedCondition)constant;
            code.loadConstant((ConstantDesc)((Object)cond.getName()));
            return new BuildContext.SingleSlot(-1, cond.getConstantPool().typeString(), CD_String, "");
        }
        throw new UnsupportedOperationException(constant.toString());
    }

    public static void load(CodeBuilder code, ClassDesc cd, int slot) {
        if (cd.isPrimitive()) {
            switch (cd.descriptorString()) {
                case "I": 
                case "S": 
                case "B": 
                case "C": 
                case "Z": {
                    code.iload(slot);
                    break;
                }
                case "J": {
                    code.lload(slot);
                    break;
                }
                case "F": {
                    code.fload(slot);
                    break;
                }
                case "D": {
                    code.dload(slot);
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        } else {
            code.aload(slot);
        }
    }

    public static void store(CodeBuilder code, ClassDesc cd, int slot) {
        if (cd.isPrimitive()) {
            switch (cd.descriptorString()) {
                case "I": 
                case "S": 
                case "B": 
                case "C": 
                case "Z": {
                    code.istore(slot);
                    break;
                }
                case "J": {
                    code.lstore(slot);
                    break;
                }
                case "F": {
                    code.fstore(slot);
                    break;
                }
                case "D": {
                    code.dstore(slot);
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        } else {
            code.astore(slot);
        }
    }

    public static void defaultLoad(CodeBuilder code, ClassDesc cd) {
        if (cd.isPrimitive()) {
            switch (cd.descriptorString()) {
                case "I": 
                case "S": 
                case "B": 
                case "C": 
                case "Z": {
                    code.iconst_0();
                    break;
                }
                case "J": {
                    code.lconst_0();
                    break;
                }
                case "F": {
                    code.fconst_0();
                    break;
                }
                case "D": {
                    code.dconst_0();
                    break;
                }
            }
        } else {
            code.aconst_null();
        }
    }

    public static void loadNull(CodeBuilder code) {
        code.getstatic(CD_Nullable, "Null", CD_Nullable);
    }

    public static void addReturn(CodeBuilder code, ClassDesc cd) {
        if (cd.isPrimitive()) {
            switch (cd.descriptorString()) {
                case "I": 
                case "S": 
                case "B": 
                case "C": 
                case "Z": {
                    code.ireturn();
                    break;
                }
                case "J": {
                    code.lreturn();
                    break;
                }
                case "F": {
                    code.freturn();
                    break;
                }
                case "D": {
                    code.dreturn();
                    break;
                }
                case "V": {
                    code.return_();
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        } else {
            code.areturn();
        }
    }

    public static void pop(CodeBuilder code, ClassDesc cd) {
        if (cd.isPrimitive()) {
            switch (cd.descriptorString()) {
                case "J": 
                case "D": {
                    code.pop2();
                    break;
                }
                default: {
                    code.pop();
                    break;
                }
            }
        } else {
            code.pop();
        }
    }

    public void unbox(CodeBuilder code, TypeConstant type, ClassDesc cd) {
        assert (cd.isPrimitive() && type.isPrimitive());
        ConstantPool pool = type.getConstantPool();
        switch (cd.descriptorString()) {
            case "Z": {
                assert (type.equals(pool.typeBoolean()));
                code.getfield(CD_Boolean, "$value", cd);
                break;
            }
            case "J": {
                if (type.equals(pool.typeInt64())) {
                    code.getfield(CD_Int64, "$value", cd);
                    break;
                }
                code.getfield(type.ensureClassDesc(this.typeSystem), "$value", cd);
                break;
            }
            case "I": {
                if (type.equals(pool.typeChar())) {
                    code.getfield(CD_Char, "codepoint", cd);
                    break;
                }
                throw new UnsupportedOperationException();
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
    }

    public void box(CodeBuilder code, TypeConstant type, ClassDesc cd) {
        assert (cd.isPrimitive() && type.isPrimitive());
        ConstantPool pool = type.getConstantPool();
        switch (cd.descriptorString()) {
            case "Z": {
                assert (type.equals(pool.typeBoolean()));
                code.invokestatic(CD_Boolean, "$box", MD_Boolean_box);
                break;
            }
            case "J": {
                if (type.equals(pool.typeInt64())) {
                    code.invokestatic(CD_Int64, "$box", MD_Int64_box);
                    break;
                }
                ClassDesc boxCD = type.ensureClassDesc(this.typeSystem);
                MethodTypeDesc boxMD = MethodTypeDesc.of(boxCD, cd);
                code.invokestatic(boxCD, "$box", boxMD);
                break;
            }
            case "I": {
                if (type.equals(pool.typeChar())) {
                    code.invokestatic(CD_Char, "$box", MD_Char_box);
                    break;
                }
                throw new UnsupportedOperationException();
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
    }

    public static TypeKind toTypeKind(ClassDesc cd) {
        return switch (cd.descriptorString()) {
            case "B" -> TypeKind.BYTE;
            case "C" -> TypeKind.CHAR;
            case "D" -> TypeKind.DOUBLE;
            case "F" -> TypeKind.FLOAT;
            case "I" -> TypeKind.INT;
            case "J" -> TypeKind.LONG;
            case "S" -> TypeKind.SHORT;
            case "Z" -> TypeKind.BOOLEAN;
            case "V" -> TypeKind.VOID;
            default -> TypeKind.REFERENCE;
        };
    }

    public static void loadFromContext(CodeBuilder code, ClassDesc cd, int returnIndex) {
        assert (returnIndex >= 0);
        code.aload(code.parameterSlot(0));
        if (cd.isPrimitive()) {
            if (returnIndex < 8) {
                code.getfield(CD_Ctx, "i" + returnIndex, ConstantDescs.CD_long);
            } else {
                code.getfield(CD_Ctx, "iN", ConstantDescs.CD_long.arrayType()).loadConstant(returnIndex - 8).aaload();
            }
            switch (cd.descriptorString()) {
                case "I": 
                case "S": 
                case "B": 
                case "C": 
                case "Z": {
                    code.l2i();
                    break;
                }
                case "J": {
                    break;
                }
                case "F": {
                    code.l2f();
                    break;
                }
                case "D": {
                    code.l2d();
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        } else if (returnIndex < 8) {
            code.getfield(CD_Ctx, "o" + (returnIndex - 1), CD_Object);
        } else {
            code.getfield(CD_Ctx, "oN", CD_Object.arrayType()).loadConstant(returnIndex - 8).aaload();
        }
    }

    public static void storeToContext(CodeBuilder code, ClassDesc cd, int returnIndex) {
        assert (returnIndex >= 0);
        code.aload(code.parameterSlot(0));
        if (cd.isPrimitive() && cd.descriptorString().equals("J")) {
            code.dup_x2().pop();
        } else {
            code.swap();
        }
        if (cd.isPrimitive()) {
            switch (cd.descriptorString()) {
                case "I": 
                case "S": 
                case "B": 
                case "C": 
                case "Z": {
                    code.i2l();
                    break;
                }
                case "J": {
                    break;
                }
                case "F": {
                    code.f2l();
                    break;
                }
                case "D": {
                    code.d2l();
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            if (returnIndex < 8) {
                code.putfield(CD_Ctx, "i" + returnIndex, ConstantDescs.CD_long);
            } else {
                code.getfield(CD_Ctx, "iN", ConstantDescs.CD_long.arrayType()).loadConstant(returnIndex - 8).aastore();
            }
        } else if (returnIndex < 8) {
            code.putfield(CD_Ctx, "o" + returnIndex, CD_Object);
        } else {
            code.getfield(CD_Ctx, "oN", CD_Object.arrayType()).loadConstant(returnIndex - 8).aastore();
        }
    }

    public static JitMethodDesc convertConstructToNew(TypeInfo typeInfo, String className, JitMethodDesc jmdCtor) {
        JitParamDesc retDesc = new JitParamDesc(typeInfo.getType(), JitFlavor.Specific, ClassDesc.of(className), 0, -1, false);
        JitParamDesc[] standardReturns = new JitParamDesc[]{retDesc};
        JitParamDesc[] optimizedReturns = jmdCtor.isOptimized ? standardReturns : null;
        return new JitMethodDesc(standardReturns, jmdCtor.standardParams, optimizedReturns, jmdCtor.optimizedParams);
    }
}

