/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.javajit;

import org.xvm.asm.LinkerContext;
import org.xvm.asm.constants.IdentityConstant;
import org.xvm.asm.constants.ModuleConstant;
import org.xvm.asm.constants.VersionConstant;
import org.xvm.javajit.Injector;
import org.xvm.javajit.TypeSystem;
import org.xvm.javajit.Xvm;
import org.xvm.util.Handy;

public class Container
implements LinkerContext {
    public final Xvm xvm;
    public final Container parent;
    public final TypeSystem typeSystem;
    public final Injector injector;
    public final long id;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    Container(Container parent, long id, TypeSystem typeSystem, Injector injector) {
        if (id < 0L) {
            if (id != -1L) throw new IllegalArgumentException("illegal id: " + id);
            if (parent != null) {
                throw new IllegalArgumentException("the native container (-1) can not have a parent");
            }
        } else {
            Handy.require("parent", parent);
        }
        Handy.require("typeSystem", typeSystem);
        Handy.require("injector", injector);
        this.xvm = typeSystem.xvm;
        this.parent = parent;
        this.id = id;
        this.typeSystem = typeSystem;
        this.injector = injector;
    }

    public boolean isCore() {
        return this.id == -1L;
    }

    public boolean isMain() {
        return this.parent.isCore();
    }

    public boolean isNested() {
        return !this.isCore() && !this.isMain();
    }

    @Override
    public boolean isSpecified(String sName) {
        return switch (sName) {
            case "debug", "test" -> true;
            default -> false;
        };
    }

    @Override
    public boolean isPresent(IdentityConstant constId) {
        return constId.getModuleConstant().equals(this.typeSystem.mainModule().getIdentityConstant());
    }

    @Override
    public boolean isVersionMatch(ModuleConstant constModule, VersionConstant constVer) {
        return true;
    }

    @Override
    public boolean isVersion(VersionConstant constVer) {
        return true;
    }
}

