/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.javajit;

import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import java.util.Set;
import org.xvm.api.Connector;
import org.xvm.asm.ConstantPool;
import org.xvm.asm.MethodStructure;
import org.xvm.asm.ModuleRepository;
import org.xvm.asm.ModuleStructure;
import org.xvm.javajit.Container;
import org.xvm.javajit.Ctx;
import org.xvm.javajit.Injector;
import org.xvm.javajit.TypeSystem;
import org.xvm.javajit.TypeSystemLoader;
import org.xvm.javajit.Xvm;
import org.xvm.util.Auto;

public class JitConnector
extends Connector {
    public final Xvm xvm;
    private TypeSystem ts;
    private ModuleStructure module;
    private Container container;
    private long result = 1L;

    public JitConnector(ModuleRepository repo) {
        super(repo);
        this.xvm = new Xvm(repo);
    }

    @Override
    public void loadModule(String appName) {
        this.module = this.f_repository.loadModule(appName);
        if (this.module == null) {
            throw new IllegalStateException("Unable to load module \"" + appName + "\"");
        }
        this.ts = this.xvm.createLinker().addModule(this.module).link();
    }

    @Override
    public ConstantPool getConstantPool() {
        return this.module.getConstantPool();
    }

    @Override
    public void start(Map<String, String> mapInjections) {
        try {
            TypeSystemLoader loader = this.xvm.nativeTypeSystem.loader;
            Class<?> clz = loader.loadClass("org.xtclang._native.mgmt.xMainInjector");
            Injector injector = (Injector)clz.getDeclaredConstructor(Xvm.class).newInstance(this.xvm);
            try (Auto ignore = ConstantPool.withPool(this.xvm.nativeTypeSystem.pool());){
                clz.getMethod("addNativeResources", new Class[0]).invoke((Object)injector, new Object[0]);
            }
            this.container = this.xvm.createContainer(this.ts, injector);
        }
        catch (ClassNotFoundException | NoClassDefFoundError e) {
            throw new RuntimeException("Failed to load xMainInjector", e);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException("Failed to invoke \"addNativeResources()\" method", e);
        }
    }

    @Override
    public Set<MethodStructure> findMethods(String sMethodName) {
        return this.findMethods(this.module.getIdentityConstant(), sMethodName);
    }

    @Override
    public void invoke0(MethodStructure methodStructure, String ... asArg) {
        ScopedValue.where(Ctx.Current, new Ctx(this.xvm, this.container)).run(() -> this.invoke0Impl(methodStructure, asArg));
    }

    public void invoke0Impl(MethodStructure methodStructure, String ... asArg) {
        String typeName = this.ts.owned[0].module.getIdentityConstant().getType().ensureJitClassName(this.ts);
        try {
            Object result;
            TypeSystemLoader loader = this.ts.loader;
            Class<?> clz = loader.loadClass(typeName);
            Ctx ctx = Ctx.get();
            Object module = clz.getDeclaredConstructor(Ctx.class).newInstance(ctx);
            loader.dump();
            if (asArg == null || asArg.length == 0) {
                method = clz.getMethod("run", Ctx.class);
                result = method.invoke(module, ctx);
            } else {
                method = clz.getMethod("run", new Class[]{Ctx.class, String.class.arrayType()});
                result = method.invoke(module, ctx, asArg);
            }
            if (result instanceof Long) {
                Long lr = (Long)result;
                this.result = lr;
            }
        }
        catch (ClassNotFoundException | NoClassDefFoundError e) {
            e.printStackTrace();
            throw new RuntimeException("Failed to load class \"" + typeName + "\"", e);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("No \"run()\" method", e);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            e.printStackTrace();
            throw new RuntimeException("Failed to invoke \"run()\" method", e);
        }
    }

    @Override
    public int join() {
        return (int)this.result;
    }
}

