/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.javajit;

import java.lang.constant.ClassDesc;
import org.xvm.asm.ClassStructure;
import org.xvm.asm.constants.MethodBody;
import org.xvm.javajit.Builder;
import org.xvm.javajit.JitMethodDesc;
import org.xvm.javajit.JitParamDesc;
import org.xvm.javajit.TypeSystem;

public class JitCtorDesc
extends JitMethodDesc {
    protected final TypeSystem ts;
    protected final MethodBody methodBody;

    public JitCtorDesc(TypeSystem ts, MethodBody methodBody, JitParamDesc[] standardReturns, JitParamDesc[] standardParams, JitParamDesc[] optimizedReturns, JitParamDesc[] optimizedParams) {
        this.ts = ts;
        this.methodBody = methodBody;
        super(standardReturns, standardParams, optimizedReturns, optimizedParams);
    }

    @Override
    public int getImplicitParamCount() {
        return 3;
    }

    @Override
    protected void fillExtraClassDesc(ClassDesc[] paramCDs) {
        super.fillExtraClassDesc(paramCDs);
        ClassStructure clz = this.methodBody.getMethodStructure().getContainingClass();
        paramCDs[1] = Builder.CD_CtorCtx;
        paramCDs[2] = clz.getCanonicalType().ensureClassDesc(this.ts);
    }
}

