/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.javajit;

import java.lang.constant.ClassDesc;
import java.lang.constant.ConstantDescs;
import java.lang.constant.MethodTypeDesc;
import org.xvm.javajit.Builder;
import org.xvm.javajit.JitParamDesc;

public class JitMethodDesc {
    public final JitParamDesc[] standardReturns;
    public final JitParamDesc[] standardParams;
    public final JitParamDesc[] optimizedReturns;
    public final JitParamDesc[] optimizedParams;
    public final boolean isOptimized;
    public final MethodTypeDesc standardMD;
    public final MethodTypeDesc optimizedMD;

    public JitMethodDesc(JitParamDesc[] standardReturns, JitParamDesc[] standardParams, JitParamDesc[] optimizedReturns, JitParamDesc[] optimizedParams) {
        this.standardReturns = standardReturns;
        this.standardParams = standardParams;
        this.optimizedReturns = optimizedReturns;
        this.optimizedParams = optimizedParams;
        this.isOptimized = optimizedParams != null && optimizedReturns != null;
        this.standardMD = this.computeMethodDesc(standardReturns, standardParams);
        this.optimizedMD = this.isOptimized ? this.computeMethodDesc(optimizedReturns, optimizedParams) : null;
    }

    public JitParamDesc getOptimizedParam(int argIndex) {
        return this.optimizedParams[this.getOptimizedParamIndex(argIndex)];
    }

    public int getOptimizedParamIndex(int argIndex) {
        int c = this.optimizedParams.length;
        for (int i = 0; i < c; ++i) {
            if (this.optimizedParams[i].index != argIndex) continue;
            return i;
        }
        throw new IllegalArgumentException("Invalid arg index");
    }

    public JitParamDesc getOptimizedReturn(int retIndex) {
        return this.optimizedReturns[this.getOptimizedReturnIndex(retIndex)];
    }

    public int getOptimizedReturnIndex(int retIndex) {
        int c = this.optimizedReturns.length;
        for (int i = 0; i < c; ++i) {
            if (this.optimizedReturns[i].index != retIndex) continue;
            return i;
        }
        throw new IllegalArgumentException("Invalid return index");
    }

    protected MethodTypeDesc computeMethodDesc(JitParamDesc[] returns, JitParamDesc[] params) {
        int extraCount = this.getImplicitParamCount();
        int paramCount = params.length;
        ClassDesc[] paramCDs = new ClassDesc[paramCount + extraCount];
        this.fillExtraClassDesc(paramCDs);
        for (int i = 0; i < paramCount; ++i) {
            paramCDs[extraCount + i] = params[i].cd;
        }
        return MethodTypeDesc.of(returns.length == 0 ? ConstantDescs.CD_void : returns[0].cd, paramCDs);
    }

    public int getImplicitParamCount() {
        return 1;
    }

    protected void fillExtraClassDesc(ClassDesc[] paramCDs) {
        paramCDs[0] = Builder.CD_Ctx;
    }
}

