/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.javajit;

import java.lang.constant.ClassDesc;
import java.lang.constant.ConstantDescs;
import org.xvm.asm.ConstantPool;
import org.xvm.asm.constants.IdentityConstant;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.javajit.Builder;
import org.xvm.javajit.JitFlavor;
import org.xvm.javajit.JitParamDesc;
import org.xvm.javajit.TypeSystem;

public class JitTypeDesc {
    public final TypeConstant type;
    public final JitFlavor flavor;
    public final ClassDesc cd;

    public JitTypeDesc(TypeConstant type, JitFlavor flavor, ClassDesc cd) {
        this.type = type;
        this.flavor = flavor;
        this.cd = cd;
    }

    public static ClassDesc getJitClass(TypeSystem ts, TypeConstant type) {
        return type.isPrimitive() ? JitParamDesc.getPrimitiveClass(type) : (type.isSingleUnderlyingClass(true) ? type.ensureClassDesc(ts) : Builder.CD_xObj);
    }

    public static ClassDesc getPrimitiveClass(TypeConstant type) {
        ConstantPool pool = type.getConstantPool();
        if (type.isSingleUnderlyingClass(false)) {
            IdentityConstant id = type.getSingleUnderlyingClass(false);
            if (id.getName().startsWith("Int")) {
                if (type.equals(pool.typeInt64()) || type.equals(pool.typeInt32()) || type.equals(pool.typeInt16()) || type.equals(pool.typeInt8())) {
                    return ConstantDescs.CD_long;
                }
            } else if (id.getName().startsWith("UInt")) {
                if (type.equals(pool.typeUInt64()) || type.equals(pool.typeUInt32()) || type.equals(pool.typeUInt16()) || type.equals(pool.typeUInt8())) {
                    return ConstantDescs.CD_long;
                }
            } else {
                if (type.equals(pool.typeBoolean())) {
                    return ConstantDescs.CD_boolean;
                }
                if (type.equals(pool.typeChar())) {
                    return ConstantDescs.CD_int;
                }
            }
        }
        return null;
    }

    public static ClassDesc getMultiSlotPrimitiveClass(TypeConstant type) {
        return type.isNullable() ? JitTypeDesc.getPrimitiveClass(type.removeNullable()) : null;
    }

    public static ClassDesc getWidenedClass(TypeConstant type) {
        if (!type.isSingleUnderlyingClass(true)) {
            return Builder.CD_xObj;
        }
        return null;
    }
}

