/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.javajit;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.xvm.asm.ErrorList;
import org.xvm.asm.ErrorListener;
import org.xvm.asm.FileStructure;
import org.xvm.asm.ModuleRepository;
import org.xvm.asm.ModuleStructure;
import org.xvm.javajit.ModuleLoader;
import org.xvm.javajit.Refiner;
import org.xvm.javajit.TypeSystem;
import org.xvm.javajit.TypeSystemLoader;
import org.xvm.javajit.Xvm;
import org.xvm.util.Handy;
import org.xvm.util.Severity;

public class Linker {
    private final Xvm xvm;
    private final ArrayList<ModuleLoader> sharedLoaders = new ArrayList();
    private final Map<String, Boolean> defines = new HashMap<String, Boolean>();
    private ModuleRepository repo;
    private Refiner refiner = Refiner.DefaultRefiner;
    private final ArrayList<ModuleStructure> modules = new ArrayList();
    private final ErrorList errors = new ErrorList(24);
    private boolean bad = false;
    public static final String LNK_NOREPO = "LNK_NOREPO";
    public static final String LNK_MODULE_LOAD = "LNK_MODULE_LOAD";
    public static final String LNK_REDEF = "LNK_REDEF";
    public static final String LNK_MAIN_EXISTS = "LNK_MAIN_EXISTS";

    protected Linker(Xvm xvm) {
        this.xvm = xvm;
        this.repo = xvm.systemRepo;
    }

    public Linker addSharedModules(TypeSystem typeSystem) {
        Handy.require("typeSystem", typeSystem);
        return this.addSharedModules(typeSystem.loader);
    }

    public Linker addSharedModules(TypeSystemLoader loader) {
        Handy.require("loader", loader);
        Linker linker = this;
        for (ModuleLoader module : loader.shared) {
            linker = linker.addSharedModule(module);
        }
        for (ModuleLoader module : loader.owned) {
            linker = linker.addSharedModule(module);
        }
        return linker;
    }

    public Linker addSharedModule(ModuleLoader loader) {
        Handy.require("loader", loader);
        if (!this.isBad() && !this.sharedLoaders.contains(loader)) {
            this.sharedLoaders.add(loader);
        }
        return this;
    }

    public Linker define(String name, boolean defined) {
        Handy.require("name", name);
        if (this.defines.containsKey(name) && defined != this.defines.get(name)) {
            this.log(this.modules.isEmpty() ? Severity.WARNING : Severity.ERROR, LNK_REDEF, name);
        }
        this.defines.put(name, defined);
        return this;
    }

    public Linker define(Collection<String> names, boolean defined) {
        Handy.require("names", names);
        Linker linker = this;
        for (String name : names) {
            linker = linker.define(name, defined);
        }
        return linker;
    }

    public boolean specified(String name) {
        Handy.require("name", name);
        return this.defines.containsKey(name);
    }

    public boolean defined(String name) {
        Handy.require("name", name);
        return this.defines.get(name) == Boolean.TRUE;
    }

    public boolean undefined(String name) {
        Handy.require("name", name);
        return this.defines.get(name) == Boolean.FALSE;
    }

    public Map<String, Boolean> defines() {
        return Collections.unmodifiableMap(this.defines);
    }

    public Linker withRepo(ModuleRepository repo) {
        Handy.require("repo", repo);
        this.repo = repo;
        return this;
    }

    public ModuleRepository repo() {
        return this.repo;
    }

    public Linker withRefiner(Refiner refiner) {
        Handy.require("Refiner", refiner);
        this.refiner = refiner;
        return this;
    }

    public Refiner refiner() {
        return this.refiner;
    }

    public Linker withMain(String moduleName) {
        Handy.require("moduleName", moduleName);
        if (!this.isBad()) {
            if (this.modules.isEmpty()) {
                ModuleStructure module = this.loadModule(moduleName);
                if (module != null) {
                    return this.withMain(module);
                }
            } else {
                this.log(Severity.ERROR, LNK_MAIN_EXISTS, this.modules.get(0).getName(), moduleName);
            }
        }
        return this;
    }

    public Linker withMain(ModuleStructure module) {
        Handy.require("module", module);
        if (!this.isBad()) {
            if (this.modules.isEmpty()) {
                return this.addModule(module);
            }
            this.log(Severity.ERROR, LNK_MAIN_EXISTS, this.modules.get(0).getName(), module.getName());
        }
        return this;
    }

    public Linker addModule(String moduleName) {
        ModuleStructure module;
        Handy.require("moduleName", moduleName);
        if (!this.isBad() && (module = this.loadModule(moduleName)) != null) {
            return this.addModule(module);
        }
        return this;
    }

    public Linker addModule(ModuleStructure module) {
        Handy.require("module", module);
        if (!this.isBad()) {
            this.modules.add(module);
        }
        return this;
    }

    public ErrorList errorList() {
        if (this.errors.hasErrors()) {
            this.bad = true;
        }
        return this.errors;
    }

    public boolean isBad() {
        return this.bad || this.errorList().hasErrors();
    }

    public TypeSystem link() {
        if (this.isBad()) {
            return null;
        }
        ModuleLoader[] shared = this.sharedLoaders.toArray(new ModuleLoader[0]);
        ModuleStructure[] owned = this.modules.toArray(new ModuleStructure[0]);
        FileStructure mainFile = owned[0].getFileStructure();
        ModuleStructure ecstasy = shared[0].module;
        mainFile.removeChild(mainFile.getChild(ecstasy.getIdentityConstant()));
        mainFile.addChild(ecstasy);
        mainFile.getConstantPool().setNakedRefType(ecstasy.getConstantPool().getNakedRefType());
        if (this.isBad()) {
            return null;
        }
        return this.xvm.ensureTypeSystem(shared, owned);
    }

    protected ModuleStructure loadModule(String moduleName) {
        ModuleRepository repo = this.repo();
        if (repo == null) {
            this.log(Severity.ERROR, LNK_NOREPO, moduleName);
            return null;
        }
        ModuleStructure module = repo.loadModule(moduleName);
        if (module == null) {
            this.log(Severity.ERROR, LNK_MODULE_LOAD, moduleName);
        }
        return module;
    }

    protected void log(Severity severity, String code, Object ... params) {
        this.errors.log(new ErrorListener.ErrorInfo(severity, code, params, null, 0L, 0L));
    }
}

