/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.javajit;

import java.lang.classfile.ClassFile;
import java.lang.classfile.ClassModel;
import java.lang.classfile.CodeModel;
import java.util.ArrayList;
import java.util.List;
import org.xvm.asm.ModuleStructure;
import org.xvm.javajit.TypeSystem;
import org.xvm.javajit.TypeSystemLoader;
import org.xvm.util.Handy;

public class ModuleLoader
extends ClassLoader {
    public final ModuleStructure module;
    public final String pkg;
    public final String prefix;
    public final TypeSystem typeSystem;
    private final List<ClassModel> loadedClasses = new ArrayList<ClassModel>();

    ModuleLoader(TypeSystemLoader parent, ModuleStructure module, String pkg) {
        super("module:" + pkg, parent);
        Handy.require("parent", parent);
        Handy.require("module", module);
        Handy.require("pkg", pkg);
        assert (pkg.indexOf(47) < 0);
        assert (pkg.indexOf(46) > 0);
        assert (module.isRefined());
        this.module = module;
        this.pkg = pkg;
        this.prefix = pkg + ".";
        this.typeSystem = parent.typeSystem;
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        if (name.startsWith(this.prefix)) {
            Class<?> clz = this.findLoadedClass(name);
            if (clz != null) {
                assert (clz.getClassLoader() == this);
                return clz;
            }
            String suffix = name.substring(this.prefix.length());
            byte[] classBytes = this.typeSystem.genClass(this, suffix);
            if (classBytes == null) {
                throw new ClassNotFoundException(name);
            }
            clz = this.defineClass(name, classBytes, 0, classBytes.length);
            this.loadedClasses.add(ClassFile.of().parse(classBytes));
            return clz;
        }
        ClassLoader classLoader = this.getParent();
        if (classLoader instanceof TypeSystemLoader) {
            TypeSystemLoader tsLoader = (TypeSystemLoader)classLoader;
            return tsLoader.findClass(name);
        }
        throw new ClassNotFoundException(name);
    }

    public String toString() {
        return this.module.toString();
    }

    public void dump() {
        int iters = 2;
        do {
            ArrayList<ClassModel> currentlyLoaded = new ArrayList<ClassModel>(this.loadedClasses);
            this.loadedClasses.clear();
            for (ClassModel model : currentlyLoaded) {
                System.out.println("\n**** Class " + model.thisClass().asSymbol().displayName());
                model.superclass().ifPresent(ce -> System.out.println("Extends: " + ce.asSymbol().displayName()));
                List interfaces = model.interfaces();
                if (!interfaces.isEmpty()) {
                    System.out.println("Implements:");
                    interfaces.stream().map(iface -> "  " + iface.asSymbol().displayName()).forEach(System.out::println);
                }
                System.out.println("Fields:");
                model.fields().stream().map(f -> "  " + String.valueOf(f.fieldName()) + " " + f.fieldTypeSymbol().descriptorString()).forEach(System.out::println);
                System.out.println("Methods:");
                model.methods().stream().map(m -> "  " + String.valueOf(m.methodName()) + m.methodTypeSymbol().displayDescriptor() + (String)(m.code().isPresent() ? "\n" + ((CodeModel)m.code().get()).toDebugString() : "")).forEach(System.out::println);
            }
        } while (!this.loadedClasses.isEmpty() && --iters > 0);
    }
}

